unit Filter;

{The Little Richard Editor
 (C) 1996 by Johannes Leckebusch
 25. 8. 96}

interface

uses
  Windows, Messages, SysUtils, Classes, (*Graphics,*) Controls, Forms, Dialogs,
  ComCtrls;

type

  TDOSConversion = class(TConversion)
  private
    { Private-Deklarationen }
    {
    FUNCTION ASCII_To_Iso_Fil (CONST Zch: CHAR): CHAR;
    FUNCTION Iso_To_ASCII_Fil (CONST Zch: CHAR): CHAR;
    }
  public
    { Public-Deklarationen }
    function ConvertReadStream(Stream: TStream; Buffer: PChar; BufSize: Integer): Integer;
      override;
    function ConvertWriteStream(Stream: TStream; Buffer: PChar; BufSize: Integer): Integer;
      override;
  end;

  TMausConversion = class(TConversion)
  private
    { Private-Deklarationen }
    {
    FUNCTION ASCII_To_Iso_Fil (CONST Zch: CHAR): CHAR;
    FUNCTION Iso_To_ASCII_Fil (CONST Zch: CHAR): CHAR;
    }
  public
    { Public-Deklarationen }
    function ConvertReadStream(Stream: TStream; Buffer: PChar; BufSize: Integer): Integer;
      override;
    function ConvertWriteStream(Stream: TStream; Buffer: PChar; BufSize: Integer): Integer;
      override;
  end;

  TMacConversion = class(TConversion)
  private
    { Private-Deklarationen }
    FUNCTION Mac_To_Iso_Fil (CONST Zch: CHAR): CHAR;
    FUNCTION Iso_To_Mac_Fil (CONST Zch: CHAR): CHAR;
  public
    { Public-Deklarationen }
    function ConvertReadStream(Stream: TStream; Buffer: PChar; BufSize: Integer): Integer;
      override;
    function ConvertWriteStream(Stream: TStream; Buffer: PChar; BufSize: Integer): Integer;
      override;
  end;

FUNCTION {TDOSConversion.}ASCII_To_Iso_Fil (CONST Zch: CHAR): CHAR;

{var
  DOSConversion: TDOSConversion;}

implementation

{USES
  LREdit;}

TYPE

        ZeichenSatz =   (* Beschreibt den erweiterten Zeichensatz
                           des IBM-PC und Atari, sofern unterschied-
                           liche Zeichen vorkommen, wurden die Namen
                           nach dem Aussehen auf dem Atari gewaehlt -
                           sorry, letzteres ist historisch bedingt! *)

          (* Steuerzeichen 0..31              Dezimal  Hex *)
        (
          NUL,  (* Null                      ^@   000   00 *)
          SOH,  (* start of heading?         ^A   001   01 *)
          STX,  (* start of text             ^B   002   02 *)
          ETX,  (* end of text               ^C   003   03 *)
          EOT,  (* end of transmission       ^D   004   04 *)
          ENQ,  (* enquiry                   ^E   005   05 *)
          ACK,  (* acknowledge               ^F   006   06 *)
          BEL,  (* bell                      ^G   007   07 *)
          BS,   (* back space                ^H   008   08 *)
          HT,   (* horizontal tabulation     ^I   009   09 *)
          LF,   (* line feed                 ^J   010   0A *)
          VT,   (* vertical tabulation       ^K   011   0B *)
          FF,   (* form feed                 ^L   012   0C *)
          CR,   (* carriage return           ^M   013   0D *)
          SO,   (* shift out                 ^N   014   0E *)
          SI,   (* shift in                  ^O   015   0F *)

          DLE,  (* data link escape          ^P   016   10 *)
          DC1,  (* device control 1          ^Q   017   11 *)
          DC2,  (* device control 2          ^R   018   12 *)
          DC3,  (* device control 3          ^S   019   13 *)
          DC4,  (* device control 4          ^T   020   14 *)
          NAK,  (* negative acknowledge (Para)^U   021   15 *)
          SYN,  (* synchronous idle          ^V   022   16 *)
          ETB,  (* end of transmission block ^W   023   17 *)
          CAN,  (* cancel                    ^X   024   18 *)
          EM,   (* end of medium             ^Y   025   19 *)
          SUB,  (* start of special sequence ^Z   026   1A *)
          ESC,  (* escape                    ^[   027   1B *)
          FS,   (* file separator            ^\   028   1C *)
          GS,   (* group separator           ^]   029   1D *)
          RS,   (* record separator          ^^   030   1E *)
          US,   (* unit seperator            ^_   031   1F *)

          (* Normale druckbare US-ASCII-Zeichen            *)

          SP,           (* Leerzeichen            032   20 *)
          RufZ,         (* !                      033   21 *)
          AnfD,         (* ", Dopp. Anf.          034   22 *)
          Numm,         (* # Doppelkreuz          035   23 *)
          Doll,         (* $                      036   24 *)
          Proz,         (* %                      037   25 *)
          Und,          (* &                      038   26 *)
          AnfE,         (* ', Einf. Anf           039   27 *)
          RuAuf,        (* (                      040   28 *)
          RuZu,         (* )                      041   29 *)
          Stern,        (* *                      042   2A *)
          Plus,         (* +                      043   2B *)
          Komma,        (* ,                      044   2C *)
          Minus,        (* -                      045   2D *)
          Punkt,        (* .                      046   2E *)
          Schraeg,      (* /                      047   2F *)

          (* Ziffern *)

          Null,         (* 0                      048   30 *)
          Eins,         (* 1                      049   31 *)
          Zwei,         (* 2                      050   32 *)
          Drei,         (* 3                      051   33 *)
          Vier,         (* 4                      052   34 *)
          Fuenf,        (* 5                      053   35 *)
          Sechs,        (* 6                      054   36 *)
          Sieben,       (* 7                      055   37 *)
          Acht,         (* 8                      056   38 *)
          Neun,         (* 9                      057   39 *)

          (* Untere Sonderzeichen 1 *)

          DpP,          (* :                      058   3A *)
          Semik,        (* ;                      059   3B *)
          klein,        (* <                      060   3C *)
          glch,         (* =                      061   3D *)
          grsser,       (* >                      062   3E *)
          FrageZ,       (* ?                      063   3F *)
          AtSig,        (* @, Klammeraffe         064   40 *)

          (* Grossbuchstaben *)

          A,            (*                        065   41 *)
          B,            (*                        066   42 *)
          C,            (*                        067   43 *)
          D,            (*                        068   44 *)
          E,            (*                        069   45 *)
          F,            (*                        070   46 *)
          G,            (*                        071   47 *)
          H,            (*                        072   48 *)
          I,            (*                        073   49 *)
          J,            (*                        074   4A *)
          K,            (*                        075   4B *)
          L,            (*                        076   4C *)
          M,            (*                        077   4D *)
          N,            (*                        078   4E *)
          O,            (*                        079   4F *)
          P,            (*                        080   50 *)
          Q,            (*                        081   51 *)
          R,            (*                        082   52 *)
          S,            (*                        083   53 *)
          T,            (*                        084   54 *)
          U,            (*                        085   55 *)
          V,            (*                        086   56 *)
          W,            (*                        087   57 *)
          X,            (*                        088   58 *)
          Y,            (*                        089   59 *)
          Z,            (*                        090   5A *)

          (* Untere Sonderzeichen 2 *)
                        (* (deutsche Umlaute ASCII) *)

          EckAuf,       (* [ (grosses Ae)         091   5B *)
          RueckStr,     (* \ (grosses Oe)         092   5C *)
          EckZu,        (* ] grosses Ue           093   5D *)
          Power,        (* ^                      094   5E *)
          Unterstr,     (* _                      095   5F *)

          (* Kleinbuchstaben *)

          Akz1,         (* `                      096   60 *)
          ka,           (*                        097   61 *)
          kb,           (*                        098   62 *)
          kc,           (*                        099   63 *)
          kd,           (*                        100   64 *)
          ke,           (*                        101   65 *)
          kf,           (*                        102   66 *)
          kg,           (*                        103   67 *)
          kh,           (*                        104   68 *)
          ki,           (*                        105   69 *)
          kj,           (*                        106   6A *)
          kk,           (*                        107   6B *)
          kl,           (*                        108   6C *)
          km,           (*                        109   6D *)
          kn,           (*                        110   6E *)
          ko,           (*                        111   6F *)
          kp,           (*                        112   70 *)
          kq,           (*                        113   71 *)
          kr,           (*                        114   72 *)
          ks,           (*                        115   73 *)
          kt,           (*                        116   74 *)
          ku,           (*                        117   75 *)
          kv,           (*                        118   76 *)
          kw,           (*                        119   77 *)
          kx,           (*                        120   78 *)
          ky,           (*                        121   79 *)
          kz,           (*                        122   7A *)

          (* Untere Sonderzeichen 3 *)
                        (* (deutsche Umlaute ASCII) *)

          SchwfAuf,     (* { (kleines ae)         123   7B *)
          SenkrStrich,  (* | (kleines oe)         124   7C *)
          SchwfZu,      (* } (kleines ue)         125   7D *)
          Tilde,        (* ~ (scharfes sz)        126   7E *)
          DEL,          (* delete, auch Delta     127   7F *)

          (* Erweiterter ASCII-Code 128-255, internationale Zeichen *)

          Cedill,       (* C, franzoesisch        128   80 *)
          kupp,         (* u.. Umlaut             129   81 *)
          keAigu,       (* e'                     130   82 *)
          kaCirc,       (* a^                     131   83 *)
          kapp,         (* a.. Umlaut             132   84 *)
          kaGrav,       (* a`                     133   85 *)
          kao,          (* o ueber a              134   86 *)
          kcedill,      (* c, franzoesisch        135   87 *)
          keCirc,       (* e^                     136   88 *)
          kepp,         (* e..                    137   89 *)
          keGrav,       (* e`                     138   8A *)
          kipp,         (* i..                    139   8B *)
          kiCirc,       (* i^                     140   8C *)
          kiGrav,       (* i`                     141   8D *)
          App,          (* A.. Umlaut             142   8E *)
          Ao,           (* o ueber A              143   8F *)

          EAigu,        (* E'                     144   90 *)
          kae,          (* ae Ligatur,            145   91 *)
          AE,           (* AE Ligatur,            146   92 *)
          koCirc,       (* o^                     147   93 *)
          kopp,         (* o.. Umlaut             148   94 *)
          koGrav,       (* o`                     149   95 *)
          kuCirc,       (* u^                     150   96 *)
          kuGrav,       (* u`                     151   97 *)
          kypp,         (* y..                    152   98 *)
          Opp,          (* O.. Umlaut             153   99 *)
          Upp,          (* U.. Umlaut             154   9A *)
          cent,         (* c/, Cent-Zeichen       155   9B *)
          pound,        (* #, britisch Pfund      156   9C *)
          Yen,          (* y_, japanischer Yen    157   9D *)
          Pts,          (* spanische Peseta/sz    158   9E *)
          Guld,         (* f, holl. Gulden        159   9F *)

          kaAigu,       (* a'                     160   A0 *)
          kiAigu,       (* i'                     161   A1 *)
          koAigu,       (* o'                     162   A2 *)
          kuAigu,       (* u'                     163   A3 *)
          knTild,       (* spanisch n~            164   A4 *)
          NTild,        (* spanisch N~            165   A5 *)
          FemOrd,       (* a_, feminin. Ordinal   166   A6 *)
          MaskOrd,      (* o_, maskul. Ordinal    167   A7 *)
          spanFrag,     (* ? verkehrt, spanisch   168   A8 *)
          NegBack,      (* Negation verkehrt      169   A9 *)
          Negation,     (*                        170   AA *)
          halb,         (* 1/2                    171   AB *)
          viert,        (* 1/4                    172   AC *)
          spanRuf,      (* ! verkehrt, spanisch   173   AD *)
          DFranzAbf,    (* <<, doppelt!           174   AE *)
          DFranzAnf,    (* >>, doppelt!           175   AF *)

          kaTild,       (* a~                     176   B0 *)
          koTild,       (* o~                     177   B1 *)
          OSchraeg,     (* O/                     178   B2 *)
          koSchraeg,    (* o/                     179   B3 *)
          koe,          (* oe Ligatur,            180   B4 *)
          OE,           (* OE Ligatur,            181   B5 *)
          AGrav,        (* A`                     182   B6 *)
          ATild,        (* A~                     183   B7 *)
          OTild,        (* O~                     184   B8 *)
          pp,           (* .., Trema (hochgest)   185   B9 *)
          Aigu,         (* '                      186   BA *)
          Tod,          (* + hochgestellt         187   BB *)
          Absatz,       (* P_ spiegelverkehrt     188   BC *)
          CopyR,        (* (C)                    189   BD *)
          Reg,          (* (R)                    190   BE *)
          TM,           (* TradeMark              191   BF *)

          ICirc,        (*                        192   C0 *)
          Ipp,          (*                        193   C1 *)
          IGrav,        (*                        194   C2 *)
          Paragraph,    (*                        195   C3 *)
          OAigu,        (*                        196   C4 *)
          OCirc,        (*                        197   C5 *)
          kThorn,       (*                        198   C6 *)
          OGrav,        (*                        199   C7 *)
          UAigu,        (*                        200   C8 *)
          koStrich,     (*                        201   C9 *)
          ppp,          (*                        202   CA *)
          Gedankenstrich, (*                      203   CB *)
          LangGedanken, (*                        204   CC *)
          DAbf,         (*                        205   CD *)
          DAnf,         (*                        206   CE *)
          Abf,          (*                        207   CF *)

          Anf,          (*                        208   D0 *)
          UCirc,        (*                        209   D1 *)
          UGrav,        (*                        210   D2 *)
          Ypp,          (*                        211   D3 *)
          Licht,        (*                        212   D4 *)
          FranzAbf,     (*                        213   D5 *)
          FranzAnf,     (*                        214   D6 *)
          AnfUnten,     (*                        215   D7 *)
          DAnfUnten,    (*                        216   D8 *)
          Promille,     (*                        217   D9 *)
          ACirc,        (* Mem am Wortende        218   DA *)
          ECirc,        (* Pe am Wortende         219   DB *)
          AAigu,        (* Sade am Wortende       220   DC *)


     (* hebraeische Zeichen - Atari (nicht implementiert: *)
          {
          Aleph,        (*                        194   C2 *)
          Beta,         (*                        195   C3 *)
          Gimel,        (*                        196   C4 *)
          Dalet,        (*                        197   C5 *)
          He,           (*                        198   C6 *)
          Waw,          (*                        199   C7 *)
          Zajin,        (*                        200   C8 *)
          Het,          (*                        201   C9 *)
          Tet,          (*                        202   CA *)
          Jod,          (*                        203   CB *)
          Kaf,          (*                        204   CC *)
          Lamed,        (*                        205   CD *)
          Mem,          (*                        206   CE *)
          Nun,          (*                        207   CF *)

          Samech,       (*                        208   D0 *)
          Ajin,         (*                        209   D1 *)
          Pe,           (*                        210   D2 *)
          Sade,         (*                        211   D3 *)
          Qof,          (*                        212   D4 *)
          Resch,        (*                        213   D5 *)
          Sin,          (*                        214   D6 *)
          Taw,          (*                        215   D7 *)
          Z216,         (*                        216   D8 *)
          KafWEnde,     (* Kaf am Wortende        217   D9 *)
          MemWEnde,     (* Mem am Wortende        218   DA *)
          PeWEnde,      (* Pe am Wortende         219   DB *)
          SadeWEnde,    (* Sade am Wortende       220   DC *)
          }
          (* verschiedene weitere Sonderzeichen, u. a. griechisch *)

          UntbrSenkrStrich, (* @                  221   DD *)
          EGrav,        (*                        222   DE *)
          IAigu,        (*                        223   DF *)

          (* --------------------------------------------------*)


          alpha,        (*                        224   E0 *)
          sz,           (* deutsches sz, beta     225   E1 *)
          Gamma,        (*                        226   E2 *)
          kpi,          (*                        227   E3 *)
          Sigma,        (*                        228   E4 *)
          ksigma,       (*                        229   E5 *)
          my,           (*                        230   E6 *)
          tau,          (*                        231   E7 *)
          Phi,          (*                        232   E8 *)
          Theta,        (*                        233   E9 *)
          Omega,        (*                        234   EA *)
          delta,        (*                        235   EB *)
          Unendlich,    (*                        236   EC *)
          OStrich,      (*                        237   ED *)
          Epsilon,      (* griech.,
                          auch Element d. Menge   238   EE *)
          DSchn,        (* Mengendurchschnitt     239   EF *)

          ident,        (* = m. drei Balken       240   F0 *)
          PM,           (* +-                     241   F1 *)
          GrGlch,       (* >=                     242   F2 *)
          KlGlch,       (* <=                     243   F3 *)
          IntOb,        (* Integral ob. Haelf.    244   F4 *)
          IntUnt,       (* Integral un. Haelf.    245   F5 *)
          DivZ,         (* :- Div.-Zeichen.       246   F6 *)
          Prop,         (* ~~, Proprotional       247   F7 *)
          Grad,         (*                        248   F8 *)
          DickPunkt,    (*                        249   F9 *)
          Mult,         (* . Malpunkt             250   FA *)
          Wurzel,       (* Wurzelzeichen          251   FB *)
          Hn,           (* wie n hoch, Verkett.   252   FC *)
          H2,           (* 2 hochgestellt         253   FD *)
          H3,           (* 3 hochgestellt         254   FE *)
          Blank         (* _ oben                 255   FF *)
          );

CONST
        (* ISO-Zeichen (Windows) *)

        IsoDEL =               #127;

        IsoAnfUnten =          #130;
        IsoGuld =              #131;
        IsoDAnfUnten =         #132;
        Isoppp =               #133;
        IsoTod =               #134;
        IsoDoppKreuz =         #135;
        IsoCirc =              #136;
        IsoPromille =          #137;
        IsoSv =                #138;
        IsoFranzAbf =          #139;
        IsoOE =                #140;

        IsoAbf =               #145;
        IsoAnf =               #146;
        IsoDAbf =              #147;
        IsoDAnf =              #148;
        IsoDickPunkt =         #149;
        IsoGedankenstrich =    #150;
        IsoLangGedanken =      #151;
        IsoTilde =             #152;
        IsoTM =                #153;
        IsoKsv =               #154;
        IsoFranzAnf =          #155;
        IsoKoe =               #156;

        IsoYpp =               #159;
        IsoBlank =             #160;
        IsoSpanRuf =           #161;
        IsoCent =              #162;
        Isopound =             #163;
        IsoLicht =             #164;
        IsoYen =               #165;
        IsoBar =               #166;
        IsoParagraph =         #167;
        IsoPP =                #168;
        IsoCopyR =             #169;
        IsoFemord =            #170;
        IsoDFranzabf =         #171;
        IsoNegation =          #172;
        IsoStrich =            #173;
        IsoReg =               #174;
        Iso175 =               #175;
        IsoGrad =              #176;
        IsoPM =                #177;
        IsoHoch2 =             #178;
        IsoHoch3 =             #179;
        IsoAigu =              #180;
        IsoMy =                #181;
        IsoAbsatz =            #182;
        IsoMult =              #183;

        IsoHoch1 =             #185;
//        IsoGrad1 =             #186;
        IsoMaskOrd =           #186;
        IsoDFranzanf =         #187;
        IsoEinviertel =        #188;
        IsoEinhalb =           #189;
        IsoDreiviertel =       #190;

        IsoSpanFrag =          #191;
        IsoAgrav =             #192;
        IsoAaigu =             #193;
        IsoACirc =             #194;
        IsoAtild =             #195;
        IsoApp =               #196;
        IsoAo =                #197;
        IsoAe =                #198;
        IsoCedill =            #199;
        IsoEgrav =             #200;
        IsoEaigu =             #201;
        IsoECirc =             #202;
        IsoEpp =               #203;
        IsoIgrav =             #204;
        IsoIaigu =             #205;
        IsoICirc =             #206;
        IsoIpp =               #207;
        IsoThorn =             #208;
        IsoNTild =             #209;
        IsoOgrav =             #210;
        IsoOaigu =             #211;
        IsoOCirc =             #212;
        IsoOtild =             #213;
        IsoOpp =               #214;
        IsoSchraegKreuz =      #215;
        IsoOstrich =           #216;
        IsoUgrav =             #217;
        IsoUaigu =             #218;
        IsoUCirc =             #219;
        IsoUpp =               #220;
        IsoYaigu =             #221;
        IsoKpb =               #222;
        IsoSZ =                #223;
        Isokagrav =            #224;
        Isokaaigu =            #225;
        Isokacirc =            #226;
        Isokatild =            #227;
        Isokapp =              #228;
        Isokao =               #229;
        Isokae =               #230;
        Isokcedill =           #231;
        IsokeGrav =            #232;
        IsokeAigu =            #233;
        IsokeCirc =            #234;
        Isokepp =              #235;
        IsokiGrav =            #236;
        IsokiAigu =            #237;
        IsokiCirc =            #238;
        Isokipp =              #239;
        Isokthorn =            #240;
        IsoknTild =            #241;
        IsokoGrav =            #242;
        IsokoAigu =            #243;
        IsokoCirc =            #244;
        IsokoTild =            #245;
        Isokopp =              #246;
        IsoDivZ =              #247;
        IsoKoquer =            #248;
        IsokuGrav =            #249;
        IsokuAigu =            #250;
        IsokuCirc =            #251;
        Isokupp =              #252;
        IsokyAigu =            #253;
        IsoPB =                #254;
        Isokypp =              #255;

        (* Mac-Zeichen *)

        MacApp =                #128;
        MacAo =                 #129;
        MacCedill =             #130;
        MacEAigu =              #131;
        MacNTild =              #132;
        MacOpp =                #133;
        MacUpp =                #134;
        MacKaAigu =             #135;
        MacKaGrav =             #136;
        MacKaCirc =             #137;
        Mackapp =               #138;
        MacKatild =             #139;
        MacKao =                #140;
        MacKcedill =            #141;
        MackeAigu =             #142;
        MackeGrav =             #143;
        MackeCirc =             #144;
        Mackepp =               #145;
        MackiAigu =             #146;
        MackiGrav =             #147;
        MackiCirc =             #148;
        Mackipp =               #149;
        MacknTild =             #150;
        MackoAigu =             #151;
        MackoGrav =             #152;
        MackoCirc =             #153;
        Mackopp =               #154;
        MackoTild =             #155;
        MackuAigu =             #156;
        MackuGrav =             #157;
        MackuCirc =             #158;
        Mackupp =               #159;
        MacTod =                #160;
        MacGrad =               #161;
        MacCent =               #162;
        Macpound =              #163;
        MacParagraph =          #164;
        MacDickPunkt =          #165;
        MacAbsatz = (* ^T *)    #166;
        MacSZ =                 #167;
        MacReg =                #168;
        MacCopyR =              #169;
        MacTM =                 #170;
        MacAigu =               #171;
        Macpp =                 #172;
        MacUngleich =           #173;
        MacAE =                 #174;
        MacOStrich (* 237 *) =  #175;
        MacUnendlich =          #176;
        MacPM =                 #177;
        MacKlGlch =             #178;
        MacGrGlch =             #179;
        MacYen =                #180;
        Macmy =                 #181;
        MacKthorn =             #182;
        MacSigma =              #183;
        MacPi =                 #184;
        MacKpi =                #185;
        MacIntegral =           #186;
        MacFemOrd =             #187;
        MacMaskord =            #188;
        MacOmega =              #189;
        MacKae =                #190;
        MacKoStrich =           #191;
        MacSpanFrag =           #192;
        MacSpanRuf =            #193;
        MacNegation =           #194;
        MacWurzel =             #195;
        MacGuld =               #196;
        MacProp =               #197;
        MacDelta =              #198;
        MacDFranzAbf =          #199;
        MacDFranzAnf =          #200;
        Macppp =                #201;
        MacBlank =              #202;
        MacAGrav =              #203;
        MacATild =              #204;
        MacOTild =              #205;
        MacOE =                 #206;
        MacKoe =                #207;
        MacGedankenstrich =     #208;
        MacLangGedanken =       #209;
        MacDAbf =               #210;
        MacDAnf =               #211;
        MacAbf =                #212;
        MacAnf =                #213;
        MacDivZ =               #214;
        MacRaute =              #215;
        MacKypp =               #216;
        MacYpp =                #217;
        MacSlash =              #218;
        MacLicht =              #219;
        MacFranzAbf =           #220;
        MacFranzAnf =           #221;
        MacZ222 =               #222;
        MacZ223 =               #223;

        MacAnfUnten =           #226;
        MacDAnfUnten =          #227;
        MacPromille =           #228;
        MacACirc =              #229;
        MacECirc =              #230;
        MacAAigu =              #231;
        MacEpp =                #232;
        MacEGrav =              #233;
        MacIAigu =              #234;
        MacICirc =              #235;
        MacIpp =                #236;
        MacIGrav =              #237;
        MacOAigu =              #238;
        MacOCirc =              #239;
        MacApfel =              #240;
        MacOGrav =              #241;
        MacUAigu =              #242;
        MacUCirc =              #243;
        MacUGrav =              #244;
        Maci =                  #245;
        MacCirc =               #246;
        MacTilde =              #247;

FUNCTION TMacConversion.Iso_To_Mac_Fil (CONST Zch: CHAR): CHAR;
VAR Zeichen: CHAR;
BEGIN
  Zeichen := Zch;
  CASE Zch OF
        {IsoDEL:                Zeichen := MacDEL;}

        IsoAnfUnten:           Zeichen := MacAnfUnten;
        IsoGuld:               Zeichen := MacGuld;
        IsoDAnfUnten:          Zeichen := MacDAnfUnten;
        Isoppp:                Zeichen := Macppp;
        IsoTod:                Zeichen := MacTod;
        {IsoDoppKreuz:          Zeichen := MacDoppKreuz;}
        IsoCirc:               Zeichen := MacCirc;
        IsoPromille:           Zeichen := MacPromille;
        {IsoSv:                 Zeichen := MacSv;}
        IsoFranzAbf:           Zeichen := MacFranzAbf;
        IsoOE:                 Zeichen := MacOE;

        IsoAbf:                Zeichen := MacAbf;
        IsoAnf:                Zeichen := MacAnf;
        IsoDAbf:               Zeichen := MacDAbf;
        IsoDAnf:               Zeichen := MacDAnf;
        IsoDickPunkt:          Zeichen := MacDickPunkt;
        IsoGedankenstrich:     Zeichen := MacGedankenstrich;
        IsoLangGedanken:       Zeichen := MacLangGedanken;
        IsoTilde:              Zeichen := MacTilde;
        IsoTM:                 Zeichen := MacTM;
        {IsoKsv:                Zeichen := MacKsv;}
        IsoFranzAnf:           Zeichen := MacFranzAnf;
        IsoKoe:                Zeichen := MacKoe;

        IsoYpp:                Zeichen := MacYpp;
        IsoBlank:              Zeichen := MacBlank;
        IsoSpanRuf:            Zeichen := MacSpanRuf;
        IsoCent:               Zeichen := MacCent;
        Isopound:              Zeichen := MacPound;
        IsoLicht:              Zeichen := MacLicht;
        IsoYen:                Zeichen := MacYen;
        {IsoBar:                Zeichen := MacBar;}
        IsoParagraph:          Zeichen := MacParagraph;
        IsoPP:                 Zeichen := MacPP;
        IsoCopyR:              Zeichen := MacCopyR;
        {Isokaunter:            Zeichen := Mackaunter;}
        IsoDFranzabf:          Zeichen := MacDFranzabf;
        IsoNegation:           Zeichen := MacNegation;
        {IsoStrich:             Zeichen := MacStrich;}
        IsoReg:                Zeichen := MacReg;
        Iso175:                Zeichen := ' ';
        IsoGrad:               Zeichen := MacGrad;
        IsoPM:                 Zeichen := MacPM;
        {IsoHoch2:              Zeichen := MacHoch2;}
        {IsoHoch3:              Zeichen := MacHoch3;}
        IsoAigu:               Zeichen := MacAigu;
        IsoMy:                 Zeichen := MacMy;
        IsoAbsatz:             Zeichen := MacAbsatz;

        {IsoHoch1:              Zeichen := MacHoch1;}
        {IsoGrad1:              Zeichen := MacGrad1;}
        IsoDFranzanf:          Zeichen := MacDFranzanf;
        {IsoEinviertel:         Zeichen := MacEinviertel;}
        {IsoEinhalb:            Zeichen := MacEinhalb;}
        {IsoDreiviertel:        Zeichen := MacDreiviertel;}

        IsoSpanFrag:           Zeichen := MacSpanFrag;
        IsoAgrav:              Zeichen := MacAgrav;
        IsoAaigu:              Zeichen := MacAaigu;
        IsoACirc:              Zeichen := MacACirc;
        IsoAtild:              Zeichen := MacAtild;
        IsoApp:                Zeichen := MacApp;
        IsoAo:                 Zeichen := MacAo;
        IsoAe:                 Zeichen := MacAe;
        IsoCedill:             Zeichen := MacCedill;
        IsoEgrav:              Zeichen := MacEgrav;
        IsoEaigu:              Zeichen := MacEaigu;
        IsoECirc:              Zeichen := MacECirc;
        IsoEpp:                Zeichen := MacEpp;
        IsoIgrav:              Zeichen := MacIgrav;
        IsoIaigu:              Zeichen := MacIaigu;
        IsoICirc:              Zeichen := MacICirc;
        IsoIpp:                Zeichen := MacIpp;
        {IsoThorn:              Zeichen := MacThorn;}
        IsoNTild:              Zeichen := MacNTild;
        IsoOgrav:              Zeichen := MacOgrav;
        IsoOaigu:              Zeichen := MacOaigu;
        IsoOCirc:              Zeichen := MacOCirc;
        IsoOtild:              Zeichen := MacOtild;
        IsoOpp:                Zeichen := MacOpp;
        {IsoSchraegKreuz:       Zeichen := MacSchraegKreuz;}
        IsoOstrich:            Zeichen := MacOstrich;
        IsoUgrav:              Zeichen := MacUgrav;
        IsoUaigu:              Zeichen := MacUaigu;
        IsoUCirc:              Zeichen := MacUCirc;
        IsoUpp:                Zeichen := MacUpp;
        {IsoYaigu:              Zeichen := MacYaigu;}
        {IsoKpb:                Zeichen := MacKpb;}
        IsoSZ:                 Zeichen := MacSZ;
        Isokagrav:             Zeichen := Mackagrav;
        Isokaaigu:             Zeichen := Mackaaigu;
        Isokacirc:             Zeichen := Mackacirc;
        Isokatild:             Zeichen := Mackatild;
        Isokapp:               Zeichen := Mackapp;
        Isokao:                Zeichen := Mackao;
        Isokae:                Zeichen := Mackae;
        Isokcedill:            Zeichen := Mackcedill;
        IsokeGrav:             Zeichen := MackeGrav;
        IsokeAigu:             Zeichen := MackeAigu;
        IsokeCirc:             Zeichen := MackeCirc;
        Isokepp:               Zeichen := Mackepp;
        IsokiGrav:             Zeichen := MackiGrav;
        IsokiAigu:             Zeichen := MackiAigu;
        IsokiCirc:             Zeichen := MackiCirc;
        Isokipp:               Zeichen := Mackipp;
        Isokthorn:             Zeichen := Mackthorn;
        IsoknTild:             Zeichen := MacknTild;
        IsokoGrav:             Zeichen := MackoGrav;
        IsokoAigu:             Zeichen := MackoAigu;
        IsokoCirc:             Zeichen := MackoCirc;
        IsokoTild:             Zeichen := MackoTild;
        Isokopp:               Zeichen := Mackopp;
        IsoDivZ:               Zeichen := MacDivZ;
        {IsoKoquer:             Zeichen := MacKoquer;}
        IsokuGrav:             Zeichen := MackuGrav;
        IsokuAigu:             Zeichen := MackuAigu;
        IsokuCirc:             Zeichen := MackuCirc;
        Isokupp:               Zeichen := Mackupp;
        {IsokyAigu:             Zeichen := MackyAigu;}
        {IsoPB:                 Zeichen := MacPB;}
        Isokypp:               Zeichen := Mackypp;
  END (* CASE *);
  Result := Zeichen;
END(* Iso_To_Mac_Fil *);

FUNCTION TMacConversion.Mac_To_Iso_Fil (CONST Zch: CHAR): CHAR;
VAR Zeichen: CHAR;
BEGIN
  Zeichen := Zch;
  CASE Zch OF
        MacApp:                 Zeichen := IsoApp;
        MacAo:                  Zeichen := IsoAo;
        MacCedill:              Zeichen := IsoCedill;
        MacEAigu:               Zeichen := IsoEAigu;
        MacNTild:               Zeichen := IsoNTild;
        MacOpp:                 Zeichen := IsoOpp;
        MacUpp:                 Zeichen := IsoUpp;
        MacKaAigu:              Zeichen := IsoKaAigu;
        MacKaGrav:              Zeichen := IsoKaGrav;
        MacKaCirc:              Zeichen := IsoKaCirc;
        Mackapp:                Zeichen := Isokapp;
        MacKatild:              Zeichen := IsoKatild;
        MacKao:                 Zeichen := IsoKao;
        MacKcedill:             Zeichen := IsoKcedill;
        MackeAigu:              Zeichen := IsokeAigu;
        MackeGrav:              Zeichen := IsokeGrav;
        MackeCirc:              Zeichen := IsokeCirc;
        Mackepp:                Zeichen := Isokepp;
        MackiAigu:              Zeichen := IsokiAigu;
        MackiGrav:              Zeichen := IsokiGrav;
        MackiCirc:              Zeichen := IsokiCirc;
        Mackipp:                Zeichen := Isokipp;
        MacknTild:              Zeichen := IsoknTild;
        MackoAigu:              Zeichen := IsokoAigu;
        MackoGrav:              Zeichen := IsokoGrav;
        MackoCirc:              Zeichen := IsokoCirc;
        Mackopp:                Zeichen := Isokopp;
        MackoTild:              Zeichen := IsokoTild;
        MackuAigu:              Zeichen := IsokuAigu;
        MackuGrav:              Zeichen := IsokuGrav;
        MackuCirc:              Zeichen := IsokuCirc;
        Mackupp:                Zeichen := Isokupp;
        MacTod:                 Zeichen := IsoTod;
        MacGrad:                Zeichen := IsoGrad;
        MacCent:                Zeichen := IsoCent;
        Macpound:               Zeichen := Isopound;
        MacParagraph:           Zeichen := IsoParagraph;
        MacDickPunkt:           Zeichen := IsoDickPunkt;
        MacAbsatz:              Zeichen := IsoAbsatz;
        MacSZ:                  Zeichen := IsoSZ;
        MacReg:                 Zeichen := IsoReg;
        MacCopyR:               Zeichen := IsoCopyR;
        MacTM:                  Zeichen := IsoTM;
        MacAigu:                Zeichen := IsoAigu;
        Macpp:                  Zeichen := Isopp;
        {MacUngleich:            Zeichen := IsoUngleich;}
        MacAE:                  Zeichen := IsoAE;
        MacOStrich:             Zeichen := IsoOStrich;
        {MacUnendlich:           Zeichen := IsoUnendlich;}
        MacPM:                  Zeichen := IsoPM;
        {MacKlGlch:              Zeichen := IsoKlGlch;}
        {MacGrGlch:              Zeichen := IsoGrGlch;}
        MacYen:                 Zeichen := IsoYen;
        Macmy:                  Zeichen := Isomy;
        MacKthorn:              Zeichen := Isokthorn;
        {MacSigma:               Zeichen := IsoSigma;}
        {MacPi:                  Zeichen := IsoPi;}
        {MacKpi:                 Zeichen := Isokpi;}
        {MacIntegral:            Zeichen := IsoIntegral;}
        {MacFemOrd:              Zeichen := IsoFemOrd;}
        {MacMaskord:             Zeichen := IsoMaskord;}
        {MacOmega:               Zeichen := IsoOmega;}
        MacKae:                 Zeichen := IsoKae;
        {MacKoStrich:            Zeichen := IsoKoStrich;}
        MacSpanFrag:            Zeichen := IsoSpanFrag;
        MacSpanRuf:             Zeichen := IsoSpanRuf;
        MacNegation:            Zeichen := IsoNegation;
        {MacWurzel:              Zeichen := IsoWurzel;}
        MacGuld:                Zeichen := IsoGuld;
        {MacProp:                Zeichen := IsoProp;}
        {MacDelta:               Zeichen := IsoDelta;}
        MacDFranzAbf:           Zeichen := IsoFranzAbf;
        MacDFranzAnf:           Zeichen := IsoFranzAnf;
        Macppp:                 Zeichen := Isoppp;
        MacBlank:               Zeichen := IsoBlank;
        MacAGrav:               Zeichen := IsoAGrav;
        MacATild:               Zeichen := IsoATild;
        MacOTild:               Zeichen := IsoOTild;
        MacOE:                  Zeichen := IsoOE;
        MacKoe:                 Zeichen := IsoKoe;
        MacGedankenstrich:      Zeichen := IsoGedankenstrich;
        MacLangGedanken:        Zeichen := IsoLangGedanken;
        MacDAbf:                Zeichen := IsoDAbf;
        MacDAnf:                Zeichen := IsoDAnf;
        MacAbf:                 Zeichen := IsoAbf;
        MacAnf:                 Zeichen := IsoAnf;
        MacDivZ:                Zeichen := IsoDivZ;
        {MacRaute:               Zeichen := IsoRaute;}
        MacKypp:                Zeichen := IsoKypp;
        MacYpp:                 Zeichen := IsoYpp;
        {MacSlash:               Zeichen := IsoSlash;}
        MacLicht:               Zeichen := IsoLicht;
        MacFranzAbf:            Zeichen := IsoFranzAbf;
        MacFranzAnf:            Zeichen := IsoFranzAnf;
        {MacZ222:
        MacZ223 =               #223;}

        MacAnfUnten:            Zeichen := IsoAnfUnten;
        MacDAnfUnten:           Zeichen := IsoDAnfUnten;
        MacPromille:            Zeichen := IsoPromille;
        MacACirc:               Zeichen := IsoACirc;
        MacECirc:               Zeichen := IsoECirc;
        MacAAigu:               Zeichen := IsoAAigu;
        MacEpp:                 Zeichen := IsoEpp;
        MacEGrav:               Zeichen := IsoEGrav;
        MacIAigu:               Zeichen := IsoIAigu;
        MacICirc:               Zeichen := IsoICirc;
        MacIpp:                 Zeichen := IsoIpp;
        MacIGrav:               Zeichen := IsoIGrav;
        MacOAigu:               Zeichen := IsoOAigu;
        MacOCirc:               Zeichen := IsoOCirc;
        {MacApfel:               Zeichen := IsoApfel;}
        MacOGrav:               Zeichen := IsoOGrav;
        MacUAigu:               Zeichen := IsoUGrav;
        MacUCirc:               Zeichen := IsoUCirc;
        MacUGrav:               Zeichen := IsoUGrav;
        {Maci:                   Zeichen := Isoi;}
        MacCirc:                Zeichen := IsoCirc;
        MacTilde:               Zeichen := IsoTilde;
  END (* CASE *);
  Result := Zeichen;
END(* Iso_To_Mac_Fil *);

function TMacConversion.ConvertReadStream(Stream: TStream; Buffer: PChar; BufSize: Integer): Integer;
VAR i: Integer;
begin
  Result := Stream.Read(Buffer^, BufSize);
  FOR i := 0 TO BufSize - 1 DO
    Buffer[i] := Mac_To_Iso_Fil (Buffer [i]);
end;

function TMacConversion.ConvertWriteStream(Stream: TStream; Buffer: PChar; BufSize: Integer): Integer;
VAR i: Integer;
    buf: PChar;
begin
  buf := StrAlloc (BufSize);
  FOR i := 0 TO BufSize - 1 DO
    buf[i] := Iso_To_Mac_Fil (Buffer [i]);
  Result := Stream.Write(buf^, BufSize);
  StrDispose (buf);
end;

FUNCTION {TDOSConversion.}ASCII_To_Iso_Fil (CONST Zch: CHAR): CHAR;
VAR Zeichen: CHAR;
BEGIN
  Zeichen := Zch;
  CASE ZeichenSatz (Zch) OF
    AnfUnten:   Zeichen := IsoAnfUnten;
    Guld:       Zeichen := IsoGuld;
    DAnfUnten:  Zeichen := IsoAnfUnten;
    ppp:        Zeichen := Isoppp;
    {Tod:        Zeichen := IsoTod;}
    {DoppKreuz:  Zeichen := IsoDoppKreuz;}
    {Power:      Zeichen := IsoCirc;}
    Promille:   Zeichen := IsoPromille;
    {Sv:         Zeichen := IsoSV;}
    FranzAbf:   Zeichen := IsoFranzAbf;
    OE:         Zeichen := IsoOE;
    Abf:        Zeichen := IsoAbf;
    Anf:        Zeichen := IsoAnf;
    DAbf:       Zeichen := IsoDAbf;
    DAnf:       Zeichen := IsoDAnf;
    DickPunkt:  Zeichen := IsoDickPunkt;
    Gedankenstrich: Zeichen := IsoGedankenstrich;
    LangGedanken: Zeichen := IsoLangGedanken;
    {Tilde:      Zeichen := IsoTilde;} {eigentlich nicht ntig}
    TM:         Zeichen := IsoTM;
    {ksv:        Zeichen := IsoKsv;}
    FranzAnf:   Zeichen := IsoFranzAnf;
    koe:        Zeichen := Isokoe;
    Ypp:        Zeichen := IsoYpp;
    Blank:      Zeichen := IsoBlank;
    spanRuf:    Zeichen := IsoSpanRuf;
    cent:       Zeichen := IsoCent;
    pound:      Zeichen := IsoPound;
    Licht:      Zeichen := IsoLicht;
    Yen:        Zeichen := IsoYen;
    UntbrSenkrStrich: Zeichen := IsoBar;
    Paragraph:  Zeichen := IsoParagraph;
    pp:         Zeichen := IsoPP;
    CopyR:      Zeichen := IsoCopyR;
    FemOrd:     Zeichen := IsoFemord;
    DFranzAbf:  Zeichen := IsoDFranzabf;
    Negation:   Zeichen := IsoNegation;
    {Strich:     Zeichen := IsoStrich;}
    Reg:        Zeichen := IsoReg;
    (* Iso173 *)
    (* Iso175 *)
    Grad:       Zeichen := IsoGrad;
    PM:         Zeichen := IsoPM;
    H2:         Zeichen := IsoHoch2;
    H3:         Zeichen := IsoHoch3;
    Aigu:       Zeichen := IsoAigu;
    my:         Zeichen := IsoMy;
    Absatz:     Zeichen := IsoAbsatz;
    Mult:       Zeichen := IsoMult;
    {Hoch1:     Zeichen := IsoHoch1;}
    {Grad1:      Zeichen := IsoGrad1;}
    Maskord:    Zeichen := IsoMaskord;
    DFranzAnf:  Zeichen := IsoDFranzanf;
    halb:       Zeichen := IsoEinhalb;
    viert:      Zeichen := IsoEinviertel;
    {IsoDreiviertel: BEGIN
                  Write ('3/4');
                    END;}
    SpanFrag:   Zeichen := IsoSpanFrag;
    AGrav:      Zeichen := IsoAGrav;
    AAigu:      Zeichen := IsoAAigu;
    ACirc:      Zeichen := IsoACirc;
    ATild:      Zeichen := IsoATild;
    App:        Zeichen := IsoApp;
    Ao:         Zeichen := IsoAo;
    Ae:         Zeichen := IsoAe;
    Cedill:     Zeichen := IsoCedill;
    EGrav:      Zeichen := IsoEGrav;
    EAigu:      Zeichen := IsoEaigu;
    ECirc:      Zeichen := IsoECirc;
    {Epp:        Zeichen := IsoEpp;}
    IGrav:      Zeichen := IsoIGrav;
    IAigu:      Zeichen := IsoIAigu;
    ICirc:      Zeichen := IsoICirc;
    Ipp:        Zeichen := IsoIpp;
    {Thorn:      Zeichen := IsoThorn;}
    NTild:      Zeichen := IsoNTild;
    OGrav:      Zeichen := IsoOGrav;
    OAigu:      Zeichen := IsoOAigu;
    OCirc:      Zeichen := IsoOCirc;
    OTild:      Zeichen := IsoOTild;
    Opp:        Zeichen := IsoOpp;
    {SchraegKreuz: Zeichen := IsoSchraegKreuz;}
    OStrich:    Zeichen := IsoOstrich;
    UGrav:      Zeichen := IsoUGrav;
    UAigu:      Zeichen := IsoUAigu;
    UCirc:      Zeichen := IsoUCirc;
    Upp:        Zeichen := IsoUpp;
    {YAigu:      Zeichen := IsoYAigu;}
    {kpb:        Zeichen := Isokpb;}
    sz{, Pts}:  Zeichen := IsoSZ;
    kagrav:     Zeichen := Isokagrav;
    kaAigu:     Zeichen := Isokaaigu;
    kaCirc:     Zeichen := Isokacirc;
    kaTild:     Zeichen := IsokaTild;
    kapp:       Zeichen := Isokapp;
    kao:        Zeichen := Isokao;
    kae:        Zeichen := Isokae;
    kcedill:    Zeichen := Isokcedill;
    keGrav:     Zeichen := IsokeGrav;
    keAigu:     Zeichen := IsokeAigu;
    keCirc:     Zeichen := IsokeCirc;
    kepp:       Zeichen := Isokepp;
    kiGrav:     Zeichen := IsokiGrav;
    kiAigu:     Zeichen := IsokiAigu;
    kiCirc:     Zeichen := IsokiCirc;
    kipp:       Zeichen := Isokipp;
    {thorn:      Zeichen := IsoThorn;}
    knTild:     Zeichen := IsoknTild;
    koGrav:     Zeichen := IsokoGrav;
    koAigu:     Zeichen := IsokoAigu;
    koCirc:     Zeichen := IsokoCirc;
    koTild:     Zeichen := IsokoTild;
    kopp:       Zeichen := Isokopp;
    DivZ:       Zeichen := IsoDivZ;
    {koQuer:     Zeichen := IsokoQuer;}
    kuGrav:     Zeichen := IsokuGrav;
    kuAigu:     Zeichen := IsokuAigu;
    kuCirc:     Zeichen := IsokuCirc;
    kupp:       Zeichen := Isokupp;
    {kyAigu:     Zeichen := IsokyAigu;}
    {PB:         Zeichen := IsoPB;}
    kypp:       Zeichen := Isokypp;
    ELSE;
  END (* CASE ZeichenSatz *);
  Result := Zeichen;
END (* ASCIIFil *);

FUNCTION {TDOSConversion.}Iso_To_Ascii_Fil (CONST Zch: CHAR): CHAR;
VAR Zeichen: CHAR;
BEGIN
  Zeichen := Zch;
  CASE Zch OF
    IsoAnfUnten:         Zeichen := CHR (ORD (AnfUnten));
    IsoGuld:             Zeichen := CHR (ORD (Guld));
    IsoDAnfUnten:        Zeichen := CHR (ORD (AnfUnten));
    Isoppp:              Zeichen := CHR (ORD (ppp));
    IsoTod:              Zeichen := CHR (ORD (Tod));
    {IsoDoppKreuz:        Zeichen := CHR (ORD (DoppKreuz));}
    IsoCirc:             Zeichen := CHR (ORD (Power));
    IsoPromille:         Zeichen := CHR (ORD (Promille));
    {IsoSv:               Zeichen := CHR (ORD (Sv));}
    IsoFranzAbf:         Zeichen := CHR (ORD (FranzAbf));
    IsoOE:               Zeichen := CHR (ORD (OE));

    IsoAbf:              Zeichen := CHR (ORD (Abf));
    IsoAnf:              Zeichen := CHR (ORD (Anf));
    IsoDAbf:             Zeichen := CHR (ORD (DAbf));
    IsoDAnf:             Zeichen := CHR (ORD (DAnf));
    IsoDickPunkt:        Zeichen := CHR (ORD (DickPunkt));
    IsoGedankenstrich:   Zeichen := CHR (ORD (Gedankenstrich));
    IsoLangGedanken:     Zeichen := CHR (ORD (LangGedanken));
    IsoTilde:            Zeichen := CHR (ORD (Tilde));
    IsoTM:               Zeichen := CHR (ORD (TM));
    {IsoKsv:              Zeichen := CHR (ORD (Ksv));}
    IsoFranzAnf:         Zeichen := CHR (ORD (FranzAnf));
    IsoKoe:              Zeichen := CHR (ORD (Koe));

    IsoYpp:              Zeichen := CHR (ORD (Ypp));
    {IsoBlank:            Zeichen := CHR (ORD (Blank));}

    IsoSpanRuf:  Zeichen := CHR (ORD (spanRuf));
    IsoCent:     Zeichen := CHR (ORD (cent));
    IsoPound:    Zeichen := CHR (ORD (pound));
    IsoYen:      Zeichen := CHR (ORD (Yen));
    IsoBar:      Zeichen := CHR (ORD (UntbrSenkrStrich));
    IsoParagraph: Zeichen := CHR (ORD (Paragraph));
    IsoPP:       Zeichen := CHR (ORD (pp));
    IsoCopyR:    Zeichen := CHR (ORD (CopyR));
    IsoFemOrd:   Zeichen := CHR (ORD (FemOrd));
    IsoMaskOrd:  Zeichen := CHR (ORD (MaskOrd));
    IsoDFranzabf: Zeichen := CHR (ORD (DFranzAbf));
    IsoDFranzanf: Zeichen := CHR (ORD (DFranzAnf));
    IsoNegation: Zeichen := CHR (ORD (Negation));
    (* Iso173 *)
    IsoReg:      Zeichen := CHR (ORD (NegBack)); (* ??? *)
    (* Iso175 *)
    IsoGrad:     Zeichen := CHR (ORD (Grad));
    IsoPM:       Zeichen := CHR (ORD (PM));
    IsoHoch2:    Zeichen := CHR (ORD (H2));
    IsoHoch3:    Zeichen := CHR (ORD (H3));
    IsoAigu:     Zeichen := '''';
    IsoMy:       Zeichen := CHR (ORD (my));
    {IsoParagraph: Zeichen := '^';} (* ??? *)
    IsoMult:     Zeichen := CHR (ORD (Mult));
    IsoHoch1:    Zeichen := '1'; (* ??? *)
    IsoEinviertel: Zeichen := CHR (ORD (viert));
    IsoEinhalb:  Zeichen := CHR (ORD (halb));
    IsoDreiviertel: BEGIN
                  Write ('3/4');
                    END;
    IsoSpanFrag: Zeichen := CHR (ORD (SpanFrag));
    {
    IsoAgrave:   Zeichen := 'A'; (* ??? *)
    IsoAaigu:    Zeichen := 'A'; (* ??? *)
    IsoAdach:    Zeichen := 'A';
    IsoAtild:    Zeichen := 'A';
    }
    IsoApp:      Zeichen := CHR (ORD (App));
    IsoAo:       Zeichen := CHR (ORD (Ao));
    IsoAe:       Zeichen := CHR (ORD (Ae));
    IsoCedill:   Zeichen := CHR (ORD (Cedill));
    IsoEgrav:    Zeichen := 'E';
    IsoEaigu:    Zeichen := CHR (ORD (EAigu));
    IsoECirc:    Zeichen := 'E';
    IsoEpp:      Zeichen := 'E';
    IsoIgrav:    Zeichen := 'I';
    IsoIaigu:    Zeichen := 'I';
    IsoICirc:    Zeichen := 'I';
    IsoIpp:      Zeichen := 'I';
    IsoThorn:    Zeichen := 'D';
    IsoNTild:    Zeichen := CHR (ORD (NTild));
    IsoOgrav:    Zeichen := 'O';
    IsoOaigu:    Zeichen := 'O';
    IsoOCirc:    Zeichen := CHR (ORD (OCirc));
    IsoOtild:    Zeichen := 'O';
    IsoOpp:      Zeichen := CHR (ORD (Opp));
    IsoOstrich:  Zeichen := CHR (ORD (OStrich));
    IsoUgrav:    Zeichen := 'U';
    IsoUaigu:    Zeichen := 'U';
    IsoUCirc:    Zeichen := 'U';
    IsoUpp:      Zeichen := CHR (ORD (Upp));
    IsoYaigu:    Zeichen := 'Y';
    Isopb:       Zeichen := 'p';

    IsoSZ:       Zeichen := CHR (ORD (sz));

    Isokagrav:   Zeichen := CHR (ORD (kagrav));
    Isokaaigu:   Zeichen := CHR (ORD (kaAigu));
    IsokaCirc:   Zeichen := CHR (ORD (kaCirc));
    Isokatild:   Zeichen := 'a';
    Isokapp:     Zeichen := CHR (ORD (kapp));
    Isokao:      Zeichen := CHR (ORD (kao));
    Isokae:      Zeichen := CHR (ORD (kae));
    Isokcedill:  Zeichen := CHR (ORD (kcedill));
    IsokeGrav:   Zeichen := CHR (ORD (keGrav));
    IsokeAigu:   Zeichen := CHR (ORD (keAigu));
    IsokeCirc:   Zeichen := CHR (ORD (keCirc));
    Isokepp:     Zeichen := CHR (ORD (kepp));
    IsokiGrav:   Zeichen := CHR (ORD (kiGrav));
    IsokiAigu:   Zeichen := CHR (ORD (kiAigu));
    IsokiCirc:   Zeichen := CHR (ORD (kiCirc));
    Isokipp:     Zeichen := CHR (ORD (kipp));
    IsokThorn:   Zeichen := 'd'; (* ??? *)
    IsoknTild:   Zeichen := CHR (ORD (knTild));
    IsokoGrav:  Zeichen := CHR (ORD (koGrav));
    IsokoAigu:   Zeichen := CHR (ORD (koAigu));
    IsokoCirc:   Zeichen := CHR (ORD (koCirc));
    IsokoTild:   Zeichen := CHR (ORD (koTild));
    Isokopp:     Zeichen := CHR (ORD (kopp));
    IsoDivZ:     Zeichen := CHR (ORD (DivZ));

    IsokuGrav:   Zeichen := CHR (ORD (kuGrav));
    IsokuAigu:   Zeichen := CHR (ORD (kuAigu));
    IsokuCirc:   Zeichen := CHR (ORD (kuCirc));
    Isokupp:     Zeichen := CHR (ORD (kupp));
    IsokyAigu:   Zeichen := 'y';
    {IsoPB:      Zeichen := 'p';} (* ??? *)
    Isokypp:     Zeichen := CHR (ORD (kypp));

    ELSE;
  END (* CASE Zeichen *);
  Result := Zeichen;
END (* IsoFil *);


function TDOSConversion.ConvertReadStream(Stream: TStream; Buffer: PChar; BufSize: Integer): Integer;
VAR i: Integer;
begin
  Result := Stream.Read(Buffer^, BufSize);
  FOR i := 0 TO BufSize - 1 DO
    Buffer[i] := ASCII_To_Iso_Fil (Buffer [i]);
end;

function TDOSConversion.ConvertWriteStream(Stream: TStream; Buffer: PChar; BufSize: Integer): Integer;
VAR i: Integer;
    buf: PChar;
begin
  buf := StrAlloc (BufSize);
  FOR i := 0 TO BufSize - 1 DO
    buf[i] := Iso_To_ASCII_Fil (Buffer [i]);
  Result := Stream.Write(buf^, BufSize);
  StrDispose (buf);
end;

function TMausConversion.ConvertReadStream(Stream: TStream; Buffer: PChar; BufSize: Integer): Integer;
VAR i, j:  Integer;
    ch: Char;
    r:  Integer;
    kursiv, fett, unterstrichen: BOOLEAN;
    buf: PChar;

  procedure writeBuf (CONST s: String);
  VAR k: Integer;
  BEGIN
    FOR k := 1 TO Length (s) DO
      Buffer [j + k - 1] := s [k];
    INC (j, Length (s));
  END (* writeBuf *);

begin (* ConvertReadStream *)
  kursiv := FALSE; fett := FALSE; unterstrichen := FALSE;
  buf := StrAlloc (BufSize);
  r := Stream.Read(buf^, BufSize);
  i := 0; j := 0;
  WHILE (i < BufSize) DO BEGIN
  {FOR i := 0 TO BufSize - 1 DO BEGIN}
    ch := ASCII_To_Iso_Fil (Buf [i]);
    CASE ch OF
      '/': BEGIN
             kursiv := NOT kursiv;
             IF kursiv THEN BEGIN
               Buffer [j] := '\'; INC (j); Buffer [j] := 'i'; ch := ' '; INC (j);
             END
             ELSE BEGIN
               {Buffer [j] := '\'; INC (j); Buffer [j] := 'p'; ch := ' '; INC (j);}
               writeBuf ('\plain'); ch := ' ';
             END (* ELSE *);
           END;
      '*':;
      '_':;
    END (* CASE *);
    Buffer[j] := ch;
    INC (i); INC (j);
  END (* WHILE *);
  Result := j;
  StrDispose (buf);
end;

function TMausConversion.ConvertWriteStream(Stream: TStream; Buffer: PChar; BufSize: Integer): Integer;
VAR i: Integer;
    buf: PChar;
begin
  buf := StrAlloc (BufSize);
  FOR i := 0 TO BufSize - 1 DO
    buf[i] := Iso_To_ASCII_Fil (Buffer [i]);
  Result := Stream.Write(buf^, BufSize);
  StrDispose (buf);
end;


{$R *.DFM}

end.
