PROGRAM I9;
  {fr alle Tastaturen, PC und AT, Turbo 3.0 4.0}
  {c-,u-}
  uses crt; {hallo Turbo 4.0!}
  {$I misc}


VAR
  {NUR FR AT und Modell 50 bis 80:  Durch nderung dieser}
  {Variable wird die AT-PC-Umsetzung des 8042 umgeschaltet}
  PCTranslate : Boolean;
  b1 : Byte;
  ESC : Byte;

BEGIN
  WriteLn;
  WriteLn('** I9, Ver 1.2, 16-jun-88 -mat ** ');
  WriteLn;
  WriteLn('I9 setzt den Tastatur-Interrupt 9 um.');
  WriteLn('Es zeigt direkt die Tastatur-Codes.');
  WriteLn('Aufruf mit "-T" schaltet bei ATs die AT/PC '+
          'Umschaltung aus.');
  WriteLn;
  WriteLn('Ende mit <ESC>.');
  WriteLn;
  WriteLn;


  If (ParamStr(1) = '-T') or (ParamStr(1) = '-t')
  THEN PCTranslate := False
  ELSE PCTranslate := True;

  IF PCTranslate
     then writeln('bersetzung in PC-Codes aktiv.')
     ELSE writeln ('bersetzung in PC-Codes abgeschaltet.');

  IF NOT PCTranslate THEN BEGIN
    REPEAT b1 := Port[$64]; UNTIL (b1 AND $03) = 0;
    WriteLn('Status : ', b1); Delay(200);
    Port[$64] := $60; Delay(10); Port[$60] := $05;
    ESC := $76;
  END
  ELSE ESC := 1;

  BufHead := 0; BufTail := 0;
  NewInt(9); Delay(100);

  REPEAT
    FOR i := 0 TO 100 DO Buffer[i] := 0;
    i := 4;          {Zeitraum zwischen zwei Tastendrcken}
    REPEAT           {die auf einer Zeile angezeigt werden}
      Delay(1);
      IF i > 0 THEN i := i-1;
    UNTIL (BufHead <> BufTail);

    IF i = 0 THEN WriteLn;    {Zeit abgelaufen, neue Zeile}
    REPEAT
      b1 := Buffer[BufHead];
      BufHead := (BufHead+1) MOD 100;
      Write(ByteToHex(b1), ' ');
    UNTIL BufHead = BufTail;          {Ringpuffer auslesen}
  UNTIL b1 = ESC;                             {ESC beendet}

  WriteLn;
  RestoreInt;               {alten Interrupt-Vektor setzen}

  IF NOT PCTranslate THEN BEGIN
    REPEAT UNTIL (Port[$64] AND $03) = 0;
    Port[$64] := $60; Delay(10); Port[$60] := $45;
  END;
END.

