TITLE   HGC
.186
;**********************************************************
;* Programmname       : hgc.asm                           *
;* Ersteller          : Peter Khlmann                    *
;* letzte nderung    : 3.8.88 / mw                       *
;* bersetzen         : MASM HGC,,NUL,NUL                 *
;*                      LINK HGC;                         *
;*                      EXE2BIN HGC HGC.COM               *
;**********************************************************

V20     EQU     0       ;fr V20,V30,80286,80386
FILL    EQU     -1      ;fr normale Hercules-Karten. Neuere
                        ;Karten mit Emulations-Modus bentigen
                        ;dies nicht
LF      EQU     10
CR      EQU     13

DISPL_REG       EQU     03B4H           ;used HGC-Ports
MODE_CTRL_REG   EQU     03B8H
LIGHT_PEN_SET   EQU     03B9H
DISPL_STAT      EQU     03BAH
LIGHT_PEN_RS    EQU     03BBH
CONFIG_PORT     EQU     03BFH

FDC_CTRL        EQU     03F2H

BIOSSEG EQU     0F000H
;These pointers are those used by IBM in the XT-BIOS. If
;your BIOS has different entries, change the pointers or
;the program will not run. Most BIOS-Writers have retained
;the Entry-Addresses, so it is very likely that you don't
;have to do that.

VIDEO           EQU     0F065H
DUMMY           EQU     0FF53H
KEYB            EQU     0E82EH
KB_INT          EQU     0E987H
PRINTER         EQU     0EFD2H
PRTSC           EQU     0FF54H
NMI             EQU     0E2C3H
DISKETTE        EQU     0EC59H
DISK_INT        EQU     0EF57H
BOOT_STRAP      EQU     0E6F2H
CLOCK_INT       EQU     0FEA5H

HGC     SEGMENT

        ASSUME DS:HGC, SS:HGC ,CS:HGC ,ES:HGC

PHGC    PROC    NEAR
        ORG     0100H

BEGINN: JMP     TRANSIENT

KEY_INT:
        PUSH    AX
        MOV     AX,WORD PTR CS:SAVE_ACT ;see if SAVE is ON...
        OR      AL,AL                   ;...and display OFF
        JZ      ORIG_KEY
        OR      AH,AH
        JNZ     ORIG_KEY ;if not active,
                         ;bypass Keyboard-sequence
        STI              ;DISPLAY IS SWITCHED OFF,
                         ;SO SWITCH BACK ON
        PUSH    BX
        PUSH    DX
        XOR     AL,AL
        MOV     DX,DISPL_STAT   ;GET VERTICAL RETRACE
VERT_RETR:
        IN      AL,DX
        TEST    AL,80H
        JZ      VERT_RETR
VERT_RETR1:
        IN      AL,DX
        TEST    AL,80H
        JNZ     VERT_RETR1
        XOR     AL,AL
        INC     DX
        OUT     DX,AL
        MOV     DL,0B9H         ;=LIGHT_PEN_SET
        OUT     DX,AL           ;NOW TRIGGER L-PEN-PORT
        MOV     AL,10H          ;READ LIGHT-PEN ADDR
        MOV     DL,0B4H         ;=DISPL_REG
        OUT     DX,AL
        INC     DX
        IN      AL,DX
        MOV     BH,AL
        MOV     AL,11H
        DEC     DX
        OUT     DX,AL
        INC     DX
        IN      AL,DX
        MOV     BL,AL      ;BX HAS LIGHT-PEN POSITION
        MOV     AH,19H     ;GET TEXT-MODE
        CMP     BX,0B8DH   ;TEST IF GRAPHIC-MODE...
        JB      IS_TEXT    ;...(VALUE TOO HIGH FOR TEXT)
        MOV     AH,57H     ;GET GRAPH-MODE
IS_TEXT:
        MOV     AL,6       ;NOW SET REGS FOR SCREEN ON
        DEC     DX
        OUT     DX,AL
        MOV     AL,AH
        INC     DX
        OUT     DX,AL
        POP     DX
        POP     BX
        MOV     WORD PTR CS:SAVE_ACT,0FFFFH
        MOV     WORD PTR CS:COUNTER,1518H
ORIG_KEY:
        POP     AX
        DB      0EAH
KEY_PTR         LABEL   DWORD
INT9_OFFS       DW      0
INT9_SEG        DW      0

;This routine will switch OFF the screen if SAVE is ON after
;5 Minutes if there was no output to the display or no
;Keypress during that time

INT_1C: STI
        PUSH    DS         ;save regs
        PUSH    AX
        PUSH    DX
        PUSH    CS
        POP     DS
        MOV     AX,WORD PTR DS:SAVE_ACT
        OR      AL,AL      ;test if SAVE is on
        JZ      EXIT_1C
        OR      AH,AH
        JZ      EXIT_1C
        DEC     COUNTER    ;SAVE is on
        JNZ     EXIT_1C    ;5 minutes done without keypress
        MOV     AL,6       ;or video-i/o ?
        MOV     DX,DISPL_REG ;seems so,so switch off video
        OUT     DX,AL
        INC     DX
        MOV     AL,0
        OUT     DX,AL
        MOV     ON_OFF_FLAG,AL ;signal video is off
EXIT_1C:
                               ;get registers back
        POP     DX
        POP     AX
        POP     DS
        DB      0EAH
INT1C_OFFS      DW      0
INT1C_SEG       DW      0


VIDEO_INT:
        MOV     WORD PTR CS:COUNTER,1518H   ;reset counter
        CMP     BYTE PTR CS:ACTIVE,0   ;see if Emulator on
NOP_NOP:
        JNZ     XVIDEO                 ;if so,else
        DB      0EAH                   ;JMP FAR
VID_PTR         LABEL   DWORD
INT10_OFFS      DW      0
INT10_SEG       DW      0


SAVE_ACT        DB      0
ON_OFF_FLAG     DB      0

PASS_CTR        DW      200H

ACTIVE          DB      0
HACTIVE         DB      0


COUNTER         DW      1518H

;These 6845-parameters are different from those
;normally used by the Hercules-Card !!

GR_PARA1        DB      34H,28H,2AH,47H,69H,0,64H,65H,2,3
                DB      6 DUP(0)

GR_PARAS        DB      34H,28H,2AH,0AH,7BH,0,64H,6AH,2,2
                DB      6 DUP(0)

CUR_SCR_MODE    DB      29H

XVIDEO:
        CALL    XMODE   ;WE GET HERE ONLY IF EMULATOR IS ON
        IRET
XMODE:
        PUSH    ES
        PUSH    DS
        PUSH    SI
        PUSH    DI
        PUSH    CS
        POP     DS
        PUSH    CS
        POP     ES
TEST_MODE:
        CMP     AH,0
        JZ      IS_MODE
        PUSHF         ;IF NO MODE-CALL,LET BIOS DO THE REST
        CALL    VID_PTR
LEAVE_10:
        POP     DI
        POP     SI
        POP     DS
        POP     ES
        RET

IS_MODE:
        CMP     AL,8       ;TEST FOR ILLEGAL MODE
        JNB     LEAVE_10
        MOV     ACTIVE,AL
        CMP     AL,4       ;TEST FOR ALL COLOR-TEXT-MODI
        JB      GOT_TEXT
        CMP     AL,7       ;TEST FOR MONO-TEXT
        JNZ     TEST_6
GOT_TEXT:
        CALL    TEXT_MODE  ;SWITCH IN NORMAL TEXT-MODE
        JMP     SHORT   LEAVE_10

TEST_6:
        MOV     AH,50H     ;MUST BE COLOR-GRAPH-MODE
        CMP     AL,6
        JZ      IS_640
        MOV     AH,28H
IS_640: CALL    GRAPHIC
        JMP     SHORT   LEAVE_10

TEXT_MODE:
        PUSH    DS
        IF      V20
        PUSH    40H
        POP     DS
        ELSE
        PUSH    AX
        MOV     AX,40H
        MOV     DS,AX
        POP     AX
        ENDIF

;This mode-switch works very alike to that of MODE itself

        OR      BYTE PTR DS:10H,30H  ;SET BIOS-FLAG TO MONO
        POP     DS

        PUSHF            ;IRET from INT 10 will remove this
        CALL    VID_PTR  ;NOW LET BIOS SWITCH

        MOV     AL,CUR_SCR_MODE
        AND     AL,4
        OR      AL,29H
        MOV     CUR_SCR_MODE,AL
        MOV     DX,MODE_CTRL_REG
        OUT     DX,AL
        RET              ;DONE

GRAPHIC:
        PUSH    CX
        PUSH    AX
        MOV     CX,4000H
        XOR     AX,AX
        MOV     DI,0B800H
        MOV     ES,DI
        XOR     DI,DI
        CLD
        REP     STOSW
        POP     AX
        PUSH    DS

        IF      V20
        PUSH    40H
        POP     DS
        ELSE
        MOV     CX,40H
        MOV     DS,CX
        ENDIF

        AND     BYTE PTR DS:10H,0EFH ;SET BIOS-FLAG TO COLOR
        MOV     WORD PTR DS:49H,AX   ;SET MODE AND LINE-LEN
        CBW
        POP     DS

        PUSHF
        CALL    VID_PTR          ;LET BIOS SWITCH MODES
        MOV     AH,93H           ;DISPLAY B800,GRAPH-MODE
        MOV     AL,CUR_SCR_MODE  ;GET VALUES FOR GRAPH
        AND     AL,0CH
        OR      AH,AL
        MOV     CUR_SCR_MODE,AH
        AND     AH,0F7H          ;DISPLAY IS OFF
        PUSH    AX
        MOV     DX,DISPL_STAT
        XOR     CX,CX
STAT1:  IN      AL,DX            ;GET HERCULES-STATUS
        TEST    AL,80H
        JNZ     STAT2
        LOOP    STAT1
STAT2:  JCXZ    STAT4
        XOR     CX,CX
STAT3:  IN      AL,DX
        TEST    AL,80H
        JZ      STAT4
        LOOP    STAT3
STAT4:  MOV     SI,OFFSET GR_PARAS
        CMP     BYTE PTR DS:HACTIVE,0
        JNZ     SET_PARAS
        MOV     SI,OFFSET GR_PARA1
SET_PARAS:
        MOV     CX,10H
        SUB     AX,AX
        CLD
LOOP_6845:
        MOV     DX,DISPL_REG     ;NOW MOVE THE GRAPHIC-
        MOV     AL,AH            ;VALUES INTO 6845
        OUT     DX,AL
        INC     DX
        LODSB
        OUT     DX,AL
        INC     AH                      ;next index
        LOOP    LOOP_6845

        POP     AX
        MOV     AL,AH
        MOV     DX,MODE_CTRL_REG
        OUT     DX,AL
        LOOP    $      ;WAIT A BIT UNTIL SCREEN IS SETTLED
        OR      AL,8   ;SCREEN ON
        OUT     DX,AL
        MOV     CUR_SCR_MODE,AL
        IF      V20
        PUSH    40H
        POP     DS
        ELSE
        MOV     CL,40H          ;get BIOS-Data-Segment
        MOV     DS,CX
        ENDIF
        POP     CX
        MOV     BYTE PTR DS:65H,AL
        RET

;This routine will switch OFF the screen if SAVE is ON after
;5 Minutes if there was no output to the display or no
;Keypress during that time

INT_8:
        IF      FILL
        STI
        CLD

        PUSH    DS    ;save regs
        PUSH    ES
        IF      V20
        PUSHA
        PUSH    40H
        POP     DS
        ELSE
        PUSH    AX
        PUSH    BX
        PUSH    CX
        PUSH    DX
        PUSH    SI
        PUSH    DI
                       ;if we need the FILL-Routine, it 
        MOV     AX,40H ;is better to use INT 8. In that
        MOV     DS,AX  ;case, the complete INT 8 must be
        ENDIF          ;reproduced.

        INC     WORD PTR DS:6CH
        JNZ     HOUR_24         
        INC     WORD PTR DS:6EH 

;NOTE: The Key-Repeat build into the V20-BIOS is not present.
;Otherwise,this Routine will run only with that BIOS. So,if
;you use this Emulator, fast Repeat is OFF.
HOUR_24:
        CMP     WORD PTR DS:6EH,18H     ;TEST IF 24.00
        JNZ     MOTOR_OFF
        CMP     WORD PTR DS:6CH,0B0H
        JNZ     MOTOR_OFF
        PUSH    DS  ;IF SO,RESET TIME TO 0 AND SET 40:70
        POP     ES
        MOV     DI,06CH
        SUB     AX,AX
        STOSW
        STOSW
        INC     AL
        STOSB
MOTOR_OFF:
        DEC     BYTE PTR DS:40H
        JNZ     EXEC_1C
        AND     BYTE PTR DS:3FH,0F0H
        MOV     AL,0CH
        MOV     DX,FDC_CTRL
        OUT     DX,AL
EXEC_1C:
        INT     1CH

        CLI
        MOV     AL,20H          ;reset INT-Controller
        OUT     20H,AL
        STI

        PUSH    CS
        POP     DS
        MOV     SI,OFFSET PASS_CTR
        LODSW
        CMP     AX,0      ;IS PASS_CTR 0 ?
        JZ      END_INT   ;if so,then normal GRAF Parameter
        INC     AL
        CMP     AL,AH
        JNZ     PUT_IN
        MOV     AL,0
PUT_IN:
        MOV     PASS_CTR,AX
        JNZ     END_INT

        LODSW             ;get ACTIVE and HACTIVE
        CMP     AL,4
        JB      END_INT
        CMP     AL,7
        JZ      END_INT

        CMP     AH,0      ;test if HGRAF or HBOOT
        MOV     AX,0B800H
        MOV     ES,AX
        MOV     DS,AX
        JNZ     PART2     ;NZ if HGRAF or HBOOT

        mov     SI,2000h  ;do full FILL-UP
        MOV     DI,4000H
        MOV     CX,3960   ;nearly 8000 Bytes
        REP     MOVSW
        MOV     DI,6000H
        jmp     short MOVE

PART2:
        MOV     DI,4000H
MOVE:   mov     SI,50h    ;HALF FILL-UP
        MOV     CX,3960   ;nearly 8000 Bytes
        REP     MOVSW

END_INT:
        IF      V20
        POPA              ;get registers back
        ELSE
        POP     DI
        POP     SI
        POP     DX
        POP     CX
        POP     BX
        POP     AX
        ENDIF
        POP     ES
        POP     DS
        IRET
        ENDIF

;Code from here is not loaded permanent. If the resident
;part is already loaded, it will not be made resident
;again. Instead the variables in the resident part will
;be changed to reflect the new status of the program.

LEN     EQU     OFFSET ORIG_KEY - 100H

TRANSIENT:
        IF      V20
        MOV     AX,SP
        PUSHA               ;SEE IF V20 PRESENT
        CMP     AX,SP
        JNZ     IS_V20      ;OK,SEEMS TO RUN
        JMP     BAD_PROC    ;PROGRAMM WAS ASSEMBLED VIA
        ENDIF
IS_V20:                     ;V20-SWITCH,BUT NO V20 PRESENT
        MOV     AX,3509H
        INT     21H         ;put key-INT into pointer
        MOV     WORD PTR CS:INT9_OFFS,BX
        MOV     WORD PTR CS:INT9_SEG,ES

        MOV     AX,351CH
        INT     21H
        MOV     WORD PTR CS:INT1C_OFFS,BX
        MOV     WORD PTR CS:INT1C_SEG,ES

        MOV     AX,3510H
        INT     21H         ;put video-INT into pointer
        MOV     WORD PTR CS:INT10_OFFS,BX
        MOV     WORD PTR CS:INT10_SEG,ES

        PUSH    CS
        POP     DS
        MOV     SI,OFFSET BEGINN ;TEST IF ALREADY LOADED
        MOV     DI,SI
        MOV     CX,LEN
        CLD
        REPZ    CMPSB     ;see if code can be found
        JCXZ    IS_LOADED ;if CX = 0,code found

        MOV     AX,3509H  ;10 DOES NOT POINT TO HGC,TRY KEY
        INT     21H
        MOV     SI,OFFSET BEGINN
        MOV     DI,SI
        MOV     CX,LEN
        REPZ    CMPSB
        JCXZ    IS_LOADED

        IF      FILL
        MOV     AX,3508H  ;9 DOES NOT POINT TO HGC,TRY CLOCK
        INT     21H
        MOV     SI,OFFSET BEGINN
        MOV     DI,SI
        MOV     CX,LEN
        REPZ    CMPSB
        JCXZ    IS_LOADED
        ENDIF

        MOV     AX,351CH                ;TRY SOFTWARE-CLOCK
        INT     21H
        MOV     SI,OFFSET BEGINN
        MOV     DI,SI
        MOV     CX,LEN
        REPZ    CMPSB
        JCXZ    IS_LOADED

        PUSH    CS ;set ES to CS,in case code is made resi-
        POP     ES ;dent put current Code-segment into ES
IS_LOADED:
        MOV     WORD PTR CS:HGCSEG,ES ;now we have the
        PUSH    CS       ;segment of the resident code
        POP     DS
        MOV     BX,80H
        XOR     CH,CH
        MOV     CL,DS:[BX]
        JCXZ    GO_EXIT  ;test if argument specified
        MOV     AL,20H
        NOT     AL
MAKE_UPPER:              ;THIS ROUTINE WILL CONVERT LOWER CASE
                         ;INPUT TO UPPER-CASE
        INC     BX
        AND     DS:[BX],AL
        LOOP    MAKE_UPPER ;after loop all set to UPPER
        MOV     DI,80H     ;now test for arguments
        LEA     SI,DIAG
        CALL    TEST_OPT
        JZ      SET_DIAG   ;DIAG found ?
        MOV     DI,80H
        LEA     SI,HALF
        CALL    TEST_OPT
        JZ      SET_HALF   ;HALF found ?
        MOV     DI,80H
        LEA     SI,FULL
        CALL    TEST_OPT
        JNZ     TEST_SAVE

SET_FULL:
        MOV     AL,3
PUT_MODE:
        MOV     DX,CONFIG_PORT
        OUT     DX,AL
        JMP     ENDE

GO_EXIT:
        JMP     EXIT

SET_DIAG:
        MOV     AX,7
        INT     10H
        MOV     AL,0
        JMP     SHORT   PUT_MODE

SET_HALF:
        MOV     AX,7
        INT     10H
        MOV     AL,1
        JMP     SHORT   PUT_MODE

TEST_SAVE:
        MOV     DI,80H
        LEA     SI,SAVE
        CALL    TEST_OPT
        JNZ     TEST_BOOT
        JMP     IS_SAVE    ;SAVE found

TEST_BOOT:
        IF      FILL
        MOV     DI,80H
        LEA     SI,HBOOT
        CALL    TEST_OPT
        MOV     AH,0FFH
        JZ      HALFB
        MOV     DI,80H
        LEA     SI,FBOOT
        CALL    TEST_OPT
        MOV     AH,0
        JNZ     TST_BOOT
HALFB:
        CALL    GET_NUMB
        MOV     CL,CH
        INC     CL
        ENDIF

GO_BOOT:
        JMP     BOOT       ;FILL-BOOT found ?

TST_BOOT:
        MOV     DI,80H
        LEA     SI,SBOOT
        CALL    TEST_OPT
        MOV     CX,0
        JZ      GO_BOOT    ;BOOT found ?
        MOV     DI,80H
        LEA     SI,TEXT
        CALL    TEST_OPT
        JZ      SET_T_MODE ;TEXT found ?

        IF      FILL
        MOV     DI,80H
        LEA     SI,HGRAF
        CALL    TEST_OPT
        MOV     AH,0FFH
        JZ      HALFG

        MOV     DI,80H
        LEA     SI,FGRAF
        CALL    TEST_OPT
        MOV     AX,0
        JNZ     TST_G_MODE ;FGRAF or HGRAF found ?
HALFG:
        CALL    GET_NUMB
        PUSH    DS
        PUSH    AX
        PUSH    CX
        MOV     WORD PTR ES:SAVE_ACT,0
        MOV     AX,CS
        MOV     CS:HGCSEG,AX
;look again for present code, this time for full code
;if not found, we must load it now
        IF      FILL
        MOV     AX,3508H
        INT     21H
        MOV     SI,OFFSET XMODE
        MOV     DI,SI
        MOV     CX,64H
        REPZ    CMPSB
        JCXZ    IS_FOUND
        PUSH    CS
        POP     ES
IS_FOUND:
        MOV     WORD PTR CS:HGCSEG,ES
        MOV     AX,CS:HGCSEG
        MOV     DS,AX
        MOV     AX,2508H   ;set INT 8 if HGRAF or FGRAF
        MOV     DX,OFFSET INT_8
        INT     21H
        ENDIF
EMUL_SET_END:
        POP     CX
        POP     AX
        POP     DS
        JMP     SET_G_MODE ;GRAF found
    ENDIF

SET_T_MODE:
        MOV     AX,3
        JMP     INIT

TST_G_MODE:
        MOV     DI,80H
        LEA     SI,GRAF
        CALL    TEST_OPT
        MOV     AX,0
        MOV     CX,0
        JZ      SET_G_MODE  ;GRAF found

EXIT:
        CMP     BYTE PTR CS:80H,0 ;see if argument supplied
        PUSH    CS                ;no, display help-screen
        POP     DS
     MOV     DX,OFFSET BAD_ARGUMENTS
        JNZ     BAD_ARGS ;if not LEN 0,bad argument supplied
        MOV     DX,OFFSET OPTIONS
BAD_ARGS:
        MOV     AH,9
        INT     21H                     ;Display it
ENDE:   INT     20H

IS_SAVE:;set to ON if it was OFF
        XOR     WORD PTR ES:SAVE_ACT,0FFFFH
        ;if it was ON,now it's OFF
        MOV     WORD PTR ES:COUNTER,1518H
        MOV     AL,BYTE PTR ES:SAVE_ACT
        OR      AL,AL                   ;see if SAVE was on
        PUSH    CS
        POP     DS
        LEA     DX,SAVE_ON
        JNZ     DISPLAY                 ;no,now it is
        LEA     DX,SAVE_OFF             ;was ON,is now OFF

DISPLAY:
        MOV     AH,9
        INT     21H
        MOV     DX,LIGHT_PEN_SET
        OUT     DX,AL
        MOV     DX,DISPL_STAT
        IN      AL,DX
        TEST    AL,2
        JZ      ENDE
        MOV     DX,LIGHT_PEN_RS
        OUT     DX,AL
        MOV     DX,DISPL_STAT
        IN      AL,DX
        TEST    AL,2
        JNZ     ENDE
        STI
        JMP     SHORT   SET_INT

SET_G_MODE:
        MOV     BYTE PTR ES:HACTIVE,AH
        MOV     WORD PTR ES:PASS_CTR,CX
        MOV     WORD PTR ES:SAVE_ACT,0  ;switch SAVE off
        MOV     AL,3
        MOV     DX,CONFIG_PORT
        OUT     DX,AL
        MOV     AX,6

INIT:   PUSH    AX
        MOV     BYTE PTR ES:ACTIVE,AL   ;set emulator to ON
        CALL    XMODE
        POP     AX
        INT     10H  ;do INT 10H,although Emulator may not
                     ;be present. But if it is,the Flags
                     ;must be set correctly

SET_INT:
        MOV     CX,WORD PTR CS:HGCSEG
        MOV     DX,CS
        CMP     CX,DX  ;if SEG same,not loaded
        JNZ     LOADED ;not same segment, so resident part 
                       ;already installed

        MOV     AX,CS  ;set up INT 9,INT 10,INT 1C
        MOV     DS,AX
        MOV     AX,2510H
        MOV     DX,OFFSET VIDEO_INT
        INT     21H

        MOV     AX,251CH
        MOV     DX,OFFSET INT_1C
        INT     21H

        MOV     AX,2509H
        MOV     DX,OFFSET KEY_INT
        INT     21H

        MOV     AL,BYTE PTR ES:ACTIVE
        CMP     AL,0            ;see if emulator is on
        JZ      NO_DISPLAY
        MOV     AH,9            ;yes, tell user
        MOV     DX,OFFSET LOGON
        INT     21H
NO_DISPLAY:
        MOV     AL,BYTE PTR ES:SAVE_ACT
        OR      AL,AL           ;see if SAVE was on
        PUSH    CS
        POP     DS
        JZ      FULL_PROGRAM
        MOV     WORD PTR CS:NOP_NOP,9090H
        MOV     DX,OFFSET GR_PARAS
        INT     27H

FULL_PROGRAM:
        MOV     DX,OFFSET TRANSIENT;terminate,stay resident
        INT     27H

LOADED:
        INT     20H               ;leave without TSR-action

;This routine will copy the emulator to high memory, fool
;the system about the size of memory installed, reset the
;INT-Vectors and boot via INT 19H
BOOT:
        PUSH    CS
        POP     ES
        PUSH    CS
        POP     DS

        MOV     BYTE PTR CS:HACTIVE,AH
        MOV     WORD PTR CS:PASS_CTR,CX ;delay fill up until
;BOOT is done.This is to ensure no delay during boot
        LEA     DX,LOGON
        MOV     AH,9
        INT     21H
        LEA     DX,MESS       ;TELL USER TO INSERT DISKETTE
        MOV     AH,9
        INT     21H
        MOV     AH,1          ;WAIT FOR KEY-PRESS
        INT     21H
        MOV     AX,0D000H     ;see if memory above Video
        MOV     DS,AX
        XOR     BX,BX
        MOV     AX,1234H
        MOV     [BX],AX
        MOV     AX,[BX]
        CMP     AX,1234H
        MOV     AX,0D000H
        JZ      GOT_HIGH      ;if memory there,take that

        MOV     AX,40H        ;else fool the machine about
        MOV     DS,AX         ;the memory-size
        INT     12H
        SUB     AX,64               ;tell machine we have
        MOV     WORD PTR DS:13H,AX  ;64 K memory less
        MOV     CL,6                ;compute segment
        SHL     AX,CL
GOT_HIGH:
        MOV     ES,AX      ;put into ES
        PUSH    ES         ;SAVE SEGMENT OF "HIDDEN" MEMORY
        MOV     WORD PTR CS:INT10_OFFS,VIDEO;INIT TO NORMAL
        MOV     WORD PTR CS:INT10_SEG,BIOSSEG;VIDEO-ENTRY
        XOR     SI,SI      ;GET PSP-BEGIN
        PUSH    CS         ;GET PROGRAM-SEGMENT
        POP     DS
        MOV     DI,SI      ;SET UP FOR MOVE
        MOV     CX,OFFSET TRANSIENT ;PROGRAM-LEN
        REP     MOVSB      ;COPY PROGRAM TO HIDDEN MEMORY

NOT_COPY:
        MOV     AX,3540H   ;TEST IF HARD-DISK
        INT     21H        ;reset INT 13 vector,some games
        PUSH    ES         ;will run only if there is
        POP     DS         ;no HD present
        MOV     AX,ES      ;this will set INT 13 to the 
        MOV     DX,BX      ;normal vector,in DOS 3.x the 
        CMP     AX,BIOSSEG ;vector points to a routine in
        JZ      HD_PRES    ;DOS
        CMP     AX,0
        JNZ     HD_PRES
        MOV     AX,BIOSSEG ;THE VALUES USED ARE THE ENTRY-
                ;POINTS USED BY THE IBM-BIOS (or V20-BIOS)
        MOV     DS,AX      ;could be that they must be
        MOV     DX,DISKETTE;modified for a different BIOS
HD_PRES:
        MOV     AX,2513H   ;DISKETTE INT
        CLI                ;BUMP ALL NORMAL INT-VECTORS TO THEIR
        INT     21H        ;POWER-ON DEFAULTS
        MOV     AX,BIOSSEG
        MOV     DS,AX
        PUSH    DS
        MOV     DX,BOOT_STRAP
        MOV     AX,2519H
        INT     21H
        POP     DS
        PUSH    DS
        MOV     AX,2509H
        MOV     DX,KB_INT
        INT     21H
        POP     DS
        PUSH    DS
        MOV     AX,2510H
        MOV     DX,VIDEO
        INT     21H
        POP     DS
        PUSH    DS
        MOV     AX,2516H
        MOV     DX,KEYB
        INT     21H
        POP     DS
        PUSH    DS
        MOV     DX,DISK_INT
        MOV     AX,250EH
        INT     21H
        POP     DS
        PUSH    DS
        MOV     DX,PRTSC
        MOV     AX,2505H
        INT     21H
        POP     DS
        PUSH    DS
        MOV     DX,PRINTER
        MOV     AX,2517H
        INT     21H
        POP     DS
        PUSH    DS
        MOV     AX,2502H
        MOV     DX,NMI
        INT     21H
        POP     DS
        PUSH    DS
        MOV     DX,DUMMY
        MOV     AX,251CH
        INT     21H
        POP     DS

        PUSH    DS
        MOV     AX,2508H
        MOV     DX,CLOCK_INT
        INT     21H
        POP     DS
        POP     DS

        IF      FILL
        CMP     WORD PTR CS:PASS_CTR,0
        JZ      NO_FILL_UP
        MOV     AX,2508H
        MOV     DX,OFFSET INT_8  ;SET INT 8
        INT     21H
        ENDIF
NO_FILL_UP:
        MOV     AX,2510H
        MOV     DX,OFFSET XVIDEO
        INT     21H
NO_SET8:
        XOR     AX,AX
        MOV     ES,AX
        MOV     DI,0180H   ;RESET NON-USED INT-VECTORS
        MOV     CX,10H
        REPZ    STOSW
        MOV     DI,041AH   ;SET KEYB-MEMORY-POINTERS
        MOV     AX,1EH
        STOSW
        STOSW
        MOV     AL,3
        MOV     DX,CONFIG_PORT
        OUT     DX,AL
        MOV     AX,6
        CALL    XMODE
        MOV     AX,6
        INT     10H
        STI
        INT     19H ;BOOT VIA BOOT-STRAP ROUTINE
                    ;THIS WILL LEAVE THE INT-VECTORS

TEST_OPT:
        PUSH    ES  ;THIS ROUTINE WILL SEEK FOR AN ARGUMENT
        PUSH    CS  ;SUPPLIED IN SI AND SEARCH FROM [DI]
        POP     ES  ;Z-FLAG SET IF FOUND
        XOR     DX,DX
        MOV     DL,DS:[DI]
        INC     DI
        XOR     BX,BX
        MOV     BL,[SI]
        INC     SI
        MOV     BP,SI
NXT_CHAR:
        MOV     CX,BX
        MOV     SI,BP
END_INPUT:
        OR      CX,CX
        JZ      EXIT_OPT
        CMP     DX,CX
        JL      EXIT_OPT
        CLD
        CMPSB
        JNZ     DEC_INPUT
        DEC     CX
        DEC     DX
        JMP     SHORT   END_INPUT

DEC_INPUT:
        DEC     DX
        JMP     SHORT   NXT_CHAR

EXIT_OPT:
        POP     ES
        RET


        IF      FILL
GET_NUMB:
        MOV     AL,[DI]
        INC     DI
        MOV     CX,0200H   ;GET DEFAULT
        CMP     AL,0DH
        JZ      GET_NUM_END
        CMP     AL,1AH     ;NUMBERS ARE AFTER UPPER-CASE 
                           ;CONVERT BETWEEN 10H AND 19H
        JNB     GET_NUMB
        CMP     AL,10H
        JB      GET_NUMB
        SUB     AL,0FH
        CMP     AL,1
        JNZ     NUM_GOOD
        CMP     AH,0FFH
        JZ      NUM_GOOD
        INC     AL
NUM_GOOD:
        MOV     CH,AL
GET_NUM_END:
        RET
        ENDIF

        IF      V20
BAD_PROC:
        MOV     DX,OFFSET BAD_PROCESSOR ;we end up here if 
        PUSH    CS              ;Processor is 8088 or 8086
        POP     DS
        MOV     AH,9
        INT     21H
        INT     20H

BAD_PROCESSOR   DB 'Dieses Programm bentigt einen V20/V30 '
                DB 'oder 80286 !!',CR,LF,CR,LF,7
        ENDIF

LOGON   DB      'Color-Grafik-Emulation auf der Hercules-'
        DB      'Karte, Version 3.2',LF,CR
        DB      '   (C) Copyright Peter Khlmann/c''t 1987'
        DB      LF,CR,LF,CR,'$'

BAD_ARGUMENTS   DB      'Ungltiges Kommando',CR,LF,CR,LF,7

OPTIONS DB      CR,LF,CR,LF,'HGC - Hercules-Utility-Program'
        DB      CR,LF,CR,LF
        DB      'HGC DIAG        setzt normalen Mono-Modus'
        DB      CR,LF
        DB      'HGC HALF        ermglicht Grafik-Modus '
        DB      'Page 1',CR,LF
        DB      'HGC FULL        ermglicht Grafik-Modus '
        DB      'Page 1 + 2',CR,LF
        DB      'HGC SAVE        schaltet Bildschirm nach'
        DB      ' 5 Minuten dunkel',CR,LF
        DB      'HGC TEXT        schaltet auf Text-Modus'
        DB      CR,LF
        DB      'HGC GRAF        schaltet auf emulierten'
        DB      ' Color-Graphics-Mode',CR,LF
        DB      'HGC BOOT        gibt Warte-Meldung aus, '
        DB      'selbstbootende Disketten',CR,LF
        DB      '                werden eingelesen, emuliert'
        DB      ' Color-Modus',CR,LF

        IF      FILL
        DB      CR,LF
        DB      'HGC FGRAF [#]   wie HGC GRAF, 400 Zeilen'
        DB      CR,LF
        DB      'HGC FBOOT [#]   wie HGC BOOT, 400 Zeilen'
        DB      CR,LF
        DB      'HGC HGRAF [#]   wie HGC FGRAF, 300 Zeilen'
        DB      CR,LF
        DB      'HGC HBOOT [#]   wie HGC FBOOT, 300 Zeilen'
        DB      CR,LF
        ENDIF

        DB      '$'

MESS    DB      'Bitte Selbstboot - Diskette in Laufwerk A,'
        DB      0AH,0DH,' dann eine beliebige Taste '
        DB      'drcken !',0AH,0DH,'$'

SAVE_OFF        DB      'SAVE ist abgeschaltet',CR,LF,'$'
SAVE_ON         DB      'SAVE ist eingeschaltet',CR,LF,'$'

DIAG    DB      4,'DIAG'
HALF    DB      4,'HALF'
FULL    DB      4,'FULL'
SAVE    DB      4,'SAVE'

        IF      FILL
FBOOT   DB      5,'FBOOT'
HBOOT   DB      5,'HBOOT'
FGRAF   DB      5,'FGRAF'
HGRAF   DB      5,'HGRAF'
        ENDIF

SBOOT   DB      4,'BOOT'
TEXT    DB      4,'TEXT'
GRAF    DB      4,'GRAF'

HGCSEG  DW      0

PHGC    ENDP
HGC     ENDS

END     BEGINN
