{$R-,S-,I+,D+,T-,F-,V-,B-,N-,L+ }

{**************************************************}
{*    Unit-File mit Grafikroutinen fr den NEC P6 *}
{*         Version 1.6   ///    Dirk Meiners      *}
{**************************************************}

UNIT NEC_P6;

INTERFACE

USES Dos;

CONST  dots             = 1439;
       lines            = 179;
       space_for_buffer : Boolean = False;

PROCEDURE get_buffer;
PROCEDURE dispose_buffer;
PROCEDURE clear_buffer (value : Byte);
PROCEDURE set_dot (x_pos, y_pos : Word);
PROCEDURE remove_dot (x_pos, y_pos : Word);
FUNCTION  is_dot_set (x_pos, y_pos : Word) : Boolean;
PROCEDURE invert_dot (x_pos, y_pos : Word);
PROCEDURE invert_buffer;
PROCEDURE draw_line (x1, y1, x2, y2 : Integer);
PROCEDURE save_buffer (name_of_file : String);
PROCEDURE load_buffer (name_of_file : String);
PROCEDURE plot_buffer;

IMPLEMENTATION

TYPE   dot_line         = ARRAY [0..dots] OF Byte;
       pointer_to_line  = ^dot_line;
VAR    buffer_line      : ARRAY [0..lines] OF
                                  pointer_to_line;
       datafile_found   : Boolean;
CONST  mask_1           : ARRAY [0..7] OF Byte
                          =(128,64,32,16,8,4,2,1);
       mask_2           : ARRAY [0..7] OF Byte
                          =(127,191,223,239,247,251,253,254);

PROCEDURE get_buffer;
VAR  counter  : Word;
BEGIN
  IF ((space_for_buffer) OR (MemAvail < 259500))
     THEN exit;
  FOR counter := 0 TO lines DO
      New (buffer_line[counter]);
  space_for_buffer := True
END;  {*  of 'get_buffer'  *}

PROCEDURE dispose_buffer;
VAR  counter  : Word;
BEGIN
  IF (space_for_buffer)
     THEN FOR counter := lines DOWNTO 0 DO
              Dispose (buffer_line[counter]);
  space_for_buffer := False
END;  {*  of 'dispose_buffer'  *}

PROCEDURE clear_buffer (value : Byte);
VAR  counter : Word;
BEGIN
  FOR counter := 0 TO lines DO
      FillChar (buffer_line[counter]^, Succ (dots), value)
END;  {*  of 'clear_buffer'  *}

PROCEDURE set_dot (x_pos, y_pos : Word);
VAR    row     : Word;
BEGIN
  row := y_pos SHR 3;
  buffer_line[row]^[x_pos] := buffer_line[row]^[x_pos] OR
                              mask_1[y_pos AND $07]
END;  {*  of 'set_dot'  *}

PROCEDURE remove_dot (x_pos, y_pos : Word);
VAR    row     : Word;
BEGIN
  row := y_pos SHR 3;
  buffer_line[row]^[x_pos] := buffer_line[row]^[x_pos] AND
                              mask_2[y_pos AND $07]
END;  {*  of 'remove_dot'  *}

FUNCTION is_dot_set (x_pos, y_pos : Word) : Boolean;
BEGIN
  is_dot_set := (buffer_line[y_pos SHR 3]^[x_pos] AND
                 mask_1[y_pos AND $07]) > 0
END;  {*  of 'is_dot_set'  *}

PROCEDURE invert_dot (x_pos, y_pos : Word);
VAR    row     : Word;
BEGIN
  row := y_pos SHR 3;
  buffer_line[row]^[x_pos] := NOT (buffer_line[row]^[x_pos]
                              XOR mask_2[y_pos AND $07])
END;  {*  of 'invert_dot'  *}

PROCEDURE invert_buffer;
TYPE   dummy_line = ARRAY [0..dots] OF Word;
VAR    dummy       : ^dummy_line;
       half_steps,
       row,
       column      : Word;
BEGIN
  half_steps := dots DIV 2;
  FOR row := 0 TO lines DO
    BEGIN
      dummy := @buffer_line[row]^;
      FOR column := 0 TO half_steps DO
          dummy^[column] := NOT dummy^[column]
    END
END;  {*  of 'invert_buffer'  *}

PROCEDURE draw_line (x1, y1, x2, y2 : Integer);
{   Bresenham-Algorithmus   }
VAR   step,
      delta,
      delta_x,
      delta_y,
      direction_x,
      direction_y  : Integer;
BEGIN
  IF (x1 < x2)
     THEN direction_x := 1
     ELSE direction_x := -1;
  IF (y1 < y2)
     THEN direction_y := 1
     ELSE direction_y := -1;
  delta_x := ABS (x1 - x2);
  delta_y := ABS (y1 - y2);
  IF (delta_x >= delta_y)
     THEN BEGIN
            delta_y := 2 * delta_y;
            delta := delta_y - delta_x;
            delta_x := 2 * delta_x;
            FOR step := 0 TO (delta_x DIV 2) DO
              BEGIN
                invert_dot (x1, y1);
                IF (delta > 0)
                   THEN BEGIN
                          y1 := y1 + direction_y;
                          Inc (delta, delta_y - delta_x);
                        END
                   ELSE Inc (delta, delta_y);
                Inc (x1, direction_x)
              END
          END
     ELSE BEGIN
            delta_x := 2 * delta_x;
            delta := delta_x - delta_y;
            delta_y := 2 * delta_y;
            FOR step := 0 TO (delta_y DIV 2) DO
              BEGIN
                invert_dot (x1, y1);
                IF (delta > 0)
                   THEN BEGIN
                          x1 := x1 + direction_x;
                          Inc (delta, delta_x - delta_y);
                        END
                   ELSE Inc (delta, delta_x);
                Inc (y1, direction_y)
              END
          END
END;  {*  of 'draw_line'  *}

{$S+}

PROCEDURE save_buffer (name_of_file : String);
VAR    datafile  : FILE OF dot_line;
       counter   : Word;
BEGIN
  Assign (datafile, name_of_file);
  Rewrite (datafile);
  FOR counter := 0 TO lines DO
      Write (datafile, buffer_line[counter]^);
  Close (datafile)
END;  {*  of 'save_buffer'  *}

PROCEDURE load_buffer (name_of_file : String);
VAR    datafile  : FILE OF dot_line;
       counter   : Word;
BEGIN
  Assign (datafile, name_of_file);
  {$I-}
  Reset (datafile);
  {$I+}
  datafile_found := (IOResult = 0);
  IF (datafile_found)
     THEN FOR counter := 0 TO lines DO
              Read (datafile, buffer_line[counter]^);
  Close (datafile)
END;  {*  of 'load_buffer'  *}

PROCEDURE write_ch (ch : byte);
VAR   reg  : Registers;
BEGIN
  reg.ah := 5;
  reg.dl := ch;
  MsDos (reg)
END;  {*  of 'write_ch'  *}

PROCEDURE write_string (VAR st : String);
VAR  counter : Byte;
BEGIN
  FOR counter := 1 to Length (st) DO
      write_ch (Byte (st[counter]))
END;  {*  of 'write_string'  *}

PROCEDURE plot_buffer;
VAR    line         : Word;
       counter      : Word;
CONST  short_space  : String [3] = #27'A'#8;
       wide_space   : String [2] = #27'2';
       graphic      : String [5] = #27'*'#39#160#5;
BEGIN
  write_ch (10);  {*  Papier spannen, wichtig.  *}
  write_string (short_space);
  line := 0;
  WHILE (line <= lines) DO
    BEGIN
      write_string (graphic);
      FOR counter := 0 TO dots DO
        BEGIN
          write_ch (buffer_line[line]^[counter]);
          write_ch (buffer_line[line + 1]^[counter]);
          write_ch (buffer_line[line + 2]^[counter])
        END;
      write_ch (13);
      write_ch (10);
      INC (line, 3);
    END;
  write_string (wide_space);
  write_ch (12)
END;  {*  of 'plot_buffer'  *}

END.  {*  of the unit 'NEC_P6'  *}

