; CONFIG-B.ASM
; c't-Bgeholz 7/88
; Aufruf CONFIG-B xx
; Dieses Programm trgt ins Konfigurations-RAM eines
; IBM PS/2 Model 50/60/80 den Laufwerkstyp xx als Laufwerk B ein.
; Entscheidend ist hierbei, da die beiden CRC-Bytes
; richtig gesetzt werden, so da es beim Booten keine
; Fehlermeldungen gibt.

; und jetzt erst mal die blichen Vorbemerkungen fr COM-Files
CODE	SEGMENT	PARA PUBLIC 'CODE'
	ASSUME	CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG	100H
ENTRY:	JMP	START

	ORG	110H
; Dieser Puffer nimmt den Inhalt des Konfigurations-RAMs auf
BUFFER:	DB	24H DUP (0)
DRIVETYPE: DB   00

; Zuerst gewnschten Drivetyp von Paramterzeile holen
START:  MOV     AL,CS:80h
        CMP     AL,2            ; ein Parameter angegeben?
        JNZ     EINTR           ; nein, dann Drivetyp=0
        MOV     AL,CS:82h       ; Parameter holen
        SUB     AL,'0'          ; ASCII-abziehen
        JC      EINTR           ; falscher Parameter
        CMP     AL,4            ;
        JA      EINTR           ; falscher Parameter
        MOV     BYTE PTR [DRIVETYPE],AL;

; nun wird die gewnschte nderung ins CMOS-RAM eingetragen:
 EINTR:	CLI				; Interrupts abschalten
	MOV	AL,10H			; Register Nr. 10H (Disk Type)
	OUT	70H,AL			; auswhlen
	NOP
	IN	AL,71H			; CMOS-RAM lesen
	AND	AL,0F0H			; Bits fr Drive B lschen und
	OR	AL, BYTE PTR DRIVETYPE	; richtigen Drive-Typ einsetzen
	MOV	AH,AL			; das ganze mal eben in AH
	MOV	AL,10H			; wieder Adresse 10H auswhlen
	OUT	70H,AL
	MOV	AL,AH			; Drive-Bits holen ...
	OUT	71H,AL			; und ins CMOS-RAM schreiben.
	MOV	AL,0DH			; auf Empfehlung von IBM ...
	OUT	70H,AL			; Register 0DH anwhlen
	NOP				; einen Moment warten
	IN	AL,71H			; Dummy-Byte lesen und
	STI				; einen Interrupt dazwischenlassen
; Nachdem alle gewnschten nderungen im CMOS-RAM erfolgt sind, mssen
; jetzt die neuen CRC-Bytes berechnet werden. Dazu erstmal den kompletten
; RAM-Inhalt in einen Puffer einlesen ...
	MOV	DI,OFFSET BUFFER	; Pufferadresse
	MOV	CX,24H			; Anzahl der zu lesenden Bytes
	MOV	DL,10H			; Anfangsadresse (CMOS)
	CLI				; Interrupts sperren
RDCFG:	MOV	AL,DL			; Adresse im CMOS-RAM
	OUT	70H,AL			; anwhlen
	NOP				; einen Moment warten
	IN	AL,71H			; und Inhalt lesen.
	STOSB				; im Puffer speichern.
	INC	DL			; nchstes Register
	LOOP	RDCFG			; ...
	MOV	AL,0DH			; auf Empfehlung von IBM ...
	OUT	70H,AL			; Register 0DH anwhlen
	NOP				; kurze Verzgerung
	IN	AL,71H			; das mu angeblich sein
	STI				; und wieder Interrupts zulassen
; Jetzt wird der CRC berechnet ...
	MOV	DX,0			; Anfangswerte fr CRC-Generator
	MOV	AX,0FFFFH		; ditto
	MOV	SI,OFFSET BUFFER	; Pufferadresse laden
	MOV	CX,22H			; Anzahl der zu bearbeitenden Bytes
CRC:	MOV	DL,[SI]			; Byte aus dem Puffer lesen
	INC	SI			; nchste Pufferadresse
	XOR	AH,DL			; diverse Manipulationen ...
	MOV	DL,AH			; das schreibt man am besten so ab
	ROL	DX,1
	ROL	DX,1
	ROL	DX,1
	ROL	DX,1
	XOR	AX,DX
	ROL	DX,1
	XCHG	AL,AH
	XOR	AX,DX
	ROR	DX,1
	ROR	DX,1
	ROR	DX,1
	ROR	DX,1
	AND	DL,0E0H
	XOR	AX,DX
	ROR	DX,1
	XOR	AH,DL
	LOOP	CRC			; ...
; Das AX-Register enthlt jetzt die bentigten CRC-Bytes. Diese mssen
; jetzt nur noch ins CMOS-RAM eingetragen werden.
	MOV	DX,AX			; AX wird anderweitig gebraucht
	CLI				; Interrupts sperren
	MOV	AL,32H			; Register 32H (CRC MSB)
	OUT	70H,AL			; anwhlen
	MOV	AL,DH			; hherwertiges CRC-Byte
	OUT	71H,AL			; ins CMOS-RAM schreiben.
	MOV	AL,33H			; Register 33H (CRC LSB)
	OUT	70H,AL			; anwhlen
	MOV	AL,DL			; niederwertiges CRC-Byte
	OUT	71H,AL			; ins CMOS-RAM schreiben.
	MOV	AL,0DH			; Auf Empfehlung von IBM ...
	OUT	70H,AL			; Register 0DH anwhlen
	NOP				; kurze Verzgerung
	IN	AL,71H
	STI				; und wieder Interrupts zulassen.
; Jetzt noch einen kleinen Text ausgeben
        MOV     BX,0
        MOV     BL,BYTE PTR DRIVETYPE
        MOV     AX,40h                  ;
        MOV     ES,AX                   ; Media established Flag lschen
        MOV     BYTE PTR ES:[91H],BL    ; und Typ eintragen
        ADD     BX,BX
	MOV	DX,WORD PTR TEXTTAB[BX] ; Adresse des Textes
	MOV	AH,9			; DOS-Funktion "Print String"
	INT	21H			; aufrufen
   	MOV	AX,4C00H		; und mit ERRORLEVEL 0
	INT	21H			; beenden.

; Wer mchte, kann sich diese Meldungen auch auf Deutsch anzeigen lassen
TEXTTAB:DW     TEXT0
        DW     TEXT1
        DW     TEXT2
        DW     TEXT3
        DW     TEXT4

TEXT0   DB      'Config-B: no Drive B',0dh,0ah,'$'
TEXT1   DB      'Config-B: Drive B configured as 5.25" 360KB Drive.'
        DB      0dh,0ah,'$'
TEXT2	DB	'Config-B: Drive B configured as 5.25" 1.2MB/360KB Drive.'
        DB      0dh,0ah,'$'
TEXT3   DB      'Config-B: Drive B configured as 3.5" 720 KB Drive.'
        DB      0dh,0ah,'$'
TEXT4   DB      'Config-B: Drive B configured as 3.5" 1.44MB/720 KB Drive.'
        DB      0dh,0ah,'$'

CODE	ENDS

	END	ENTRY
; 360KBIOS.ASM fr IBM PS/2 Model 50/60/80
; c't-Bgeholz 7/88
; Dieses Programm hngt sich in den INT 13H ein (Disketten-Funktionen)
; und untersttzt das BIOS bei der Erkennung des 360K-Formates.

	.286C			; es kommen ein paar 80286-Befehle vor

BIOS_DATA SEGMENT AT 40H

	ORG	90H
MEDIA_STATE	LABEL	BYTE

BIOS_DATA ENDS

CODE	SEGMENT	PARA PUBLIC 'CODE'

	ASSUME	CS:CODE

	ORG	2CH
ENV_SEG	LABEL	WORD		; Segmentadresse des Environments

; COM-Files fangen immer bei 100H an...
	ORG	100H
ENTRY:	JMP	INIT

OLDVEC	LABEL	DWORD		; Hier wird der alte INT 13H-Vektor
OLDVEC_OFS	DW	?	; gespeichert.
OLDVEC_SEG	DW	?

CALL_AX	DW	?		; Hier werden - statt auf dem Stack -
CALL_BX	DW	?		; die Registerinhalte zwischengespeichert.
CALL_CX	DW	?
CALL_DX	DW	?
CALL_SI	DW	?
CALL_DI	DW	?
CALL_ES	DW	?
RETURN_AX DW	?
RETURN_SI DW	?
ALTERNATE_FORMAT DB	?

; Wir drfen in der Interrupt-Routine ber die Segment-Register nichts
; voraussetzen:
	ASSUME	DS:NOTHING, ES:NOTHING

OLD13:	CLI
	JMP	[OLDVEC]	; Aufruf des alten Vektors

; Neue Einsprungadresse fr den INT 13H.
NEW13	PROC	FAR
	STI			; Interrupts zulassen
	CMP	AH,2		; Funktionscode in AH prfen.
	JB	OLD13		; wenn er nicht zwischen 2 und 4 liegt
	CMP	AH,5		; (Read, Write, Verify)
	JNB	OLD13		; -> nichts unternehmen
	CMP	DL,2		; Laufwerks-Nummer 0 oder 1 ?
	JNB	OLD13		; nein -> nichts unternehmen
	MOV	CALL_AX,AX	; Die wesentlichen Registerinhalte
	MOV	CALL_BX,BX	; sichern, damit der Aufruf eventuell
	MOV	CALL_CX,CX	; noch einmal wiederholt werden kann
	MOV	CALL_DX,DX
	MOV	CALL_SI,SI
	MOV	CALL_DI,DI
	MOV	CALL_ES,ES
	MOV	AX,BIOS_DATA	; Zugriff auf BIOS-Datenbereich vorbereiten
	MOV	ES,AX		; ber das (oben gerettete) ES-Register
	ASSUME	ES:BIOS_DATA	; ... damit der Assembler Bescheid wei
	MOV	DH,0		; DX=Drive #
	MOV	DI,DX		; DI=Drive #
	TEST	MEDIA_STATE[DI],10H	; wurde das Format bereits erkannt?
	JNZ	GOOLDX			; ja -> nichts weiter unternehmen
	CALL	READ_CMOS_DISK_TYPE	; Laufwerkstyp feststellen
	JC	GOOLDX			; CRC-Error -> nichts unternehmen
	MOV	CX,9717H	; Formate fr 3,5"-Disks vorbereiten
	CMP	AL,4		; ist es ein 1,44MB-Drive ?
	JZ	DT_OK		; ja -> diese Formate ausprobieren
	MOV	CX,1574H	; sonst Formate fr MF-Drive vorbereiten
	CMP	AL,2		; ist es ein 1.2MB-Drive ?
	JZ	DT_oK
GOOLDX:	JMP	GOOLD		; nein -> nichts weiter unternehmen
DT_OK:	MOV	MEDIA_STATE[DI],CH  ; Format fr ersten Versuch festlegen
	MOV	ALTERNATE_FORMAT,CL ; und fr zweiten Versuch merken
	MOV	SI,SP		; Flags aus dem Stack fischen (sie
	MOV	AX,SS:4[SI]	; wurden vom INT dort abgelegt)
	PUSH	AX		; und auf dem Stack ablegen
	MOV	AX,CALL_AX	; alle Registerinhalte wiederherstellen
	MOV	BX,CALL_BX
	MOV	CX,CALL_CX
	MOV	DX,CALL_DX
	MOV	SI,CALL_SI
	MOV	DI,CALL_DI
	MOV	ES,CALL_ES
	ASSUME	ES:NOTHING
	CLI
	CALL	[OLDVEC]	; und alten Vektor aufrufen
	PUSHF			; Flags retten
	MOV	RETURN_AX,AX	; diese beiden Register werden u.U.
	MOV	RETURN_SI,SI	; verndert ...
	JNC	RET13		; Kein Fehler aufgetreten -> auch recht
	CMP	AH,6		; War es `Disk change'?
	JE	RET13		; ja -> nichts unternehmen
	POPF			; Flags werden nicht mehr gebraucht
	MOV	AX,BIOS_DATA	; Zugriff auf BIOS-Daten vorbereiten
	MOV	ES,AX		; ES-Register benutzen
	ASSUME	ES:BIOS_DATA	; ... damit der Assembler Bescheid wei
	MOV	DX,CALL_DX	; Laufwerksnummer holen
	MOV	DH,0		; DX = Laufwerksnummer
	MOV	DI,DX		; DI = Laufwerksnummer
	MOV	AL,ALTERNATE_FORMAT	; Format-Byte fr zweiten Versuch
	MOV	MEDIA_STATE[DI],AL	; speichern
GOOLD:	MOV	AX,CALL_AX	; alle Registerinhalte wiederherstellen
	MOV	BX,CALL_BX
	MOV	CX,CALL_CX
	MOV	DX,CALL_DX
	MOV	SI,CALL_SI
	MOV	DI,CALL_DI
	MOV	ES,CALL_ES
	ASSUME	ES:NOTHING
	CLI
	JMP	[OLDVEC]	; und alten Vektor aufrufen (endgltig)

RET13:	POP	AX              ; Dies sind die Flags nach dem BIOS-Aufruf
	MOV	SI,SP		; Die speichern wir wieder im Stack,
	MOV	SS:4[SI],AX     ; wo sie der IRET dann liest...
	MOV	AX,RETURN_AX	; AX und
	MOV	SI,RETURN_SI	; SI wiederherstellen
	IRET

NEW13	ENDP

READ_CMOS PROC NEAR
	PUSHF		; Flags retten
	ROL	AL,1	; Bit 7 in Bit 0 zwischenspeichern (NMI Maske)
	STC		; NMI-Maske wird fr den Zugriff gesetzt
	RCR	AL,1	; das ursprngliche Bit 7 ist jetzt in CY
	CLI		; normale Interrupts sperren
	OUT	70H,AL	; CMOS-Adresse ausgeben
	NOP		; kurze Verzgerung ...
	IN	AL,71H	; Byte aus dem RAM lesen
	PUSH	AX	; und speichern
	MOV	AL,1EH	; Register 0FH wird angewhlt (vorsichtshalber)
	RCR	AL,1	; mit der NMI-Maske aus dem CY-Flag
	OUT	70H,AL	; Adresse ausgeben
	NOP		; kurze Verzgerung
	IN	AL,71H	; dummy-Byte lesen (wird nicht gebraucht)
	POP	AX	; gelesenes Byte vom Stack holen
	POPF		; Flags wiederherstellen
	RET
READ_CMOS ENDP

READ_CMOS_DISK_TYPE PROC NEAR
	MOV	AL,0EH		; `Diagnostic Status Byte' anwhlen
	CALL	READ_CMOS	; und aus dem CMOS-RAM lesen
	TEST	AL,0C0H		; CRC-Error ?
	STC			; CY setzen als Fehler-Flag
	JNZ	L0EBF		; und im Fehlerfalle -> return
	MOV	AL,10H		; `Diskette Drive Type Byte'
	CALL	READ_CMOS	; aus dem CMOS-RAM lesen
	OR	DI,DI		; Laufwerk 0 ?
	JNZ	L0EBD		; nein -> untere 4 Bits benutzen
	ROR	AL,4		; ansonsten obere 4 Bits benutzen
L0EBD:	AND	AL,0FH		; andere Hlfte lschen
L0EBF:	RET
READ_CMOS_DISK_TYPE ENDP

END_RESIDENT	LABEL BYTE	; Hier endet der residente Teil

; Es folgt die Installationsroutine
	ASSUME	DS:CODE
INIT:
	MOV	AX,3513H	; `Get Interrupt' 13H
	INT	21H		; MS-DOS
	MOV	OLDVEC_OFS,BX	; alten Vektor speichern
	MOV	OLDVEC_SEG,ES
	MOV	DX,OFFSET NEW13	; und neuen Vektor holen
	MOV	AX,2513H	; `Set Interrupt' 13H
	INT	21H		; MS-DOS
	MOV	ES,ENV_SEG	; Das Environment brauchen wir nicht mehr
	MOV	AH,49H		; `Free memory'
	INT	21H		; MS-DOS
	MOV	AX, seg BIOS_Data ;
	MOV	DS,AX             ; lscht
 ASSUME	DS:	BIOS_Data
 	MOV	MEDIA_STATE[1],2 ; Media-Established-Bit, setzt Typ 2
	MOV	DX,OFFSET END_RESIDENT
	MOV	CL,4		; Anzahl der residenten `Paragraphs'
	SHR	DX,CL		; ermitteln. Dazu durch 16 teilen
	INC	DX		; und aufrunden
	MOV	AX,3100H	; `Terminate and stay resident'
	INT	21H		; MS-DOS

CODE	ENDS

	END	ENTRY
; DSTEP.ASM fr IBM PS/2 Model 50/60/80
; c't-Bgeholz,A.S.  7/88
; Dieses Programm hngt sich in den INT 13H ein (Disketten-Funktionen)
; und schaltet bei Low-Density auf Doppelstep.
: (einfacher, aber nicht so leistungsfhig wie 360KBIOS.ASM)

	.286C			; es kommen ein paar 80286-Befehle vor

BIOS_DATA SEGMENT AT 40H

	ORG	90H
MEDIA_STATE	LABEL	BYTE

BIOS_DATA ENDS

CODE	SEGMENT	PARA PUBLIC 'CODE'

	ASSUME	CS:CODE

	ORG	2CH
ENV_SEG	LABEL	WORD		; Segmentadresse des Environments

; COM-Files fangen immer bei 100H an...
	ORG	100H
ENTRY:	JMP	INIT

OLDVEC	LABEL	DWORD		; Hier wird der alte INT 13H-Vektor
OLDVEC_OFS	DW	?	; gespeichert.
OLDVEC_SEG	DW	?

; Wir drfen in der Interrupt-Routine ber die Segment-Register nichts
; voraussetzen:
	ASSUME	DS:NOTHING, ES:NOTHING

OLD13:	CLI
	JMP	[OLDVEC]	; Aufruf des alten Vektors

; Neue Einsprungadresse fr den INT 13H.
NEW13	PROC	FAR
	STI			; Interrupts zulassen
	CMP	AH,2		; Funktionscode in AH prfen.
	JB	OLD13		; wenn er nicht zwischen 2 und 4 liegt
	CMP	AH,5		; (Read, Write, Verify)
	JNB	OLD13		; -> nichts unternehmen
	CMP	DL,2		; Laufwerks-Nummer 0 oder 1 ?
	JNB	OLD13		; nein -> nichts unternehmen
	PUSH	DS              ; nur diese drei Register
 	PUSH	DI              ; werden gebraucht
 	PUSH	DX
	MOV	DI,SEG BIOS_DATA;
	MOV	DS,DI           ; um Media_Status-Byte
	ASSUME	DS:BIOS_DATA;   ; abzufragen
	MOV	DH,0
 	MOV	DI,DX;
 	CMP	MEDIA_STATE[DI],57h; Wert bei Low-Density
	JNZ	SKIP               ; nein, dann nicht
	OR	MEDIA_STATE[DI],20h; sonst setz Doppelstep
SKIP:	POP     DX
	POP	DI
 	POP	DS
 	JMP	OLD13
NEW13	ENDP

END_RESIDENT	LABEL BYTE	; Hier endet der residente Teil

; Installationsroutine wie zuvor in 360KBIOS.ASM
