#include <stdio.h>

/* globale Struktur, in der Daten auch
   zwischen Programmsegmenten ausgetauscht werden */
struct  {int  tag, monat, jahr, tgind;} datum;

/* Liste der Tage pro Monat,
   einmal fr Schaltjahre - einmal fr andere */
char  tab_tage[2][12] = { { 31,28,31,30,31,30,31,31,30,31,30,31 },
                          { 31,29,31,30,31,30,31,31,30,31,30,31 } };

/* liefert zu einem Jahr den boolschen Wert
   'Schaltjahr ja' oder 'Schaltjahr nein'   */
int  schalt (j)
register int  j;
{ return(j % 4 == 0 && j % 100 != 0 || j % 400 == 0);
}                      

/* berechnet aus einem Datum die
   laufende Nummer des Tages im Jahr */
int  tag_num (t, m, j)
register int  t, m, j;
{ register char  *tm = tab_tage[schalt(j)];

  while(--m)  t += *tm++;
  return(t);
}

/* berechnet aus der Jahreszahl und einer
   laufenden Nummer das zugehrige Datum  */
num_tag (jahr, lfd)
int  jahr, lfd;
{ register int  i;
  register char  *t;

  while(lfd < 1)  lfd += tag_num(31, 12, --jahr);
  t = tab_tage[schalt(jahr)];
  for(i=1; lfd > *t && i < 13; i++)  lfd -= *t++;
  if(i > 12)  num_tag(++jahr, lfd);
  else  { datum.monat = i;                        /* Rckgabe ber    */
          datum.tag   = lfd;                      /* die globale      */
          datum.jahr  = jahr;                     /* Struktur 'datum' */
}       }

/* berechnet fr ein vorgegebenes Datum den Wochentag
   (mit den  hier auskommentierten Programmteilen gibt
   die Funktion den Wochentag als String zurck -
   fr dieses Programm gengt es, da die globale
   Variable 'datum.tgind' korrekt gesetzt wird)       */
char  *wotag(t,m,j)
register int  j, m, t;
{ long f;

  f = (j-1)*365L   /* Tage bis Jahresbeginn (365 Tage pro Jahr   */
      + (j-1)/4L   /* plus der Schalttage */
      -(j-1)/100L  /* Jahre modulo 100 waren keine Schaltjahre */
      + (j-1)/400L /* auer denen, die modulo 400 */
      + (long) tag_num(t,m,j) -1L; /* plus Tage bis akt. Datum */
  datum.tgind = (int) (f % 7L); /* modulo 7 ergibt Index */
}

/* Konstanten fr die Berechnung der Feiertage */
/* Anzahl der zu berechneden Feiertage */
#define A_FEI 15
/*Position der Feiertage im Array 't_ftag[]' (siehe unten) */
#define MUTT 2
#define KARF 3
#define OST1 4
#define OST2 5
#define CHRI 6
#define PFI1 7
#define PFI2 8
#define FRON 9
#define BUSS 12

feier_tage(jj)
int  jj;
{ struct w_ftag { char tag;               /*Struktur eines Feiertages */
                  char monat;
                  char bez[30];
                };
  static struct  w_ftag t_ftag[] = {                /* alle Feiertage */
                  {  1,  1, "Neujahr                      " }  /*  0 */
                 ,{  1,  5, "Maifeiertag                  " }  /*  1 */
                 ,{  0,  0, "Muttertag                    " }  /*  2 */
                 ,{  0,  0, "Karfreitag                   " }  /*  3 */
                 ,{  0,  0, "Ostersonntag                 " }  /*  4 */
                 ,{  0,  0, "Ostermontag                  " }  /*  5 */
                 ,{  0,  0, "Christi Himmelfahrt          " }  /*  6 */
                 ,{  0,  0, "Pfingstsonntag               " }  /*  7 */
                 ,{  0,  0, "Pfingstmontag                " }  /*  8 */
                 ,{  0,  0, "Fronleichnam                 " }  /*  9 */
                 ,{ 17,  6, "Tag der deutschen Einheit    " }  /* 10 */
                 ,{  1, 11, "Allerheiligen                " }  /* 11 */
                 ,{  0,  0, "Bu- und Bettag              " }  /* 12 */
                 ,{ 25, 12, "1. Weihnachtstag             " }  /* 13 */
                 ,{ 26, 12, "2. Weihnachtstag             " }  /* 14 */
                                   };
  static struct  w_ftag t_stag[A_FEI];
  struct  w_ftag t_ztag;
  static int  erst = 0;
  register int  mm, tt, i, j, a, b;

  if (!erst)  for(i=0; i<A_FEI; i++)  t_stag[i] = t_ftag[i];
  else  for(i=0; i<A_FEI; i++)  t_ftag[i] = t_stag[i];
  erst = 1;

  i = jj/100 - jj/400 + 4;                                  /* Ostern */
  j = i - jj/300 + 11;                                  /* nach Gauss */
  a = (((jj % 19) * 19) + j) % 30;
  b = (((jj % 4) * 2 + (4 * jj) + (6 * a) + i) % 7) + a - 9;
  if (b < 1)  { tt = 31 + b; mm = 3; }
  else
  { if ((b==26) || ((a==28) && (b==25) && ((11 * (j + 1) % 30) < 19)))
      b -= 7;
    tt = b; mm = 4;
  }
  num_tag(jj, tag_num(tt, mm, jj));
  t_ftag[OST1].monat = datum.monat;  t_ftag[OST1].tag = datum.tag;
  num_tag(jj, 1 + tag_num(datum.tag, datum.monat, jj));
  t_ftag[OST2].monat = datum.monat;  t_ftag[OST2].tag = datum.tag;
  num_tag(jj, -3 + tag_num(datum.tag, datum.monat, jj));
  t_ftag[KARF].monat = datum.monat;  t_ftag[KARF].tag = datum.tag;
                                                         /* Pfingsten */
  num_tag(jj, 51 + tag_num(datum.tag, datum.monat, jj));
  t_ftag[PFI1].monat = datum.monat;  t_ftag[PFI1].tag = datum.tag;
  j = tag_num(datum.tag, datum.monat, jj);
  num_tag(jj, 1 + tag_num(datum.tag, datum.monat, jj));
  t_ftag[PFI2].monat = datum.monat;  t_ftag[PFI2].tag = datum.tag;

  num_tag(jj, -10 + tag_num(t_ftag[PFI1].tag,          /* Himmelfahrt */
                            t_ftag[PFI1].monat, jj));
  t_ftag[CHRI].monat = datum.monat;  t_ftag[CHRI].tag = datum.tag;

  num_tag(jj, 11 + tag_num(t_ftag[PFI1].tag,          /* Fronleichnam */
                           t_ftag[PFI1].monat, jj));
  t_ftag[FRON].monat = datum.monat;  t_ftag[FRON].tag = datum.tag;

  mm = 11;  tt = 1;                                         /* Butag */
  wotag(tt, mm, jj);
  i = datum.tgind;
  t_ftag[BUSS].tag = (i < 2) ? 17-i : 24-i;
  t_ftag[BUSS].monat = mm;

  mm = 5;   tt = 1;                                      /* Muttertag */
  for(;;)
  { wotag(tt, mm, jj);
    if(datum.tgind == 6)  break;
    tt++;
  }
  a = tag_num(tt, mm, jj) + 7;
  b = (j == a) ? a-7 : a;
  num_tag(jj, b);
  t_ftag[MUTT].monat = datum.monat;  t_ftag[MUTT].tag = datum.tag;

  j = 1;                                       /* Feiertage sortieren */
  while(j)
  { j = 0;
    for(i=0; i < A_FEI-1; i++)
    { if (tag_num(t_ftag[i+1].tag, t_ftag[i+1].monat, jj)
         < tag_num(t_ftag[i].tag, t_ftag[i].monat,jj))
      { j = 1;
        t_ztag = t_ftag[i];
        t_ftag[i] = t_ftag[i+1];
        t_ftag[i+1] = t_ztag;
  } } }
                                                /* Feiertage ausgeben */
 j = A_FEI / 2;
 printf("\n");
 for(i=0; i<j; i++)
   printf("%2d.%2d. %s    %2d.%2d. %s\n", t_ftag[i].tag,
                                          t_ftag[i].monat,
                                          t_ftag[i].bez,
                                          t_ftag[i+j].tag,
                                          t_ftag[i+j].monat,
                                          t_ftag[i+j].bez );
 if(A_FEI%2) printf("\t\t\t\t\t%2d.%2d. %s\n", t_ftag[A_FEI-1].tag,
                                               t_ftag[A_FEI-1].monat,
                                               t_ftag[A_FEI-1].bez);
}

/* gibt den Kalender in Tabellenform aus */
kalender(jahr)
int  jahr;
{ /* Der Rahmen */
  static char  *ueb[] = {
"\n              Januar               Februar              Mrz\n",
"\n              April                Mai                  Juni\n",
"\n              Juli                 August               September\n",
"\n              Oktober              November             Dezember\n"
                        };
  static char  *t_tagef[] = { "Montag    ", "Dienstag  ", "Mittwoch  ",
                              "Donnerstag", "Freitag   ", "Samstag   ",
                              "Sonntag   " };
  static char  t_kal[13][6][7];           /* dreidimensionale Tabelle */
  int  index, zwoche, alt_monat = 0;
  register int  i, k, t, j = schalt(jahr) ? 366 : 365;

  printf( "Jahreskalender  %d\n", jahr);
  for(i=1; i<=j; i++)
  { num_tag(jahr,i);
    wotag(datum.tag, datum.monat, datum.jahr);
    index = datum.tgind;
    if(alt_monat != datum.monat)
      { alt_monat = datum.monat;  zwoche = 0; }
    t_kal[datum.monat][zwoche][index] = datum.tag;
    if(index == 6)  zwoche++;
  }
  for(i=0, k=1; i < 4; i++, k+=3)
  { printf("%s", ueb[i]);
    for(t=0; t<7; t++)
    { printf(t_tagef[t]);
      for(index=0; index<3; index++)
      { printf("   ");
        for(j=0; j < 6; j++)
          if(t_kal[k+index][j][t] == 0)  printf("   ");
          else
          { printf("%2d ",t_kal[k+index][j][t]);
            t_kal[k+index][j][t] = 0;
       }  }
      printf("\n");
} } }

main()
{ int ein;

  while(1)
  { printf("\nFr welches Jahr bentigen Sie den Kalender? ");
    scanf("%d\n",&ein);
    if(ein <= 0)  exit(0);
    kalender(ein);
    feier_tage(ein);
} }
