{$R-,S+,I+,D+,T-,F-,V-,B-,N-,L+ }
{$M 65520,0,655360 }

PROGRAM Printergraphik_Demo;

USES Crt, Dos, NEC_P6;

  PROCEDURE demonstration_1;
  VAR  counter1,
       middle_dot : Word;

    PROCEDURE mirror_pattern;
    VAR  counter1,
         counter2  : Word;
    BEGIN
      FOR counter1 := 0 TO middle_dot DO
          FOR counter2 := 0 TO counter1 DO
              IF is_dot_set (counter1, counter2)
                 THEN BEGIN
                   set_dot(dots - counter1, counter2);
                   set_dot(counter2, counter1);
                   set_dot(counter2, dots - counter1);
                   set_dot(dots - counter2, counter1);
                   set_dot(dots - counter2, dots - counter1);
                   set_dot(counter1, dots - counter2);
                   set_dot(dots - counter1, dots - counter2);
                      END
    END;  {*  of 'mirror_pattern'  *}

  BEGIN
    WriteLn ('Zunchst wird ein interessantes Muster erzeugt.');
    WriteLn ('Dieser Test bentigt lngere Zeit,',
             ' bitte etwas Geduld.', #10);
    WriteLn ('Getestet werden folgende Prozeduren :');
    WriteLn ('- get_buffer');
    WriteLn ('- clear_buffer');
    WriteLn ('- draw_line');
    WriteLn ('- invert_dot');
    WriteLn ('- is_dot_set');
    WriteLn ('- set_dot');
    WriteLn ('- plot_buffer', #10);
    Write ('Ich rechne . . . ');
    clear_buffer (0);
    middle_dot := dots DIV 2;
    FOR counter1 := 0 TO middle_dot DO
        draw_line (counter1, 0, middle_dot, middle_dot);
    mirror_pattern;
    WriteLn ('fertig !', #7, #10);
    Write ('Ich drucke . . . ');
    plot_buffer;
    WriteLn ('fertig !', #7, #10, #10);
  END;  {*  of 'demonstration_1'  *}

  PROCEDURE demonstration_2;
  BEGIN
    WriteLn ('Nun wird die Grafik abgespeichert ',
             '(mindestens 259200 Bytes freier');
    WriteLn ('Plattenspeicher erforderlich !), ',
             'wieder eingelesen, invertiert');
    WriteLn ('und erneut ausgedruckt.');
    WriteLn ('Getestet werden folgende Prozeduren :');
    WriteLn ('- save_buffer');
    WriteLn ('- dispose_buffer');
    WriteLn ('- get_buffer');
    WriteLn ('- load_buffer');
    WriteLn ('- invert_buffer');
    WriteLn ('- plot_buffer', #10);
    Write ('Beim Speichern . . . ');
    save_buffer ('BILD.PRT');
    WriteLn ('fertig !', #7);
    dispose_buffer;
    WriteLn ('MemAvail nach Speicherfreigabe : ', MemAvail);
    get_buffer;
    WriteLn ('MemAvail nach erneuter Speicherallokation : ',
              MemAvail);
    Write ('Beim Lesen . . . ');
    load_buffer ('BILD.PRT');
    Write ('fertig !', #7, #10, #13, 'Beim Invertieren . . . ');
    invert_buffer;
    Write ('fertig !', #7, #10, #13, 'Beim Drucken . . . ');
    plot_buffer;
    WriteLn ('fertig !', #7, #10)
  END;  {*  of 'demonstration_2'  *}

BEGIN
  ClrScr;
  WriteLn ('Demonstration der Grafik-Unit fr Matrix-Drucker ',
           'unter Turbo-Pascal 4.0 !');
  WriteLn ('=================================================',
           '========================');
  Window (1,5, 80,25);
  GotoXY (1,1);
  WriteLn ('MemAvail vor Speicherallokation  : ', MemAvail);
  get_buffer;
  IF (NOT space_for_buffer)
     THEN BEGIN
            WriteLn ('Nicht gengend Platz fr ',
                     'den Grafikspeicher !');
            Halt;
          END;
  WriteLn ('MemAvail nach Speicherallokation : ',
                                       MemAvail, #10, #10);
  demonstration_1;
  demonstration_2;
  WriteLn ('*****   Auf Wiedersehen !   *****', #10)
END.  {*  of the program 'Printergraphik_Demo'  *}
