*+
* Tastaturtreiber fr AT-Tastatur am Atari ST
*
* Ingo Sprick, Andreas Kromke 8.9.88
*-

gemdos    EQU       1
xbios     EQU       14
Keytbl    EQU       16
Kbdvbase  EQU       34
Supexec   EQU       38
Crawcin   EQU       $07
Cconws    EQU       $09
Super     EQU       $20
Ptermres  EQU       $31
Pterm     EQU       $4c
Mshrink   EQU       $4a
TAB       EQU       9
ESC       EQU       $1b
CR        EQU       $0d
LF        EQU       $0a
QUOTE     EQU       $27

PAUSE     EQU       $61            ; pause (AT) -> UNDO (ST)


     TEXT

_base     EQU  *-$100              ; Adresse der Basepage

 bra      install

neu_ikbd  EQU  _base+$80           ; Zweiten Teil der Basepage nutzen
 DS.W     256                      ; Platz fr neue Interrupt- Routine

*+ Unser neuer Teil der Routine ikbdsys.
*
*  In Register d0 steht der Scancode des AT, in a0 ein Zeiger auf
*  iorec der Tastatur, den wir nicht verndern drfen.
*  Folgende Register drfen benutzt werden: a1,a2,d1,d2,d0
*  In d0 steht dann der ST-Scancode, mit dem die alte Routine
*  aufgerufen wird.
*  Falls die Daten nicht bergeben werden sollen (z.B. mu auf weitere
*  Bytes gewartet werden), wird ein RTS ausgefhrt.
*  Durch das ANDen mit den Mausdaten des ST-Tastaturprozessors kann 
*  es vorkommen, da Teile von Mauspaketen sich mit AT-Tastencodes
*  vermischen, falls der Bediener gleichzeitig Maus und Tastatur
*  bettigt. Die Routine ist deshalb besonders robust geschrieben und
*  weist alle AT-Scancodes ab, die eigentlich garnicht auftreten
*  knnen.
*
*  Die F11-Taste auf der AT-Tastatur schaltet zwischen den Modi
*- "Atari" und "MF-2" hin und zurck.


unsere:
 lea      h_tab(pc),a2
 cmp.b    #$f0,d0             ; Break- Code ?
 bne.s    no_f0
 st       h_brk(a2)           ; Break- Code merken
nixmehr:
 rts                          ; noch nichts bergeben (auf mehr warten)
no_f0:
 cmpi.b   #$78,d0             ; Scancode $78 (F11 beim AT)
 bne.s    no_f11
 tst.b    h_brk(a2)
 beq.s    nixmehr             ; HOT KEY nicht bermitteln
 not.b    mf_mode(a2)         ; Modus toggeln
 clr.b    h_brk(a2)
 rts                          ; HOT KEY nicht bermitteln
no_f11:
 tst.b    mf_mode(a2)         ; im MF-Modus ?
 beq      atari_modus         ; nein !
 cmp.b    #$e0,d0             ; ESC- Code E0 gesendet ?
 bne.s    vgl_e1
 st       h_esc(a2)           ; ESC- Flag merken
 sf       h_e1(a2)            ; andere lschen (Vorsichtsmanahme!)
 sf       h_brk(a2)
 rts                          ; nichts bergeben, nur ESC gemerkt
vgl_e1:
 cmp.b    #$e1,d0             ; ESC- Code E1 gesendet ?
 bne.s    sonst
 move.b   #2,h_e1(a2)         ; Auf E1 folgen immer zwei Bytes
 sf       h_esc(a2)           ; andere Flags vorsichtshalber lschen
 sf       h_brk(a2)
 rts                          ; nichts bergeben, nur E1 gemerkt
sonst:
 tst.b    h_e1(a2)            ; kam vorher ESC- Code E1 ?
 beq.s    sonstsonst          ; nein
 subq.b   #1,h_e1(a2)         ; schon zwei Bytes nach E1 empfangen ?
 bne.s    nixmehr             ; nein, weiterwarten
 move.b   #PAUSE,d0           ; E1,XX,XX ist immer die "PAUSE"- Taste
 sf       d1                  ; kein Fehler
 bra.s    wiedereinsprung     ; ST- Code fr PAUSE bergeben
sonstsonst:
 lea      tab_normal(pc),a1   ; Tabelle fr Scancodes ohne ESC
 tst.b    h_esc(a2)
 beq.s    no_esc
 lea      tab_esc(pc),a1      ; Tabelle fr Scancodes mit ESC
 sf       h_esc(a2)           ; ESC- Status lschen
no_esc:
 andi.w   #$00ff,d0           ; Fr Zugriff auf Tabelle
 move.b   0(a1,d0.w),d0
 smi      d1                  ; plausibel ?
wiedereinsprung:
 tst.b    h_brk(a2)           ; Kam vorher ein Break- Prfix  ?
 beq.s    no_brk
 bset     #7,d0               ; In ST- Breakcode umrechnen
 clr.b    letzte_taste(a2)    ; Autorepeat- Verhinderer lschen
 sf       h_brk(a2)
no_brk:
 tst.b    d1                  ; war Fehler aufgetreten ?
 bne      nixmehr             ; ja, unterdrcken (evtl. Mausdaten?)
 tst.b    d0
 bmi.s    ins_rom
 cmp.b    letzte_taste(a2),d0 ; vorherige Taste war dieselbe ?
 beq      nixmehr             ; Autorepeat sperren
 move.b   d0,letzte_taste(a2) ; neue Taste merken
ins_rom:
 move.l   wdeinsprg(pc),a1
 jmp      (a1)                ; alte Routine aufrufen
atari_modus:
 clr.b    h_brk(a2)
 bra.s    ins_rom


*+ Die Tabellen ordnen dem AT- Scancode einen ST- Scancode zu.
*  Die untere Tabelle wird benutzt, wenn das Prfix E0 vorher kam.
*  Fr das Prfix E1 wird keine Tabelle angelegt, weil es nur eine
*  einzige Taste mit Prfix E1 gibt, nmlich PAUSE.
*  Eintrge $ff knnen eigentlich nicht auftreten. Falls doch, handelt
*  es sich vermutlich um Teile von Mauspaketen, die wir ignorieren.
*  Sicherheitshalber sind daher auch beide Tabellen je 256 Bytes lang,
*  damit durch Empfang falscher Codes (von der Maus z.B.) kein
*  Tabellenberlauf stattfindet, sondern der jeweilige falsche Code
*- einfach unterdrckt wird.

tab_normal:
 DC.B   $ff,$43,$ff,$3f,$3d,$3b,$3c,$74,$ff,$44,$42,$40,$3e,$0f,$2b,$ff
 DC.B   $ff,$38,$2a,$ff,$1d,$10,$02,$ff,$ff,$ff,$2c,$1f,$1e,$11,$03,$ff
 DC.B   $ff,$2e,$2d,$20,$12,$05,$04,$ff,$ff,$39,$2f,$21,$14,$13,$06,$ff
 DC.B   $ff,$31,$30,$23,$22,$15,$07,$ff,$ff,$ff,$32,$24,$16,$08,$09,$ff
 DC.B   $ff,$33,$25,$17,$18,$0b,$0a,$ff,$ff,$34,$35,$26,$27,$19,$0c,$ff
 DC.B   $ff,$ff,$28,$ff,$1a,$0d,$ff,$ff,$3a,$36,$1c,$1b,$ff,$29,$ff,$ff
 DC.B   $ff,$60,$ff,$ff,$ff,$ff,$0e,$ff,$ff,$6d,$ff,$6a,$67,$ff,$ff,$ff
 DC.B   $70,$71,$6e,$6b,$6c,$68,$01,$75,$fe,$4e,$6f,$4a,$66,$69,$76,$ff
 DC.B   $ff,$ff,$ff,$41,$62,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
 DC.B   $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
 DC.B   $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
 DC.B   $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
 DC.B   $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
 DC.B   $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
 DC.B   $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
 DC.B   $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff

tab_esc:
 DC.B   $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
 DC.B   $ff,$38,$ff,$ff,$1d,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
 DC.B   $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
 DC.B   $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
 DC.B   $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$65,$ff,$ff,$ff,$ff,$ff
 DC.B   $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$72,$ff,$ff,$ff,$ff,$ff
 DC.B   $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$77,$ff,$4b,$47,$ff,$ff,$ff
 DC.B   $52,$53,$50,$ff,$4d,$48,$ff,$ff,$ff,$ff,$64,$ff,$62,$63,$ff,$ff
 DC.B   $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
 DC.B   $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
 DC.B   $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
 DC.B   $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
 DC.B   $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
 DC.B   $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
 DC.B   $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
 DC.B   $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff



h_tab:         DC.B      0,0,0,0,0,$ff  ; Arbeitstabelle
h_esc          EQU       0              ; Flag : ESC- Byte   E0
h_e1           EQU       1              ; Flag : ESC- Byte   E1
h_brk          EQU       2              ; Flag : Break- Code F0
h_e1_cnt       EQU       3              ; Zhler fr E1- Taste
letzte_taste   EQU       4              ; letzter ST- Make- Code fr
*                                       ;  Sperren des Autorepeat
mf_mode        EQU       5              ; TRUE <=> im MF-2 Modus

wdeinsprg:     DS.L      1

unser_ende:


*+ Installationsteil.
*
*  Kopiert einen Teil der Original-Routine ikbdsys in den Arbeits-
*- bereich und unsere Routine zum Einschleifen dahinter.


install:
 move.w   #Kbdvbase,-(sp)
 trap     #xbios
 addq.l   #2,sp
 move.l   d0,a5                    ; a5 := Kdvbase
 move.l   $20(a5),a0               ; ikbdsys
*                                  ; Suche nach "bcs wiedereinsprung"
 move.w   #256-1,d0                ; maximal 256 Worte durchsuchen
suche:
 addq.w   #2,a0
 cmpi.l   #$0c0000f6,(a0)          ; 68000- Code fr "cmpi.b #$f6,d0"
 dbeq     d0,suche
 bne      err
 addq.w   #4,a0
 cmpi.w   #$6500,(a0)+             ; "bcs.l" ?
 bne      err
 adda.w   (a0),a0                  ; a0 := Wiedereinsprungpunkt
 lea      wdeinsprg(pc),a1
 move.l   a0,(a1)

* Bentigten Teil der Originalroutine kopieren

 lea      neu_ikbd(pc),a1
 lea      unsere(pc),a2
 move.l   $20(a5),a0               ; a0 := ikbdsys
copy:
 move.w   (a0)+,(a1)+
 cmpa.l   a1,a2
 beq      err                      ; ROM- Routine zu lang
 cmpa.l   wdeinsprg(pc),a0
 bne.s    copy

* Unseren Teil dahinterkopieren

 move.w   #(unser_ende-unsere-2),d0
 lsr      #1,d0                    ; d0 := Lnge in Worten
copyunsere:
 move.w   (a2)+,(a1)+              ; a1 zeigt hinter Kopie
 dbra     d0,copyunsere

* neuen Interrupt anmelden

 lea      neu_ikbd,a0
 move.l   a0,$20(a5)

*+ An dieser Stelle knnen durch den Xbios- Aufruf Keytbl()
*  PC- angepate Tastaturtabellen angelegt werden.
*  (vgl. 1. Teil in c't 10/88)
*  Termres
*  Es wird tatschlich nur exakt soviel Speicher resident gemacht,
*  wie unsere Routine bentigt.
*- Der Installationsteil fllt nicht darunter.

 lea      _base(pc),a0             ; Beginn des residenten Teils
 suba.l   a0,a1                    ; Abziehen vom Ende desselben
 pea      ok(pc)
 move.w   #Cconws,-(sp)
 trap     #gemdos                  ; "OK" Meldung
 addq.l   #6,sp
 move.w   #Crawcin,-(sp)           ; auf Tastendruck warten
 trap     #gemdos
 addq.l   #2,sp
 clr.w    -(sp)                    ; kein Fehler
 move.l   a1,-(sp)
 move.w   #Ptermres,-(sp)          ; festsaugen
 trap     #gemdos

err:
 pea      fehler(pc)
 move.w   #Cconws,-(sp)
 trap     #gemdos                  ; Fehlermeldung
 addq.l   #6,sp
 move.w   #Crawcin,-(sp)           ; auf Taste warten
 trap     #gemdos
 addq.l   #2,sp
 move.w   #-1,-(sp)                ; Bei Fehlern wird ERROR geliefert
 move.w   #Pterm,-(sp)
 trap     #gemdos                  ; nichtresidental beenden

fehler:
 DC.B ESC,'ETreiber arbeitet nicht mit Ihrem installierten TOS.',0
ok:
 DC.B ESC,'E',LF,TAB,TAB,TAB,' c',QUOTE,'t  Tastaturtreiber V1.0'
 DC.B CR,LF,LF,TAB,TAB,TAB,'   Version fr AT- Modus',CR,LF,0

 END
