{ FILEASSO.PAS   (C) AssoSoft 1988,  Autor: Michael Hagstrm

  assoziativer Speicher, der alle Eintrge eines Pfades auf
  Diskette oder Platte lernt. Um Platz zu sparen, wird die 
  Matrix mit Hilfe von Pointern realisiert. }


PROGRAM FindFile;


USES   Dos, Crt;

CONST  Max_Ein = 2000;          { maximale Anzahl von Filenamen }

TYPE   Str2    = String [2];
       Str12   = String [12];
       Str14   = String [14];
       Str64   = String [64];
       Str80   = String [80];

       S_Pointer  = ^S_Typ;           { Datenstrukturen fr die }
       S_Typ      = RECORD            { Matrix                  }
                      Inhalt : WORD;
                      next   : S_Pointer
                    END;

       Z_Pointer  = ^Z_Typ;
       Z_Typ      = RECORD
                      Inhalt : WORD;
                      Zeiger : S_Pointer;
                      next   : Z_Pointer
                    END;

VAR    Z_Kopf, Z_Eintrag : Z_Pointer;                  { Matrix }
       S_Eintrag         : S_Pointer;
       AnzAnt, AnzPfad   : WORD;                       { Zhler }
       MaxSchw           : BYTE;            { maximale Schwelle }
                      { Datei- und Pfadnamen, Schwellensteuerung}
       DatName           : ARRAY [1 .. Max_Ein] OF Str12;
       VerFeld, AusFeld  : ARRAY [1 .. Max_Ein] OF BYTE;
       Pfad              : ARRAY [1 .. 255] OF Str64;


PROCEDURE MatEin (NeuI, NeuJ : WORD);

{ Lernphase }

VAR  Z_Vor, Z_Neu : Z_Pointer;
     S_Neu        : S_Pointer;
     Weiter       : BOOLEAN;

BEGIN
  Z_Eintrag := Z_Kopf;
  Weiter := TRUE;
  WHILE Weiter AND (Z_Eintrag <> NIL) DO
    WITH Z_Eintrag^ DO
      IF NeuI < Inhalt
         THEN Weiter := False
         ELSE BEGIN
                Z_Vor := Z_Eintrag;
                Z_Eintrag := Next;
              END;
  IF NeuI = Z_Vor^.Inhalt
     THEN BEGIN
            New (S_Neu);
            S_Neu^.Inhalt := NeuJ;
            S_Neu^.Next := Z_Vor^.Zeiger;
            Z_Vor^.Zeiger := S_Neu;
          END
     ELSE BEGIN
            New (Z_Neu);
            New (Z_Neu^.Zeiger);
            Z_Neu^.Inhalt := NeuI;
            Z_Neu^.Zeiger^.Inhalt := NeuJ;
            Z_Neu^.Zeiger^.Next := NIL;
            Z_Neu^.Next := Z_Eintrag;
            IF Z_eintrag = Z_Kopf
               THEN Z_Kopf := Z_Neu
               ELSE Z_Vor^.Next := Z_Neu
          END;
END; { MatEin }


PROCEDURE Lernen (St : Str12; AnzVerz : BYTE);

{ Einen Dateinamen lernen }

VAR i    : BYTE;
    Hilf : Str14;

BEGIN
  AnzAnt := Succ (AnzAnt);
  DatName [AnzAnt] := St;
  VerFeld [AnzAnt] := AnzVerz;
  Hilf :=  Concat ('@', St, '[');
  FOR i := 1 TO (Length (Hilf) - 1) DO
      MatEin (Ord (Hilf [i]) Shl 7 + Ord (Hilf [i+1]), AnzAnt);
END; { Lernen }


PROCEDURE WriteKomm (St : Str80);

{ String in der "Kommandozeile" schreiben }

BEGIN
  Window (2, 24, 78, 24);
  Write ('       ', St); ClrEol;
END; { WriteKomm }


PROCEDURE LiesPLatte;

{ Auf einer Platte alle Eintrge lesen. }

VAR Start, Wurzel, St : Str64;
    i                 : BYTE;
    Ch                : Char;

PROCEDURE LiesDir (St : Str64; AnzVerz : BYTE);

{ In einem Verzeichnis alle Dateinamen lesen, bzw. in ein
  neues Verzeichnis wechseln (rekursiv). }

VAR DirInfo : SearchRec;
    i       : BYTE;

BEGIN
  ChDir (St);
  i := 0;
  AnzPfad := Succ (AnzPfad);
  AnzVerz := AnzPfad;
  GetDir (i, Pfad [AnzVerz]);
  GotoXY (5, 6);  Write ('Verzeichnis  : ' + Pfad [AnzVerz]);
  IF Pfad [AnzVerz] [Length (Pfad [AnzVerz])] <> '\'
     THEN Pfad [AnzVerz] := Concat (Pfad [AnzVerz], '\');
  ClrEol;
  FindFirst ('*.*', AnyFile - VolumeID, DirInfo);
  WHILE DosError = 0 DO
    BEGIN
      IF (DirInfo.Attr = Directory)
         THEN BEGIN
                IF DirInfo.Name [1] <> '.'
                   THEN LiesDir (DirInfo.Name, AnzVerz);
              END
         ELSE BEGIN
                i := Pos ('\', DirInfo.Name);
                WHILE i > 0 DO
                  BEGIN
                    Delete (DirInfo.Name, 1, i);
                    i := Pos ('\', DirInfo.Name);
                  END;
                Lernen (DirInfo.Name, AnzVerz);
              END;
      FindNext (DirInfo);
    END;
  GotoXY (5, 9);  Write ('Anzahl Files : ', AnzAnt : 4);
  GetDir (i, St);
  IF St <> Wurzel
     THEN ChDir ('..')
     ELSE AnzPfad := AnzVerz;
END; { Lies_Dir }

BEGIN { LiesPlatte }
  Window (2, 6, 78, 25);
  GotoXY (10, 3); Write ('Gib Namen des Pfades : ');
  ReadLn (Wurzel);
  FOR i := 1 TO Length (Wurzel) DO
      Wurzel [i] := UpCase (Wurzel [i]);
  GotoXY (10, 3); Write ('Lernen der Filenamen'); ClrEol;
  AnzAnt := 0;
  AnzPfad := 0;
  Z_Kopf := NIL;
  GetDir (0, Start);
  LiesDir (Wurzel, AnzPfad);
  WriteKomm ('Bitte Taste bettigen ...');
  Ch := ReadKey;
  ChDir (Start);
END; { Lies_Platte }


PROCEDURE AusLesen (St : Str14);

{ Antwortphase }

VAR SuchInd  : WORD;
    AnzP     : BYTE;
    SuchFeld : ARRAY [1 .. 13] OF WORD;

PROCEDURE SetzeFeld (St : Str14);

VAR  i, j      : BYTE;
     Hilf      : WORD;

BEGIN
  FOR i := 1 TO 13 DO
      SuchFeld [i] := 0;
  AnzP := Length (St) - 1;
  FOR i := 1 TO AnzP DO
      SuchFeld [i] := Ord (St [i]) Shl 7 + Ord (St [i+1]);
  FOR i := 1 TO AnzP DO  { sortieren }
      FOR j := 1 TO i DO
          IF SuchFeld [j] > SuchFeld [i]
             THEN BEGIN
                    Hilf := SuchFeld [i];
                    SuchFeld [i] := SuchFeld [j];
                    SuchFeld [j] := Hilf;
                  END;
END; { SetzeFeld  }

PROCEDURE IncrAusFeld (i : WORD);

{ Schwellensteuerung }

BEGIN
  AusFeld [i] := Succ (AusFeld [i]);
  IF AusFeld [i] > MaxSchw
     THEN MaxSchw := AusFeld [i];
END; { AuswertSpeichern }

BEGIN { AusLesen }
  SetzeFeld (St);
  SuchInd := 1;
  Z_Eintrag := Z_Kopf;
  WHILE (Z_Eintrag <> NIL) AND (SuchInd <= AnzP) DO
    BEGIN
      WHILE (Z_Eintrag <> NIL) AND
            (SuchFeld[SuchInd] > Z_Eintrag^.Inhalt) DO
         Z_Eintrag := Z_Eintrag^.Next;
      WHILE (SuchFeld[SuchInd] < Z_Eintrag^.Inhalt) AND
            (SuchInd <= AnzP) DO
         SuchInd := Succ (SuchInd);
      IF SuchFeld[SuchInd] = Z_Eintrag^.Inhalt
         THEN BEGIN
                S_Eintrag := Z_Eintrag^.Zeiger;
                WHILE S_Eintrag <> NIL DO
                  BEGIN
                    IncrAusFeld (S_Eintrag^.Inhalt);
                    S_Eintrag := S_Eintrag^.Next;
                  END;
                SuchInd := Succ (SuchInd);
              END;
      IF Z_Eintrag <> NIL
         THEN Z_Eintrag := Z_Eintrag^.Next;
    END;
END; { AusLesen }


PROCEDURE Ausgabe;

{ Ausgabe der gefundenen Eintrge }

VAR i, Anz  : WORD;
    AktSchw : BYTE;
    Frage   : Str12;
    ch      : Char;

BEGIN
  WriteKomm ('    Leereingabe beendet Find File');
  Window (2, 6, 78, 22);
  ClrScr;
  GotoXY (3, 2);  Write ('Frage : ');
  ReadLn (Frage);
  WHILE Frage <> '' DO
    BEGIN
      FOR i := 1 TO Length (Frage) DO
          Frage [i] := UpCase (Frage [i]);
      FOR i := 1 TO AnzAnt DO
          AusFeld [i] := 0;
      Frage := Concat ('@', Frage, '[');
      MaxSchw := 0;
      AusLesen (Frage);
      AktSchw := MaxSchw;
      REPEAT
        GotoXY (33, 2);  Write ('Schwelle : ', AktSchw : 2);
        Window (4, 10, 78, 22);
        ClrScr;
        Anz := 0;
        FOR i := 1 TO AnzAnt DO
            IF (AusFeld [i] = AktSchw) AND (AktSchw > 0)
               THEN BEGIN
                      Anz := Succ (Anz);
                      WriteLn (Pfad [VerFeld [i]], DatName [i]);
                      IF (Anz Mod 10) = 0
                         THEN BEGIN
                                WriteLn;
                                WriteLn ('*** Weiter ***');
                                WriteKomm
                                  ('Bitte Taste bettigen ...');
                                Ch := ReadKey;
                                Window (4, 10, 78, 22);
                                ClrScr;
                              END;
                    END;
        WriteLn;
        IF Anz > 0
           THEN WriteLn ('*** Fertig ***')
           ELSE WriteLn ('*** Keine Eintrge ***');
        WriteKomm ('    [+,-] Schwelle ndern' +
                   '    [F] neue Frage');
        REPEAT
          ch := UpCase (ReadKey);
        UNTIL Ch IN ['F', '+', '-'];
        IF (ch = '+') AND (AktSchw < MaxSchw)
           THEN AktSchw := Succ (AktSchw);
        IF (ch = '-') AND (AktSchw > 1)
           THEN AktSchw := Pred (AktSchw);
        Window (2, 6, 78, 22);
      UNTIL ch = 'F';
      WriteKomm ('    Leereingabe beendet Find File');
      Window (2, 6, 78, 22);
      ClrScr;
      GotoXY (3, 2);  Write ('Frage : ');
      ReadLn (Frage);
    END;
END; { Ausgabe }


PROCEDURE Rahmen;

{ Rahmen fr die Ausgabe zeichnen }

VAR i : BYTE;

BEGIN
  ClrScr;
  TextColor (Yellow);
  Write (#201);
  FOR i := 2 TO 78 DO  Write (#205);
  Write (#187);
  FOR i := 2 TO 24 DO
      BEGIN
        GotoXY (1, i);  Write (#186);
        GotoXY (79, i); Write (#186);
      END;
  GotoXY (1, 25); Write (#200);
  FOR i := 2 TO 78 DO  Write (#205);
  Write ('');
  GotoXY (1, 5); Write (#199);
  FOR i := 2 TO 78 DO  Write (#196);
  Write (#182);
  GotoXY (1, 23); Write (#199);
  FOR i := 2 TO 78 DO  Write (#196);
  Write (#182);
  TextColor (White);
  GotoXY (10, 3); Write ('Find File');
END; { Rahmen }


BEGIN { Hauptprogramm }
  Rahmen;
  LiesPlatte;
  Ausgabe;
  Window (1, 1, 80, 25);
  ClrScr;
END. { Ende }
