*****************************************************************
* 
*        H A R D W A R E - M A T H - I E E E - L I B R A R Y  
*       
*        F O R  A L C Y O N - C - C O M P I L E R  V. 4.14
*
*        MODULE: fpuneu.s               IMPORTS: none 
*
*        EXPORTS: _sin, _cos, _tan, _asin, _acos, _atan, _sinh,
*                 _cosh, _tanh, _atanh, _exp, _fabs, _fmod, _pi,
*                 _log, _ln, _logn, _log10, _log2, _pow, _sqrt,
*                 _tentox, _twotox, _spabs.
*
*        1988, Stephan Hering
*
*****************************************************************

* Export the globals .......

*---------  angle functions ------------------------------------*

                .globl  _sin            ; sine
                .globl  _cos            ; cosine
                .globl  _tan            ; tangent
                .globl  _acos           ; arc cosine
                .globl  _asin           ; arc sine
                .globl  _atan           ; arc tangent
                .globl  _atan2          ; arc tangent of two args
*                                         (atan2(x/y)

*--------- hyperbolic functions --------------------------------*

                .globl  _sinh           ; hyperbolic sine
                .globl  _cosh           ; hyperbolic cosine
                .globl  _tanh           ; hyperbolic tangent
                .globl  _atanh          ; hyperbolic arc tangent

*---------  the rest of the mathematische krams ----------------*
                
                .globl  _exp            ; e to x
                .globl  _fabs           ; dp absolute value
                .globl  _spabs          ; single prec. absolute
                .globl  _fmod           ; modulo remainder
                .globl  _pi             ; 3.1415....
                .globl  _log2           ; binary logarithm
                .globl  _ld             ;  dito. ( log. duales)
                .globl  _log            ; natural logarithm
                .globl  _logn           ;   -"-      -"-
                .globl  _ln             ;   -"-      -"-
                .globl  _log10          ; Decade base logarithm
                .globl  _pow            ; power function (x^y)
                .globl  _sqrt           ; square root
                .globl  _tentox         ; 10^x
                .globl  _twotox         ; 2^x

         .text

*****************************************************************
* 
*        calculate sine
* 
*        C-Syntax: double sin(fp)
*                  double fp;    
*        Export:   _sin
*        Import:   none    
*        Input :   4(sp) double_precision_real (64bits)
*        Output:   function return in fp0
*        Kills :   fp0
*
*****************************************************************
        
_sin:   fsin.d  $4(sp),fp0
        rts
                
*****************************************************************
*                                                                       
*        calculate cosine
* 
*        C-Syntax: double cos(fp)
*                  double fp;  
*        Export:   _cos
*        Import:   none    
*        Input :   4(sp) double_precision_real (64bits)
*        Output:   function return in fp0
*        Kills :   fp0  
*
*****************************************************************

_cos:   fcos.d  $4(sp),fp0
        rts

*****************************************************************
* 
*        calculate tangent
* 
*        C-Syntax: double tan(fp)
*                  double fp;
*        Export:   _tan
*        Import:   none    
*        Input :   4(sp) double_precision_real (64bits)
*        Output:   function return in fp0
*        Kills :   fp0
*
*****************************************************************

_tan:   ftan.d  $4(sp),fp0   
        rts

*****************************************************************
* 
*        calculate arc sine
* 
*        C-Syntax: double asin(fp)
*                  double fp;    
*        Export:   _asin
*        Import:   none    
*        Input :   4(sp) double_precision_real (64bits)
*        Output:   function return in fp0
*        Kills :   fp0
*
*****************************************************************
        
_asin:  fasin.d  $4(sp),fp0
        rts 
                
*****************************************************************
*                                                                       
*        calculate arc cosine
* 
*        C-Syntax: double acos(fp)
*                  double fp;  
*        Export:   _acos
*        Import:   none    
*        Input :   4(sp) double_precision_real (64bits)
*        Output:   function return in fp0
*        Kills :   fp0  
*
*****************************************************************

_acos:   facos.d  $4(sp),fp0
         rts

*****************************************************************
* 
*        calculate arc tangent
* 
*        C-Syntax: double atan(fp)
*                  double fp;
*        Export:   _atan
*        Import:   none    
*        Input :   4(sp) double_precision_real (64bits)
*        Output:   function return in fp0
*        Kills :   fp0
*
*****************************************************************

_atan:  fatan.d  $4(sp),fp0   
        rts

*****************************************************************
* 
*        calculate hyperbolic sine
* 
*        C-Syntax: double sinh(fp)
*                  double fp;    
*        Export:   _sinh
*        Import:   none    
*        Input :   4(sp) double_precision_real (64bits)
*        Output:   function return in fp0
*        Kills :   fp0
*
*****************************************************************
        
_sinh:  fsinh.d  $4(sp),fp0
        rts
                
*****************************************************************
*                                                                       
*        calculate hyperbolic cosine
* 
*        C-Syntax: double cosh(fp)
*                  double fp;  
*        Export:   _cosh
*        Import:   none    
*        Input :   4(sp) double_precision_real (64bits)
*        Output:   function return in fp0
*        Kills :   fp0  
*
*****************************************************************

_cosh:  fcosh.d  $4(sp),fp0
        rts

*****************************************************************
* 
*        calculate hyperbolic tangent
* 
*        C-Syntax: double tanh(fp)
*                  double fp;
*        Export:   _tanh
*        Import:   none    
*        Input :   4(sp) double_precision_real (64bits)
*        Output:   function return in fp0
*        Kills :   fp0
*
*****************************************************************

_tanh:  ftanh.d  $4(sp),fp0   
        rts

*****************************************************************
* 
*        calculate arc hyperbolic tangent
* 
*        C-Syntax: double atanh(fp)
*                  double fp;
*        Export:   _atanh
*        Import:   none    
*        Input :   4(sp) double_precision_real (64bits)
*        Output:   function return in fp0
*        Kills :   fp0
*
*****************************************************************

_atanh: fatanh.d  $4(sp),fp0   
        rts

*****************************************************************
* 
*        calculate arc tangent of two arguments arctan(x/y);
* 
*        C-Syntax: double atan2(x,y)
*                  double x,y;
*        Export:   _atan2
*        Import:   none    
*        Input :   4(sp) double_precision_real (64bits)
*                 12(sp) double_precision_real (64bits)
*        Output:   function return in fp0
*        Kills :   fp0
*
*****************************************************************

_atan2: fmove.d   $4(sp),fp0
        fdiv.d    $C(sp),fp0
        fatan.d   fp0   
        rts

*****************************************************************
* 
*        calculate e to the power of x
* 
*        C-Syntax: double exp(fp)
*                  double fp;
*        Export:   _exp
*        Import:   none
*        Input :   4(sp) double_precision_real (64bits)
*        Output:   function return in fp0
*        Kills :   fp0
*
*****************************************************************

_exp:   fetox.d $4(sp),fp0   
        rts

*****************************************************************
* 
*        calculate absolute value
* 
*        C-Syntax: double fabs(fp)
*                  double fp;
*        Export:   _fabs
*        Import:   none
*        Input :   4(sp) double_precision_real (64bits)
*        Output:   function return in fp0
*        Kills :   fp0
*
*****************************************************************

_fabs:  fabs.d  $4(sp),fp0   
        rts

*****************************************************************
* 
*        calculate single prec. absolute value
* 
*        C-Syntax: for library internal use only
*        Export:   _spabs
*        Import:   none
*        Input :   4(sp) singlee_precision_real (32bits)
*        Output:   function return in fp0
*        Kills :   fp0
*
*****************************************************************

_spabs: fabs.s  $4(sp),fp0   
        rts

*****************************************************************
* 
*        fmod returns the remainder when x is divided by y
* 
*        C-Syntax: double fmod(x,y)
*                  double x,y;
*        Export:   _fmod
*        Import:   none
*        Input :    4(sp) double_precision_real (64bits)
*                  12(sp) double_precision_real (64bits)
*        Output:   function return in fp0
*        Kills :   fp0
*
*****************************************************************

_fmod:  fmove.d $4(sp),fp0
        fmod.d  $C(sp),fp0   
        rts

*****************************************************************
* 
*        pow caculates x to the power of y
* 
*        C-Syntax: double pow(x,y)
*                  double x,y;
*        Export:   _pow
*        Import:   none
*        Input :    4(sp) double_precision_real (64bits)
*                  12(sp) double_precision_real (64bits)
*        Output:   function return in fp0
*        Kills :   fp0
*
*****************************************************************

_pow:   flogn.d $4(sp),fp0
        fmul.d  $C(sp),fp0
        fetox.d fp0   
        rts

*****************************************************************
* 
*        returns the natural logarithm
* 
*        C-Syntax: double log(fp) or ln(fp) or logn(fp)
*                  double fp;
*        Export:   _log, _ln, _logn
*        Import:   none
*        Input :    4(sp) double_precision_real (64bits)
*        Output:   function return in fp0
*        Kills :   fp0
*
*****************************************************************

_log:
_ln:
_logn:  flogn.d $4(sp),fp0
        rts

*****************************************************************
* 
*        returns the decade logarithm
* 
*        C-Syntax: double log10(fp)
*                  double fp;
*        Export:   _log10
*        Import:   none
*        Input :   4(sp) double_precision_real (64bits)
*        Output:   function return in fp0
*        Kills :   fp0
*
*****************************************************************

_log10: flog10.d $4(sp),fp0
        rts

*****************************************************************
* 
*        returns the binary logarithm (logarithmus duales)
* 
*        C-Syntax: double log2(fp) or ld(fp)
*                  double fp;
*        Export:   _log2, _ld
*        Import:   none
*        Input :   4(sp) double_precision_real (64bits)
*        Output:   function return in fp0
*        Kills :   fp0
*
*****************************************************************

_ld:
_log2:  flog2.d $4(sp),fp0
        rts

*****************************************************************
* 
*        returns the square root
* 
*        C-Syntax: double sqrt(fp)
*                  double fp;
*        Export:   _sqrt
*        Import:   none
*        Input :   4(sp) double_precision_real (64bits)
*        Output:   function return in fp0
*        Kills :   fp0
*
*****************************************************************

_sqrt:  fsqrt.d $4(sp),fp0
        rts

*****************************************************************
* 
*        returns ten to the power of x
* 
*        C-Syntax: double tentox(fp)
*                  double fp;
*        Export:   _tentox
*        Import:   none
*        Input :   4(sp) double_precision_real (64bits)
*        Output:   function return in fp0
*        Kills :   fp0
*
*****************************************************************

_tentox: ftentox.d $4(sp),fp0
         rts

*****************************************************************
* 
*        returns ten to two power of x
* 
*        C-Syntax: double tentox(fp)
*                  double fp;
*        Export:   _twotox
*        Import:   none
*        Input :   4(sp) double_precision_real (64bits)
*        Output:   function return in fp0
*        Kills :   fp0
*
*****************************************************************

_twotox: ftwotox.d $4(sp),fp0
         rts

*****************************************************************
* 
*        pi returns 3.141592654.............
* 
*        C-Syntax: double pi()
*        Export:   _pi
*        Import:   none
*        Input :   none
*        Output:   function return in fp0
*        Kills :   d0,fp0
*
*****************************************************************

_pi:    fmovecr.x $0,fp0
        rts

        .data

        .dc.b   "IEEE Hardware floating point library"
        .dc.b   "for the alcyon c compiler and MC68881"
        .dc.b   "Copyright (C)1988 by Stephan Hering"
        .dc.b   "Special thanks to Kai & Burkart"
        .dc.b   "for all the Help !!!! "

        end
