program ifsedit;

{$i hgr1.inc}
{$i hgr2.inc}

type arr19_6 = array[0..19,0..6] of real;
      matrix = array[0..2, 0..2] of real;

var
   codes,ifscodes,pntcodes :arr19_6;
   ifsp                    :array[0..19] of real;
   maxcode,ifsmax,pntmax,
   lastpos,codepos,
   xscale,yscale,
   xoffset,yoffset,
   rec,iter                :integer;

procedure invvideo;
begin
     textcolor(0);
     textbackground(7);
end;

procedure setifsmask;
var
   i:integer;
begin
     highvideo;
     clrscr;
     writeln ('
     Ŀ');
     writeln (' T      a    
         b        c        d        e        f    ');
     writeln ('
     Ĵ');
     for i:=1 to 20 do
         writeln (' ',i:2,'         
                                                  ');
     write   ('
     ');
end;

procedure setpntmask;
var
   i:integer;
begin
     highvideo;
     clrscr;
     writeln('
     Ŀ');

     writeln(' NO.    X1   
         Y1       X2       Y2       X3       Y3   ');

     writeln('
     for i:=0 to 19 do
         writeln(' ',i:2,'          
                                                  ');

     write  ('
     ');
end;

procedure codein(var out:real;ch:char);
var
   line:string[10];
      y:integer;
begin
     write('       ',#8#8#8#8#8#8#8);
     if ch= '-' then line:='-'
                else line:=' '+ch;
     write(line);
     repeat
           read(kbd,ch);
           if ch in ['0'..'9','.','-'] then
              if length(line)<7 then begin
                 write(ch);line:=line+ch;
              end;
           if (ch=#8) and (length(line)>0) then begin
              write(ch,' ',#8);
              line:=copy(line,1,length(line)-1);
           end;
      until ch =#13;
      y:=pos('.',line);
      if y>4 then delete(line,2,y-4);
      if (y=0) and (length(line)>3)
        then delete(line,2,length(line)-3);
      if line[1]=' '
        then delete(line,1,1);
      val(line,out,y);
end;


procedure calccursor(pos:integer);
var
   x,y:integer;
begin
     x:=(pos mod 6)*10+8;
     y:=(pos div 6)+4;
     gotoxy(x,y);
end;

procedure writecode(pos:integer);
begin
     calccursor(pos);
     if pos<=maxcode
        then write(codes[pos div 6,pos mod 6]:7:3)
        else write('       ');
     calccursor(pos);
end;


procedure setcursor;
begin
     lowvideo;
     writecode(lastpos);
     lastpos:=codepos;
     invvideo;
     writecode(codepos);
end;

procedure  readcode(ch:char);
begin
     codein(codes[codepos div 6,codepos mod 6],ch);
     if (codepos<119) then begin
        if codepos>maxcode then
           maxcode:=codepos;
        codepos:=codepos+1;
     end else
        maxcode:=codepos;
     setcursor;
end;


procedure delcode;
var
   i,j:integer;
begin
     if maxcode>=codepos then begin

        if (maxcode div 6)=(codepos div 6) then begin
           for i:=codepos to maxcode do begin
               calccursor(i);
               lowvideo;write('        ');
           end;
           maxcode:=codepos-1;
           setcursor;
        end
        else begin
            for i:=(codepos div 6) to
              (maxcode div 6)-1 do begin
                for j:=0 to 5 do begin
                    codes[i,j]:=codes[i+1,j];
                    lowvideo;writecode(i*6+j);
                end;
            end;
            maxcode:=maxcode-6;
            for j:=maxcode+1 to (maxcode div 6)*6+11 do begin
                calccursor(j);
                lowvideo;write('        ');
            end;
            if codepos>maxcode then codepos:=maxcode+1;
            setcursor;
        end;
     end;
end;

procedure movecursor;
var
   ch:char;
begin
     repeat
           read(kbd,ch);
           if ch=#27 then read(kbd,ch);
           case ch of
                #75:if codepos>0 then begin
                       codepos:=codepos-1;
                       setcursor;
                    end;
                #77:if (codepos<=maxcode) and (codepos<119)
                  then begin
                    codepos:=codepos+1;
                    setcursor;
                  end;
                #72:if codepos>5
                  then begin
                     codepos:=codepos-6;
                     setcursor;
                  end;
                #80:if (codepos<(maxcode-4)) and (codepos<114)
                  then begin
                     codepos:=codepos+6;
                     setcursor;
                  end;
                #83:delcode;
           end;
           if ch in ['0'..'9','-'] then readcode(ch);
     until (ch=#59) and ((maxcode mod 6)=5);
end;

function ifsdet(t:integer):real;
var
   d:real;
   i:integer;
begin
     d := abs (ifscodes[t,0]*ifscodes[t,3] -
                     ifscodes[t,1]*ifscodes[t,2]);
     if d=0 then d:=0.01;
     ifsdet:=d;
end;

function calcprob:boolean;
var
   i      :integer;
   sum,pc :real;
   p      :array[0..19] of real;
begin
     sum:=0;
     for i:=0 to (ifsmax div 6) do begin
         sum:=sum+ifsdet(i);
     end;
     pc:=0;
     for i:=0 to (ifsmax div 6) do begin
         p[i]:=ifsdet(i)/sum;
         pc:=pc+p[i];
         ifsp[i]:=pc;
     end;
     calcprob:=true;
     for i:=0 to (ifsmax div 6)-1 do begin
         if abs(p[i]-p[i+1])>0.01  then calcprob:=false;
     end;
end;

procedure setcodes;
var
   i:integer;
begin
     if maxcode>=0 then begin
        lowvideo;
        for i:=0 to maxcode do
            writecode(i);
     end;
end;

procedure editifs;
begin
     setifsmask;
     codes  :=ifscodes;
     maxcode:=ifsmax;
     codepos:=0;
     lastpos:=0;
     setcodes;
     setcursor;
     movecursor;
     ifsmax  :=maxcode;
     ifscodes:=codes;
end;

procedure editpnt;
begin
     setpntmask;
     codes  :=pntcodes;
     maxcode:=pntmax;
     codepos:=0;
     lastpos:=0;
     setcodes;
     setcursor;
     movecursor;
     pntmax  :=maxcode;
     pntcodes:=codes;
 end;


function det(m:matrix):real;
begin
     det := m[0,0]*m[1,1]*m[2,2] + m[0,1]*m[1,2]*m[2,0] +
            m[0,2]*m[1,0]*m[2,1] - m[2,0]*m[1,1]*m[0,2] -
            m[2,1]*m[1,2]*m[0,0] - m[2,2]*m[1,0]*m[0,1];
end;

procedure setmat(var m:matrix);
var
   i:integer;
begin
     for i:=0 to 2 do begin
         m[0,i]:=pntcodes[0,i*2];
         m[1,i]:=pntcodes[0,i*2+1];
         m[2,i]:=1;
     end
end;

function solve(t,c,xy:integer;d:real):real;
var
   m:matrix;
   i:integer;
begin
     setmat(m);
     for i:=0 to 2 do
         m[c,i]:=pntcodes[t+1,i*2+xy];
     solve:=det(m)/d;
end;

procedure transform;
var
   c,t:integer;
   d  :real;
   m  :matrix;
begin
     setmat(m);
     d:=det(m);
     ifsmax:=pntmax-6;
     for t:=0 to (ifsmax div 6) do begin
         ifscodes[t,0]:=solve(t,0,0,d);
         ifscodes[t,1]:=solve(t,1,0,d);
         ifscodes[t,2]:=solve(t,0,1,d);
         ifscodes[t,3]:=solve(t,1,1,d);
         ifscodes[t,4]:=solve(t,2,0,d);
         ifscodes[t,5]:=solve(t,2,1,d);
     end;
end;

procedure iterate(var x,y:real);
var
   rnd,newx,newy:real;
   i            :integer;
begin
     rnd:=random;
     i:=-1;
     repeat
           i:=i+1;
     until rnd<ifsp[i];
     newx:=ifscodes[i,0] * x+ifscodes[i,1] * y+ifscodes[i,4];
     newy:=ifscodes[i,2] * x+ifscodes[i,3] * y+ifscodes[i,5];
     x:=newx;
     y:=newy;
end;


procedure iterdraw;
var r,x,y:real;
    i,j  :integer;
begin
     write('Iterationen:');readln(iter);
     herkulesgrafik_einschalten(1);hclrscr(1);
     x:=0;y:=0;
     for i:=0 to 20 do iterate(x,y);
     for i:=0 to iter do begin
         iterate(x,y);
         hplot (trunc(x*xscale+xoffset),
                  347-trunc(y*yscale+yoffset));
     end;
 end;


procedure recurs(i:integer;x,y:real);
var
   newx,newy:real;
   j        :integer;
   ch       :char;
begin
     if i>0 then begin
        for j:=0 to ifsmax div 6 do begin
            newx := ifscodes[j,0]*x + ifscodes[j,1]*y +
                         ifscodes[j,4];
            newy := ifscodes[j,2]*x + ifscodes[j,3]*y +
                         ifscodes[j,5];
            hplot(trunc(newx*xscale+xoffset),
                    347-trunc(newy*yscale+yoffset));
            recurs(i-1,newx,newy);
        end;
     end;
end;

procedure recdraw;
var
   i  :integer;
   x,y:real;
begin
     x:=0;
     y:=0;
     write('Rekursionen:');
     readln(rec);
     herkulesgrafik_einschalten(1);
     hclrscr(1);
     for i:=0 to 20 do iterate(x,y);
     recurs(rec,x,y);
end;

procedure drawifs;
var
   ch:char;
begin
     clrscr;
     normvideo;
     highvideo;
     clrscr;
     write('X-Offset:'); readln(xoffset);
     write('Y-Offset:'); readln(yoffset);
     write('X-Scale :'); readln(xscale);
     write('Y-Scale :'); readln(yscale);
     if calcprob then begin
        writeln('Soll ich diese IFS rekursiv
                oder iterativ berechnen? (r/i)');
        read(kbd,ch);
        if ch='r' then recdraw else iterdraw;
     end else iterdraw;

     read(kbd,ch);
     if ch='h' then hgrafikhardcopy(1);
     herkulesgrafik_ausschalten;
end;

procedure menue;
var
   ch:char;
begin
     repeat
           clrscr;
           invvideo;
           gotoxy(30,6);writeln('****   IFS-Editor   ****');
           gotoxy(30,7);writeln('(c) 1988 by Rainer Urian');
           highvideo;
           gotoxy(30,10);writeln('* 1 * Koordinaten Eingabe');
           gotoxy(30,12);writeln('* 2 * IFS-Code Eingabe');
           gotoxy(30,14);writeln('* 3 * Zeichne IFS');
           gotoxy(30,16);writeln('* e * Beende Editor');
           read(kbd,ch);
           case ch of
                '1':begin
                         editpnt;
                         transform;
                         editifs;
                         drawifs;
                    end;
                '2':begin
                         editifs;
                         drawifs;
                    end;
                '3':drawifs;
           end;
     until ch='e';
end;

begin
     herkulesinitialisierung;
     herkulesseite(1);
     zeichenmodus(0);
     ifsmax:=-1;
     pntmax:=-1;
     menue;
end.
