/*-------------------------------------*
 * LPTUM.C - Umleitung von Ausgaben auf*
 * den Drucker in eine Datei           *
 *-------------------------------------*
 * (c) 1988 M. Bhrer                  *
 *-------------------------------------*
 * wegen Pseudovariablen nur TURBO-C ! *
 *-------------------------------------*
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <stat.h>
#include <process.h>

#pragma warn -par

/* Maximale Zahl von Buffern (slots) */
#define MAXSLOTS 8
#define DEFSLOTS 4
#define DEFSIZE  1024

/* LPTx - 0=LPT1, 1=LPT2 usw.         */
#define DEFPORT  0

/* Printer-Status-Byte                */
#define NOTBUSY       0x8000
#define ACKNOWLEDGE   0x4000
#define PAPEREMPTY    0x2000
#define SELECTED      0x1000
#define IOERROR       0x0800
#define TIMEOUT       0x0100

/* File-Attribute                     */

#define F_MODE    (O_WRONLY|O_TRUNC|\
                   O_CREAT|O_BINARY)
#define F_PERMISS (S_IREAD|S_IWRITE)

/* Typ-Vereinbarungen:
   ISR = Pointer auf Interrupt-Rtn
   FARCHR = Far Pointer auf char
   FARINT = Far Pointer auf int
*/
typedef void interrupt (*ISR)();
typedef unsigned char far *FARCHR;
typedef unsigned int  far *FARINT;	

/* Globale Variablen:
   Zeiger ins DOS
*/
FARCHR indos_flag;
FARCHR criticl_err;

/* Adressen der Slots, aktueller Slot */
char *slots[MAXSLOTS],*bf;
/* Anzahl und Gre der Slots         */
unsigned nslots,slotsz;
/* Nr. des Schreib- bzw. Buffer-Slots */
unsigned wslot,bslot;
/* Fllstandanzeiger des akt. Slots   */
unsigned bfill,wsize;
/* Printer-Status, File-Handle, Flags */
volatile unsigned status,timeout;
int active, errflg, reqflg, handle;
/* Nummer des abzufangenden Ports     */
unsigned lptnum;

/* Adressen der "alten" Interrupts    */
ISR old_08,old_17,old_28;

/* Prompt-Erweiterung fr COMMAND.COM */
char prompt[80]=
 "PROMPT=LPTUM aktiv - type EXIT $_";

/* Aufruf-Syntax ausgeben & Abbruch */
void usage(void)
{
  fprintf(stderr,"\a\n"
   "LPTUM -- leitet Drucker-Ausgaben"
   " (INT 17h) in Datei um\n"
   "Aufruf:  LPTUM [-opt] lptfile"
   " [programm [argumente ..]]\n"
   "wenn <programm> nicht angegeben,"
   " wird COMMAND gestartet\n"
   " -Pn   = Port-Nummer (1-3) [1]\n"
   " -SnXm = Anzahl (n) und Gre"
   " (m) der Buffer [4x1024]\n");
  exit(1);
}

/* s2u = string to unsigned          */
unsigned s2u(char **s)
{
  unsigned x=0;
  while (**s>='0' && **s<='9')
   x=10*x+ *(*s)++ -'0';
  return x;
}

/* "set_indos" ermittelt die Adresse
   des InDos-Flags und des Critical-
   Error_Flags;
   ACHTUNG: Funktion 34H ist NICHT
   dokumentiert!
*/
int set_indos(void)
{
  FARCHR s;
  unsigned count;
  unsigned dos_seg,indos_off,err_off;
  /* Adresse des InDos-Flags ber die
     DOS-Funktion 0x34 ermitteln
     (Rckgabe in ES:BX) und daraus
     den Far-Pointer basteln
  */
  _AH=0x34; geninterrupt(0x21);
  dos_seg=_ES; indos_off=_BX;
  indos_flag=MK_FP(dos_seg,indos_off);
  /* Ab hier den Code durchsuchen   */
  s=indos_flag; count=0x4000;
  while (count-- &&
         (*(FARINT)s!=0x3E80
          || *(s+7)!=0xBC) )  s++;
  /* wenn gefunden, dann den offset
     aus dem Befehl extrahieren
  */
  if (count)
  {
    s+=2; err_off=*(FARINT)s;
    criticl_err=MK_FP(dos_seg,err_off);
  }
  else criticl_err=NULL;
  /* TRUE, wenn NICHT gefunden */
  return count==0;
}

/* "swp_psp" ermittelt den Wert des
   aktuellen PSP und setzt gleichzeitig
   "new" als neuen Wert ein
   ACHTUNG: die DOS-Funktionen 50H und
   51H sind nicht dokumentiert!
*/
unsigned int swap_psp(unsigned int new)
{
  unsigned int old;
  _AH=0x51;
  geninterrupt(0x21);
  old=_BX;
  _BX=new; _AH=0x50;
  geninterrupt(0x21);
  return old;
}

/* "save_slot" schreibt den Buffer Nr.
   "wslot" aus und erhht wslot um 1;
   sicherheitshalber wird das Program-
   Segment-Prefix (PSP) gendert;
*/
void save_slot()
{
  unsigned oldpsp,wb;
  /* hier evtl. eigenen Stack ein-
     richten (ACHTUNG: lokale Vars)
     und die Interrupts 1BH, 23H und
     24H umbiegen
  */
  active++;
  oldpsp=swap_psp(_psp);
  wb=write(handle,slots[wslot],wsize);
  if (wb!=wsize) status|=IOERROR;
  else
  {
    wslot=(wslot+1)%nslots;
    status|=NOTBUSY;
    status&=~TIMEOUT;
  }
  swap_psp(oldpsp);
  reqflg--; active--;
}

/* "new_17" ist die neue Interrupt-
   Service-Routine des Drucker-In-
   terrupts; in DX wird die Nummer
   des Drucker-Ports bergeben, in
   AH das Kommando (0,1,2) und in AL
   das zu druckende Zeichen; in AH
   wird immer der Drucker-Status zu-
   rckgeliefert
*/
void interrupt new_17(
 unsigned bp, unsigned di, unsigned si,
 unsigned ds, unsigned es, unsigned dx,
 unsigned cx, unsigned bx, unsigned ax)
{
  int nxt_slot;
  /* wenn DX ungleich lptnum, dann
     alte ISR aufrufen
  */
  if (dx!=lptnum)
  {
    _AX=ax; _DX=dx; (old_17)();
    ax=_AX;
  }
  /* ansonsten Funktionen selbst aus-
     fhren; interessant ist hier nur
     Funktion 0 (drucke bzw. speichere)
  */
  else
  {
    if ((ax&0xFF00)==0)
    {
      /* wenn BUSY, dann Int 08 eine
         Chance einrumen:
      */
      if ((status&NOTBUSY)==0)
      {
        enable(); /* enable ints    */
        timeout=18; /* ca. 1 sec    */
        while ((status&NOTBUSY)==0 &&
               (status&TIMEOUT)==0);
        if (status&TIMEOUT) errflg++;
      }
      /* wenn bislang kein Fehler auf-
         getreten ist, dann das Byte in
         AL im Buffer speichern
      */
      if ((status&TIMEOUT)==0
        && (status&IOERROR)==0)
      {
        *bf++=ax&0xFF;
        /* wenn der aktuelle Buffer voll
           ist (bfill=0), bslot erhhen
           und evtl. gleich auf Platte
           schreiben, sonst auf Int 08
           oder Int 28 warten
        */
        if (--bfill==0)
        {
          reqflg++;
          bslot=(bslot+1)%nslots;
          bf=slots[bslot];
          bfill=slotsz;
          if (*indos_flag==0
              && *criticl_err==0)
          {
            save_slot();
          }
          else if (bslot==wslot)
          {
            status&=~NOTBUSY;
          }
        }
      }
    }
    ax=(ax&0xFF)|status;
  }
}

/* "new_08" ist die neue Service-
   Routine des Timer-Interrupt, der
   normalerweise ca. 18 mal in der
   Sekunde aufgerufen wird: wenn's
   was zu schreiben gibt und weder
   das DOS-Flag, noch das Critical-
   Error-Flag gesetzt sind, kann
   ein Block ausgeschrieben werden
*/
void interrupt new_08()
{
  (old_08)();
  if (!active && reqflg)
  {
    if ((*indos_flag==0)
         && (*criticl_err==0))
    {
      save_slot(); timeout=0;
    }
    else if (timeout)
    {
      if (!--timeout) status|=TIMEOUT;
    }
  }
}

/* "new_28" ersetzt den Int_28H, den
   DOS aufruft, um zu signalisieren,
   da DOS zwar aktiv ist, aber in
   keinem kritischen Zustand
*/
void interrupt new_28()
{
  (old_28)();
  if (!active && reqflg
      && (*criticl_err==0))
  {
    save_slot();
  }
}

/*-----------------------------------*/
/* Hauptprogramm .....               */
/* Aufruf:                           */
/* LPTUM [-opt] filnam [prg ...]     */
/*  -Pn  (n=1-3) Nummer des Ports    */
/*  -Ss  Anzahl/Gre der Buffer     */
/*    s= [nslots X]size[K]           */
/*       -S1K <=> -S1x1024           */
/*-----------------------------------*/

main(int ac,char *av[])
{
  int i,p;
  char *cmd;
  /* Default-Werte der Optionen      */
  lptnum=DEFPORT;
  nslots=DEFSLOTS;
  slotsz=DEFSIZE;
  /* Optionen (UNIX-style) lesen     */
  p=1;
  while (p<ac && *av[p]=='-')
  {
    cmd=av[p++]; cmd++;
    if (*cmd=='P' || *cmd=='p')
    {
      cmd++;
      if (*cmd<'1' || *cmd>'3'
          || *(cmd+1) ) usage();
      lptnum=*cmd-'1';
    }
    else if (*cmd=='S' || *cmd=='s')
    {
      cmd++;
      nslots=1; slotsz=s2u(&cmd);
      if (*cmd=='X' || *cmd=='x')
      {
        cmd++; nslots=slotsz;
        slotsz=s2u(&cmd);
      }
      if (*cmd=='K' || *cmd=='k')
      {
        cmd++; slotsz*=1024;
      }
      if (*cmd || !nslots || !slotsz)
         usage();
      if (nslots>MAXSLOTS)
      {
        fprintf(stderr,"\a\n"
         "LPTUM - Parameterfehler."
         " Maximal %d Slots",MAXSLOTS);
        exit(1);
      }
    }
    else usage();
  }
  if (p==ac) usage();
  if (set_indos())
  {
    fprintf(stderr,"\a\n"
     "LPTUM - Adresse des Critical-"
     "Error-Flag ist unbekannt\n");
    exit(2);
  }

  /* Speicher fr Buffer beantragen  */
  for (i=0; i<nslots; i++)
   if ((slots[i]=malloc(slotsz))==NULL)
   {
     fprintf(stderr,"\a\n"
      "LPTUM - Zu wenig Speicher fr "
      "%d x %d Bytes\n",nslots,slotsz);
     exit(4);
   }

  /* Drucker-Datei ffnen */
  handle=open(av[p],F_MODE,F_PERMISS);
  if (handle<0)
  {
    fprintf(stderr,"\a\n"
     "LPTUM - die Datei <%s> kann nicht"
     " geffnet werden\n",av[p]);
    exit(3);
  }
  p++;

  /* Variablen initialisieren         */
  status=NOTBUSY|SELECTED;
  errflg=reqflg=timeout=0;
  active=wslot=bslot=0;
  bf=slots[0]; bfill=wsize=slotsz;

  /* verwendete Interrupts "umbiegen" */
  old_17=getvect(0x17);
  old_28=getvect(0x28);
  old_08=getvect(0x08);
  setvect(0x17,new_17);
  setvect(0x28,new_28);
  setvect(0x08,new_08);

  /* wenn kein Programm angegeben, dann
     COMMAND.COM starten, ansonsten das
     Programm und die Parameter aus der
     Kommandozeile ermitteln
  */
  if ((ac-=p)==0)
  {
    strcat(prompt,getenv("PROMPT"));
    putenv(prompt);
    cmd=getenv("COMSPEC");
    i=spawnl(P_WAIT,cmd,cmd,NULL);
  }
  else
  {
/*=====================================
    for(i=0; i<ac; i++) av[i]=av[i+p];
    av[ac]=NULL;
    i=spawnvp(P_WAIT,av[0],av);
=======================================*/
    av+=p;
    i=spawnvp(P_WAIT,*av,av);
  }

  /* Ursprngl. Interrupts einsetzen  */
  setvect(0x08,old_08);
  setvect(0x17,old_17);
  setvect(0x28,old_28);

  if (i<0)
  {
    fprintf(stderr,"\a\n"
     "LPTUM - das Programm <%s> kann"
     " nicht ausgefhrt werden\n",
     (ac) ? av[0] : cmd);
    close(handle);
    exit(5);
  }
  /* eventuell Rest der Buffer aus-
     schreiben und  Datei schlieen
  */
  while ((status&IOERROR)==0 && reqflg)
        save_slot();
  if ((status&IOERROR)==0 &&
      (wsize-=bfill)!=0)  save_slot();
  if (errflg || status&IOERROR)
  {
    fprintf(stderr,"\a\n"
     "LPTUM -- Fehler. Datei wahr"
     "scheinlich unvollstndig!\n");
  }
  exit(0);
}
