/* PARK bewegt den Kopf der Festplatte auf die hoechste

   Spur. D. Goehler, Juli 1988 */

#include "exec/types.h"
#include "exec/io.h"
#include "devices/trackdisk.h"

#define  SPUREN  640L     /* Hoechste Spur */
#define  KOEPFE   4L       /* Anzahl Koepfe */
#define  SEKTOREN 26L      /* Sektoren pro Spur */

SHORT error;               /* fuer Fehler-Codes */
struct MsgPort *diskport;  /* Nachrichten-Port */
struct IOStdReq *diskreq;  /* Message-Struktur */

extern struct MsgPort *CreatePort();
extern struct IORequest *CreateExtIO();

LONG drive = 1L;     /* !!! wichtig: Laufwerk 1 !!! */

park()  /* Kopf auf hoechste Spur bewegen */
{
   diskreq->io_Command = TD_SEEK;  /* Spur anfahren */
   diskreq->io_Offset  = SPUREN*KOEPFE*SEKTOREN*512L; 
   if(DoIO(diskreq)) /* wenn ein Fehler auftrat */
      return(1);     /* dann 1 zurueckgeben */
   else
      return(0);     /* sonst 0 */
}

main()
{
   if ((diskport = CreatePort(0L,0L)) == NULL)
      Error(4,"Der Port laesst nicht oeffnen\n");

   diskreq = (struct IOStdReq *)CreateExtIO(diskport,
                      (long)sizeof(struct IOStdReq));
   if (diskreq == 0)
      Error(3,"Request nicht zu erstellen\n");
   /* Port und Request zur Kommunikation stehen */

   error = OpenDevice("harddisk.device",drive,diskreq,0L);
   if (error)
      Error(2,"Device laesst sich nicht oeffnen !!\n");

   if (park() == 1) Error(1,"Fehler beim Parken !!\n");
   else             Error(0,"Koepfe gesichert.\n");
}

Error(num,text)
int num;
char *text;
{
   if (text != 0L) printf(text);
   switch(num)
   { case 0: 
     case 1: CloseDevice(diskreq); 
     case 2: DeleteExtIO(diskreq,(long)sizeof(*diskreq));
     case 3: DeletePort(diskport);
     default: break;
   }
   if (num != 0) exit(20);
   else          exit(0);
}
