*+ 
*  Tastaturtreiber fr MF-2 Tastatur im PC - Modus ber MIDI
* 
*  Ingo Sprick, Andreas Kromke 14.9.88
*-

gemdos    EQU       1
xbios     EQU       14
Iorec     EQU       14
Keytbl    EQU       16
Kbdvbase  EQU       34
Supexec   EQU       38
Crawcin   EQU       $07
Cconws    EQU       $09
Super     EQU       $20
Ptermres  EQU       $31
Pterm     EQU       $4c
Mshrink   EQU       $4a
TAB       EQU       9
ESC       EQU       $1b
CR        EQU       $0d
LF        EQU       $0a
QUOTE     EQU       $27

PAUSE     EQU       $61            ; pause (pc) -> UNDO (ST)




     TEXT

_base     EQU  *-$100              ; Adresse der Basepage

 bra      install

neu_midisys:
 move.l   keyb_iorec(pc),a0
 lea      $fffffc04,a1
 move.b   0(a1),d2
 btst     #7,d2                    ; Interrupt Request ?
 beq.s    nix                      ; nein
 btst     #0,d2                    ; Receiver Buffer full ?
 beq.s    nicht_voll               ; nein
 movem.l  d2/a0/a1,-(sp)
 bsr.s    arcvint_neu
 movem.l  (sp)+,a1/a0/d2
nicht_voll:
 andi.b   #$20,d2
 beq.s    nix
 move.b   2(a1),d0                 ; Fehler: nur Status lschen
nix:
 rts

*+ Unsere neue Routine "arcvint"
* 
*  In Speicherstelle 2(a1) steht der PC- Scancode, in a0 ein Zeiger
*  auf iorec der Tastatur, den wir nicht verndern drfen.
*  Folgende Register drfen benutzt werden: a1,a2,d1,d2,d0
*  In d0 steht dann der ST-Scancode, mit dem die alte Routine
*  aufgerufen wird. Falls die Daten nicht bergeben werden sollen
*  (z.B. mu auf weitere Bytes gewartet werden), wird ein RTS
*  ausgefhrt.
*- Die Routine weist alle unmglichen PC- Scancodes ab.

arcvint_neu:
 move.b   2(a1),d0
 lea      h_tab(pc),a2
no_f0:
 cmp.b    #$e0,d0             ; ESC- Code E0 gesendet ?
 bne.s    vgl_e1
 st       h_esc(a2)           ; ESC- Flag merken
 sf       h_e1(a2)            ; anderes lschen (Vorsichtsmanahme!)
nixmehr:
 rts                          ; nichts bergeben, nur ESC gemerkt
vgl_e1:
 cmp.b    #$e1,d0             ; ESC- Code E1 gesendet ?
 bne.s    sonst
 move.b   #2,h_e1(a2)         ; Auf E1 folgen immer zwei Bytes
 sf       h_esc(a2)           ; andere Flags vorsichtshalber lschen
 rts                          ; nichts bergeben, nur ESC1 gemerkt
sonst:
 tst.b    h_e1(a2)            ; kam vorher ESC- Code E1 ?
 beq.s    sonstsonst          ; nein
 subq.b   #1,h_e1(a2)         ; schon zwei Bytes nach E1 empfangen ?
 bne.s    nixmehr             ; nein, weiterwarten
 move.b   d0,d2
 andi.b   #$80,d2             ; Break-Bit in D2 merken
 move.b   #PAUSE,d0           ; E1,XX,XX ist immer die "PAUSE"- Taste
 sf       d1                  ; kein Fehler
 bra.s    wiedereinsprung     ; ST- Code fr PAUSE bergeben
sonstsonst:
 lea      tab_normal(pc),a1   ; Umwandlungstabelle ohne ESC
 tst.b    h_esc(a2)
 beq.s    no_esc
 lea      tab_esc(pc),a1      ; Umwandlungstabelle mit ESC
 sf       h_esc(a2)           ; ESC- Status lschen
no_esc:
 move.b   d0,d2
 andi.b   #$80,d2             ; Break-Bit in D2 merken
 andi.w   #$7f,d0             ; Fr Tabellenzugriff (max. 128-Byte)
 move.b   0(a1,d0.w),d0
 smi      d1                  ; plausibel ?
wiedereinsprung:
 or.b     d2,d0               ; ggf. ST- Breakcode setzen
 bpl.s    no_brk
 clr.b    letzte_taste(a2)    ; Autorepeat- Verhinderer lschen
no_brk:
 tst.b    d1                  ; war Fehler aufgetreten ?
 bne      nixmehr             ; ja, Scancode unterdrcken
 tst.b    d0
 bmi.s    ins_bios
 cmp.b    letzte_taste(a2),d0 ; vorherige Taste war dieselbe ?
 beq      nixmehr             ; Autorepeat sperren
 move.b   d0,letzte_taste(a2) ; neue Taste merken
ins_bios:
 move.l   tastenverarb(pc),a1
 jmp      (a1)                ; alte Routine aufrufen


*+ Die Tabellen ordnen dem PC- Scancode einen ST- Scancode zu.
*  Die untere Tabelle wird benutzt, wenn das Prfix E0 vorher kam.
*  Fr das Prfix E1 wird keine Tabelle angelegt, weil es nur eine
*  einzige Taste mit Prfix E1 gibt, nmlich PAUSE.
*  Eintrge $ff knnen eigentlich nicht auftreten. Sie werden einfach
*  ignoriert.
*  Sicherheitshalber sind beide Tabellen je 128 Bytes lang, damit durch
*  Empfang falscher Codes kein Tabellenberlauf stattfindet,
*- sondern der jeweilige falsche Code unterdrckt wird.


tab_normal:

*       $0              $4              $8              $c
 DC.B  $ff,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0a,$0b,$0c,$0d,$0e,$0f
 DC.B  $10,$11,$12,$13,$14,$15,$16,$17,$18,$19,$1a,$1b,$1c,$1d,$1e,$1f
 DC.B  $20,$21,$22,$23,$24,$25,$26,$27,$28,$2b,$2a,$29,$2c,$2d,$2e,$2f
 DC.B  $30,$31,$32,$33,$34,$35,$36,$66,$38,$39,$3a,$3b,$3c,$3d,$3e,$3f

*       $0              $4              $8              $c
 DC.B  $40,$41,$42,$43,$44,$75,$76,$67,$68,$69,$4a,$6a,$6b,$6c,$4e,$6d
 DC.B  $6e,$6f,$70,$71,$62,$ff,$60,$45,$46,$ff,$ff,$ff,$ff,$ff,$ff,$ff
 DC.B  $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
 DC.B  $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff


tab_esc:

*       $0              $4              $8              $c
 DC.B  $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
 DC.B  $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$72,$1d,$ff,$ff
 DC.B  $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
 DC.B  $ff,$ff,$ff,$ff,$ff,$65,$ff,$62,$38,$ff,$ff,$ff,$ff,$ff,$ff,$ff

*       $0              $4              $8              $c
 DC.B  $ff,$ff,$ff,$ff,$ff,$ff,$ff,$47,$48,$63,$ff,$4b,$ff,$4d,$ff,$77
 DC.B  $50,$64,$52,$53,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
 DC.B  $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
 DC.B  $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff


h_tab:         DC.B      0,0,0,0        ; Arbeitstabelle
h_esc          EQU       0              ; Flag : ESC- Byte   E0
h_e1           EQU       1              ; Flag : ESC- Byte   E1
h_e1_cnt       EQU       2              ; Zhler fr E1- Taste
letzte_taste   EQU       3              ; letzter ST- Make- Code fr
*                                          Sperren des Autorepeat

tastenverarb:  DS.L      1
keyb_iorec:    DS.L      1


unser_ende:
*         ende


*+ Installationsteil.
* 
*  Ermittelt die Adresse der Tastenverarbeitung im TOS und speichert
*-  sie fr spteren Gebrauch in "tastenverarb".


install:
 move.w   #Kbdvbase,-(sp)
 trap     #xbios
 addq.l   #2,sp
 move.l   d0,a5                    ; a5 := Kdvbase
 move.l   $20(a5),a0               ; ikbdsys
*                                    Suche nach "bcs tastenverarb"
 move.w   #1024-1,d0               ; maximal 1024 Worte durchsuchen
suche:
 addq.w   #2,a0
 cmpi.l   #$0c0000f6,(a0)          ; 68000- Code fr "cmpi.b #$f6,d0"
 dbeq     d0,suche
 bne      err
 addq.w   #4,a0
 cmpi.w   #$6500,(a0)+             ; "bcs.l" ?
 bne      err
 adda.w   (a0),a0                  ; a0 := Wiedereinsprungpunkt
 lea      tastenverarb(pc),a1
 move.l   a0,(a1)

* iorec fr Tastatur merken

 move.w   #1,-(sp)                 ; Tastatur
 move.w   #Iorec,-(sp)
 trap     #xbios
 addq.l   #2,sp
 lea      keyb_iorec(pc),a0
 move.l   d0,(a0)

*  neuen Interrupt anmelden

 lea      neu_midisys(pc),a0
 move.l   a0,$1c(a5)               ; als midisys

*+ An dieser Stelle knnen durch den Xbios- Aufruf Keytbl()
*  PC- angepate Tastaturtabellen angelegt werden.
*  (vgl. 1. Teil in c't 10/88)
*  Termres
*  Es wird tatschlich nur exakt soviel Speicher resident gemacht,
*- wie unsere Rotine bentigt (ohne Installationsteil).

 lea      _base(pc),a0             ; Beginn des residenten Teils
 lea      unser_ende,a1
 suba.l   a0,a1                    ; Abziehen vom Ende desselbigen
 pea      ok(pc)
 move.w   #Cconws,-(sp)
 trap     #gemdos                  ; "OK" Meldung
 addq.l   #6,sp
 move.w   #Crawcin,-(sp)           ; Auf Taste warten
 trap     #gemdos
 addq.l   #2,sp
 clr.w    -(sp)                    ; kein Fehler
 move.l   a1,-(sp)
 move.w   #Ptermres,-(sp)          ; festkrallen
 trap     #gemdos

err:
 pea      fehler(pc)
 move.w   #Cconws,-(sp)
 trap     #gemdos                  ; Fehlermeldung
 addq.l   #6,sp
 move.w   #Crawcin,-(sp)
 trap     #gemdos                  ; auf Taste warten
 addq.l   #2,sp
 move.w   #-1,-(sp)                ; Bei Fehlern wird ERROR geliefert
 move.w   #Pterm,-(sp)             ; nichtresident beenden
 trap     #gemdos

fehler:
 DC.B ESC,'ETreiber arbeitet nicht mit Ihrem installierten TOS.',0
ok:
 DC.B ESC,'E',LF,TAB,TAB,TAB,' c',QUOTE,'t - PC- Tastaturtreiber V1.0'
 DC.B CR,LF,LF,TAB,TAB,TAB,'Version fr MIDI- Schnittstelle',CR,LF,0
 
 END
