; PrintScreen

;
; Dieses Programm kopiert den Inhalt eines CLI- oder
; CLI-aehnlichen Fensters in hoher Geschwindigkeit in ASCII
; zum Drucker. Es benoetigt keine Library zum Linken !!!
;
; (C) 1988  Matthias Melcher, Jentgesallee 44, 4150 Krefeld
;
AZTEC    EQU   1     ; wenn kein Aztec-Assembler benutzt wird,
                     ; AZTEC auf 0 setzen
      IFNE AZTEC
         far   code
         far   data
      ENDC

ExecBase EQU 4
OpenLib  EQU -552
CloseLib EQU -414
Write    EQU -48
Open     EQU -30
Close    EQU -36

       IFNE AZTEC
        SECTION printcode,CODE
       ENDC

       XDEF    _start
_start:
       bsr     OpenLibs        ; Wo ist intuition
       bsr     setVars         ; Setzt einige Werte fuer spaeter
       tst.b   Ok              ; Fehler Aufgetreten ?
       beq     ende            ; falscher Zeichensatz ->Schluss
       bsr     FindBase        ; Sucht das 1. Byte d. Fensters
       bsr     PrintCRLF       ; Neue Zeile
       move.l  FirstByte,a0    ; erstes Zeichen
       bsr     PrintWdw        ; Zeichen fuer Zeichen ausgeben
ende:
       bsr     CloseLibs       ; Libraries schliessen
       rts

;#### Sucht alle Positionen des Fensters ab und gibt Buchstaben
;     an den Drucker aus.

PrintWdw:
       move.w  WdwHeight,d6    ; Hoehe inneres Fenster in Pixel
       lsr.w   #3,d6           ; d6 = Hoehe in Bytes
       move.l  a0,a5           ; erstes Byte im Fenster -> a5
lp006: move.w  WdwWidth,d7     ; Breite des inneren Fensters
       lsr.w   #3,d7           ; ... in Bytes
lp007: bsr     WhatChar        ; Zeichen lesen und drucken
       addq.l  #1,a0           ; naechstes Zeichen
       subq.w  #1,d7           ; Zeile komplett?
       bne     lp007           ; wenn nicht, springe
       bsr     PrintCRLF       ; sonst Zeilenvorschub ausgeben
       move.w  BpR,d1          ; Screen-Breite -> d1
       mulu    YSize,d1        ; mal der Hoehe eines Zeichens
       ext.l   d1              ; auf Langwort erweitern
       add.l   d1,a5           ; a5 = Zeiger Byte naechste Zeile
       move.l  a5,a0           ; a0  wird laufend veraendert
       subq.w  #1,d6           ; alle Zeilen gelesen?
       bne     lp006           ; nicht ? dann springe
       move.b  #12,d0          ; FormFeed am Ende
       bsr     PrintIt         ; und ausgeben
       rts                     ; fertig

;#### Vergleicht das Muster eines Zeichens vom Bildschirms
;     (steht in CBuff) mit denen des Zeichensatzes

FindChar:
       clr.l   d0              ; aktuell getestetes Zeichen
       clr.l   d1              ; Anzahl der zu testenden Zeichen
       move.b  Chars,d1        ; Anzahl aller Zeichen im ROM
       addq.w  #1,d1           ; (Angleich)
lp002: lea     CBuff,a2        ; Pufferadresse in a2
       move.l  BitData,a1      ; Adresse der Zeichen-Pattern
       add.l   d0,a1           ; plus Offset des akt. Zeichens
       move.w  YSize,d4        ; Zeilenzaehler
lp003: move.b  (a2)+,d3        ; Puffer nach d3
       cmp.b   (a1),d3         ; Vergleiche mit Zeichensatz
       bne     cn001           ; wenn beide gleich sind...
       add.l   d1,a1           ; ... naechste Zeile...
       subq.w  #1,d4           ; ... bis alle Zeilen ...
       bne     lp003           ; ... getestet sind
       rts                     ; Erfolgreich !
cn001: addq.b  #1,d0           ; naechster Kandidat
       cmp.b   Chars,d0        ; letztes Zeichen ?
       bls     lp002           ; nein - dann weitertesten
       clr.b   d0
       rts

;#### Fuellt den Puffer (CBuff) mit einem Buchstaben vom
;     Bildschirm und richtet ihn bitweise aus, damit er
;     mit den Buchstaben im ROM verglichen werden kann.

FillBuff:
       move.w  BpR,d0          ; Breite des Screens nach d0
       ext.l   d0              ; auf Langwort erweitern
       move.l  d0,a3           ; in a3 ablegen (fuer spaeter)
       move.w  YSize,d1        ; Zaehler (=Buchstabenhoehe)
       move.l  a0,a1           ; Bitplane nach a1 sichern
       lea     CBuff,a2        ; Adresse des Buffers
       move.w  WdwLeft,d2      ; Pixel-Offset
       and.w   #7,d2           ; modulo 8
       add.w   #8,d2           ; plus 8, siehe weiter unten
lp001: move.b  (a1),d0         ; Bit 8-15
       rol.w   #8,d0           ; an die richtige Stelle
       move.b  1(a1),d0        ; Bit 0-7
       rol.w   d2,d0           ; rechtsbuendig machen
       move.b  d0,(a2)+        ; in den Puffer
       add.l   a3,a1           ; naechste Zeile
       subq.w  #1,d1           ; Zaehler herabzaehlen
       bne     lp001           ; wenn der Puffer noch nicht
       rts                     ; voll ist: nochmal

;#### verrichtet die Arbeit, ein Zeichen vom Bildschirm zu
;     analysieren und auszugeben

WhatChar:
       bsr     FillBuff        ; Zeichen vom Schirm in CBuff
       bsr     FindChar        ; Zeichen ermitteln
       add.b   #32,d0          ; 32 addieren.
       bpl     cn002           ; Wenn das Zeichen > 127 ist,
       add.b   #32,d0          ; wiederum 32 addieren
cn002: bsr     PrintIt         ; Zeichen ausgeben
       rts

;#### Sendet ein Zeichen zum Druckertreiber. Bei einem Fehler
;     wird jedes weitere Zeichen verschluckt.

PrintIt:
       tst.b   fault           ; schon Fehler aufgetreten ?
       bne.s   PrintIt_end     ; dann Ausgabe ueberspringen
       move.l  a0,-(sp)        ; sonst a0 sichern
       move.b  d0,CharToPrint  ; sichere das Zeichen
       move.l  #CharToPrint,d2 ; Adresse davon nach d2
       move.w  #1,d3           ; ein Zeichen ausgeben
       move.l  PrtHandle,d1    ; Datei-Handle nach d1
       move.l  DOSbase,a6      ; DosBase nach a6
       jsr     Write(a6)       ; und zum Drucker schicken
       tst.b   d0              ; Fehler aufgetreten ?
       smi     fault           ; setze Fehlerflag auf $ff
       move.l  (sp)+,a0        ; restauriere a0
PrintIt_end:                   ; das wars
       rts

;#### Sendet eine CR-LF-Sequenz zum Drucker

PrintCRLF:
       move.b  #10,d0          ; 10 = Linefeed
       bsr     PrintIt         ; ausgeben
       move.b  #13,d0          ; 13 = Carriage Return
       bsr     PrintIt         ; ausgeben
       rts

;#### Sucht die Basis des Fensters und fuellt einige
;     Variablen (WdwWidth, WdwHeight, WdwLeft, FirstByte,
;                BpR)

FindBase:
       move.l  BitMap,a1       ; Adresse der BitMap-Struktur
       move.l  WdwHandle,a0    ; Zeiger auf die Window-Struktur
       move.w  112(a0),WdwWidth  ; Breite des Windows
       move.w  114(a0),WdwHeight ; Hoehe des Windows speichern
       move.l  8(a1),d0        ; Adresse der 1 BitPlane -> d0
       move.l  d0,Plane1       ; in Variable Plane1 sichern
       move.w  0(a1),BpR       ; Bytes per Row
       move.b  55(a0),d1       ; Dicke oberer Fensterrahmen
       ext.w   d1              ;   vom Byte zum Word
       add.w   6(a0),d1        ; plus TopEdge
       mulu    BpR,d1          ; * Screen-Breite
       move.b  54(a0),d2       ;   Dicke des linken Rahmens
       ext.w   d2              ;   vom Byte zum Word
       add.w   4(a0),d2        ;   plus LeftEdge
       move.w  d2,WdwLeft      ;   sichern (wird noch gebraucht)
       lsr.w   #3,d2           ;   LeftEdge durch 8 teilen
       add.w   d2,d1           ; plus LeftEdge in Bytes
       ext.l   d1              ;   vom Word zum Long
       add.l   Plane1,d1       ; plus Screen-Adresse
       move.l  d1,FirstByte    ; = Fenster-Adresse
       rts

;#### Diese Unterroutine oeffnet IntuitionBase, DosBase sowie
;     "prt:"

OpenLibs:
       clr.b   fault           ; kein Fehler bei der Ausgabe.
       move.b  #$ff,Ok         ;
       move.l  ExecBase,a6     ; Anfang der ExecBase in a6
       clr.l   d0              ; Versionsnummer ist egal
       lea     IntuiName,a1    ; Adresse der "intuition.library"
       jsr     OpenLib(a6)     ; Oeffne Intuition
       move.l  d0,IntuiBase    ; und in Variable sichern
       lea     DosName,a1      ; Adresse der "dos.library"
       clr.l   d0              ; Version ist egal
       jsr     OpenLib(a6)     ; Oeffne DosBase
       move.l  d0,DOSbase      ; Adresse sichern
       move.l  #PrtName,d1     ; 'PRT:'
       move.l  #1005,d2        ; MODE_OLDFILE
       move.l  DOSbase,a6      ; DOSBase nach a6
       jsr     Open(a6)        ; Datei "PRT:" oeffnen
       move.l  d0,PrtHandle    ; Handle in Variable sichern
       rts                     ; und zurueck

CloseLibs:
       move.l  DOSbase,a6      ; DosBase nach a6 bringen
       move.l  PrtHandle,d1    ; Handle nach d1
       tst.l   d1              ; Ueberhaupt gueltig ?
       beq     cn004           ; wenn nicht, springe
       jsr     Close(a6)       ; sonst schliesse Datei
cn004: move.l  DOSbase,a1      ; DosBase nach a1
       move.l  ExecBase,a6     ; ExecBaseadresse nach a6
       jsr     CloseLib(a6)    ; DOS schliessen
       move.l  IntuiBase,a1    ; IntuitionBaseadresse nach a6
       jsr     CloseLib(a6)    ; Intuition schliessen
       rts

;#### Hier werden die wichtigsten Adressen abgefragt + abgelegt

setVars:
       move.b  #0,Ok           ; Rueckgabe-Flag -> Fehler
       move.l  IntuiBase,a0    ;
       move.l  52(a0),a0       ; Zeiger auf die Window-Struktur
       move.l  a0,WdwHandle    ; Sichern.
       move.l  128(a0),a1      ; Zeiger auf TextFont-Structur
       move.l  a1,TextFont     ; Sichern
       move.l  34(a1),BitData  ; Hier starten die Bit-Pattern
                               ; des aktuellen Zeichensatzes
       cmp.w   #8,24(a1)       ; wenn der Zeichensatz 8 Pixel
       beq     weiter1         ; breit ist, springe zu weiter1
       rts                     ; sonst zurueck (Ok ist 0=FALSE)
weiter1:
       move.w  20(a1),YSize    ; Hoehe wird beruecksichtigt
       move.b  33(a1),d0       ; HiChar,letztes druckbares Zei.
       sub.b   32(a1),d0       ; LoChar,erstes druckbares Zei.
       sub     #32,d0          ; 128 - 159 sind nicht vorhanden
       move.b  d0,Chars        ; in Chars sichern
       move.l  50(a0),a2       ; RastPort-Adresse lesen
       move.l  a2,RastPort     ; in Variable sichern
       move.l  4(a2),BitMap    ; BitMap-Struktur-Adresse
       move.b  #$ff,Ok         ; Kein Fehler aufgetreten
       rts                     ; zurueck

               IFNE AZTEC
                 SECTION printdata,DATA
               ENDC
               cnop    0,4     ; align auf Langwortgrenze
IntuiBase:     dc.l    0       ; Basis der Intuition.Library
DOSbase:       dc.l    0       ; Basis der DOS.library
PrtHandle:     dc.l    0       ; Handle des Druckertreibers
WdwHandle:     dc.l    0       ; Handle des aktuellen Fensters
TextFont:      dc.l    0       ; Zeichensatzstruktur
BitData:       dc.l    0       ; Bit-Pattern des Zeichensatzes
RastPort:      dc.l    0       ; Rastport-Struktur
Plane1:        dc.l    0       ; 1. Bitplane des Bildschirms
FirstByte:     dc.l    0       ; das erste Byte im Fenster
BitMap:        dc.l    0       ; BitMap-Struktur
YSize:         dc.w    0       ; Hoehe des Zeichensatzes
BpR:           dc.w    0       ; Breite Bildschirms in Bytes
WdwLeft:       dc.w    0       ; ergibt modulo 8 den Offset
WdwWidth:      dc.w    0       ; zu FirstByte
WdwHeight:     dc.w    0       ; Breite + Hoehe des Fensters
Chars:         dc.b    0       ; Anzahl Zeichen im Zeichensatz
Ok:            dc.b    0       ; Flag(s)
CBuff:         ds.b    16      ; Puffer fuer max. 16 Pixel hohe,
                               ; 8 Pixel breite Zeichen
fault:         ds.b    0       ; Fehlerbyte (0 = alles OK)
               cnop    0,4     ; align
CharToPrint:   dc.w    0
IntuiName:     dc.b    'intuition.library',0
DosName:       dc.b    'dos.library',0
PrtName:       dc.b    'PRT:',0
               end
