#define STRICT
#include "wclsinc.h"
#include <commdlg.h>
#include <memory.h>


class EditorEditControl : public EditControl {
private:
  void LoadFile();
  void SaveFile();


public:
  DECL_HANDLER(WM_KEYDOWN);
  EditorEditControl(int w,int h,HWND hWndParent);
};



class EditorEditMetaClass : public MetaClass {
public:
  EditorEditMetaClass() {
	 MAP_HANDLER(EditorEditControl,WM_KEYDOWN);
  }
};

EditorEditMetaClass TheEditorClass;


EditorEditControl::EditorEditControl(int w,int h,
				     HWND hWndParent):
				     EditControl("",
				     WS_CHILD|WS_HSCROLL|WS_VSCROLL|
				     ES_MULTILINE|WS_VISIBLE,
				     0,0,w,h,hWndParent,1,TRUE)
{
  SetMetaClass(&TheEditorClass);
  

}


void EditorEditControl::LoadFile()
{
OPENFILENAME ofn;
char szDirName[128];
char szFile[128]="\0";
HFILE hf;
HGLOBAL hMem;
LPSTR lpText;
int nBytes;

  /* Hole Namen des Windows Directories */

  GetWindowsDirectory(szDirName, sizeof(szDirName));


  /* Initalisiere Struktur mit Nullen */
  memset(&ofn, 0, sizeof(OPENFILENAME));

  ofn.lStructSize = sizeof(OPENFILENAME);
  ofn.hwndOwner = WinHandle;
  ofn.lpstrFilter = "Alle Dateien\0*.*\0\0";
  ofn.nFilterIndex = 1;
  ofn.lpstrFile= szFile;
  ofn.nMaxFile = sizeof(szFile);
  ofn.lpstrInitialDir = szDirName;
  ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;


  if (GetOpenFileName(&ofn)) {
    hMem=GlobalAlloc(GMEM_MOVEABLE,65535);
    if (!hMem) return;
    lpText=(LPSTR)GlobalLock(hMem);

    hf = _lopen(ofn.lpstrFile, OF_READ);
    nBytes=_lread(hf,lpText,65535);
    _lclose(hf);
    if (nBytes>0) {
      lpText[nBytes]='\0';
      SetText(lpText);
    }
    GlobalFree(hMem);
  }


}


void EditorEditControl::SaveFile()
{
OPENFILENAME ofn;
char szDirName[128];
char szFile[128]="\0";
HFILE hf;
HGLOBAL hMem;
LPSTR lpText;
int nBytes;
OFSTRUCT of;

  /* Hole Namen des Windows Directories */

  GetWindowsDirectory(szDirName, sizeof(szDirName));


  /* Initalisiere Struktur mit Nullen */
  memset(&ofn, 0, sizeof(OPENFILENAME));

  ofn.lStructSize = sizeof(OPENFILENAME);
  ofn.hwndOwner = WinHandle;
  ofn.lpstrFilter = "Alle Dateien\0*.*\0\0";
  ofn.nFilterIndex = 1;
  ofn.lpstrFile= szFile;
  ofn.nMaxFile = sizeof(szFile);
  ofn.lpstrInitialDir = szDirName;
  ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;


  if (GetSaveFileName(&ofn)) {
    hMem=GlobalAlloc(GMEM_MOVEABLE,65535);
    if (!hMem) return;
    lpText=(LPSTR)GlobalLock(hMem);
    nBytes=GetText(lpText,65535);

    hf=OpenFile(ofn.lpstrFile,&of,OF_CREATE|OF_WRITE);
    if (!hf) {
      GlobalFree(hMem);
      return;
    }
    _lwrite(hf,lpText,nBytes);
    _lclose(hf);

    GlobalFree(hMem);
  }

}


DEF_HANDLER(EditorEditControl,WM_KEYDOWN)
{
  switch (wParam) {
   case VK_ESCAPE:
      SendMessage(GetParent(WinHandle),WM_CLOSE,0,0L);
      return 0L;
   case VK_F2:
     SaveFile();
     return 0L;
   case VK_F3:
     LoadFile();
     return 0L;
   default:   
    return CallDefProc(WM_KEYDOWN,wParam,lParam);
  }
}



class Editor : public ToplevelWindow {
protected:
  EditorEditControl *pEdit;

  virtual BOOL QueryClose();

public:
  DECL_HANDLER(WM_SIZE);
  DECL_HANDLER(WM_ACTIVATE);

  Editor( WindowClass *pClass);
};





class EditorClass : public WindowClass {
public:
  EditorClass():WindowClass("MySpecialWindowClass",hInstance)
  {
    MAP_HANDLER(Editor,WM_SIZE);
    MAP_HANDLER(Editor,WM_ACTIVATE);
  }
};


Editor::Editor( WindowClass *pClass):
                ToplevelWindow("Simple Editor",pClass)
{
RECT rc;

  GetClientRect(&rc);
  pEdit=new EditorEditControl(rc.right,rc.bottom,WinHandle);
}


DEF_HANDLER(Editor,WM_SIZE)
{
  pEdit->Move(0,0,LOWORD(lParam),HIWORD(lParam),TRUE);
  return 0L;
}

DEF_HANDLER(Editor,WM_ACTIVATE)
{
  if (wParam && !HIWORD(lParam))
    pEdit->SetFocus();

  return 0L;
}

BOOL Editor::QueryClose()
{
  return MessageBox(WinHandle,
		    "Wollen sie dieses Programm wirklich verlassen?",
		    "WCLSTST2",
                    MB_YESNO|MB_ICONQUESTION)==IDYES;
}

int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInst,
		   LPSTR lpCmdLine, int nCmdShow)
{
Editor		*pWindow;
EditorClass	*pClass;  // ps: lokal statt global
MSG msg;

   hInstance=hInst; // Wichtig damit WClasses funktioniert.
   hPrevInstance=hPrevInst; // dito.

   pClass=new EditorClass();
   pWindow=new Editor( pClass);
   pWindow->Show(nCmdShow);

   while (GetMessage(&msg,0,0,0)) {
     TranslateMessage(&msg);
     DispatchMessage(&msg);
   }
   return msg.wParam;
}