{$S-,R-,Q-,I-}
(* Heap-berwachung fr Turbo-Pascal DOS / DPMI *)
(* Karsten Strobel und Achim Olbrich, c't 11/94 *)
Unit HeapDeb;

{$IFDEF DPMI} {$C FIXED PRELOAD PERMANENT} {$ENDIF}

interface

implementation

uses crt, drivers;

type
  PPointerMap = ^TPointerMap;
  TPointerMap = record
    P: pointer;
    Nr: word;
    Size: Word;
    Next: PPointerMap;
  end;

const
  PtrMap: PPointerMap = nil;
  PtrCount: longint = 0;
  TotalPtrCount: longint = 0;

  HeapDebId : record
    IdStr : array [1..4] of char;
    MapProcPtr,
    UnmapProcPtr : pointer;
  end = (IdStr:'HDeb';MapProcPtr:nil;UnmapProcPtr:nil);

procedure MapProc(P: pointer; Size: Word); far;
var
  APtrMap: PPointerMap;
const
  Recurse : Boolean = false;
begin
  if Recurse or (Size = 0) then Exit;
  inc (PtrCount);
  inc (TotalPtrCount);
  Recurse := true;
  new (APtrMap);
  Recurse := false;
  if not Assigned(APtrMap) then RunError(203);
  APtrMap^.P := P;
  APtrMap^.Nr := TotalPtrCount;
  APtrMap^.Size := Size ;
  APtrMap^.Next := PtrMap;
  PtrMap := APtrMap;
end;

{-- diese Prozedur wird bei jeder Speichefreigabe aufgerufen --}
procedure UnmapProc(P: pointer; Size: Word); far;
var
  APtrMap, Prev: PPointerMap;
const
  Recurse : Boolean = false;
begin
  if Recurse or (Size = 0) then Exit;
  Prev := nil;
  APtrMap := PtrMap;
  while (APtrMap <> nil) and (APtrMap^.P <> P) do begin
    Prev := APtrMap;
    APtrMap := APtrMap^.Next;
  end;

  if Assigned(APtrMap) then   begin
    Dec (APtrMap^.Size, Size);
    if APtrMap^.Size = 0 then begin
      if Prev <> nil then Prev^.Next := APtrMap^.Next;
      if PtrMap = APtrMap then PtrMap := APtrMap^.Next;
      Recurse := true;
      dispose(APtrMap);
      Recurse := false;
      dec(PtrCount);
    end
    else RunError(204);
  end
  else RunError(204);
end;

{---------------------------------------------------------------------------}
var
  OldExitProc: pointer;
  OrigHeapSize: LongInt;

procedure LocalExitProc; far;
type
  PtrRec = record
     Ofs, Seg: Word;
  end;
var
  A: array[0..3] of longint;
  S: string;
  C: Char ;
  APtrMap: PPointerMap;
  L: LongInt ;

begin
  ExitProc := OldExitProc;
  if ExitCode <> 0 then begin
    A[0] := ExitCode;
    if ErrorAddr = nil then
      FormatStr(S, 'Programm wurde mit HALT(%d) abgebrochen', A)
    else begin
      A[1] := PtrRec(ErrorAddr).Seg;
      A[2] := PtrRec(ErrorAddr).Ofs;
      FormatStr(S, 'Laufzeitfehler %03d bei %04x:%04x', A);
      ErrorAddr := nil;
    end;
    writeln (S);
    readkey;
    exit;
  end;

  L := OrigHeapSize - MemAvail ;
  if L <> 0 then begin
    FormatStr(S, '%d Bytes zuwenig freigegeben', L);
    writeln (S);
  end ;

  FormatStr(S, '%d Pointer wurden insgesamt verwaltet', TotalPtrCount);
  writeln (S);

  APtrMap := PtrMap;
  if APtrMap <> nil then begin
    FormatStr(S, '%d Pointer zuwenig freigegeben', PtrCount);
    Writeln (S);
    Write ('auflisten (J/N) ? ');
    C := ReadKey;
    writeln (C);
    if Upcase (C) = 'J' then begin
      while Assigned (APtrMap) do begin
        with APtrMap^ do begin
          A[0] := Nr;
          A[1] := PtrRec(P).Seg;
          A[2] := PtrRec(P).Ofs;
          A[3] := Size;
          FormatStr(S, 'Lfd.Nr.: %d, Ptr.: %04x:%04x, Blockgre: %d', A);
          writeln (S);
          APtrMap := Next;
        end;
      end;
      ReadKey;
    end ;
  end
  else
    ReadKey;
end;

var
  P : pointer;

begin
{$IFOPT D+}
  OrigHeapSize := MemAvail;

  OldExitProc := ExitProc;
  ExitProc := @LocalExitProc;

  HeapDebID.MapProcPtr   := @MapProc;
  HeapDebID.UnmapProcPtr := @UnmapProc;
  P := @HeapDebID;
  FreeMem (P, 0); {dieser Aufruf gibt die beiden User-Routinen bekannt}
{$ENDIF}
end.
