// Implementations-Datei der Klasse Auto (Auto.m)
#import "Auto.h"
#import <math.h>
#include <stdio.h>

#define VERBRAUCHS_FAKTOR  0.1  /* Liter pro Weg-Koordinate */

@implementation Auto : Fahrzeug    // darf wiederholt werden

- init
{ [super init];
  spritImTank = 0.0;
  return self;
}

- initLabel:(char *)einName sprit:(float)liter
{ [self init];
  [self setLabel:einName];
  [self tanke:liter];
  return self;
}

- tanke:(float) liter
{ spritImTank += liter;
  return self;
}

- moveTo:(float)newX :(float)newY
{ float  distanz, dX, dY;

  dX = newX - posX;  // Distanz zur alten Position berechnen
  dY = newY - posY;
  distanz = sqrt (dX * dX + dY * dY);
  spritImTank -= distanz * VERBRAUCHS_FAKTOR;  
  [super moveTo:newX :newY];
  return self;
}

- dump
{ printf ("(Sprit: %f) ", spritImTank);
  return [super dump];
}

- read:(NXTypedStream*)stream
{ [super read:stream];
  NXReadTypes(stream, "f", &spritImTank);
  return self;
}

- write:(NXTypedStream*)stream
{ [super write:stream];
  NXWriteTypes(stream, "f", &spritImTank);
  return self;
}
@end
