/* ** SaveTime.C **
Compiler: Borland C++ 3.1 , (c) c't/Jrg Scholvin/as
Achtung: 'Test Stack-Overflow' aus!     */

#include <dos.h>
#include <stdio.h>

/* Alle resistenten Variablen global und initiiert */

short Zaehler=0;
unsigned char Altstunde=0;

void WriteRTC (int index,int wert) {
  __emit__ (0xfa);     /* oder _disable() in BC 3.1 */
  outportb (0x70,index);
  outportb (0x71,wert);
 __emit__ (0xfb);    /* oder  _enable()  in BC 3.1*/;
 }

int ReadRTC (int index) {
  int b;
__emit__ (0xfa);     /* oder _disable() in BC 3.1 */
  outportb   (0x70,index);
  b=inportb  (0x71);
 __emit__ (0xfb);    /* oder  _enable()  in BC 3.1*/;
   return b;
}

void interrupt ( *oldhandler)(void)=NULL;       /* alter Interrupt */

void interrupt handler(void) {                 /* eigener Interrupt*/

  Zaehler++;
  if (Zaehler>=18) {
    unsigned char Stunde, Tage;
    Zaehler=0;                               /* Sekunde speichern  */
    WriteRTC(1,(ReadRTC(1) & 0x80) | (ReadRTC (0) & 0x7F));
    WriteRTC(3,ReadRTC (2));                 /* Minute  speichern  */
    Stunde=ReadRTC(4);                            /* Stunde lesen..*/
    Tage=ReadRTC(5) & 0xC0;
    WriteRTC(5,Tage | Stunde);
    if ((Stunde==0)  && (Altstunde==0x23)) { /* ein neuer Tag  ... */
      Altstunde=0;
    WriteRTC(5,(Tage + 0x40));           /* Tageszhler in Bit 7,6 */
    }
  Altstunde=Stunde;
 }
  oldhandler();    /* Die alte Interrupt-Prozedur aufrufen        */
}

/*  Hauptprogramm: Timer-Interrupt auf eigene Routine umlenken    */
int main(void) {
  oldhandler=getvect(0x1C);   /* Alten Handler von INT 1C sichern */
  Altstunde=ReadRTC(4);       /* Startstunde */
  WriteRTC(5,Altstunde);
  setvect(0x1C,handler);      /* Eigenen Interrupt installieren   */
  keep(0,_DS+((FP_OFF(&oldhandler) +20) >> 4)  - _psp);
  return 0;
}
