/* gpi.h Konstanten, Prototypen u. typedefs fr die zentralen gpi-Module  */

/*----------------------- Verschiedene Konstanten ------------------------*/
#define MESSAGELEN   256

#define RETURN_SUCCESS           0       /* successfull return in DosExit */
#define RETURN_ERROR             1             /* error return in DosExit */

#define BEEP_WARN_FREQ          60                    /* Frequenz Warnton */
#define BEEP_WARN_DUR          100                  /* Dauer des Warntons */


/*------- zentrale globale Struktur, die handles etc. enthlt ------------*/

typedef struct {
  HAB  hab;                                        /* anchor block handle */
  HMQ  hmq;                           /* handle to process' message queue */
  CHAR szAppName[MAXNAMEL];           /* buffer appl. Name string & class */
  HWND hwndMainFrame;                         /* handle main frame window */
  HWND hwndMainClient;                       /* client area of main frame */
  FONTMETRICS fm;
  USHORT usPtSize;
  HDC hdcScreen;                                 /* Device-Context Screen */
  HDC hdcPrinter;
  HPS hps;                            /* retain-PS fr die gesamte Grafik */
  HPOINTER hptr;                           /* Fr alternativen Mauszeiger */
  RECTL rclDVL;                          /* fr Default Viewing Transform */
} MainParamBlock;


/*------------------------ Funktionsprototypen ---------------------------*/
/***************************** gpi_main.c *********************************/

MRESULT EXPENTRY MainWndProc(HWND hwnd ,ULONG msg, MPARAM mp1, MPARAM mp2);
VOID MainCommand(HWND hwnd, MPARAM mp1, MPARAM mp2);
ULONG MessageBox(HWND hwndOwner, ULONG idMsg, ULONG fsStyle, BOOL fBeep);
void PrimMessageBox(char *text);
void ShowErrorMsg(char *text);
BOOL Init(VOID);
VOID ExitProc(USHORT usTermCode);

POINTL *HandleRubberObject(HPS hps, HDC hdcScreen, POINTL ptl,
			   unsigned RubCommand, unsigned long *State);
BOOL SetSegmentTranslation(HPS hps, LONG lSegId, POINTL ptlTrans);
BOOL SetSegmentScale(HPS hps, FIXED afxScale[2], LONG lSegId, 
		     POINTL ptlRoot);
BOOL SetSegmentRotation(HPS hps, FIXED fxAngle, LONG lSegId, POINTL ptl);
BOOL SetSegmentShear(HPS hps, long lSegId, double lfAngleHor,
		     double lfAngleVer);
int GrConvert(HPS hps, HDC hdc, long lPtlNum, POINTL *pPtl, LONG Source,
	      LONG Target);
VOID DrawCircle(HPS hps, POINTL pCenter, POINTL pBorder, long SC);
VOID DrawLine(HPS hps, POINTL ptlA, POINTL ptlB, long SC);
VOID DrawBox(HPS hps, POINTL ptlA, POINTL ptlB, long SC);
VOID DrawText(HPS hps, POINTL ptl, long SC);
VOID MainPaint(HWND hwnd);
unsigned long MainPrint(HWND hwnd);




