/*------------------ gpi_main.c: Hauptmodul fr GPI-Test -------------------*/

#define INCL_PM            
#define INCL_GPI
#define INCL_DOSPROCESS
#include <os2.h>                /* Alle Definitionen fr PM-Programme: faul */
                                /* spter spezielle INCL... */
#include <stdlib.h>
#include <math.h>

#include "gpi.h"                      /* Konstanten und Funktionsprototypen */
#include "gpi_rsc.h"
#include "gpi_main.h"
#include "pm_fonts.h"                         /* Fr Zeichensatzeinstellung */

MainParamBlock Mpb;                  /* globale Variable, vor allem Handles */

static struct {
  unsigned long MainState;                           /* Prog.-Zustvariable  */
  long Segment_Counter;                          /* eindeutige Nummern Segs */
  long Selected_Segment;               /* ID des gerade gewhlten Segmentes */
} State = {ST_SELECTION, 0L, 0L};


/*--------------------------------------------------------------------------*/
/* ExitProc(), Funktion zum Aufrumen, die beim Abbruch ber die DOSEXITLIST*/
/* von OS/2 aufgerufen wird, so da man sich nicht bei jedem Ausgang extra  */
/* um das Aufrumen kmmern mu                                             */
/*--------------------------------------------------------------------------*/
VOID ExitProc(USHORT usTermCode)
{
  if (WinIsWindow(Mpb.hab, Mpb.hwndMainFrame))
    WinDestroyWindow(Mpb.hwndMainFrame);
  WinDestroyMsgQueue(Mpb.hmq);
  WinTerminate(Mpb.hab);
  DosExitList(EXLST_EXIT, (PFNEXITLIST)NULL);
}  

/*--------------------------------------------------------------------------*/
/* weitere Initialisierungen beim Programmstart                             */
/*--------------------------------------------------------------------------*/
static BOOL Init(VOID)
{
  if (DosExitList(EXLST_ADD, (PFNEXITLIST)ExitProc)) {
    MessageBox(HWND_DESKTOP,
	       IDMSG_CANNOTLOADEXITLIST,
	       MB_OK | MB_ERROR,
	       TRUE);
    DosExit(EXIT_PROCESS, RETURN_ERROR);
  }
  
  if (!WinLoadString(Mpb.hab,                     /* Resource Programmname  */
		     (HMODULE)0, 
		     IDS_APPNAME,
		     MAXNAMEL,
		     Mpb.szAppName))
    return(FALSE);
                                                  
  Mpb.hptr = WinLoadPointer(HWND_DESKTOP,  /* Resource alternat. Mauszeiger */
			    NULLHANDLE,
                            IDP_GPI);
  
  if (!WinRegisterClass(Mpb.hab,             /* registr.  Main Window Class */
			(PSZ)Mpb.szAppName, 
			(PFNWP)MainWndProc,
			CS_CLIPCHILDREN | CS_SIZEREDRAW,
			0L)) {                           /* no extra memory */
    return(FALSE);
  }
  return(TRUE);
}  /*----------------------- endfunction Init() ----------------------------*/




/*--------------------------------------------------------------------------*/
/* main(): Initi. PM, erzeugt MSG_QUEUE und ruft gpi_main.c:Init() auf      */
/*         erzeugt das zentrale Window und startet die Message-Loop         */
/*--------------------------------------------------------------------------*/
int main(void)
{
  ULONG flMainWinStyle = 0L;                    /* Flags fr Fenster-Layout */
  QMSG qmsg;                                               /* Message Queue */
  
  if ((Mpb.hab = WinInitialize(0)) == NULLHANDLE)   {        /* PM-Initial. */
    DosBeep(BEEP_WARN_FREQ, BEEP_WARN_DUR);
    return(RETURN_ERROR);
  }
                              
  if ((Mpb.hmq = WinCreateMsgQueue(Mpb.hab,0)) == NULLHANDLE) {
    DosBeep(BEEP_WARN_FREQ, BEEP_WARN_DUR);
    WinTerminate(Mpb.hab);
    return(RETURN_ERROR);
  }

  if (!Init()) {                                           /* Andere Inits. */
    MessageBox(HWND_DESKTOP,                      /* Window handle of owner */
	       IDMSG_INITFAILED,                /* Index in RC-Messagetable */
	       MB_OK | MB_ERROR,                    /* OK-Button, Stop-Sign */
	       TRUE);                                 /* Alarmton ja nein ? */
    return(RETURN_ERROR);
  }
  
  /*------------ Ab jetzt Aufrumen ber ExitProc bei Prog.-Ende -----------*/
  flMainWinStyle = FCF_TITLEBAR | FCF_SYSMENU | FCF_SIZEBORDER
    | FCF_MENU | FCF_TASKLIST | FCF_SHELLPOSITION;
  /*------------- Hauptfenster erzeugen ------------------------------------*/
  Mpb.hwndMainFrame = WinCreateStdWindow(HWND_DESKTOP,       /*parent handle*/
					 WS_VISIBLE,         /* frame style */
					 &flMainWinStyle,     /* creat style*/
					 (PSZ)Mpb.szAppName,  /* Class name */
					 (PSZ)NULL,           /* title text */
					 WS_VISIBLE,         /* client style*/
					 (HMODULE) NULL,     /* res. in exe */
					 IDR_GPI,               /* frame ID */
					 (PHWND) &Mpb.hwndMainClient);
  
  if(NULLHANDLE == Mpb.hwndMainFrame)   {
    MessageBox(HWND_DESKTOP,
	       IDMSG_MAINWINDOWCREATEFAILED,
	       MB_OK | MB_ERROR,
	       TRUE);
    return(RETURN_ERROR);
  }
  
  /*-------------------------- Message Loop --------------------------------*/
  /* kein Filter : Alle Messages, kein Bereich definiert                    */
  while(WinGetMsg(Mpb.hmq, (PQMSG) &qmsg, (HWND)NULL,(ULONG)NULL,(ULONG)NULL))
    WinDispatchMsg(Mpb.hmq, (PQMSG) &qmsg);
  
  return(RETURN_SUCCESS);
}  /*---------------------------- Ende main() ------------------------------*/


/*--------------------------------------------------------------------------*/
/* InitializePSandDC() : Funktion erzeugt PS im retain Mode mit passenden   */
/*                       Einstellungen, der im MainParameterBlock Mpb gesp. */
/*                       wird. Auerdem einen DC aufs Client-Window         */
/*--------------------------------------------------------------------------*/
static void InitializePSandDC(HWND hwnd)
{
  SIZEL sizlPSize={21000,15000};                          /* Pres Page Size */
  BOOL fRet = FALSE;
  
  Mpb.hps = GpiCreatePS(Mpb.hab,                              /* PS erzeugen*/
			NULLHANDLE,
			&sizlPSize,
			PU_HIMETRIC |                          /* 1/100 mm */
			GPIF_DEFAULT |
			GPIT_NORMAL |
			GPIA_NOASSOC);                 /* nicht assoziiert */
  
  if (Mpb.hps != GPI_ERROR)
    fRet = GpiSetDrawingMode(Mpb.hps, DM_RETAIN);                /* retain */
  if (fRet) {
    fRet = GpiSetInitialSegmentAttrs(Mpb.hps,          /*  fr Correlation */
				     ATTR_DETECTABLE,
				     ATTR_ON);
    fRet &= GpiSetInitialSegmentAttrs(Mpb.hps,            /* reset Attribs */
				      ATTR_FASTCHAIN,     /* bei Seg-Open  */
				      ATTR_OFF);
  }
  
  if (!fRet) 
    PrimMessageBox("Fatal: Erzeugung des PS fehlgeschlagen ");

  Mpb.hdcScreen = WinOpenWindowDC(hwnd);            /* DC auf Client-Window*/
  if (Mpb.hdcScreen == NULLHANDLE) 
    PrimMessageBox("Fatal: DC auf Clientwindow failed. ");
} /*------------------ endfunction InitializePSandDC  ---------------------*/
      

/*-------------------------------------------------------------------------*/
/* ndert eine Order im Segment mit ID Seg zum Hervorheben                 */
/* State TRUE : Color-Order Rot; State FALSE : Color-Order Schwarz         */
/*-------------------------------------------------------------------------*/
static void SelectSegment(HPS hps, long Seg, BOOL State)
{
  GpiSetEditMode(hps, SEGEM_REPLACE);                     /* berschreiben */
  GpiOpenSegment(hps, Seg);
  GpiSetElementPointerAtLabel(hps, Seg);               /* Label direkt vor */
  GpiOffsetElementPointer(hps, 1L);                      /* SetColor-Order */
  if (State) 
    GpiSetColor(hps, CLR_RED);                           /* Element ndern */
  else
    GpiSetColor(hps, CLR_BLACK);
  GpiCloseSegment(hps);                                /* wieder schlieen */
  GpiSetEditMode(hps, SEGEM_INSERT);
  
  if (!GpiAssociate(Mpb.hps, Mpb.hdcScreen))
    PrimMessageBox("Fatal: Associate DCScreen hps failed.");
  GpiDrawSegment(Mpb.hps, Seg);                           /* aktualisieren */
  GpiAssociate(Mpb.hps, NULLHANDLE);                     /* Disassoziieren */
  
} /*----------------- endfunction SelectSegment ---------------------------*/


/*-------------------------------------------------------------------------*/
/* Legt ein neues Segment mit Objekt an, je nachdem, welches Objekt mit    */
/* MainState gewnscht mit Nummer ID                                       */
/*-------------------------------------------------------------------------*/
void CreateSegment(POINTL *pPtl, unsigned long MainState, long ID)
{
  GpiOpenSegment(Mpb.hps, ID);
  GpiSetTag(Mpb.hps, ID);                                /* Fr Correlation */
  
  switch (MainState) {                         /* je nach Zustand zeichnen */
  case ST_DRAWLINE:
    DrawLine(Mpb.hps, pPtl[0], pPtl[1], ID);
    break;
    
  case ST_DRAWBOX:
    DrawBox(Mpb.hps, pPtl[0], pPtl[1], ID);
    break;
    
  case ST_DRAWCIRCLE:
    DrawCircle(Mpb.hps, pPtl[0], pPtl[1], ID);
    break;
    
  case ST_DRAWTEXT:                             /* hat kein Rubber-Element */
    DrawText(Mpb.hps, pPtl[0], ID);
    break;
    
  } 
  GpiCloseSegment(Mpb.hps);            /* Falls unbesetzte States Leersegs */
}


void DrawPage(SIZEL sizl)
{
  AREABUNDLE abnd;
  POINTL ptl = {0,0};

    ptl.x = 0; ptl.y = 0;    GpiMove(Mpb.hps, &ptl);
    ptl.x = sizl.cx; ptl.y = sizl.cy;                   /* Pres. Page Size */
    abnd.lColor = CLR_WHITE;
    GpiSetAttrs(Mpb.hps, PRIM_AREA, ABB_COLOR, 0L, &abnd); /* Innere Farbe */
    GpiBox(Mpb.hps, DRO_OUTLINEFILL, &ptl, 0L, 0L);
}


/*-------------------------------------------------------------------------*/
/* Funktion MainWndProc(),Window-Procedure fr die Registrierte ClientClass*/
/*-------------------------------------------------------------------------*/
MRESULT EXPENTRY MainWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  POINTL ptl={0,0};               /* Hilfsvariable fr Koord.- Berechnungen*/
  static SIZEL sizl={0,0};
  POINTL *pPtl = NULL, pCenter = {1000,1000}, pBorder = {3000,3000};
  LONG alSegTag[12], lHits=0;
  RECTL rctl;
  HPS hps;
  
  switch(msg)  {
    
  case WM_CREATE:                /* Initialisierungen vor Fenstererzeugung */
    hps = WinGetScreenPS(HWND_DESKTOP);
    GpiQueryFontMetrics(hps,sizeof(FONTMETRICS),&Mpb.fm);
    Mpb.usPtSize = (unsigned short) Mpb.fm.sNominalPointSize;
    WinReleasePS(hps);                              /* Standardzeichensatz */
    
    InitializePSandDC(hwnd);               /* erzeuge PS retained und DC's */
    GpiQueryPS(Mpb.hps, &sizl);              /* Pres. Page als weie Seite */

    GpiOpenSegment(Mpb.hps, 0L);          /* 0 Segment, nicht detektierbar */
    DrawPage(sizl);
    GpiCloseSegment(Mpb.hps);          /* Falls unbesetzte States Leersegs */
    rctl.xLeft = rctl.yBottom = 0; rctl.xRight = sizl.cx; rctl.yTop = sizl.cy;
    GpiQueryDefViewingLimits(Mpb.hps, &Mpb.rclDVL);   /* Fr MainPaint()   */
    GpiSetDefViewingLimits(Mpb.hps, &rctl);
    break; /* WM_CREATE */

  case WM_PAINT:                         /* Neuzeichnen des Fensterinhalts */
    MainPaint(hwnd);
    break;
    
  case WM_COMMAND:                                       /* Menuauswahlen  */
    MainCommand(hwnd,mp1,mp2);
    break;
        
  case WM_DESTROY:                       /* Fenster zerstren              */
    WinReleasePS(Mpb.hps);       /* retained PS freigeben, WindowDC autom. */
    break;                       /* beim Fenster-Schlieen freigegeben     */
    
  case WM_BUTTON1DOWN:                          /* Linker Mausknopf gedrckt */
    WinSetCapture(HWND_DESKTOP, hwnd);
    ptl.x = MOUSEMSG(&msg)->x;
    ptl.y = MOUSEMSG(&msg)->y;                   /* Mausposition ermitteln */
    GrConvert(Mpb.hps, Mpb.hdcScreen, 1L, &ptl,CVTC_DEVICE,CVTC_WORLD);    
    switch(State.MainState) {                 /* Aktion je nach Zustandsvariable */
    case ST_DRAWBOX:      
    case ST_DRAWLINE:                        /* Menu Objekt->Linie gewhlt */
    case ST_DRAWCIRCLE:
      HandleRubberObject(Mpb.hps,                                /* PS und */
			 Mpb.hdcScreen,             /* DC fr Rubberaction */
			 ptl,                            /* Mauskoordinate */
			 INIT_RUBBER,                    /* Was ist zu tun */
                         &State.MainState);
      break;
      
    }                                             /* endswitch (MainState) */
    break;                                               /* WM_BUTTON1DOWN */
    
  case WM_BUTTON2DOWN:         /*------------------------------------------*/
    WinSetCapture(HWND_DESKTOP, NULLHANDLE);
    State.MainState = ST_SELECTION;      /* Operation abgebrochen, Standard Mode */
    WinSetPointer(HWND_DESKTOP,                             /* Pfeilzeiger */
		  WinQuerySysPointer(HWND_DESKTOP, 
				     SPTR_ARROW, 
				     FALSE));
    if (State.Selected_Segment) {
      SelectSegment(Mpb.hps, State.Selected_Segment,FALSE);
      State.Selected_Segment = 0;
      WinInvalidateRect(hwnd,NULL,FALSE);            /* und sichtbar machen*/
    }
    break;
  
  case WM_MOUSEMOVE:              /*---------------------------------------*/
    ptl.x = MOUSEMSG(&msg)->x;
    ptl.y = MOUSEMSG(&msg)->y;                   /* Mausposition ermitteln */
    GrConvert(Mpb.hps, Mpb.hdcScreen, 1L, &ptl,CVTC_DEVICE,CVTC_WORLD);

    switch (State.MainState) {                    /* Aktion je nach Zustandsvar. */
    case ST_DRAWLINE:
    case ST_DRAWBOX:
    case ST_DRAWCIRCLE:
    case ST_DRAWTEXT:                       /* Mauspointer auf Zeichenicon */
      WinSetPointer(HWND_DESKTOP,
		    Mpb.hptr);
      break;

    case ST_DRAWRUBBERBOX:
    case ST_DRAWRUBBERLINE:
    case ST_DRAWRUBBERCIRCLE:
      WinSetPointer(HWND_DESKTOP,
		    Mpb.hptr);
      HandleRubberObject(Mpb.hps, Mpb.hdcScreen, ptl, MOVE_RUBBER,&State.MainState);
      break;
      
    default:
      WinDefWindowProc(hwnd, msg,mp1,mp2);   /* bei SELECTION oder unknown */
      break;                                           /* wegen Mauszeiger */
    }                              /* endswitch Zustandsvariable MainState */
    break;                                         /* Ende msg = MOUSEMOVE */

  case WM_BUTTON1UP:
    ptl.x = MOUSEMSG(&msg)->x;
    ptl.y = MOUSEMSG(&msg)->y;                   /* Mausposition ermitteln */
    WinSetCapture(HWND_DESKTOP, NULLHANDLE);
    GrConvert(Mpb.hps, Mpb.hdcScreen, 1L, &ptl,CVTC_DEVICE,CVTC_WORLD);
    if (State.MainState & RUBBERMODE)  /* Rubber beenden und Endkoords ermitteln */
      pPtl = HandleRubberObject(Mpb.hps, 
				Mpb.hdcScreen, 
				ptl, 
				END_RUBBER,
				&State.MainState);
    else
      pPtl = &ptl;                            /* Sonst nur eine Koordinate */

    WinSetPointer(HWND_DESKTOP,                             /* Pfeilzeiger */
		  WinQuerySysPointer(HWND_DESKTOP,
				     SPTR_ARROW,
				     FALSE));
    
    if (State.MainState != ST_SELECTION) {
      if (!pPtl)   
	ShowErrorMsg("intern: Keine Koordinaten von RubberObjekt fr Draw!");
      else                               /* Ein passendes Segment erzeugen */
        CreateSegment(pPtl, State.MainState, ++State.Segment_Counter);		     
      State.MainState = ST_SELECTION;                 /* Operation beendet */
      WinInvalidateRect(hwnd,NULL,FALSE);            /* und sichtbar machen*/
    } 
    else {                                             /* Auswahl mit Maus */
      if (State.Selected_Segment) {
	SelectSegment(Mpb.hps, State.Selected_Segment,FALSE);
	State.Selected_Segment = 0;
      } /* endif */
      GpiSetPickApertureSize(Mpb.hps, PICKAP_DEFAULT, NULL);
      GrConvert(Mpb.hps, Mpb.hdcScreen, 1L, &ptl,CVTC_WORLD,CVTC_PAGE);
      lHits = GpiCorrelateChain(Mpb.hps,
				PICKSEL_VISIBLE,
				&ptl,       
				1,1,                    /* Immer nur einen */
				alSegTag);     /* Tag = Label = Segment-ID */
      /*-------- jetzt Segment hervorheben, als ausgewhlt Speichern ------*/
      if (lHits) {
        State.Selected_Segment = alSegTag[0];        /* Tag = Label = Segment-ID */
        SelectSegment(Mpb.hps, State.Selected_Segment, TRUE);
      } /* endif */

    } 
    break; /* Ende BUTTON1UP */
                                       
  default:                                       /* wenn keiner getroffen */
    return( WinDefWindowProc(hwnd,msg,mp1,mp2) );
    
  } /* switch (msg) zuende */
  return (MRESULT)NULL; 
} /* Ende MainWndProc */



/*---------------------------------------------------------------------*/
/* MainCommand: auswertung der Kommandomessages: Menpunkte            */
/*---------------------------------------------------------------------*/
VOID MainCommand(HWND hwnd,MPARAM mp1,MPARAM mp2)
{
  BOOL bResult = FALSE;
  POINTL ptl = {0,0};
  FIXED afxScale[2];
  RECTL rctl;
  MATRIXLF mArr;

  if (State.MainState) {                     /* d.h. nicht im SELECTION-Mode */
    DosBeep(800,100);
    return;                                          /* Men blockiert */
  }     
        
  switch(SHORT1FROMMP(mp1))  {                   /* Welches Kommando ? */
          
    
  case IDM_FILE_PRINT:                     /* Drucke aktu. Darstellung */
    MainPrint(hwnd);
    break; 
    
  case IDM_FILE_FONTS:
    ShowFontDialog(Mpb.hab, 
		   Mpb.hwndMainClient, 
		   WinGetScreenPS(HWND_DESKTOP),
		   NULLHANDLE,
		   &Mpb.fm,
		   &Mpb.usPtSize,
		   &bResult);
    break;
                             
  case IDM_FILE_EXIT:
    WinSendMsg(hwnd, WM_CLOSE, 0L, 0L);
    break;
    
  case IDM_OBJS_LINE:
    State.MainState = ST_DRAWLINE;
    break; 
    
  case IDM_OBJS_BOX:
    State.MainState = ST_DRAWBOX;
    break;
    
  case IDM_OBJS_CIRCLE:
    State.MainState = ST_DRAWCIRCLE;
    break;
    
  case IDM_OBJS_TEXT:
    State.MainState = ST_DRAWTEXT;
    break;
    
  case IDM_OBOPS_DEL:
    if (State.Selected_Segment)
      GpiDeleteSegment(Mpb.hps, State.Selected_Segment);
    State.Selected_Segment = 0L;
    WinInvalidateRect(hwnd,NULL,FALSE);             /* und sichtbar machen*/
    break;

  
  case IDM_TRNSFRMS_TRNSLT:
    if (!GpiAssociate(Mpb.hps, Mpb.hdcScreen)) {   
      PrimMessageBox("Fatal: Associate DCScreen hps failed.");
      return ;
    }
    if (State.Selected_Segment) {
      ptl.x = 1000; ptl.y = 2000;
      SetSegmentTranslation(Mpb.hps, State.Selected_Segment, ptl);
    }

    GpiAssociate(Mpb.hps, NULLHANDLE);
    WinInvalidateRect(hwnd,NULL,FALSE);
    break;
    
  case IDM_TRNSFRMS_ROT:
    /*-------------- zuerst Mittelpunkt bestimmtn ----------------- ---*/
    GpiSetDrawControl(Mpb.hps, DCTL_DISPLAY,DCTL_OFF);
    GpiSetDrawControl(Mpb.hps, DCTL_BOUNDARY,DCTL_ON);
    GpiDrawSegment(Mpb.hps, State.Selected_Segment);         /* neu zeichnen */
    GpiQueryBoundaryData(Mpb.hps, &rctl);
    GpiSetDrawControl(Mpb.hps, DCTL_DISPLAY,DCTL_ON);
    GpiSetDrawControl(Mpb.hps, DCTL_BOUNDARY,DCTL_OFF);
    
    
    if (!GpiAssociate(Mpb.hps, Mpb.hdcScreen)) {    /* fertig zum zeichnen */
      PrimMessageBox("Fatal: Associate DCScreen hps failed.");
      return ;
    }
    
    if (State.Selected_Segment) {
      ptl.x = (rctl.xRight + rctl.xLeft)/2;
      ptl.y = (rctl.yBottom + rctl.yTop)/2;
      SetSegmentRotation(Mpb.hps, MAKEFIXED(30,0), State.Selected_Segment, ptl);
    }
    
    GpiAssociate(Mpb.hps, NULLHANDLE);
    WinInvalidateRect(hwnd,NULL,FALSE);
    break;
    
  case IDM_TRNSFRMS_SCALE:
    if (!GpiAssociate(Mpb.hps, Mpb.hdcScreen)) { 
      PrimMessageBox("Fatal: Associate DCScreen hps failed.");
      return ;
    }
    if (State.Selected_Segment) {
      ptl.x = 0; ptl.y = 0;                         /* Aufpunkt Ursprung */
      afxScale[0] = MAKEFIXED(1,2*65536/10);
      afxScale[1] = MAKEFIXED(1,4*65536/10);
      SetSegmentScale(Mpb.hps,afxScale, State.Selected_Segment, ptl);
    }
    
    GpiAssociate(Mpb.hps, NULLHANDLE);
    
    WinInvalidateRect(hwnd,NULL,FALSE);
    break;
    
    
 case IDM_TRNSFRMS_SHEAR:
    if (!GpiAssociate(Mpb.hps, Mpb.hdcScreen)) {           
      PrimMessageBox("Fatal: Associate DCScreen hps failed.");
      return ;
    }
    if (State.Selected_Segment) {
      SetSegmentShear(Mpb.hps, State.Selected_Segment, 45.0, 30.0);
    }

    GpiAssociate(Mpb.hps, NULLHANDLE);            
    WinInvalidateRect(hwnd,NULL,FALSE);
    break;

 case IDM_DVT_ZOOM_IN:
      mArr.fxM11 = mArr.fxM22 = MAKEFIXED(1,3*65536/10);
      mArr.fxM21 = mArr.fxM12 = MAKEFIXED(0,0);
      mArr.lM13 = mArr.lM23 = 0;
      mArr.lM33 = 1;
      mArr.lM31 = mArr.lM32 = 0; 
      bResult = GpiSetDefaultViewMatrix(Mpb.hps, 9, &mArr, TRANSFORM_ADD);
      WinInvalidateRect(hwnd,NULL,FALSE);             /* und sichtbar machen*/
    break;

 case IDM_DVT_ZOOM_OUT:
      mArr.fxM11 = mArr.fxM22 = MAKEFIXED(0,10*65536/13);
      mArr.fxM21 = mArr.fxM12 = MAKEFIXED(0,0);
      mArr.lM13 = mArr.lM23 = 0;
      mArr.lM33 = 1;
      mArr.lM31 = mArr.lM32 = 0;
      bResult = GpiSetDefaultViewMatrix(Mpb.hps, 9, &mArr, TRANSFORM_ADD);
      WinInvalidateRect(hwnd,NULL,FALSE);             /* und sichtbar machen*/
  break;
    
  default:
    break;
  }/* Ende switch */
}  /* Ende MainCommand() */



/* ---------------------- Messagebox() --------------------------------*/
/* gibt Fehlermeldung mit in Resourcen definiertem Text aus            */
/*---------------------------------------------------------------------*/

ULONG MessageBox(HWND hwndOwner, ULONG idMsg, ULONG fsStyle, BOOL fBeep)
{
  CHAR szText[MESSAGELEN];          /* MESSAGELEN definiert in PMWIN.h */

  if (!WinLoadMessage(Mpb.hab,                  /* anchor block handle */
		      (HMODULE)NULL,     /* module handle, 0 = in .exe */
		      idMsg,                 /* Resource-ID of message */
		      MESSAGELEN,        /* length of recieving buffer */
		      (PSZ)szText))     /* buffer that recieve message */
    {
      WinAlarm(HWND_DESKTOP, WA_ERROR);
      return MBID_ERROR;              /* returnvalue von WinMessageBox */
    }

  if (fBeep)
    WinAlarm(HWND_DESKTOP, WA_ERROR);     /* einer von drei Alarmtnen */

  return(WinMessageBox(HWND_DESKTOP,                         /* Parent */
		       hwndOwner,                            /* Owner  */
		       szText,                          /* Text in box */
		       (PSZ)NULL,                  /* 'Error' as title */
		       0,    /*Box ID,passed to HK_HELP hook if WM_HELP*/
		       fsStyle));    /* Knpfe und Symboles der Msgbox */
}  /* End Messagebox */

void PrimMessageBox(char *text)
{
  WinMessageBox(HWND_DESKTOP,
		HWND_DESKTOP,
		text,
		(PSZ)NULL,
		0,
		MB_OK | MB_ERROR);
}
		


void ShowErrorMsg(char *text)
{
  PrimMessageBox(text);
  return;
}

