{ SmartCard-Terminalprogramm fr MacInterface mit 8031 aus c't 12/94 }
{ mit modifiziertem iodriver.asm von C.Meyer 8/94, Teile (C) KSC     }
{ tcycle=1.0851 us bei 11,059 MHz Takt, 27128 EPROM                  }
{ Da nur rund 60 Bytes RAM zur Verfgung stehen, wurde konsequent    }
{ auf lokale Variable verzichtet. Der verwendete KSC-Pascal-Compiler }
{ Version 4.19 legt leider auch lokale Variable dauerhaft und nicht  }
{ auf dem Stack ab. Ferner wird ein berschreiben benachbarter Bytes }
{ durch den Parser in Kauf genommen, wenn diese zur Laufzeit gerade  }
{ nicht verwendet werden. Vorsicht also bei eigenen Erweiterungen.   }

{ Erweiterungen gegenber der verffentlichten Version:              }
{ Stand-Alone-Betrieb mit P1.7 an Masse, Auftrennen der Verbindung   }
{ hlt die Anzeige an. Zeigt nun auch den Inhalt von Speicherkarten. }

{ m-Befehl akzeptiert nun die Angabe einer Basisadresse, zB. m 02    }
{ listet den Inhalt ab Adresse $0200 auf (nur bei "greren" Karten).}
{ r und w inkrementieren automatisch. s und d sind nicht mehr auf 8  }
{ Zeichen beschrnkt, sondern akzeptieren unbegrenzt lange Strings.  }
{ 10 ms Wartezeit nach jedem Zeichen fr die Programmierung sind     }
{ nach wie vor erforderlich! }

{ Befehle t und k geben den Inhalt von Telefon- und KV-Karten for-   }
{ matiert aus. Bei Speicherkarten ohne Versicherten-Template zeigt   }
{ k nur den Inhalt ab $30 als ASCII-File an. Beide Befehle haben     }
{ keine Parameter. }

program cardterm;

  const
    VersStr = 'c''t-CardTerminal (C) C.Meyer 9/94 V0.9';
    ProtStr = '  Protokoll: ';
    HexStr = '0123456789ABCDEF';
    BinStr = '01';

    ZWDStr = 'Siemens 2-Draht Bus ';
    DRDStr = 'Siemens 3-Draht Bus ';
    I2CStr = 'Philips I2C Bus ';
    TelStr = 'Telefonkarte ';
    unbStr = 'unbekannt, ';
    ATRStr = 'ATR = ';
    ValErrStr = 'Val Err';
    CmdErrStr = 'Cmd Err';

    high=true;
    low=false;
    dta=0;                 { ISO-I/O-Lines P1 }
    clk=1;
    rst=2;
    skt=4;                 { Schaltkontakt }
    switch=7;              { Betriebsart }
    CdOff=$F8;             { fr Kartenleseroutine }
    CdOn=$F1;
    CdI2Cidle=$F3;

    I2CreadC=$A1;
    I2CwriteC=$A0;
    ZWDreadC=$30;
    ZWDwriteC=$38;
    ZWDreadProtC=$34;
    ZWDwriteProtC=$3C;
    ZWDreadSecC=$31;
    ZWDwriteSecC=$39;
    ZWDcompvC=$3B;
    DRDreadC=$0E;
    DRDwriteC=$33;
    DRDwriteProtC=$30;

    NoATRC=$F;
    Tel0prtkC=0;
    Tel1prtkC=2;
    Tel2prtkC=4;
    I2CprtkC=$8;
    ZWDprtkC=$A;
    DRDprtkC=$9;

  var
    ptr:byte;
    cliBuf: packed array[0..6] of byte;   { fr Parser/CLI }
    dataBuf: packed array[0..3] of byte;  { fr fast alles }
    aInt:integer;
    device,count: byte;
    a,b,c,d,e,f,g,i,j,x,y: Byte;
    z: char;
    adrLo,adrHi,value: Byte;
    ISOprtk,ISOstruc,ISOsize,ISOlng: byte; { ATR = Kartenprotokoll }
    noCard,MonDisp,ErrCond: boolean;


{************************* Low-Level-Routinen ****************************}

  procedure wait(zehntelsec:integer);
  var
    countInt:Integer;
{ Zehntelsekunden abgestimmt auf 11,059 MHz Takt }
  begin
    for countInt:= 0 to zehntelsec*43 do
      for x:=0 to 253 do;
  end;

  procedure pwait;
{ 10 ms Programmierzeit fr EEPROM bei 11,059 MHz }
  begin
    for y:= 0 to 4 do
      for x:=0 to 255 do;
  end;

  procedure rwait;
{ Timing fr Lesen: Luxus-NOP, incl. Aufruf 10 us bei 11,059 MHz }
  begin
    y:=y;
    y:=y;
  end;

{************************* allgemeine Routinen ***************************}

  procedure SendStat(State:Boolean);
  begin
    if State then
      write(serial,'OK',char(13))
    else
      write(serial,'ERROR',char(13));
  end;

  function NumToHex (theByte: byte): string[2];
  begin
   NumToHex := '00';
   for x := 2 downto 1 do
     begin
       y := theByte and $F;
       theByte := theByte shr 4;
       NumToHex[x] := char(HexStr[y + 1]);
     end;
  end;

  function NumToBin (theByte: byte): string[4];
  begin
   NumToBin := '0000';
   for x := 4 downto 1 do
     begin
       y := theByte and 1;
       theByte := theByte shr 1;
       NumToBin[x] := char(BinStr[y + 1]);
     end;
  end;


{************************** I2C-Bus-Routinen *****************************}

  function sendbyteI2C (daten: Byte): boolean;
{ sendet Byte, liefert True, wenn bertragung erfolgreich }
  begin
    for x := 7 downto 0 do
      begin
        if ((daten shr x) and 1) = 1 then
          P1.dta:=high
        else
          P1.dta:=low;
        rwait;
        P1.clk:=high;
        rwait;
        P1.clk:=low;
        rwait;
      end;
{ Quittierungsbit lesen }
    P1.dta:=high;
    rwait;
    P1.clk:=high;
    rwait;
    sendByteI2C := not P1.dta;
    P1.clk:=low;
  end;

  procedure receiveByteI2C (var daten: Byte; letzte: boolean);
{ Empfngt ein Datenbyte ber den I2C-Bus }
{ daten:  empfangenes Datenbyte;  }
{ letzte: Flag ob dieses Byte das letzte ist. Wenn ja, }
{ dann invertiertes Quittungsbit senden }
{ Am Anfang mu SCL=L sein, am Schlu ist SCL=L }
  begin
    P1.dta:=high;
    daten := 0;
    P1.clk:=low;
    for x := 7 downto 0 do
      begin
        P1.clk:=high;
        rwait;
        daten := daten shl 1;
        if P1.dta then
          daten := succ(daten);
        P1.clk:=low;
        rwait;
      end;
{ Quittierungsbit senden }
    if letzte then
      P1.dta:=high
    else
      P1.dta:=low;
    rwait;
    P1.clk:=high;
    rwait;
    P1.clk:=low;
    rwait;
    P1.dta:=high;
  end;

  function SendI2C: boolean;
{ sendet kompletten Datenblock ber I2C-Datenbus. }
{ SendI2C: TRUE - alles OK, FALSE - Error }
  begin
    P1.dta:=low;            { Start I2C }
    rwait;
    P1.clk:=low;
    if not SendByteI2C(device) then
      begin
        sendI2C := False;
        P1.dta:=low;        { Stop I2C }
        rwait;
        P1.clk:=high;
        rwait;
        P1.dta:=high;
        exit;
      end;
    for y := 0 to count-1 do
      begin
        if not sendByteI2C(dataBuf[y]) then
          begin
            SendI2C := false;
            P1.dta:=low;        { Stop I2C }
            rwait;
            P1.clk:=high;
            rwait;
            P1.dta:=high;
            exit;
          end;
      end; { For }
    sendI2C := True;
    P1.dta:=low;            { Stop I2C }
    rwait;
    P1.clk:=high;
    rwait;
    P1.dta:=high;
  end;

  function receiveI2C: boolean;
{ Empfngt kompletten Datenblock ber I2C-Bus. }
{ addr:		I2C-Adresse fr Lesen }
{ cnt:	    Anzahl der zu empfangenden Datenbytes }
{ dataBuf:	empfangener Datenblock }
{ receiveI2C: TRUE - alles OK, FALSE - Error }
    var
      letzte: boolean;
  begin
    P1.dta:=low;            { Start I2C }
    rwait;
    P1.clk:=low;
{ Bausteinadresse schreiben }
    if sendbyteI2C(device) = false then
      begin
        receiveI2C := false;
        P1.dta:=low;        { Stop I2C }
        rwait;
        P1.clk:=high;
        rwait;
        P1.dta:=high;
        exit;     {Fehler}
      end;
    P1.dta:=high;           { fr lesen }
    letzte := false;
    for y := 0 to count-1 do
      begin
        if y = count-1 then
          letzte := true;
        receivebyteI2C(dataBuf[y], letzte);
      end;{for}
    receiveI2C := true; {alles ok}
    P1.dta:=low;        { Stop I2C }
    rwait;
    P1.clk:=high;
    rwait;
    P1.dta:=high;
  end;

  procedure I2CCmd(MemCmd:byte);
  begin
    P1:=CdI2Cidle;
    dataBuf[0]:=adrLo;
    dataBuf[1]:=value;
    case MemCmd of
      I2CwriteC:
{ Byte ber I2C schreiben: }
        begin
          count:=2;
{ obere Adressbits in Block Select einfgen }
          device:=I2CWriteC or (adrHi shl 1);
          ErrCond:=sendI2C;
          pwait;
        end;
      I2CreadC:
{ 4 Bytes ber I2C lesen: }
        begin
          count:=1;
          device:=I2CWriteC or (adrHi shl 1);
          ErrCond:=sendI2C;
          device:=I2CreadC or (adrHi shl 1);
          count:=4;
          if receiveI2C then;
        end;
      end;
  end;

{*********************** Zweidraht-Bus-Routinen **************************}

  procedure ZWDByteSend;
{ Byte in y senden }
  begin
    for x := 0 to 7 do
    begin
      P1.clk:=low;
      if (y and 1) = 1 then
        P1.dta:=high
      else
        P1.dta:=low;
      y:=y shr 1;
      P1.clk:=high;
    end;
  end;

  procedure ZWDByteRecv;
{ geliefertes Byte in y bergeben }
  begin
    y:=0;
    for x := 0 to 7 do
      begin
        P1.clk:=low;
        rwait;
        P1.clk:=high;
        y := y shr 1;
        if P1.dta then
          y:=y or $80;
      end;
  end;

  procedure ZWDCmd(MemCmd:byte);
{ Befehl, Adresse und Datenbyte ber Zweidraht-IF schreiben }
{ liefert 4 Datenbytes (0 bei Processing Mode) in dataBuf }
  begin
    P1.clk:=high;
    rwait;
    P1.dta:=low;
    rwait;
    y:=MemCmd;
    ZWDByteSend;
    y:=adrLo;
    ZWDByteSend;
    y:=value;
    ZWDByteSend;
    P1.clk:=low;
    P1.dta:=low;
    rwait;
    P1.clk:=high;
    rwait;
    P1.dta:=high;
    rwait;

    case MemCmd of
      ZWDwriteC, ZWDwriteProtC, ZWDwriteSecC, ZWDcompvC:
{ Warten auf "End of Processing" }
        repeat
          P1.clk:=low;
          rwait;
          P1.clk:=high;
          rwait;
        until P1.dta;
      ZWDreadC, ZWDreadProtC, ZWDreadSecC:
{ 4 Bytes in dataBuf ablegen }
        for j:=0 to 3 do
        begin
          ZWDByteRecv;
          dataBuf[j]:=y;
        end;
    end;
{ Abbrechen durch Reset }
    P1.clk:=low;
    rwait;
    P1.rst:=high;
    rwait;
    P1.rst:=low;
  end;

{*********************** Dreidraht-Bus-Routinen **************************}

  procedure CardReset;
  begin
    P1:=CdOn;
    rwait;
    P1.rst:=high;
    rwait;
    P1.clk:=high;
    rwait;
    P1.clk:=low;
    rwait;
    P1:=CdOn;
  end;

  procedure CardPOR;
  begin
    P1:=CdOff;
    pwait;
    CardReset;
  end;

  procedure DRDCmd(MemCmd:byte);
{ Befehl, Adresse und Datenbyte ber Dreidraht-IF schreiben }
{ liefert 4 Datenbytes (0 bei Processing Mode) in dataBuf }
  begin
    CardReset;
    rwait;
    P1.rst:=high;
{ obere zwei Adressbits in Command unterbringen, SLE4418 hat 1 KByte }
    y:=MemCmd or (adrHi shr 6);
    ZWDByteSend;
    y:=adrLo;
    ZWDByteSend;
    y:=value;
    ZWDByteSend;
    P1.clk:=low;
    rwait;
    P1.dta:=high;
    P1.rst:=low;

    case MemCmd of
      DRDwriteC, DRDwriteProtC:
{ Warten auf "End of Processing" mit 50 kHz Takt }
        for x:=0 to 202 do
          begin
            P1.clk:=low;
            rwait;
            P1.clk:=high;
          end;
      DRDreadC:
{ 4 Bytes in dataBuf ablegen }
        for j:=0 to 3 do
        begin
          ZWDByteRecv;
          dataBuf[j]:=y;
        end;
    end;
    P1.clk:=low;
  end;


{*********************** Telefonkarten-Routinen **************************}

  function TCdShiftNibble: byte;
{ Bits eines Nibble sammeln }
  begin
    x:= 0;
    for y := 0 to 3 do
      begin
        x:=x shr 1;
        if P1.dta then
          x:=x + 8;
        P1.clk := high;
        rwait;
        P1.clk := low;
        rwait;
      end;
    TCdShiftNibble:= x;
  end;

  function TCdShiftByte: byte;
{ Bits eines Byte sammeln }
  begin
    x:= 0;
    for y := 0 to 7 do
      begin
        x:=x shr 1;
        if P1.dta then
          x:=x + 128;
        P1.clk := high;
        rwait;
        P1.clk := low;
        rwait;
      end;
    TCdShiftByte:= x;
  end;

  function TCdAddByte: byte;
{ Bits eines Byte addieren, fr Gebhrenstand }
  begin
    x:=0;
    for y := 0 to 7 do
      begin
        if P1.dta then
          x:=x+1;
        P1.clk := high;
        rwait;
        P1.clk := low;
        rwait;
      end;
    TCdAddByte:=x;
  end;

  procedure TelCmd;
{ Schreiben: Bit in adrLo adressieren und mit value Pulsen brennen }
{ Lesen: nchste 4 Bytes in dataBuf zurckliefern. }
  begin
    CardReset;

    if value>0 then
{ Schreiben: Bit adressieren und 10ms-Pulse geben }
      begin
        if adrLo>0 then
          for j:= 1 to adrLo do
            begin
              P1.clk:=high;
              rwait;
              P1.clk:=low;
            end;
        for j:= 0 to value-1 do
          begin
            P1.rst:=high;
            rwait;
            P1.rst:=low;
            rwait;
            P1.clk:=high;
            pwait;
            P1.clk:=low;
            rwait;
          end;
      end
    else
{ Lesen: Byte adressieren }
      begin
        if adrLo>0 then
          for j:= 1 to adrLo*8 do
            begin
              P1.clk:=high;
              rwait;
              P1.clk:=low;
            end;
        for j:=0 to 3 do
          dataBuf[j]:=TcdShiftByte;
      end;
  end;


{*************** Karten-Initialisierung und ATR-Routinen *****************}

  function CardInit: boolean;
{ liefert TRUE wenn Karte steckt }
  begin
    CardInit:=(P1.skt=(not noCard));
    if P1.4=noCard then
      begin
        write(display,char(12),'Karte einsetzen!');
        for i:=0 to 150 do
        begin
          if P1.skt=(not noCard) then
            begin
              i:=150;
              CardInit:=true;
              write(display,char(12));
            end;
          wait(1);
        end;
      end;
  end;

  function CardExit: boolean;
{ liefert TRUE wenn Karte entnommen }
  begin
    P1:=CdOff;
    CardExit:=(P1.skt=noCard);
    if P1.4=(not noCard) then
      begin
        write(display,char(12),'Karte entnehmen!');
        for i:=0 to 50 do
        begin
          if P1.skt=noCard then
            begin
              i:=50;
              CardExit:=true;
            end;
          wait(1);
        end;
        write(display,char(12));
      end;
  end;


{************************* High-Level-Routinen ***************************}

  procedure AdrMon;
{ Adresse und Wert auf Display anzeigen }
  begin
    if monDisp then
      write(display,char(12),NumToHex(adrHi),NumToHex(adrLo),':');
  end;

  procedure ValMon;
{ Adresse und Wert auf Display anzeigen }
  begin
    if monDisp then
      begin
        write(display,char(13),char(9),char(9),char(9),char(9),char(9));
        write(display,NumToHex(value));
        if (value>31) and (value<127) then
          write(display,'="',char(value),'"')
        else
          write(display,'    ');
      end;
  end;

  procedure CardATRtoBuf;
{ rohen ATR einlesen }
  begin
    CardPOR;
    for j:=0 to 3 do
      begin
        i:=TCdShiftByte;
        dataBuf[j]:=i;
      end;
    P1:=CdOn;
  end;

  procedure SetISOparam;
{ ISO-Parameter nach ATR im Buffer setzen }
  begin
    ISOprtk:=dataBuf[0] shr 4;
    ISOstruc:=dataBuf[0] and 3;
    ISOsize:=(dataBuf[1] shr 3) and 7;
    d:=dataBuf[1] and 3;
    ISOlng:=1;
    ISOlng:=ISOlng shl d;
  end;

  procedure GetProtParams;
{ liest ATR, sofern vorhanden, und stellt Ruhezustand ein }
  begin
    CardATRtoBuf;
    SetISOparam;
    case ISOprtk of
      I2CprtkC:
        P1:=CdI2Cidle;
      ZWDprtkC:
        begin
          P1:=CdOn;
          rwait;
          P1.rst:=high;
          rwait;
          P1.rst:=low;
        end;
      DRDprtkC,Tel0PrtkC,Tel1PrtkC,Tel2PrtkC:
        CardPOR;
      else
{ ISO-Parameter dann eventuell in den ersten 4 Bytes des I2C-EEPROM }
        begin
          P1:=CdI2Cidle;
          adrLo:=0;
          adrHi:=0;
          value:=0;
          I2CCmd(I2CreadC);
          SetISOparam;
          if ISOprtk<>I2CprtkC then
            begin
              ISOprtk:=NoATRC;
              ISOstruc:=2;
              ISOsize:=2;
              ISOlng:=3;
            end;
        end;
    end;
    case ISOprtk of
    Tel0PrtkC,Tel1PrtkC,Tel2PrtkC:
      begin
        ISOsize:=1;
        ISOlng:=1;
      end;
    end;
    adrLo:=0;
    adrHi:=0;
  end;

  procedure WriteCard;
{ Beschreibt Kartenadresse in adrHi, adrLo mit value }
  begin
    AdrMon;
    ValMon;
    case ISOprtk of
      NoATRC, I2CprtkC:
        I2CCmd(I2CwriteC);
      Tel0PrtkC,Tel1prtkC,Tel2prtkC:
        TelCmd;
      ZWDprtkC:
        ZWDCmd(ZWDwriteC);
      DRDprtkC:
        DRDCmd(DRDwriteC);
    end;
    aInt:=adrHi*256+adrLo+1;
    adrHi:=aInt shr 8;
    adrLo:=aInt and $FF;
  end;

  procedure DispatchCard;
{ Lesezugriff auf zugehrige Routine verteilen }
  begin
    case ISOprtk of
      NoATRC, I2CprtkC:
        I2CCmd(I2CreadC);
      Tel0PrtkC,Tel1prtkC,Tel2prtkC:
        TelCmd;
      ZWDprtkC:
        ZWDCmd(ZWDreadC);
      DRDprtkC:
        DRDCmd(DRDreadC);
    end;
  end;

  procedure ReadCard;
{ Anzahl value Werte lesen und hexadezimal seriell ausgeben }
  begin
    AdrMon;
    if value<>0 then
      begin
        value:=value-1;
        f:=value div 4;
        g:=value mod 4;
        for e:=0 to f do
          begin
            value:=0;
            DispatchCard;
            if e = f then
              c:=g
            else
              c:=3;
            for d := 0 to c do
              begin
                AdrMon;
                aInt:=adrHi*256+adrLo+1;
                adrHi:=aInt shr 8;
                adrLo:=aInt and $FF;
                value:=dataBuf[d];
                ValMon;
                write(serial,NumToHex(value));
                if (d<c) or (e<f) then
                  write(serial,',');
              end;
          end;
      end
    else
      write(serial,'OK');
  end;

  procedure MemCdDisplay;
{ fr Stand-Alone-Betrieb: Kartendaten auslesen und anzeigen }
  begin
    aInt:=0;
    repeat
      write(display,char(13),NumToHex(Hi(aInt)),NumToHex(Lo(aInt)),': ');
      for f:=0 to 2 do
        begin
          value:=0;
          adrHi:=aInt shr 8;
          adrLo:=aInt and $FF;
          DispatchCard;
          for e:=0 to 3 do
            begin
              value:=dataBuf[e];
              if (value>31) and (value<127) then
                write(display,char(value))
              else
                write(display,'.');
            end;
          aInt:=adrHi*256+adrLo+4;
        end;
      aInt:=aInt-11;
      wait(2);
      repeat
      until P1.switch=low;
    until P1.skt=noCard;
  end;

  procedure GetTelCdData;
{ Telefonkarten-Nibbles in cliBuf eintragen und Restwert ermitteln }
  begin
    CardReset;
{ ATR und Fllbyte bergehen }
    for f:=1 to 3 do
      d:=TCdshiftByte;
{ Manufacturer Data }
    for f:=0 to 9 do
      cliBuf[f]:=TCdshiftNibble;
{ Rest-Gebhrenstand }
    d:=TCdAddByte shl 6;
    d:=d or TCdAddByte shl 3;
    d:=d or TCdAddByte;
    aInt:=d;
    aInt:=aInt shl 6;
    d:=TCdAddByte shl 3;
    d:=d or TCdAddByte;
    aInt:=aInt or d;
    P1:=CdOff;
{ Restwert in aInt }
  end;

  procedure TelCdAnalyze;
{ fr Stand-Alone-Betrieb: Telefonkartendaten analysieren und anzeigen }
  begin
    repeat
      GetTelCdData;
      if cliBuf[1]=5 then
        write(display,char(12),TelStr)
      else
        write(display,char(12),unbStr,'[',d,']');
      wait(15);
{ Anhalten, wenn Schalter bettigt }
      repeat
      until P1.switch=low;
      write(display,char(12),'von ');
      case cliBuf[0] of
        0:
          write(display,'Orga');
        1:
          write(display,'G&D');
        2:
          write(display,'ODS');
        3:
          write(display,'Gemplus');
        4:
          write(display,'Solaic');
        5:
          write(display,'Uniqa');
        6:
          write(display,'Schlumberger');
        else
          write(display,unbStr,'[',d,']');
      end;
      wait(15);
      repeat
      until P1.switch=low;
      write(display,char(12),'Datum ',cliBuf[4],'/9',cliBuf[3]);
      wait(15);
      repeat
      until P1.switch=low;
      write(display,char(12),'SerNr ');
      write(display,cliBuf[0]);
      write(display,cliBuf[3]);
      if cliBuf[4]<10 then
        write(display,'0');
      write(display,cliBuf[4]);
      for e:=9 downto 5 do
        write(display,cliBuf[e]);
      wait(15);
      repeat
      until P1.switch=low;
      write(display,char(12),'Nennwert ');
      case cliBuf[2] of
        3:
          write(display,'1,50 DM');
        4:
          write(display,'6 DM');
        5:
          write(display,'12 DM');
        6:
          write(display,'50 DM');
        else
          write(display,'[',cliBuf[1],']');
      end;
      wait(15);
      repeat
      until P1.switch=low;
      write(display,char(12),'Rest ');
      write(display,aInt div 100,',');
      if aInt mod 100 < 10 then
        write(display,'0');
      write(display,aInt mod 100,' DM');
      wait(15);
      repeat
      until P1.switch=low;
    until P1.skt=noCard;
  end;

  procedure TelCdSerAnalyze;
{ Telefonkartendaten analysieren und Daten seriell ausgeben }
  begin
    if CardInit then;
    CardATRtoBuf;
    write(serial,ATRStr);
    for j:=0 to 1 do
      write(Serial,NumToHex(dataBuf[j]));
    GetProtParams;
    GetTelCdData;
    if cliBuf[1]=5 then
      write(serial,char(13),TelStr)
    else
      write(serial,char(13),'Keine ',TelStr,'[',d,']');
    write(serial,char(13),'Hersteller: ');
    case cliBuf[0] of
      0:
        write(serial,'Orga Kartensysteme');
      1:
        write(serial,'Giesecke & Devrient');
      2:
        write(serial,'Oldenbourg Daten Systeme');
      3:
        write(serial,'Gemplus');
      4:
        write(serial,'Solaic');
      5:
        write(serial,'Uniqa');
      6:
        write(serial,'Schlumberger');
      else
        write(serial,unbStr,'[',d,']');
    end;
    write(serial,char(13),'Herstellungsdatum: ',cliBuf[4],'/9',cliBuf[3]);
    write(serial,char(13),'Seriennummer: ');
    write(serial,cliBuf[0]);
    write(serial,cliBuf[3]);
    if cliBuf[4]<10 then
      write(serial,'0');
    write(serial,cliBuf[4]);
    for e:=9 downto 5 do
      write(serial,cliBuf[e]);
    write(serial,char(13),'Nennwert: ');
    case cliBuf[2] of
      3:
        write(serial,'1,50 DM');
      4:
        write(serial,'6 DM');
      5:
        write(serial,'12 DM');
      6:
        write(serial,'50 DM');
      else
        write(serial,'[',cliBuf[1],']');
    end;
    write(serial,char(13),'Restguthaben: ');
    write(serial,aInt div 100,',');
    if aInt mod 100 < 10 then
      write(serial,'0');
    write(serial,aInt mod 100,' DM', char(13));
  end;

  procedure KVKSerAnalyze;
{ Daten der KVK nach Tags scannen und seriell ausgeben }
  begin
    if CardInit then;
    GetProtParams;
    adrHi:=0;
    adrLo:=$1E;
    DispatchCard;
    if dataBuf[0]=$60 then
       write(serial,'Versichertendaten-Template');
    if dataBuf[1]>$80 then
      c:=dataBuf[1]-128+32
        else
      c:=32;
    for adrLo:= c to $FF do
      begin
        value:=1;
        DispatchCard;
        z:=char(dataBuf[0]);
        case byte(z) of
        $5B:
          write(serial,'');
        $5C:
          write(serial,'');
        $5D:
          write(serial,'');
        $7B:
          write(serial,'');
        $7C:
          write(serial,'');
        $7D:
          write(serial,'');
        $7E:
          write(serial,'');
        else
          if (byte(z)<$80) and (byte(z)>31) then
            write(serial,z);
        end;
        case byte(z) of
        $80:
          write(serial,char(13),'Krankenkassen-Name: ');
        $81:
          write(serial,char(13),'Krankenkassen-Nummer: ');
        $8F:
          write(serial,char(13),'VKNR: ');
        $82:
          write(serial,char(13),'Versicherten-Nummer: ');
        $83:
          write(serial,char(13),'Versicherten-Status: ');
        $90:
          write(serial,char(13),'Status-Ergnzung: ');
        $84:
          write(serial,char(13),'Titel: ');
        $85:
          write(serial,char(13),'Vorname: ');
        $86:
          write(serial,char(13),'Namenszusatz: ');
        $87:
          write(serial,char(13),'Familienname: ');
        $88:
          write(serial,char(13),'Geburtsdatum: ');
        $89:
          write(serial,char(13),'Strae: ');
        $8A:
          write(serial,char(13),'Lnder-Code: ');
        $8B:
          write(serial,char(13),'Postleitzahl: ');
        $8C:
          write(serial,char(13),'Ort: ');
        $8D:
          write(serial,char(13),'Gltigkeit: ');
        $8E:
          begin
            write(serial,char(13),'Prfsumme');
            adrLo:=$FF;
          end;
        end;
      end;
    write(serial,char(13));
  end;

  procedure HexMon;
  begin
    f:=AdrHi;
    if CardInit then;
    CardATRtoBuf;
    write(serial,ATRStr);
    for j:=0 to 3 do
      write(serial,NumToHex(dataBuf[j]));
    GetProtParams;
    AdrHi:=f;
    case ISOprtk of
    Tel0PrtkC,Tel1PrtkC,Tel2PrtkC:   { Telefonkarte? }
      begin
        write(serial,char(13),TelStr,'bitseriell',char(13));
        CardReset;      { ATR mitlesen }
        write(serial,'Bit:     7654 3210',char(13));
        for j:=0 to 17 do
          write(serial,'-');
        for f:= 0 to 15 do
          begin
            write(serial,char(13));
            e:=TCdShiftByte;
            write(serial,NumToHex(f*8),': ');
            write(serial,NumToHex(e),' = ',NumToBin(e shr 4),'');
            write(serial,NumToBin(e and $F));
          end;
      end
    else
      begin
        case ISOprtk of
          I2CprtkC:
            write(serial,char(13),I2CStr);
          ZWDprtkC:
            write(serial,char(13),ZWDStr);
          DRDprtkC:
            write(serial,char(13),DRDStr);
          else
            write(serial,char(13),unbStr,I2Cstr,'benutzt');
        end;
        write(serial,char(13),'Basisadresse: ',NumToHex(adrHi),'00',char(13));
        write(serial,'Byte:0 ');
        for j:=1 to 15 do
          write(serial,NumToHex(j),' ');
        write(serial,'   ASCII',char(13));
        for j:=0 to 70 do
          write(serial,'-');
        for f:= 0 to 15 do
          begin
            write(serial,char(13),NumToHex(f*16),': ');
            for e:=0 to 15 do
              begin
                adrLo:= f*16+e;
                value:=0;
                DispatchCard;
                d:=dataBuf[0];
                write(serial, NumToHex(d),' ');
              end;
            write(serial,'   ');
            for e:=0 to 15 do
              begin
                adrLo:= f*16+e;
                value:=0;
                DispatchCard;
                d:=dataBuf[0];
                if (d>31) and (d<128) then
                  write(serial,char(d))
                else
                  write(serial,'.');
              end;
            end;
        end;
    end;
    write(serial,char(13));
  end;

  procedure BufEval;
{ Simpel-Parser: Hexzahlen im Buffer umwandeln in Adressen }
{ zulssige Eingaben: }
{ ABCD,EF  adrHi=AB, adrLo=CD, value=EF }
{ CD,EF    adrHi=0,  adrLo=CD, value=EF }
{ ABCD     adrHi=AB, adrLo=CD, value=0  }
{ EF       value=EF                     }

    function BufHex: byte;
    begin
      y:=cliBuf[ptr];
      if y>$60 then        { a..f }
        y:=y-39;
      if y>$40 then        { A..F }
        y:=y-7;
      y:=y-$30;            { 0..9 }
      If y>15 then
        ErrCond:=true
      else
        BufHex:=y;
    end;

  begin
    ptr:=2;
    if cliBuf[4]<>13 then
      begin
        if cliBuf[4]<>byte(',') then
          begin
            adrHi:=16*BufHex;
            inc(ptr);
            adrHi:=adrHi+BufHex;
            inc(ptr);
          end
        else
          adrHi:=0;
        adrLo:=16*BufHex;
        inc(ptr);
        adrLo:=adrLo+BufHex;
        inc(ptr);
      end;
    if cliBuf[ptr]=13 then
      value:=0
    else
      begin
        if cliBuf[ptr]=byte(',') then
          inc(ptr);
        value:=16*BufHex;
        inc(ptr);
        value:=value+BufHex;
        inc(ptr);
      end;
    if cliBuf[ptr]<>13 then
      ErrCond:=true;
    case ptr of
      4,6,7,9:;
    else
      ErrCond:=true;
    end;
    if ErrCond then
      begin
        adrLo:=0;
        adrHi:=0;
        value:=0;
      end;
  end;


{*************************** Hauptschleife *******************************}

begin
  reset(serial);
  reset(display);
  IE:=0;
  write(display,char(12),versStr,chr(13));
  TH1:=250;              { 9600 bit/s }

  write(serial,char(12),versStr,char(13));
  monDisp:=false;
  noCard:=P1.skt;        { Schaltkontakt Ruhestellung }
  P1:=CdOff;
  if P1.switch then
    repeat
      for y:=0 to 9 do
        cliBuf[y]:=0;
      write(serial,'>');
      for ptr:= 0 to 19 do
        begin
          read(serial,z);
          cliBuf[ptr]:=byte(z);
          case char(cliBuf[0]) of
          'D','d':
{ direkt ins Display schreiben }
          if ptr>1 then
            begin
              write(display,z);
              ptr:=2;
            end;
          'S','s':
{ direkt ins EEPROM schreiben }
            if (ptr>1) and (z<>char(13)) then
              begin
                value:=byte(z);
                writeCard;           { erhht adrLo, adrHi }
                ptr:=2;
              end;
          else                       { Backspace? }
            if (z=char(8)) and (ptr>0) then
              ptr:=ptr-2;
          end;                       { Abschlieen mit Return }
          if z=char(13) then
            ptr:=99;
        end;
      case char(cliBuf[0]) of
        'W','w':
{ Wert in Karte schreiben }
          begin
            ErrCond:=false;
            BufEval;
            if ErrCond then
              write(serial,ValErrStr,char(13))
            else
              begin
                writeCard;
                sendStat(true);
              end;
          end;
        'R','r':
{ Wert(e) aus Karte lesen }
          begin
            ErrCond:=false;
            BufEval;
            if ErrCond then
              write(serial,ValErrStr)
            else
              begin
                readCard;
              end;
            write(serial,char(13));
          end;
        'P','p':
{ Parameter (ATR) setzen }
          begin
            ErrCond:=not(cliBuf[6]=13);
            BufEval;
            if ErrCond then
              write(serial,ValErrStr,char(13))
            else
              begin
                dataBuf[1]:=value;
                dataBuf[0]:=adrLo;
                setISOparam;
              end;
            if monDisp then
              begin
                write(display,char(12),ATRStr,NumToHex(adrHi),NumToHex(adrLo));
              end;
          end;
        'A','a':
{ ATR ausgeben }
          begin
            GetProtParams;
            if monDisp then
              write(display,char(12),ATRStr);
            for j:=0 to 3 do
              begin
                if monDisp then
                  write(display,NumToHex(dataBuf[j]));
                write(serial,NumToHex(dataBuf[j]));
                if j<3 then
                  write(serial,',');
              end;
            write(serial,char(13));
          end;
        'M','m':
{ Hexdump }
          begin
            ErrCond:=false;
            if cliBuf[1] <> 13 then
              begin
                BufEval;
                if ErrCond then
                  write(serial,ValErrStr,char(13))
                else
                  adrHi:=value;
              end
            else
              adrHi:=0;
            if not ErrCond then
              HexMon;
          end;
        'T','t':
{ Telefonkarte auslesen und Daten in Klartext ausgeben }
          begin
            TelCdSerAnalyze;
          end;
        'K','k':
{ KV-Karte auslesen und Daten in Klartext ausgeben }
          begin
            KVKSerAnalyze;
          end;
        'I','i':
{ "Karte einsetzen" }
          begin
            SendStat(CardInit);
          end;
        'O','o':
{ "Karte entnehmen" }
          begin
            SendStat(CardExit);
          end;
        'D','d','S','s':
{ schon oben behandelt }
          begin
            SendStat(true);
          end;
        'B','b':
{ Monitor on/off }
          begin
            ErrCond:=false;
            BufEval;
            if ErrCond then
              write(serial,ValErrStr,char(13))
            else
              if value=1 then
                begin
                  monDisp:=true;
                  write(display,char(12),'Monitor on');
                end
              else
                begin
                  monDisp:=false;
                  write(display,char(12));
                end;
          end;
        char(13):
          begin
          end;
        else
          begin
            write(serial,CmdErrStr,char(13));
          end;
      end;
    until false
  else
{ Stand-Alone-Betrieb }
    repeat
      wait(10);
      if CardInit then
        begin
          CardATRtoBuf;
          write(display,char(12),ATRStr);
          for j:=0 to 3 do
            write(display,NumToHex(dataBuf[j]));
          GetProtParams;
          wait(15);
          repeat
            case ISOprtk of
              Tel0PrtkC,Tel1prtkC,Tel2prtkC:
                begin
                  TelCdAnalyze;
                end;
              NoATRC, I2CprtkC:
                begin
                  write(display,char(12),I2CStr);
                  wait(15);
                  MemCdDisplay;
                end;
              ZWDprtkC:
                begin
                  write(display,char(12),ZWDStr);
                  wait(15);
                  MemCdDisplay;
                end;
              DRDprtkC:
                begin
                  write(display,char(12),DRDStr);
                  wait(15);
                  MemCdDisplay;
                end;
            end;
            P1:=CdOff;
          until CardExit;
        end;
    until false;
end.
