{$S-,R-,Q-,I-}
(* Autoren: Karsten Strobel und Achim Olbrich, Augsburg *)
(* Heap-Ueberwachung fuer Borland Pascal fuer Windows *)
(* Karsten Strobel und Achim Olbrich, Augsburg        *)
(* erfordert zusaetzlich Modifikation der RTL         *)
(* c't 12/94 / Borland Pascal fuer Windows            *)
(* Karsten Strobel: FIDONET  2:2480/300.7             *)

Unit HeapDebW;

interface

{$IFNDEF WINDOWS} diese Version von HEAPDEB laeuft nur unter Windows {$ENDIF}
{$C FIXED PRELOAD PERMANENT}

implementation

uses WinProcs, WinTypes;

type
  PPointerMap = ^TPointerMap;
  TPointerMap = record
    P: pointer;
    Nr: word;
    Size: Word;
    Next: PPointerMap;
  end;

const
  PtrMap: PPointerMap = nil;
  PtrCount: longint = 0;
  TotalPtrCount: longint = 0;
  ExitProcEntered: Boolean = false;

  HeapDebId : record
    IdStr : array [1..4] of char;
    MapProcPtr,
    UnmapProcPtr : pointer;
  end = (IdStr:'HDeb';MapProcPtr:nil;UnmapProcPtr:nil);

{---------------------------------------------------------------------------}
procedure MapProc(P: pointer; Size: Word); far;
var
  APtrMap: PPointerMap;
const
  Recurse : Boolean = false;
begin
  if Recurse or (Size = 0) or ExitProcEntered then Exit;
  inc (PtrCount);
  inc (TotalPtrCount);
  Recurse := true;
  new (APtrMap);
  Recurse := false;
  if not Assigned(APtrMap) then RunError(203);
  APtrMap^.P := P;
  APtrMap^.Nr := TotalPtrCount;
  APtrMap^.Size := Size ;
  APtrMap^.Next := PtrMap;
  PtrMap := APtrMap;
end;

procedure UnmapProc(P: pointer; Size: Word); far;
var
  APtrMap, Prev: PPointerMap;
const
  Recurse : Boolean = false;
begin
  if Recurse or (Size = 0) or ExitProcEntered then Exit;
  Prev := nil;
  APtrMap := PtrMap;
  while (APtrMap <> nil) and (APtrMap^.P <> P) do
  begin
    Prev := APtrMap;
    APtrMap := APtrMap^.Next;
  end;

  if Assigned(APtrMap) then
  begin
    Dec (APtrMap^.Size, Size);
    if APtrMap^.Size = 0 then
    begin
      if Prev <> nil then Prev^.Next := APtrMap^.Next;
      if PtrMap = APtrMap then PtrMap := APtrMap^.Next;
      Recurse := true;
      dispose(APtrMap);
      Recurse := false;
      dec(PtrCount);
    end
    else RunError(204);
  end
  else RunError(204);
end;

{---------------------------------------------------------------------------}
var
  OldExitProc: pointer;

procedure LocalExitProc; far;
type
  PtrRec = record
     Ofs, Seg: Word;
  end;
var
  A: array[0..3] of longint;
  S: array [0..100] of char;
  APtrMap: PPointerMap;
  L: LongInt;
  I: Integer;

begin
  ExitProc := OldExitProc;
  ExitProcEntered := true;
  if ExitCode <> 0 then
  begin
    A[0] := ExitCode;
    if ErrorAddr = nil then
      wvsprintf(S, 'Programm wurde mit HALT(%lu) abgebrochen', A)
    else
    begin
      A[1] := PtrRec(ErrorAddr).Seg;
      A[2] := PtrRec(ErrorAddr).Ofs;
      wvsprintf(S, 'Laufzeitfehler %03lu bei %04lx:%04lx', A);
      ErrorAddr := nil;
    end;
    MessageBox(0, S, 'ACHTUNG', MB_OK);
    exit;
  end;

  A[0] := TotalPtrCount;
  A[1] := PtrCount;
  wvsprintf(S, '%lu Pointer wurden insgesamt verwaltet,'#13#10'%lu Pointer zuwenig freigegeben'#13#10'auflisten ?', A);
  I := MessageBox(0, S, 'ACHTUNG', MB_YESNO);

  APtrMap := PtrMap;
  while (I = IDYES) and Assigned (APtrMap) do
    with APtrMap^ do
    begin
      A[0] := Nr;
      A[1] := PtrRec(P).Seg;
      A[2] := PtrRec(P).Ofs;
      A[3] := Size;
      wvsprintf(S, 'Lfd.Nr.: %lu, Ptr.: %04lx:%04lx, Blockgre: %lu'#13#10'weiter ?', A);
      I := MessageBox(0, S, 'ACHTUNG', MB_YESNO);
      APtrMap := Next;
    end;
end;

var
  P : pointer;

begin
{$IFOPT D+}
  OldExitProc := ExitProc;
  ExitProc := @LocalExitProc;

  HeapDebID.MapProcPtr   := @MapProc;
  HeapDebID.UnmapProcPtr := @UnmapProc;
  P := @HeapDebID;
  FreeMem (P, 0); {dieser Aufruf gibt die beiden User-Routinen bekannt}
{$ENDIF}
end.
