/* --- gpi_paint.c: alles fr Grafikausgabe ----------*/


#define INCL_PM
#define INCL_GPILCIDS
#include <os2.h>

#include <string.h>
#include <math.h>

#include "gpi.h"
#include "pm_print.h"
#include "pm_fonts.h"
#include "pm_cgrs.h"
#include "gpi_main.h"

extern MainParamBlock Mpb;        /* Mpb wird bentigt fr Handles u. Font */



/*---------------------------------------------------------------------------*/
/* PrimCirc zeichnet einfachen Kreis mit aktuellem Linienstil und aktueller  */
/* Linienfarbe mit Mittelpunkt bei pCenter, der den Punkt pBorder berhrt    */
/*---------------------------------------------------------------------------*/
VOID PrimCirc(HPS hps, POINTL pCenter, POINTL pBorder)
{
   ARCPARAMS ArcP;

        ArcP.lR = -pBorder.y + pCenter.y;
        ArcP.lQ = pBorder.x - pCenter.x;
        ArcP.lP =  pBorder.x - pCenter.x;
        ArcP.lS = pBorder.y - pCenter.y;
        GpiSetArcParams(hps,&ArcP);

        GpiMove(hps, &pCenter);                         /* zum Mittelpunkt */
        GpiFullArc(hps, DRO_OUTLINE,
                   MAKEFIXED(1,0));                  /* Kreis mit Faktor 1 */
}


/*-------------------------------------------------------------------------*/
/* zeichnet Kreis als Path                                                 */
/* verwendet PrimCirc                                                      */
/*-------------------------------------------------------------------------*/
VOID DrawCircle(HPS hps, POINTL pCenter, POINTL pBorder, long SC)
{
  GpiSetLineWidthGeom(hps, 40);                    /* 3/10 mm Linienstrke */
  GpiSetLineJoin(hps, LINEJOIN_ROUND);                       /* Ecken rund */

  GpiBeginPath(hps, 1L);                                    /* Path ffnen */
  GpiLabel(hps,SC);                             /* Farbe kommt im nchsten */
  GpiSetColor(hps, CLR_BLACK);                             /* Farbe setzen */
  PrimCirc(hps, pCenter, pBorder);
  GpiEndPath(hps);                                       /* path schlieen */
  GpiStrokePath(hps,1L,0L);                           /* und path zeichnen */
}

/*- -----------------------------------------------------------------------*/
/* zeichnet Linie als Path !                                               */
/*-------------------------------------------------------------------------*/
VOID DrawLine(HPS hps, POINTL ptlA, POINTL ptlB, long SC)
{
  GpiSetLineWidthGeom(hps, 40);                    /* 3/10 mm Linienstrke */
  GpiSetLineJoin(hps, LINEJOIN_ROUND);                       /* Ecken rund */

  GpiBeginPath(hps, 1L);                                    /* Path ffnen */
  GpiLabel(hps,SC);                             /* Farbe kommt im nchsten */
  GpiSetColor(hps, CLR_BLACK);                             /* Farbe setzen */
  GpiMove(hps, &ptlA);                                     /* Anfangspunkt */
  GpiLine(hps, &ptlB);
  GpiEndPath(hps);                                       /* path schlieen */
  GpiStrokePath(hps,1L,0L);                           /* und path zeichnen */
}



VOID DrawBox(HPS hps, POINTL ptlA, POINTL ptlB, long SC)
{

  GpiSetLineWidthGeom(hps, 100);                    /* 3/10 mm Linienstrke */

  GpiSetLineJoin(hps, LINEJOIN_ROUND);                       /* Ecken rund */
  GpiLabel(hps,SC);                             /* Farbe kommt im nchsten */
  GpiSetColor(hps, CLR_BLACK);                             /* Farbe setzen */


  GpiBeginPath(hps, 1L);                                    /* Path ffnen */
  GpiMove(hps, &ptlA);
  GpiBox(hps, DRO_OUTLINE, &ptlB, 300L, 300L);         /* gerundete Kanten */
  GpiEndPath(hps);                                       /* path schlieen */
  GpiStrokePath(hps,1L,0L);                           /* und path zeichnen */

  GpiSetPattern(hps, 2L);
  GpiBeginPath(hps, 1L);                                    /* Path ffnen */
  GpiLabel(hps,SC);                             /* Farbe kommt im nchsten */
  GpiMove(hps, &ptlA);
  GpiBox(hps, DRO_OUTLINE, &ptlB, 300L, 300L);         /* gerundete Kanten */
  GpiEndPath(hps);                                       /* path schlieen */
  GpiFillPath(hps,1L,FPATH_ALTERNATE);                           /* und path zeichnen */
}



/**********************************************************/
/* Gibt den Text 'Gpi' aus                                */
/* Setzt aktuellen Font, geht von HIMETRIC aus!!!         */
/**********************************************************/
VOID DrawText(HPS hps, POINTL ptl, long SC)
{

  long lLcid=0;
  BOOL fRet = FALSE;
  SIZEF  sizfxCharBox;

  lLcid = CreateOutlineFont(hps,Mpb.fm.szFacename,(PSTR8)"FONT01");
  fRet = GpiSetCharSet(hps, lLcid);
  sizfxCharBox.cx = 
    MAKEFIXED((int)(Mpb.usPtSize*3.5277),0);           /* nur HIMETRIC !! */
  sizfxCharBox.cy = MAKEFIXED((int)(Mpb.usPtSize*3.5277),0);
  
  if (fRet)
    fRet = GpiSetCharBox(hps, &sizfxCharBox);
  
  GpiLabel(hps,SC);
  GpiSetColor(hps,CLR_BLACK);
  PMText(ptl.x, ptl.y, "GPI", T_LEFT, T_LOWER, hps);
}




/*-------------------------------------------------------------------------*/
/* Verwaltung eines Rubberobjekts:                                         */
/* bentigte Daten: Startpunkt, alter Punkt, neuer Punkt                   */
/*    werden in static-POINTL-Array gespeichert                            */
/*                                                                         */
/* ntige Operationen:                                                     */
/*       - Initialsierung: Start- und aktueller Punkt auf den              */
/*         gleichen Wert setzen, es braucht nichts gezeichnet zu werden    */
/*         Das Programm mu aus dem einfachen Zeichenmode in den Rubbermode*/
/*         versetzt werden.                                                */
/*         bei BUTTON1DOWN
/*       - Ein Schritt: alte Linie lschen, neue Linie zeichnen, aktuellen */
/*         Punkt updaten bei MOUSEMOVE&Rubbermode                          */
/*       - Beenden: Linie lschen, nichts zeichnen,                        */
/*         Programm zurck in Zeichenmode, damit BUTTON1UP das Grafikobjekt*/
/*         zeichnen kann, hierzu mssen die beiden Punkte an Aufrufer zurck*/
/*         gegeben werden BUTTON1UP                                        */
/*       - es ist zu beachten, da keine neue Ini erlaubt ist, wenn sich   */
/*         das Programm bereits im Rubbermode befindet                     */
/*         Im normalfall sollten zwar die Messages immer in der richtigen  */
/*         Reihenfolge von der Maus kommen, aber im Prinzip knnte auch    */
/*         falsche Message gepostet oder gesendet werden                   */
/*         Daher erscheint es sinnvoll, einen Kommandoparameter einzufhren*/
/* hat Zugriff auf globale Variable MainState                              */
/*-------------------------------------------------------------------------*/
POINTL *HandleRubberObject(HPS hps, HDC hdcScreen, POINTL ptl,
			   unsigned RubCommand, unsigned long *State)
{
  static POINTL aptlRubPts[2];                    /* akt. Rubberpositionen */

  switch (RubCommand) {

  case INIT_RUBBER:
    if ((*State) & (unsigned long) RUBBERMODE) {    /* schon im Rubbermode */
#ifdef _DEBUG
      ShowErrorMsg("Rubbermode im Rubbermode Sartversuch!");
#endif
      return NULL;                                    /* keine Op. mglich */
    }
    aptlRubPts[0] = aptlRubPts[1] = ptl;                   /* Punkte init. */
    (*State) |= RUBBERMODE;                               /* Mode anpassen */
    return aptlRubPts;                                     /* alles ok.    */

  case MOVE_RUBBER:                     /*---------------------------------*/
    if (!((*State) & RUBBERMODE)) {                  /* nur zur Sicherheit */
#ifdef _DEBUG
      ShowErrorMsg("Fatal:MOVE_RUBBER ohne Rubbermode!");
#endif
      return NULL;                               /* sollte nicht passieren */
    }
    
    if (!GpiAssociate(hps, hdcScreen)) {            /* fertig zum zeichnen */
      PrimMessageBox("Fatal: Associate DCScreen hps failed.");
      return NULL;
    }
    GpiSetColor(hps, CLR_GREEN);
    GpiSetMix(hps, FM_XOR);                           /* XOR wegen lschen */

    switch((*State)) {                             /* Zeichnen je nach Obj.*/
    case ST_DRAWRUBBERLINE:     
      GpiMove(hps, aptlRubPts);
      GpiLine(hps, aptlRubPts+1);                               /* lschen */
      aptlRubPts[1] = ptl;                                /* Punkt updaten */
      GpiMove(hps, aptlRubPts);                                /* zeichnen */
      GpiLine(hps, aptlRubPts+1);
      break;                                        /* Ende DRAWRUBBERLINE */

    case ST_DRAWRUBBERBOX:
    case ST_DRAWRUBBERBITMAP:
      GpiMove(hps, aptlRubPts);
      GpiBox(hps, DRO_OUTLINE, aptlRubPts+1, 0L, 0L);           /* lschen */
      aptlRubPts[1] = ptl;                                /* Punkt updaten */
      GpiMove(hps, aptlRubPts);                                /* zeichnen */
      GpiBox(hps, DRO_OUTLINE, aptlRubPts+1, 0L, 0L);
      break;

    case ST_DRAWRUBBERCIRCLE:
      PrimCirc(hps, aptlRubPts[0], aptlRubPts[1]);
      aptlRubPts[1] = ptl;                                 /* Punkt updaten */
      PrimCirc(hps, aptlRubPts[0], aptlRubPts[1]);
      break;
    } /* endswitch */

    GpiSetMix(hps, FM_OVERPAINT);                        /* PS/DC aufrumen */
    if (!GpiAssociate(hps, NULLHANDLE)) {
      PrimMessageBox("Fatal: DisAssociate DCScreen hps failed.");
      return NULL;
    }
    return aptlRubPts;                                     /* Punkte zurck */

  case END_RUBBER:           /*---------------------------------------------*/
    if (!((*State) & RUBBERMODE))                     /* nur zur Sicherheit */
      return NULL;                                /* sollte nicht passieren */
    (*State) &= ~RUBBERMODE;                            /* Rub-Bit lschen */
    return aptlRubPts;
  }                                         
  ShowErrorMsg("Fatal: unbekanntes Kommando in HandleRubberObjekt.");
  return NULL;
} /* endfunction HandleRubberObject() */


/***************************************************************************/
/* Funktionen fr die Transformationen                                     */
/***************************************************************************/


BOOL SetSegmentTranslation(HPS hps, LONG lSegId, POINTL ptlTrans)
{
   MATRIXLF matlTFM;

   GpiTranslate(hps,
                &matlTFM,
                TRANSFORM_REPLACE,
                &ptlTrans);
   return 
     GpiSetSegmentTransformMatrix(hps, lSegId, 9, &matlTFM, TRANSFORM_ADD);
} /* endfunction SetSegmentTranslation */


BOOL SetSegmentScale(HPS hps, FIXED afxScale[2], LONG lSegId, POINTL ptlRoot)
{
   MATRIXLF matlTFM;

   GpiScale(hps,
            &matlTFM,
            TRANSFORM_REPLACE,
            afxScale,
            &ptlRoot);

   return 
     GpiSetSegmentTransformMatrix(hps, lSegId, 9, &matlTFM, TRANSFORM_ADD);
}


BOOL SetSegmentShear(HPS hps, long lSegId, double lfAngleHor, 
		     double lfAngleVer)
{
  MATRIXLF matlTFM = {MAKEFIXED(1,0), MAKEFIXED(0,0), 0L, 
		      MAKEFIXED(0,0), MAKEFIXED(1,0), 0L,
		      0L, 0L, 1L};
  unsigned h1, h2;

  lfAngleHor = tan(lfAngleHor*3.1415927/180.0);
  lfAngleVer = tan(lfAngleVer*3.1415927/180.0);

  h1 = (unsigned ) floor(lfAngleHor);          /* ganzzahliger Anteil */
  h2 = (unsigned ) ((lfAngleHor-floor(lfAngleHor))*65536.0);  /* Rest */
  matlTFM.fxM21 = MAKEFIXED(h1,h2);
 
  h1 = (unsigned ) floor(lfAngleVer);          /* ganzzahliger Anteil */
  h2 = (unsigned ) ((lfAngleVer-floor(lfAngleVer))*65536.0);  /* Rest */
  matlTFM.fxM12 = MAKEFIXED(h1,h2);
 
  return 
    GpiSetSegmentTransformMatrix(hps, lSegId, 9, &matlTFM, TRANSFORM_ADD);
}


/*----------------------------------------------------------------------*/
/* ptl ist der Aufpunkt, soll zum Beispiel das Objekt um seinen         */
/* Schwerpunkt gedreht werden, so mssen dessen Koordinaten angegeben   */
/* werden.                                                              */
/*----------------------------------------------------------------------*/
BOOL SetSegmentRotation(HPS hps, FIXED fxAngle, LONG lSegId, POINTL ptl)
{
   MATRIXLF matlTFM;
 
   GpiRotate(hps,
                       &matlTFM,                 /* Fr Ergebnis */
                       TRANSFORM_REPLACE,        /* Matrix neu erzeugen */
                       fxAngle,                  /* wieviel Drehen */
                       &ptl);                    /* Aufpunkt */
   return GpiSetSegmentTransformMatrix(hps, 
				       lSegId,
				       9, 
				       &matlTFM, 
				       TRANSFORM_ADD);
}
 



/*-------------------------------------------------------------------------*/
/* GrConvert() rechnet Koordinaten um mit Assoziation                      */
/* Parameter:                                                              */
/*             hps         - PS mit gesetzten Einheiten                    */
/*             hdc         - DC, von dem Quellkoords stammen               */
/*             lPtlNum     - Anzahl der zu transformierenden Punkte        */
/*             pPtl        - Zeiger auf ein POINTL-Array mit den Punkten   */
/*             Source,Target- CVTC-Konstanten                              */
/* Rckgabe:                                                               */
/*             0 - Fehler; 1 - Alles o.k.                                  */
/*-------------------------------------------------------------------------*/
int GrConvert(HPS hps, HDC hdc, long lPtlNum, POINTL *pPtl, LONG Source, LONG Target)
{
  LONG lMode;

  if (hps == NULLHANDLE) {
    PrimMessageBox("Fatal NULL-hps in ConvertDevice2World.");
    return 0;
  }

  if (!GpiAssociate(hps, hdc)) {
    PrimMessageBox("Fatal: Associate ConvertDevice2World PS-DC failed.");
    return 0;
  }
 
  if ((lMode = GpiQueryDrawingMode(hps)) == DM_RETAIN) /* nach PM Ref. */
    GpiSetDrawingMode(hps, DM_DRAW);    /* nicht im Retain sein fr    */
                                       
  GpiConvert(hps,                      /* in Weltkoordinaten umrechnen */
	     Source,
	     Target,
	     lPtlNum,
	     pPtl);
  
  GpiSetDrawingMode(hps, lMode);                       /* zurcksetzen */

  if (!GpiAssociate(Mpb.hps, NULLHANDLE)) {
    PrimMessageBox("Fatal: DisAssociate ConvertDev2World failed.");
    return 0;
  }
  return 1;
}   /*-------------endfunction  GrConvert() ---------------*/





/****************************************************************************/
/* MainPaint: ausgelst durch Anforderung Neuzeichnen                       */
/*            des Client-Window                                             */
/****************************************************************************/
VOID MainPaint(HWND hwnd)
{
  RECTL rclUpdate,rcl;         /* Aufzufrischendes Rechteck */
  HPS hps = Mpb.hps;
  BOOL fRet = FALSE;


  WinQueryUpdateRect(hwnd, &rclUpdate); /* zu repar. Rect erfragen */

  GpiQueryDefViewingLimits(hps, &rcl);
  GpiSetDefViewingLimits(hps, &Mpb.rclDVL);
  
  if (!GpiAssociate(Mpb.hps, Mpb.hdcScreen)) 
     PrimMessageBox("Fatal: Associate DCScreen hps failed.");

  WinFillRect(hps, &rclUpdate, SYSCLR_DIALOGBACKGROUND);  

  GpiSetDefViewingLimits(hps, &rcl);
  fRet = GpiResetPS(Mpb.hps, GRES_ATTRS);
                                               /* !!! Device-Koordinaten */
    fRet = GpiDrawChain(Mpb.hps);

   GpiAssociate(Mpb.hps, NULLHANDLE);                     /* Disassoziieren */ 
   WinValidateRect(hwnd, &rclUpdate, FALSE);    /* Fenster gueltig erklren */
} /* endfunction DrawLine */



/****************************************************************************/
/* MainPrint: ausgelst durch Druckanforderung fr das Client-Window        */
/****************************************************************************/
unsigned long MainPrint(HWND hwnd)
{
  HAB hab;
  HDC hdc;
  LONG lLength = 0L;
  BOOL fRet=FALSE, fRetA=FALSE;
  char DocName[40]="GPI-Druckjob";
  USHORT usJobId;
  ERRORID eid;
    
  hab = WinQueryAnchorBlock(hwnd);

  hdc = OpenDefaultPrinter(hab,TRUE);
         
  if (hdc == DEV_ERROR)
    PrimMessageBox("Konnte Standarddrucker nicht ffnen !");

  lLength = 0L;
  if ( hdc != DEV_ERROR)             /* Sende Startsequenz */
    fRet = DevEscape(hdc,
		     DEVESC_STARTDOC,
		     (LONG )(strlen(DocName)+1),
		     DocName,
		     &lLength,
		     NULL) == DEV_OK;


  fRetA = GpiAssociate(Mpb.hps, hdc); /* Mit Drucker assoziieren */
  if (!fRetA)
    PrimMessageBox(" Assoziation mit Drucker fehlgeschlagen ");

  fRetA = GpiDrawChain(Mpb.hps);
  if (!fRetA) {
      eid = WinGetLastError(Mpb.hab);
  }

  fRetA = GpiAssociate(Mpb.hps,NULLHANDLE);
  if (!fRetA)
    PrimMessageBox(" Disassoziation vom Drucker fehlgeschlagen ");
  lLength = 2L;
  if (fRet)
    fRet = DevEscape(hdc,
		     DEVESC_ENDDOC,
		     0L,
		     NULL,
		     &lLength,
		     (PBYTE)&usJobId) == DEV_OK;
  if (!fRet)
    PrimMessageBox("Drucker Endsequenz nicht akzeptiert");

  /*------------------- noch PS, Dokument und hdc schlieen ------------*/
  if (hdc != DEV_ERROR) 
    if (!CloseDefaultPrinter(hdc)) {
      PrimMessageBox("Konnte Standarddrucker nicht schlieen !");
      fRet = fRet && FALSE;
    }
  return fRet && fRetA;
}

                  












