Program UseDLL;
{ Datei  : UseDLL.PAS
  Autoren: Gemkow, Doering, Woog
  Datum  : 10.09.94              }
{$A+,B-,D-,F+,G+,I+,L-,N+,P-,Q-,R-,S+,T-,V+,X+,Y-}

{ Demonstrationsprogramm fuer die Nutzung von C-DLLs
  unter Windows und DPMI. Es veranschaulicht den
  Austausch von Parametern und deren Uminterpretierung
  zwischen den Sprachen. Speziell die Verarbeitung
  von Double-Werten aus dem PASCAL-Teil in der C-DLL
  wird behandelt. Unter DPMI kommt dabei mit DUMMY87.DLL
  ein Ersatz fuer die WIN87EM.DLL zum Einsatz, weil das
  Windows-Orginal zu Konflikten fuehrt.                  }

{$IFDEF MSDOS}
  Nicht fuer den Realmode compilierbar!
{$ENDIF}

{$IFDEF Windows}
  {$M 8192,8192}
  Uses WinCrt, uSample, Strings, WinAPI;
{$ELSE}
  {$M 16384,0}
  Uses Crt, uSample, Strings, WinAPI;
{$ENDIF}

Const
  A: tDArr5 = (0.0, 1.1, 2.2, 3.3, 4.4);

Procedure WriteResult(d: Double; bValid: Boolean);
{ Callback-Prozedur, die der DLL-Funktion UniFunc ueber-
  geben wird. Die C-Funktion schreibt damit den jeweils 
  berechneten Wert aus. Konnte keine Berechnung durchge-
  fuehrt werden, ist der Parameter bValid=False. In 
  diesem Fall erscheint eine entsprechende Meldung.     }
Var
  wDllDS: Word;
Begin
  Asm
    Mov wDllDS, DS
    Mov AX, Seg @Data
    Mov DS, AX
  End;
  If bValid
  Then WriteLn(d)
  Else WriteLn('nicht berechnet');
  Asm
    Mov DS, wDllDS
  End;
End;

Var
  iY,i    : Integer;
  dX, dY  : Double;
  szA, szB: Array [0..15] Of Char;
  psz     : pChar;
  sr      : tSampleRec;
  ad      : tDArr5;

Begin
  WriteLn('Das Beste aus beiden Welten');
  WriteLn('===========================');
  WriteLn;
  WriteLn;
  WriteLn('Integer-Addition');
  WriteLn('----------------');
  WriteLn('a= 1    b= 2');
  WriteLn('y= a+ b');
  iY:= AddInteger(1, 2);                   { aus der DLL }
  WriteLn('y= ', iY);
  WriteLn;
  WriteLn('Weiter mit [ENTER].');
  ReadKey;
  WriteLn;
  WriteLn;
  WriteLn('Stringoperation: Append');
  WriteLn('-----------------------');
  WriteLn('StringA=''Hallo ''');
  WriteLn('StringB=''Welt.''');
  StrCopy(@szA, 'Hallo ');
  StrCopy(@szB, 'Welt.');
  psz:= AppendString(@szA, @szB);          { aus der DLL }
  WriteLn('Die Verkettung liefert: ', psz);
  WriteLn;
  WriteLn('Weiter mit [ENTER].');
  ReadKey;
  WriteLn;
  WriteLn;
  WriteLn('Mathematische Funktionen');
  WriteLn('------------------------');
  WriteLn('x= 0.5');
  dX:= 0.5;
  Write('x^2    : ');
  UniFunc(dX, 0, WriteResult);             { aus der DLL }
  Write('sqrt(x): ');
  UniFunc(dX, 1, WriteResult);             { aus der DLL }
  Write('sin(x) : ');
  UniFunc(dX, 2, WriteResult);             { aus der DLL }
  Write('ln(x)  : ');
  UniFunc(dX, 3, WriteResult);             { aus der DLL }
  WriteLn;
  WriteLn('Weiter mit [ENTER].');
  ReadKey;
  WriteLn;
  WriteLn;
  WriteLn('Polynomberechnung');
  WriteLn('-----------------');
  WriteLn('x= 1.0');
  WriteLn('y= 4.4*x^4+ 3.3*x^3+ 2.2*x^2+ 1.1*x^1+ 0.0');
  dX:= 1.0;
  dY:= EvalPoly(4, @A, dX);                { aus der DLL }
  WriteLn('y=', dY);
  WriteLn;
  WriteLn('Weiter mit [ENTER].');
  ReadKey;
  WriteLn;
  WriteLn;
  WriteLn('DLL fuellt einen Record');
  WriteLn('-----------------------');
  sr.pad:= @ad;
  sr.cd := 5;      { ad kann fuenf Doublewerte aufnehmen }
  GetRecord(@sr);                          { aus der DLL }
  WriteLn('Die DLL hat folgende Werte eingetragen:');
  WriteLn('  i      = ', sr.i);
  WriteLn('  d      =', sr.d);
  For i:=0 To 4 Do
    WriteLn('  pad^[',i,']=', sr.pad^[i]);
  WriteLn('  sz     = ', sr.sz);
  WriteLn;
  WriteLn('Weiter mit [ENTER].');
  ReadKey;
{$IFDEF Windows}
  DoneWinCrt;
{$ENDIF}
End.
