/* mkcf.c
 * erzeugt aus einer Datei eine Hufigkeitstabelle
 * Aufruf  : mkcf [-v] [-Einheit] Dateiname
 * Optionen: v       gibt eine ausfuehrliche Version der Tabelle aus
 *           Einheit Zahl der Zeichen, auf die sich die Angaben beziehen
 *                   Standard ist 100 d.h. alle Angaben pro 100 Zeichen
 *
 * Der Output laesst sich direkt im C-Quelltext verwenden, etwa so:
 *
 * static long cf_table = {
 * #include "mkcf.out"
 * };
 *
 * wenn mkcf.out die Datei ist, in die die Ausgabe umgelenkt wurde.
 *
 * (C) Guido Gronek, Januar 1995
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

float N=0.0, freq[256];
int verbose = 0;

#define MAXLINE       50    /* max. Zeilenlaenge */


int main(int  argc, char *argv[])
{
  int c,i;
  long l, TP = 0, P;
  long einheit = 100;
  char einhstr[12] = "100";
  float *fp;
  char *filename, *optp;
  FILE *file;

  if ( argc<2 ) {
usage:
    fprintf(stderr,"Aufruf: %s [-v] [-Einheit] Dateiname\n",argv[0]);
    fprintf(stderr,"Optionen:  v      : Ausfhrliche Darstellung\n");
    fprintf(stderr,"           Einheit: Pro <Einheit> Zeichen\n");
    exit(1); }
  c = 1;
  while ( *argv[c] == '-' ) {
    optp = argv[c]+1;
    if ( isdigit(*optp) ) {   /* Einheit */
      if ( (einheit = atol(optp)) ==0 || argc<3 )
        goto usage;
      strcpy(einhstr,optp);
    }
    else if ( *optp == 'v' )  /* Verbose ein */
      verbose = 1;
    else
      goto usage;
  ++c; }

  for ( i=0, fp = freq; i<=255; ++i)
    *fp++ = 0.0;

  filename = argv[c];

  if ( (file=fopen(filename,"rb")) ==0 ) {
    fprintf(stderr,"%s: Kann Datei %s nicht oeffnen.\n",argv[0],argv[c]);
    exit(2); }

  while ( (c = getc(file)) != EOF ) {
    freq[c] += 1.0;
    N += 1.0; }

  printf("/*** Dies ist ein Output vom Programm mkcf.       ***/ \n");
  if ( verbose ) {
    printf("/*%-12s%-12s%s%s*/\n","Zeichen","Gesamt","Pro",einhstr);
    for ( i=0; i<256; ++i) {
      l = (long)freq[i];
      printf( (isprint(i) || (i>=129 && i<=154)) ?
      "/*%-3c         " : "/*%-3d         " ,i );
      TP += (P = (long)(freq[i] * einheit / N));
      printf("%-12ld*/%-12ld",l,P);
      if ( i<255 ) printf (",");
      printf("\n");
    }
    printf("/*%-12s%-12ld  %ld*/","Total",(long)N,TP);
  }
  else {                              /* compact output */
    static char buf[100];

    char *bufptr;
    printf(" *** Zeichenhaeufigkeit im Text %s pro %s Zeichen ***/ \n",
             filename,einhstr);
    printf(" ***/\n");
    bufptr = buf;

    for ( i=0; i<256; ++i) {
      P = (long)(freq[i] * einheit / N);
      ltoa(P,bufptr,10);
      while (*bufptr) ++bufptr;
      if ( i<255) { *bufptr++ = ','; *bufptr = 0; }

      if ( (int)(bufptr - buf) >= MAXLINE )  {
        printf ("%s\n",buf);
        bufptr = buf; }
    }

    if ( bufptr > buf )
      printf("%s",buf);
  }
  return 0;
}











