#include <AppleEvents.h>
#include "globals.h"
#include "util.h"
#include "io.h"
#include "addr.h"

/* Dialogelemente im Adressenfenster */
#define kAddrNewItem    1 /* Neu */
#define kAddrEditItem   2 /* ndern */
#define kAddrDeleteItem 3 /* Lschen */
#define kAddrListItem   4 /* die Liste */

#define kAddrSize sizeof (addrRecord)

DialogPtr   addrDialog; /* Dialog mit der Liste */
ListHandle  addrList; /* die Liste */
Rect        addrListRect; /* Rechteck des Listenfeldes im Dialog */
RgnHandle   addrListRegion; /* Region mit eben diesem Rechteck */
short       addrAllocated; /* max. Zahl Adressen */
short       addrUsed; /* so viele Adressen in Gebrauch */
addrRecord  **addrBuffer; /* Handle auf die Adressen im Speicher */
Boolean     addrIsActive; /* Ist das Fenster aktiv? */
UserItemUPP addrListProc; /* Update-Funktion fr die Liste */

/* Dialogfenster laden und die Liste vorbereiten */
void addrInit(void) {
	Handle dItem;
	Rect   dataBounds;
	Point  cSize;
	short  dType;
	short  i;
	short  len;
	Ptr	   theData;
	
	addrBuffer =  (addrRecord **) NewHandleClear (5 * kAddrSize);
	if (addrBuffer == nil)
		errorHandler (kNotEnoughMemory, true);
	HLock ((Handle) addrBuffer);
	addrAllocated = 5; /* zunchst fnf Eintrge reservieren */
	addrUsed = 0; /* noch keine Eintrge belegt */
	ioLoadAddresses (addrBuffer, &addrUsed, &addrAllocated);
	setupDialog (kAddressDialog, &addrDialog); /* Dialog laden */
	GetDialogItem (addrDialog, kAddrListItem, &dType, &dItem,
	            &addrListRect); /* Daten des Listenelements holen */
	addrListProc = NewUserItemProc (&addrListUpdate);
	SetDialogItem (addrDialog, kAddrListItem, dType,
	 (Handle) addrListProc, &addrListRect); /* Prozedur einhngen */
	SetRect (&dataBounds, 0, 0, 1, 0); /* Anzahl der Spalten */
	SetPt (&cSize, 0, 0);
	addrList = LNew (&addrListRect, &dataBounds, cSize, 0,
	             (WindowPtr) addrDialog, false, false, false, true);
	if (addrList == nil)
		errorHandler (kNotEnoughMemory, true);
	HLock ((Handle) addrList);
	SetRect (&addrListRect,addrListRect.left-1,addrListRect.top-1,
	                   addrListRect.right+16,addrListRect.bottom+1);
	InvalRect (&addrListRect); /* Update-Event anfordern */
	if (nil == (addrListRegion = NewRgn ()))
		errorHandler (kNotEnoughMemory, true);
	RectRgn (addrListRegion, &addrListRect);
	(*addrList)->selFlags = lOnlyOne | lNoRect;
	for (i=0; i<addrUsed; i++) { /* Eintrge in die Liste bringen */
		LAddRow (1, i+1, addrList);
		SetPt (&cSize, 0, i); /* diese Zelle soll gendert werden */
		len = (*addrBuffer)[i].aName[0]; /* Lnge des Namens */
		theData = (Ptr) &(*addrBuffer)[i].aName[1];	/* Name */
		LSetCell (theData, len, cSize, addrList);
	} /* for */
	LDoDraw (true, addrList);
	HUnlock ((Handle) addrBuffer);
	addrIsActive = false;
} /* addrInit */

/* Mens angepassen, je nachdem, ob das Fenster vorne ist */
void addrAdjustMenus (void) {
	MenuHandle addrMenu;

	addrMenu = GetMHandle (kAddrMenu);
	if (FrontWindow () == addrDialog) { /* Adressenfenster vorne? */
		EnableItem (addrMenu, kAdMNewAddr);
		if (addrListSelected () >= 0) { /* Eintrag ausgewhlt? */
			EnableItem (addrMenu, kAdMEditAddr);
			EnableItem (addrMenu, kAdMDeleteAddr);
			EnableItem (addrMenu, kAdMMerge);
		} /* if */
		else {
			DisableItem (addrMenu, kAdMEditAddr);
			DisableItem (addrMenu, kAdMDeleteAddr);
			DisableItem (addrMenu, kAdMMerge);
		} /* else */	
	} /* if */
	else {
		DisableItem (addrMenu, kAdMNewAddr);
		DisableItem (addrMenu, kAdMEditAddr);
		DisableItem (addrMenu, kAdMDeleteAddr);
		DisableItem (addrMenu, kAdMMerge);
	} /* else */
} /* addrAdjustMenus */

/* eine neue Adresse in die Liste und das Array aufnehmen */
void addrAdd (addrRecord theAddr) {
	short len, i;
	Ptr   theData;
	short index;
	Point cSize;
	
	/* zuerst die Adresse in die Datenstruktur aufnehmen */
	if (addrUsed == addrAllocated) { /* reservierter Speicher voll */
		SetHandleSize ((Handle) addrBuffer, /* nachfordern */
		                          (addrAllocated + 10) * kAddrSize);
		if (MemError () != noErr) {
			errorHandler (kNotEnoughMemory, false);
			return;
		} /* if */
		addrAllocated = addrAllocated + 10;
	} /* if */
	HLock ((Handle) addrBuffer);
	/* den Namen alphabetisch einfgen */
	index = addrUsed;
	for (i=0; i < addrUsed; i++)
		if (IUCompString((*addrBuffer)[i].aName,theAddr.aName)==1 ) {
				BlockMoveData (&(*addrBuffer)[i],
				   &(*addrBuffer)[i+1], kAddrSize * (addrUsed - i));
				index = i; /* An dieser Stelle fgen wir ein! */
				break; /* Schleife beenden */
			} /* if */
	(*addrBuffer)[index] = theAddr;
	HUnlock ((Handle) addrBuffer);
	addrUsed++;	/* eine Adresse mehr */
	len = theAddr.aName[0]; /* Lnge des Namens */
	theData = (Ptr) &theAddr.aName[1]; /* Pointer auf den Namen */
	LAddRow (1, index, addrList); /* Zeile einfgen */
	SetPt (&cSize, 0, index);
	LSetCell (theData, len, cSize, addrList); /* Name -> Zeile */	
} /* addrAdd */

/* einen Eintrag aus Liste und Array entfernen */
void addrDelete (short theEntry) {
	LDelRow (1, theEntry, addrList);
	if (theEntry < addrUsed) { /* Nicht der letzte Eintrag? */
		HLock ((Handle) addrBuffer);	
		BlockMoveData (&(*addrBuffer)[theEntry+1],
		    &(*addrBuffer)[theEntry],(addrUsed-theEntry)*kAddrSize);
		HUnlock ((Handle) addrBuffer);
	} /* if */
	addrUsed--;	/* jetzt eine Adresse weniger */
} /* addrDelete */

/* Welches Listenelement ist angeklickt? -1, wenn nichts gewhlt */
short addrListSelected (void) {
	short result;
	Cell  start;
	
	result = -1;
	SetPt (&start, 0, 0); /* oben anfangen zu suchen */
	if (LGetSelect (true, &start, addrList)) /* ausgewhlt? */
		result = start.v;
	return result;
} /* addrListSelected */

/* ein Men wurde ausgewhlt oder ein Dialogelement angeklickt */
void addrDoMenu (short theItem) {
	short      result, entry, len, index;
	addrRecord temp;
	char       scrapData [kAddrSize];
	char       cr = 13; /* ASCII: Return */
	
	switch (theItem) {
		case kAdMNewAddr: /* neue Adresse anlegen */
			temp.aName[0] = 0; /* mit leeren Strings vorbelegen */
			temp.aCity[0] = 0;
			temp.aStreet[0] = 0;
			temp.aPhone[0] = 0;
			result = addrEditAddress (&temp);
			if (result == 1) /* Benutzer hat auf OK geklickt */
				addrAdd (temp);
			break;
		case kAdMEditAddr: /* Adresse bearbeiten */
			entry = addrListSelected ();
			HLock ((Handle) addrBuffer);
			temp = (*addrBuffer)[entry];
			HUnlock ((Handle) addrBuffer);
			result = addrEditAddress (&temp);
			if (result == 1) {
				addrDelete (entry); /* alten Eintrag lschen */
				addrAdd (temp); /* neuen Eintrag einfgen */
			} /* if */
			break;
		case kAdMDeleteAddr: /* Adresse lschen */
			entry = addrListSelected (); /* Hier immer >= 0! */
		    HLock ((Handle) addrBuffer);
		    ParamText((*addrBuffer)[entry].aName,"\p","\p","\p");
			HUnlock ((Handle) addrBuffer);
			result = StopAlert (kDeleteAlert, nil);
			if (result == 2) /* Wirklich lschen ! */
				addrDelete (entry);
			break;
		case kAdMMerge: /* gesamte Adresse zur Zwischenablage */
			entry = addrListSelected ();
			HLock ((Handle) addrBuffer);
			temp = (*addrBuffer)[entry];
			ZeroScrap (); /* Zwischenablage lschen */
			index = 0;
			len = temp.aName [0]; /* Namen bernehmen */
			BlockMoveData (&temp.aName[1], &scrapData[index], len);
			index = index + len + 1;
			BlockMoveData (&cr, &scrapData[index - 1], 1);
			/* Zeilenumbruch */
			len = temp.aStreet [0];	/* Strae bernehmen */
			BlockMoveData (&temp.aStreet[1],&scrapData[index],len);
			index = index + len + 1;
			BlockMoveData (&cr, &scrapData[index - 1], 1);
			len = temp.aCity [0]; /* Stadt bernehmen */
			BlockMoveData (&temp.aCity[1], &scrapData[index], len);
			index = index + len + 1;
			BlockMoveData (&cr, &scrapData[index - 1], 1);
			len = temp.aPhone [0]; /* Telefonnummer bernehmen */
			BlockMoveData (&temp.aPhone[1], &scrapData[index], len);
			index = index + len + 1;
			BlockMoveData (&cr, &scrapData[index - 1], 1);
			PutScrap(index,'TEXT',scrapData); /* ->Zwischenablage */
			HUnlock ((Handle) addrBuffer);
			break;
		default:
			break;
	} /* switch */
} /* addrDoMenu */

/* ein TextEdit-Feld des Dialoges mit Text vorbelegen */
void addrSetText (DialogPtr theDialog, short item, Str255 theText) {
	short  iType;
	Rect   itemRect;
	Handle iHandle;
	
	GetDialogItem (theDialog, item, &iType, &iHandle, &itemRect);
	SetDialogItemText (iHandle, theText);
} /* addrSetText */

/* Text aus einem TextEdit-Feld des Dialoges lesen */
void addrGetText (DialogPtr theDialog, short item, Str255 theText) {
	short  iType;
	Rect   itemRect;
	Handle iHandle;
	
	GetDialogItem (theDialog, item, &iType, &iHandle, &itemRect);
	GetDialogItemText (iHandle, theText);
} /* addrGetText */

/* Adresse bearbeiten */
short addrEditAddress (addrRecord *theAddr) {
	DialogPtr editDialog;
	short     itemHit;
	OSErr     myErr;
	
	setupDialog (kEditAddrDialog, &editDialog);
	myErr = SetDialogDefaultItem (editDialog, 1);
	myErr = SetDialogCancelItem (editDialog, 2);
	myErr = SetDialogTracksCursor (editDialog, true);
	addrSetText (editDialog, 4, theAddr->aName);
	addrSetText (editDialog, 6, theAddr->aStreet);
	addrSetText (editDialog, 8, theAddr->aCity);
	addrSetText (editDialog, 10, theAddr->aPhone);
	while (ModalDialog (NIL, &itemHit), itemHit > 2) {}
	if (itemHit == 1) { /* Benutzer hat OK angeklickt */
		addrGetText (editDialog, 4, theAddr->aName);
		addrGetText (editDialog, 6, theAddr->aStreet);
		addrGetText (editDialog, 8, theAddr->aCity);
		addrGetText (editDialog, 10, theAddr->aPhone);
	} /* if */
	DisposeDialog (editDialog);
	InitCursor ();
	return itemHit;
} /* addrEditAddress */

/* Liste nach Update-Event aktualisieren */
pascal void addrListUpdate (DialogPtr theDialog, short theItem) {
	GrafPtr oldPort;
	
	GetPort (&oldPort);
    SetPort (theDialog);
	FrameRect (&addrListRect); /* Rahmen um das Feld */
	LUpdate (addrListRegion, addrList);
	SetPort (oldPort);
} /* addrListUpdate */

void addrHandleItemHit (short theItem) {
	addrDoMenu (theItem); /* Nummern fr Men und Buttons gleich! */
} /* addrHandleItemHit */

/*ein Button des Dialoges wird aktiviert oder deaktiviert */
void enableDialogItem (DialogPtr theDialog, short theItem,
                                                 Boolean isActive) {
	Rect   itemRect;
	Handle dItem;
	short  dType;
	
	GetDialogItem (theDialog, theItem, &dType, &dItem, &itemRect);
	HiliteControl ((ControlHandle) dItem, isActive ? 0 : 255);
} /* enableDialogItem */

/* alle Events prfen und gegebenenfalls selbst verarbeiten */
void addrEventDispatch (EventRecord *theEvent) {
	Boolean oneSelected, doActivate;
	Point   where;

	if (FrontWindow () == addrDialog) { /* Unser Dialog vorne? */
		SetPort (addrDialog); /* unser Grafport */
		if (theEvent->what == mouseDown) {
			where = theEvent->where; /* Wo war der Klick? */
			GlobalToLocal (&where); /* in lokale Koordinaten */
			LClick (where, theEvent->modifiers, addrList);
		} /* if */
		if ((theEvent->what == updateEvt) &&
		              ((DialogPtr) theEvent->message == addrDialog))
			addrListUpdate (addrDialog, kAddrListItem);
		oneSelected = (addrListSelected () >= 0) ? true : false;
		enableDialogItem (addrDialog, kAddrEditItem, oneSelected);
		enableDialogItem (addrDialog, kAddrDeleteItem, oneSelected);
	} /* if */
	doActivate = (isInFront ()) && (FrontWindow () == addrDialog);
	if (doActivate != addrIsActive) { /* ndert sich der Zustand? */
		LActivate (doActivate, addrList); /* an List-Manager */
		addrIsActive = doActivate;
	} /* if */
} /* addrEventDispatch */

/* Adressen sichern */
void addrClose (void) {
	DisposeDialog (addrDialog); /* Dialogfenster schlieen */
	HLock ((Handle) addrBuffer);
	ioSaveAddresses (*addrBuffer,addrUsed); /* Adressen speichern */
	HUnlock ((Handle) addrBuffer);
} /* addrClose */