#include <processes.h>
#include "util.h"
#include "globals.h"

long gStartTime; /* fr doAbout */

void errorHandler (short errorType, Boolean isFatal)
{
	Str255 why;
	short  i;
	
	GetIndString(why, kErrorStrings, errorType);
	ParamText (why,"\p","\p","\p");
	InitCursor();
	i = StopAlert (kErrorAlert, NIL);
	if (isFatal)
		ExitToShell(); /* tritt _nie_ ein ;-) */
} /* errorHandler */

void setupDialog (short dialogID, DialogPtr *theDialog)
{
	*theDialog = GetNewDialog (dialogID, NIL, (WindowPtr) -1L);
	if (theDialog == NIL)
		errorHandler(kResourceError,true);
	SetPort(*theDialog);
} /* setupDialog */

void drawTextItem (DialogPtr theDialog, short item,
                       short fontNr, short fontSize)
{
	Rect   itemRect;
	Handle theItem;
	short  itemType;
	Str255 itemText;
	short  oldFont, oldSize;
	
	oldFont = theDialog->txFont;
	oldSize = theDialog->txSize;
	GetDialogItem(theDialog, item, &itemType, &theItem, &itemRect);
	GetDialogItemText(theItem, itemText);
	TextFont(fontNr);
	TextSize(fontSize);
	SetDialogItemText(theItem, itemText);
	TextFont(oldFont);
	TextSize(oldSize);
} /* drawTextItem */

/* meldet true nach 5 s oder wenn die Maus geklickt wurde */
pascal Boolean aboutFilter (DialogPtr theDialog,
                          EventRecord *theEvent, short *itemHit)
{
	return (gStartTime + 300 < TickCount ()) ||
	                          (theEvent->what == mouseDown);
} /* aboutFilter */

void doAbout (void) /* Zeige Dialogbox "ber..." */
{
	DialogPtr       aboutDialog;
	short           itemHit;
	ModalFilterUPP  myFilterProc;
	
	myFilterProc = NewModalFilterProc (aboutFilter);
	setupDialog (kAboutDialog, &aboutDialog);
	drawTextItem (aboutDialog, 3, geneva, 9);
	gStartTime = TickCount ();
	ModalDialog (myFilterProc, &itemHit);
	DisposeDialog (aboutDialog);
	DisposeRoutineDescriptor (myFilterProc);
} /* doAbout */

Boolean isInFront (void) /* Sind wir im Vordergrund? */
{
	ProcessSerialNumber front, ours;
	OSErr               err;
	Boolean             result;
	
	err = GetCurrentProcess (&ours);
	err = GetFrontProcess (&front);
	err = SameProcess (&ours, &front, &result);
	return result;
} /* isInFront */

