  (* qm
     d. heise 1990
     Programm fr c't :
     Anwendung des Quine-McCluskey-Algorithmus
     Input des Programms ist ein File mit der Definition der zu
     optimierenden Funktionen; Output ist eine Beschreibung der
     Gatter-Realisierung.
     Implementationssprache Turbo Pascal 4.0
  *)
  uses utility,crt,dos; (* benutzt dos. *)
  const maxinput = 32 ; (* maximale Anzahl der  Inputs *)
        maxoutput = 32 ; (* dto. fuer outputs. *)
        maxtextbuf = 20 ; (* soviele Character buffer *)
  (* -------------------- Typen -------------------------- *)
  type polaritytyp=(negativ,positiv,best);
  type fehlercode = (toomuchinputs,colonexpected,numberexpected,
        toomuchoutputs,emptyprogram,semikexpected,noname,
        binexpected,missingterm);
       QMtyp = ( nichts,stern,noprime,block,core); (* Das sind ein
        paar Kennungen, um verschiedene Arten von MinTermen und
        Primimplikanten zu unterscheiden. *)
       Implikant =
        record TInput : longint ;
               Mask : longint ;
  	     Typ : QMTyp;
  	     Einsen : integer ;
               Affection : longint; (* Angabe, welche Outputs von
                diesem Term betroffen sind.  *)
        end;
       AufImplikant = ^Implikant;
       ImpliTab = array[0..255] of Implikant;
       AufImpliTab = ^ImpliTab;
       VieleImplikanten = array[0..255] of AufImpliTab;
       ITab = ^VieleImplikanten;
       bithelp = (* dieser Typ wird fr bitset/bitclr gebr. *)
        record
         case boolean of
          false :( val1 : integer ; val2 : integer ; );
          true  :( value : longint ;)
        end;
  (* ----Variablen------------ *)
  var bitkard  : array[0..255] of byte;
      negMask : longint ; (* Diese Variable gibt fuer jede der
       Funktionen an, ob sie zum Schlub negiert werden muss. *)
      error : boolean; (* globales errorflag *)
      inputs , (* laufender Index der Inputdeklaration *)
      outputs : integer ; (* dto. fuer Outputs *)
      quelle : Text; (* Quellfile *)
      topptr,lastptr : integer; (* textbufferkontrolle *)
      truthTab : ITab;
      nextTruthLine : integer; (* Index des naechsten freien
       Records der truthTab, sie werden beim Parsen der Reihe nach
       belegt. *)
      polarity:polaritytyp;
      inputname:array[0..31] of string[10];
      outputname:array[0..31] of string[10];
const Form:boolean=false;

  procedure anykey;
   var c : char;
   begin
    writeln('hit any key to continue');
    repeat until keypressed;
    c:=readkey; if c=chr(0) then c:=readkey;
   end;
  procedure bitset(var wert : longint ; bitpos : integer);
   (* Setze das durch 'bitpos' angegebene Bit im longint 'wert' *)
   (* Hier lohnt sich Assembleroptimierung! *)
   var bs: bithelp ; (* Variantes Record zur Typenumwandlung. *)
   begin
    bs.value := wert;
    if bitpos > 15 then bs.val2 := bs.val2 or (1 shl (bitpos-16))
    else bs.val1 := bs.val1 or (1 shl bitpos);
    wert:= bs.value;
   end;
  procedure bitclr(var wert : longint ; bitpos : integer);
   (* Loesche das durch 'bitpos' angegebene Bit in 'wert' *)
   begin wert := not(wert); bitset(wert,bitpos); wert := not(wert);
   end;
  function btst(wert : longint ; bitpos : integer ) : boolean ;
   var bs : bithelp ; var x : integer;
   begin
    if bitpos > 15 then
     begin bs.value := wert ;
      btst := ( (bs.val2 and ( 1 shl ( bitpos - 16 ))) ) <> 0;
     end
    else
     begin x := wert;
      btst := ( (x and (1 shl (bitpos))) ) <> 0 ;
     end;
   end;
  (* ---------------- Hashing ---------------------------------- *)
  (* Parameter fuer Hashing: Hashtabelle hat 128 Spalten mit je 16
     Eintraegen. (d.h. 16 Implikanten koennen unter demselben
     Hashcode eingetragen werden; damit ist schon erhebliche
     Beschleunigung mgl.). *)
  const maxhmembers = 16;
  const maxhmem2 = 15;
  const hashbreite = 128;
  const hashbr2 = 127;
  type HashTab =
   array[0..hashbr2] of
    record
     members : integer;
     member : array[0..maxhmem2] of integer;
    end;
   AufHash = ^HashTab;
  var QMhash  : AufHash;
  procedure erasehash;
   var i : integer;
   begin
    for i := 0 to (hashbreite-1) do QMhash^[i].members := 0;
   end;
  (* ----------------------------------------------------------- *)
  (* File - Schnittstelle *)
  var charcount : integer;
      quellname : string ;
  procedure OpenQuelle;
   (* Oeffnet das Quellfile, muss immer test.pla heissen. *)
   (* setzt error, falls nicht existent. *)
   begin
    {$I-}
    Assign(quelle,quellname+'.tab');
    Reset(quelle); (* Textzeiger auf Anfang setzen. *)
    {$I+}
    if (IOResult<>0) then
     begin
      writeln('file ',quellname,'.tab doesnt exist.');
      halt(1);
     end;
    topptr := 0;
    lastptr := 0;
    charcount := 0;
   end;
  
  (* error reklamation *)
  procedure fehler(code : fehlercode); forward;
  function enoughmem(len : longint) : boolean;
   begin
    if maxavail > len then enoughmem := true
    else
     begin writeln('not enough memory!'); error := true;
      enoughmem := false;
     end;
   end;
  (* ----------- B-Tree Handling --------------------------- *)
  procedure InitImplikanten(var table : ITab);
   var len,i : integer; (* Erzeuge Stamm; d.h. Tabelle mit   *)
   begin                (* Zeigern auf Subtabellen ( erstmal *)
    if not error then   (* alle NIL                          *)
     begin
      len := SizeOf(VieleImplikanten);
      if enoughmem(len) then
       begin
        GetMem(table,len);
        for i := 0 to 255 do table^[i]:=nil;
       end;
     end;
   end;
  procedure Existence(var table : ITab; index:integer);
   var len : integer; (* Gewaehrleiste Existenz eines speziellen *)
   begin              (* Records.                                *)
    if table = nil then InitImplikanten(table);
    if not error then begin
      if table^[index shr 8] = nil then begin
        len := SizeOf(ImpliTab);
        if enoughmem(len) then begin
         GetMem(table^[index shr 8],len);
         FillChar(table^[index shr 8]^,len,0);
        end;
      end;
    end;
   end;
  function Impli(var table : ITab;index : integer) :
   AufImplikant;  (* adressiere ein Record. *)
   var subtable : AufImpliTab;
   begin subtable :=  (table^[index shr 8]);
    Impli := @subtable^[index and 255];
   end;
  function ExImpli(var table : ITab;index : integer) :
   AufImplikant;
   var subtable : AufImpliTab;
   begin
    Existence(table,index);
    if error then ExImpli := nil
    else ExImpli:=Impli(table,index);
   end;
  procedure MoveI(var ziel:ITab;z:integer;
                 var quelle:ITab;q:integer);
   begin
    Existence(ziel,z);
    if not error then Impli(ziel,z)^:=Impli(quelle,q)^;
   end;
  (* -----------------  Parserprozeduren ------------------------ *)
  var textbuffer : array[0..maxtextbuf] of char ; (* hier werden
    einige Character des Quelltextes gebuffert. *)
  const eofchar = 0 ;
  function nilchar ( c : char ) : boolean ;
   begin
    nilchar := (c=chr(32)) or (c=chr(13)) or (c=chr(9))
            or (c=chr(10));
   end;
  var showit : boolean;
  function readchar : char ;
   (* liest den naechsten character des files in den buffer.
      Gibt ihn ausserdem als Funktionsergebnis zurueck. *)
   var newchar : char;
   begin
    inc (lastptr);
    if lastptr >= maxtextbuf then lastptr := 0;
    if Eof(quelle) then newchar := char(eofchar)
    else read (quelle,newchar);
    textbuffer[lastptr]:=newchar;
    if showit then write (newchar);
    readchar := newchar;
   end;
  function getchar : char; (* liefert den naechsten Character *)
   var c : char;
   begin
    if topptr = lastptr then c := readchar;
    inc (topptr);
    if topptr >= maxtextbuf then topptr := 0;
    c := textbuffer[topptr];
    inc(charcount);
    getchar := c;
   end;
  procedure Lok; (* Fehlerlokalisation *)
   var i,errorloc : integer; var x : char;
   begin
    anykey; errorloc := charcount;  OpenQuelle;
    showit := true;
    for i := 0 to errorloc-1 do x := (getchar);
    writeln; writeln('Da der Fehler.');
   end;
  procedure fehler;  (* (code : fehlercode);  *)
   (* wurde oben FORWARD deklariert *)
   begin
    error := true;
    write('Fehler festgestellt,es ist');
    writeln;
    case code of
      toomuchinputs : writeln('Too much inputs!');
      numberexpected : begin writeln('Number expected!'); Lok; end;
      colonexpected :
       begin writeln('Doppelpunkt erwartet!'); Lok; end;
      toomuchoutputs : writeln('Too much outputs!');
      emptyprogram : writeln ('Leeres Programm!');
      semikexpected :
       begin writeln('";" erwartet!'); Lok; end;
      noname : writeln ('Es wurde kein Quellfilename angegeben!');
      binexpected : begin writeln('0 or 1 expected!'); Lok; end;
      missingterm: begin writeln('Term missing!'); Lok; end;
      else writeln('ein fehler, den ich nicht erklaeren kann.');
    end;
    anykey;
   end;
  procedure putchar ( zeichen : char ) ;
   (* Gegenstueck zu getchar : es wird kein Zeichen gelesen,
      sondern eins vorne an Filebuffer angeklebt *)
   begin
    textbuffer[topptr]:=zeichen;
    dec (topptr);
    if topptr<0 then topptr := maxtextbuf-1;
    dec(charcount);
   end;

  function unspace : char ;
   (* liefert den naechsten character des quelltextes, der weder
      space noch tab ist *)
   var zeichen : char;
   begin
    repeat zeichen := getchar; until not nilchar(zeichen);
    unspace := zeichen;
   end;

  function freeTruthLine : integer;
   (* liefert die Nummer einer freien TruthLine. *)
   var temp : integer;
   begin
    temp := nextTruthLine;
    inc(nextTruthLine);
    Existence(truthTab,temp); (* Existenz dieses
     Records gewaehrleisten *)
    freeTruthLine := temp;
   end;

  function ReadWord : string; (* lies bis space *)
   var aname : string;
   var c: char;
   begin
    aname := '';
    c := unspace; putchar(c);
    repeat c := getchar; if not nilchar(c) then aname := aname + c;
    until nilchar(c);
    ReadWord := aname;
   end;

Procedure ReadInputs;
  var aname:string;
  begin
  inputs:=0;
  repeat
   aname:=Readword;
   if aname='$' then exit;
   inputname[inputs]:=aname;
   inc (inputs);

  until false;
  end;

Procedure Readoutputs;
  var aname:string;
  begin
  outputs:=0;
  repeat
   aname:=Readword;
   if aname='$' then exit;
   outputname[outputs]:=aname;
   inc (outputs);

  until false;
  end;


  procedure Parser; (* Tabelle einlesen *)
   var quit : boolean;
       c: char;
       term,i,firsttime,code : integer;
       aname : string;
       termcount,maxtermcount : longint;
   begin
    termcount := 0;
    aname := ReadWord;
    code:=0;
    if upstr(aname)='INPUTS:' then readInputs
                                    else Val(aname,inputs,code);
    if code = 0 then
     begin
      maxtermcount :=0;
      bitset(maxtermcount,inputs); (* soviel terme gibts *)
      aname := ReadWord;
      Code:=0;
      if upstr(aname)='OUTPUTS:' then readOutputs
                                       else Val(aname,inputs,code);

      if code = 0 then
       begin
        quit := false;
        repeat
         c := unspace;
         if c = 'E' then quit := true (* kann nur END sein *)
         else
          begin
           putchar(c); (* Dann mu ein Implikant folgen. *)
           term := freeTruthLine;
           with ExImpli(truthTab,term)^ do
            begin
             Mask := -1; TInput := 0 ; Affection := 0;
             for i := 0 to inputs - 1 do
              begin c := unspace;
               bitclr(Mask,inputs-i-1);
               if c = '0' then bitclr(TInput,inputs-i-1)
               else
                 if c = '1' then bitset(TInput,inputs-i-1)
                 else (* fehler *)
                  begin fehler(binexpected); exit; end;
              end;
             (* jetzt ':' *)
             if unspace = ':' then
              begin
               for i := 0 to outputs - 1 do
                begin
                 c := unspace;
                 if c = '0' then bitclr(Affection,outputs-i-1)
                 else
                  begin
                   if c = '1' then bitset(Affection,outputs-i-1)
                   else begin fehler(binexpected); exit; end;
                  end;
                end;
              end
             else begin fehler(colonexpected); exit; end;
             (* Jetzt ';' : *)
             if unspace <> ';' then fehler(semikexpected)
             else
              if TInput <> termcount then fehler(missingterm)
              else inc(termcount);
            end; (* with *)
          end;
        until quit or error ;
        if not error then
         if termcount <> maxtermcount then fehler(missingterm);
       end
      else fehler(numberexpected);
     end
    else fehler(numberexpected);
   end;
  (* ----------- Q U I N E   M C C L U S K E Y ---------------- *)
  (* Tabellen fr eine Handvoll Implikanten: *)
  var QMTable,QMZiel,QMMin,Prime,Selector,All,Collect : ITab;
  var QMTcount,QMZcount,QMMcount,PrimeCount,SelectorCount,AllCount,
      CollectCount : integer ;

  (* Hin und Her *)
  procedure QMZnachQMT ;
   var i : integer;
   begin
    for i := 0 to QMZcount-1 do
      if not error then MoveI(QMTable,i,QMZiel,i);
    QMTcount := QMZcount;
    QMZcount := 0 ;
   end;
  procedure QMTnachQMM ;
   (* Merk alle MinTerme in der Tabelle QMMin; ignoriere
      block-MinTerme (Markierungen zur Einteilung in Gruppen mit
      gleich viel 'Einsen') *)
   var i : integer;
   begin
    QMMcount := 0 ;
    for i := 0 to QMTcount-1 do
     begin
      if (not error) and(not(Impli(QMTable,i)^.Typ = block)) then
       begin
        MoveI(QMMin,QMMcount,QMTable,i);
        inc(QMMcount);
       end;
     end;
   end;
  procedure CollToSel; (* Collect-->Selector moven *)
   var i : integer;
   begin
    for i := 0 to CollectCount -1 do
      if not error then MoveI(Selector,i,Collect,i);
    SelectorCount := CollectCount;
   end;
  
  procedure sortiereinsen;
   (* Bilde QMTable nach QMZiel ab und sortier dabei nach einsen.
      Kopiere QMZiel dann zurueck in die QMTable. Sortiere inner-
      halb Gruppen mit gleich vielen Einsen nach der Maske. *)
   var i,j,k,l,afterlastblock : integer;
   begin
    afterlastblock := 0;
    QMZcount := 0 ;
    for i := 0 to 32 do
     begin
      if QMTcount <> 0 then
        for j := 0 to QMTcount-1 do
          if (Impli(QMTable,j)^.Typ) <> block then
            if (Impli(QMTable,j)^.einsen=i)then
              if QMZcount = afterlastblock then
               begin
                MoveI(QMZiel,QMZcount,QMTable,j);
                if error then exit;
                Inc(QMZcount);
               end
              else
               begin
                k := afterlastblock;
                while (k<QMZcount) and
                 (Impli(QMZiel,k)^.Mask < Impli(QMTable,j)^.Mask)
                 do inc(k);
                if k = QMZcount then
                 begin
                  MoveI(QMZiel,QMZcount,QMTable,j);
                  if error then exit;
                  Inc(QMZcount);
                 end
                else
                 begin
                  l := QMZcount;
                  while (l>k) do
                   begin
                    MoveI(QMZiel,l,QMZiel,l-1);
                    if error then exit;
                    dec(l);
                   end;
                  MoveI(QMZiel,k,QMTable,j);
                  if error then exit;
                  Inc(QMZcount);
                 end;
               end;
      (* Erzeuge ein Block-Record *)
      ExImpli(QMZiel,QMZcount)^.typ := block ;
      if error then exit; (* Verlass diese Prozedur *)
      Inc(QMZcount);
      afterlastblock := QMZcount;
     end; (* for *)
    QMZnachQMT;
   end;
  procedure QMInit (outputbit : integer ; negation : boolean);
   var i,j,k : integer ;
   var eintragen,irrelevant,changed,partner : boolean;
   var soll : longint;
    (* Initialisierung fuer Quine McCluskey: Neuaufbau der QMTable
       aus der truthTab heraus, sortiert nach aufsteigender
       Anzahl der Einsen.
       Kopie dieser Tabelle nach QMMin (ohne blocks) *)
   begin
    (* Alle temporaerTabellen leer: *)
    QMTcount := 0;
    Primecount := 0;
    for i := 0 to nextTruthLine - 1 do
     begin
      eintragen := btst(Impli(truthTab,i)^.Affection,outputbit);
      if negation then eintragen := not eintragen ;
      if eintragen then
       begin
        ExImpli(QMTable,QMTcount)^.Mask := Impli(truthTab,i)^.Mask;
        if error then exit;
        with Impli(QMTable,QMTcount)^ do
         begin
          TInput := Impli(truthTab,i)^.TInput;
          Typ := nichts;
          einsen := 0;
          for j := 0 to 31 do
           if btst(TInput,j) or btst(Mask,j) then inc (einsen);
         end;
        Inc (QMTcount);
       end;
     end;
    sortiereinsen;
    if error then exit;
    QMTnachQMM; (* Bewahre hier die Minterme auf; sie werden zum
     Schluss zur Primimplikantenauswahl gebraucht. *)
   end;
  function QMident (qmx : ITab; t1,t2 : integer ) : boolean;
   (* Diese Funktion vergleicht zwei Implikanten der angegebenen
      Tabelle auf Identitaet *)
   var equal : boolean;
   var help : longint;
   var i : integer ;
   begin
    equal := false;
    (* Die Masken muessen identisch sein : *)
    if Impli(qmx,t1)^.Mask = Impli(qmx,t2)^.Mask then
     begin
      help := (Impli(qmx,t1)^.TInput xor Impli(qmx,t2)^.TInput);
      help := help and (Impli(qmx,t1)^.Mask xor -1);
      equal := (help = 0);
     end;
    QMident := equal;
   end;
  
  function Nachbarn ( t1,t2 : integer ; var bitpos : integer ) :
     boolean;
   (* Diese Funktion vergleicht zwei Records der QMTable.
      Identitaet der Masken vorausgesetzt.
      Falls die durch diese Records definierten Terme sich nur in
      einem Input-Bit unterscheiden, sind sie Nachbarn. *)
   var equal,leave : boolean;
   var help : bithelp;
   var i,bk : integer ;
   var p1,p2 : AufImplikant;
   var themask :longint;
   begin
    p1 := Impli(QMTable,t1);
    p2 := Impli(QMTable,t2);
    equal := false;
    themask := (p1^.Mask xor -1);
    help.value := ((p1^.TInput and themask)xor
                   (p2^.TInput and themask));
    bk := bitkard[help.val1 and 255];
    if not (bk>1) then
     begin
      bk := bk + bitkard[help.val1 shr 8];
      if not(bk>1) then
       begin
        bk := bk + bitkard[help.val2 and 255];
        if not (bk>1)  then
          equal := ( bk + bitkard[help.val2 shr 8] ) = 1;
       end;
     end;
    if equal then
     begin
      i := 0;
      leave := false;
      repeat
       if btst(help.value,i) then
        begin bitpos := i; leave := true; end
       else inc(i);
      until leave;
     end;
    Nachbarn := equal;
   end;
  
  function QMreduce : boolean;
   (* Grundlegender Reduktionsschritt. *)
   (* Gibt true zurueck, wenn eine Reduktion gelungen ist.
      Sukzessiv aufrufen, bis kein Erfolg mehr; dann liegen
      alle gefundenen Primimplikanten in der Tabelle 'Prime';
      man muss dann lediglich ein guenstiges Set davon
      herausfiltern. *)
   var success,doubleline,stopit : boolean;
       i,j,k,bitpos,hc,minj,qc : integer ;
       afterlastblock : integer; (* Index des ersten Implikanten
        hinter dem letzten erzeugten Block. *)
       mymask : longint;
       ref : AufImplikant;
    function QMhashcode(tab : ITab; index : integer) : integer;
     begin
      with Impli(tab,index)^ do
       QMhashcode := (((((Mask-1) mod 17)+Mask) * (TInput-7)) and
         mymask) mod 123; (* diese Hashfunktion ist natuerlich
         durch wildes Probieren entstanden. *)
     end;
   begin
    minj := 0;
    write('*'); (* Um nervoese Benutzer zu beruhigen *)
    QMZcount := 0 ;
    erasehash;
    afterlastblock := 0;
    success := false;
    mymask := 0;
    bitset(mymask,inputs);
    mymask := mymask - 1;
    if QMTcount <> 0 then
     begin
      for i := 0 to QMTcount-1 do
       begin
        if not (Impli(QMTable,i)^.typ = block) then
         begin
          if i > minj then minj := i;
          j := minj ; (* finde Partner: Er muss die gleiche Maske
            haben und mehr einsen als Impli(i) *)
          stopit := false;
          ref := Impli(QMTable,i);
          repeat
           with Impli(QMTable,j)^ do
            if (j>(QMTcount-1)) or
               ((Typ<>block)and((einsen-ref^.einsen)>1)) or
               ( (einsen>ref^.einsen)and(Typ<>block)and
                 (Mask = ref^.Mask) )
            then stopit := true else inc(j);
          until stopit;
          if not((j>(QMTcount-1))
               or((Impli(QMTable,j)^.einsen-ref^.einsen)>1)) then
           begin
            if j > minj then minj := j;
            if (Impli(QMTable,j)^.einsen-ref^.einsen=1) then
             begin (* j zeigt in einen Bereich mit moeglichen
                      Partnern fuer i *)
              repeat
               if Nachbarn(i,j,bitpos) then
                begin (* Neue Ziel-Zeile erzeugen? *)
                 MoveI(QMZiel,QMZcount,QMTable,j);
                 if error then exit;
                  (* j : wichtig wegen max-Bildung der einsen *)
                 bitset(Impli(QMZiel,QMZcount)^.Mask,bitpos);
                 bitclr(Impli(QMZiel,QMZcount)^.TInput,bitpos);
                   (* damit hashcodes korrekt gebildet werden. *)
                 Impli(QMZiel,QMZcount)^.typ := nichts;
                 Impli(QMTable,i)^.typ := noprime;
                 Impli(QMTable,j)^.typ := noprime;
                  (* Diese Zeilen konnten zusammengefasst werden,
                     sie sind also keine Primimplikanten *)
                 success := true;
                 qc := QMZcount;
                 (* Finde heraus ob neue Zeile schon einmal
                    erzeugt wurde (dafuer hashing wichtig): *)
                 hc := QMhashcode(QMZiel,qc);
                 doubleline := false;
                 if QMhash^[hc].members <> 0 then
                  begin
                   (* Durchsuch die hash-Liste: *)
                   k := 0;
                   while(not doubleline)and(k<QMhash^[hc].members)do
                    begin
                     if QMIdent(QMZiel,QMhash^[hc].member[k],qc)
                     then doubleline := true;
                     inc(k);
                    end;
                   if (not doubleline) and
                    (QMHash^[hc].Members = maxhmembers) then
                    begin
                     k := (* 0 *) afterlastblock;
                     while (not doubleline) and (k<qc) do
                      begin
                       if QMident(QMZiel,k,qc) then
                        doubleline := true;
                       inc(k);
                      end;
                    end;
                  end;
                 if not doubleline then
                  begin
                   if not(QMhash^[hc].Members = maxhmembers) then
                    begin
                     QMhash^[hc].Member[QMhash^[hc].Members] := qc;
                     inc (QMhash^[hc].Members);
                    end;
                   inc(QMZcount);
                   write('!');
                  end;
                end;
               inc(j);
              until (j>QMTcount-1)or(Impli(QMTable,j)^.typ=block)or
               (Impli(QMTable,j)^.Mask <> Impli(QMTable,i)^.Mask);
             end
           end;
         end
        else
         begin
          (* Erzeugung eines blocks: *)
          ExImpli(QMZiel,QMZcount)^.typ := block;
          if error then exit;
          Inc(QMZcount);
          afterlastblock := QMZcount;
          minj := i;
          erasehash;
         end;
       end;
      for i := 0 to QMTcount -1  do
        if Impli(QMTable,i)^.typ = nichts then
         begin
            MoveI(Prime,Primecount,QMTable,i);
            if error then exit;
            Inc (Primecount);
         end;
      QMZnachQMT;
      sortiereinsen; (* Sortierung nach gleichen Masken. *)
      QMreduce := success ;
    end;
   end;
  
  function MinInPrim (Minix : integer ; Prim : ITab;
    Primix : integer) : boolean;
   (* Untersuche, ob der durch Minix indizierte Minterm in der
      Tabelle QMMin durch den durch Primix indizierten P.I.
      in der Tabelle Prim 'bedeckt' / 'erzeugt' wird. *)
   var mwert,pwert,pmask : longint;
   begin
    mwert := Impli(QMMin,Minix)^.TInput;
    pwert := Impli(Prim,primix)^.TInput;
    pmask := Impli(Prim,primix)^.Mask;
    pmask := (pmask xor -1);
    mwert := mwert and pmask;
    pwert := pwert and pmask;
    MinInPrim:= (mwert = pwert);
   end;
  
  procedure APrimeIsBorn(p : integer); (* Der p-te Primimplikant
   in der Tabelle Prime gehoert definitiv zur Loesung; also
   markiere seine Minterme in der Tabelle QMMin. *)
   var k : integer;
   begin
    for k := 0 to QMMcount - 1 do
      if MinInPrim(k,Prime,p) then
       (* Der MinTerm k ist im Prime p enthalten, wird also
          von p abgedeckt und ist zu markieren: *)
       Impli(QMMin,k)^.Typ := stern;
    Impli(Prime,p)^.Typ := core; (* markieren! *)
   end;
  
  function UnChecked : integer;
   (* Rechne aus, wieviele MinTerme in der Tabelle QMMin noch
      nicht den Vermerk 'stern' tragen *)
   var i,c : integer;
   begin
    c := 0 ;
    for i := 0 to QMMcount-1 do
      if (not (Impli(QMMin,i)^.Typ = block)) and
         (not (Impli(QMMin,i)^.Typ = stern) ) then
         inc(c);
    UnChecked := c;
   end;
  function Checking(p : integer) : integer;
   (* Rechne aus, wieviele MinTerme der Primimplikant p  in der
      Tabelle QMMin noch zusaetzlich abdecken wuerde *)
   var i,c : integer;
   begin
    c := 0 ;
    for i := 0 to QMMcount-1 do
      if (not (Impli(QMMin,i)^.Typ = block)) and
         (not (Impli(QMMin,i)^.Typ = stern )) then
          if MinInPrim(i,Prime,p) then inc(c);
    Checking := c;
   end;
  procedure CheckCore;
    (* Diese Prozedur benutzt die Tabelle QMMin, in der nach
       Quine-McCluskey-Abarbeitung alle MinTerme stehen, um
       aus der Tabelle Prime, in der alle ermittelten P.I. stehen,
       ein gnstiges (kleines) Lsungs-Set herauszusieben. *)
   var i,myprimes,j,lastprime,maxchecking,maxchecker,temp : integer;
   begin
    for i := 0 to QMMcount - 1 do
      (* Alle bereits markierten Minterme brauchen nicht untersucht
         zu werden, da sie bereits im core liegen: *)
      if not (Impli(QMMin,i)^.Typ = stern) then
       begin
        myprimes := 0 ; (* Zaehle, in wieviel Primimplikanten
         dieser MinTerm liegt *)
        for j := 0 to primecount - 1 do
         begin
          if MinInPrim(i,Prime,j) then
           begin
            lastprime := j;
            inc(myprimes);
           end;
         end;
        if myprimes = 1 then (* dieser MinTerm liegt in genau einem
          der festgestellten Primimplikanten, damit ist dieser P.I.
          ein Core-Mitglied! *)
         APrimeIsBorn(lastprime);
       end;
    (* Selektion aus dem ELIGIBLE SET : *)
    while not(UnChecked=0)
     do begin
      writeln('ELI-SELECT');
      maxchecking := 0 ;
      for i := 0 to PrimeCount - 1 do
       begin
        temp := Checking(i);
        if maxchecking < temp then
         begin
          maxchecker := i;
          maxchecking := temp;
         end;
       end;
      APrimeIsBorn(maxchecker);
     end;
   end;
  
  function QMfunction(bitnr : integer; neglog : boolean) : integer;
    (* QM-Optimierung, neglog bestimmt Polaritaet *)
   var i : integer ;
   begin
    QMInit(bitnr,neglog); (* Versuch, die Funktion in gewuenschter
     Polaritaet zu realisieren. *)
    if not error then
      repeat
      until (not QMreduce) or error ;
    if not error then
     begin
      CheckCore;
      if not error then
       begin
        (* Die ermittelten Implikanten sammelnrime->Collect *)
        CollectCount := 0 ;
        for i := 0 to PrimeCount - 1 do
          if ( Impli(Prime,i)^.Typ = core) then
           begin
            MoveI(Collect,CollectCount,Prime,i);
            if  error then exit;
            with Impli(Collect,CollectCount)^ do
             begin
              Affection := 0 ;
              bitset(Affection,bitnr);
             end;
            Inc (CollectCount);
           end;
       end;
     end;
    QMfunction := CollectCount; (* Anzahl Primimpl. *)
   end;

  procedure Materialisiere;
   (* Optimiere alle Funktionen. Output ist die Tabelle ALL *)
   var i,j,poscount,negcount : integer;
   begin
    writeln;
    AllCount := 0; (* Loesche die evtl. in vorhergehenden
      Versuchen gesammelten Implikanten. *)
    writeln('Functions to be minimized:',outputs);
    i := 0;
    repeat
     poscount := QMfunction(i,false); (* Versuch pos. Logik *)
     if not error then
      begin
       CollToSel; (* Kopiere das in die Selektor Tabelle *)
       if not error then
        begin
         bitclr(negmask,i); (* erstmal pos versuchen. *)
         negcount := QMfunction(i,true); (* Und nochmal neg. *)
        end;
       if not error then
        begin
         if (polarity=best) and (negcount < poscount) or (polarity=negativ) then
          begin (* negative Loesung besser: *)
           CollToSel;
           bitset(negMask,i);
          end;
         if (not error) and (SelectorCount<>0) then
          begin
           (* In der Tabelle Selector stehen die Ergebnisse des
              letzten Laufes, diese muessen in die Tabelle All
              aufgenommen werden.d.h. Selector beschreibt eine
              einzelne Funktion, All  beschreibt alle. *)
           for j := 0 to SelectorCount - 1 do
            if not error then MoveI(All,j+AllCount,Selector,j);
           AllCount:=AllCount + SelectorCount;
           writeln;
           writeln('Function #',i,' has been minimized.');
          end;
        end;
      end;
     inc(i);
    until error  or (i = outputs);
   end;
  (* -------------------- OUTPUT --------------------- *)
  Procedure setDefaultnames;
  var aname : string;
  var i:integer;
  begin
  For i:=1 to 32 do
   begin
    Str(i,aname);
    inputname[i] := 'x'+ aname;
    outputname[i]:= 'z'+ aname;
   end;
  end;

  procedure QMText;
   (* Erzeuge aus Primimplikanten in der Tabelle 'all'
      Textfile mit Beschreibung der Funktionen. *)
   var logfile : text ;
       i,j,k,l : integer ;
       firstterm,firstmal : boolean;
   begin
    assign(logfile,quellname+'.log');
    rewrite(logfile);
    writeln(logfile,'Logische Funktionsbeschreibung');
    writeln(logfile);
    writeln(logfile,'Liste der Inputs:');
    for i := 0 to inputs-1 do write(logfile,inputname[i],' ');
    writeln(logfile);
    writeln(logfile,'Liste der Outputs:');
    for i := 0 to outputs-1 do write(logfile,outputname[i],' ');
    writeln(logfile);
    Writeln(logfile);
    for i := 0 to outputs-1 do (* fuer alle Funktionen *)
     begin
      j := 0; (* laeuft durch alle Primimplikanten *)
      if btst(negMask,i) then write (logfile,'/')
      else if form then Write (logfile,' ');
      write(logfile,outputname[i],' :=  ');
      firstterm := true;
      while (j<AllCount) do
       begin
        with Impli(All,j)^ do
         begin
          if btst(Affection,i) then
           begin
            if firstterm then firstterm := false
            else write(logfile,' ':length(outputname[i]),'+  ');

            firstmal := true;
            for k := inputs-1 downto 0 do
              if not btst (Mask,k) then
               begin
                if firstmal then firstmal := false
                else write(logfile,' * ');
                if not btst(TInput , k) then write (logfile,'/')
                                        else if form then write (logfile,' ');
                write(logfile,inputname[k]);
               end
               else if form then
                begin
                Write (logfile,' ':length(inputname[k])+4);

                end;
            if firstmal then    (* Es kann passieren, dass kein
             einziger Input den Output beeinflusst, da sie alle
             'dont care' sind. Dann ist der Output immer true. *)
              write (logfile,'1');
            writeln(logfile);
            write(logfile,'   ');
           end;
         end;
        inc(j); (* naechster term *)
       end;
      if firstterm then
       write (logfile,'0'); (* Kein einziger term. Immer FALSE *)
      writeln(logfile);
     end; (* und naechste Funktion *)
    close(logfile);
   end;
  (* -------------------- HAUPTPROG --------------------------- *)
  var i,j : integer ;
      bitcount : byte;
      para:string;
  begin (* Hauptprogramm *)
   polarity:=best;   { Default }
   para:=upstr(paramstr(2));
   if (pos('H',para)> 0) then polarity:=positiv;
   if (pos('L',para)> 0) then polarity:=negativ;
   if (pos('F',para)> 0) then Form:=true;
   error := false;
   (* VariablenInitialisierung *)
   GetMem ( QMhash,SizeOf(HashTab));
   InitImplikanten(truthTab);
   InitImplikanten(QMTable);
   InitImplikanten(QMZiel);
   InitImplikanten(QMMin);
   InitImplikanten(Prime);
   InitImplikanten(Selector);
   InitImplikanten(All);
   InitImplikanten(Collect);
   if not error then
    begin
     showit := false;
     inputs := 0;
     outputs := 0 ;
     nextTruthLine := 0 ;
     negMask := 0;
     for i := 0 to 255 do
      begin
       bitcount := 0;
       for j := 0 to 7 do if btst(i,j) then inc(bitcount);
       bitkard[i]:=bitcount;
      end;
    end;
   if not error then
    begin
     writeln('QM parsing.');
     quellname := '';
     quellname := ParamStr(1);
     if quellname = '' then fehler(noname);
     if not error then
      begin OpenQuelle;
       if not error then
        begin
         Parser;
         if (not error) then
          begin
           writeln;
           writeln('Going to opimize...');
           Materialisiere;
           if not error then begin
            writeln;
            writeln('Creating result file...');
            QMText;
           end;
          end;
        end;
      end;
    end;
   halt(0);
  end.
