#if !defined(__OWL_NOTEBOOK_H)
#define __OWL_NOTEBOOK_H

#define INCL_PM

#include <os2.h>
#include <control.h>

class _OWLCLASS TNotebook;

class _OWLCLASS TNotebook : public TControl
{
 public:  TNotebook (TWindow* parent,int resourceId,TModule* module=0)
         :TControl (parent, resourceId, module) {}
          TNotebook (TWindow *parent, TResId id,
                    int x, int y, int w, int h,  TModule *module = 0)
         :TControl (parent,id,NULL,x,y,w,h,module)
              { Attr.Style |= BKS_SOLIDBIND | BKS_BACKPAGESBR |
                              BKS_MAJORTABRIGHT | BKS_SQUARETABS |
                              BKS_TABTEXTCENTER | BKS_STATUSTEXTLEFT;}
public: ULONG SetPageWindow (ULONG ulPageID, TWindow* window);
        ULONG SetStatuslineText (ULONG ulPageID, const char far* text);
        ULONG SetTabText (ULONG ulPageID, const char far* text);
        ULONG SetTabBitmap (ULONG ulPageID, HBITMAP hbm);
        ULONG SetDimensions (TSize size, USHORT usFlags);
        ULONG SetColor (TColor color, USHORT usFlags);
        ULONG DeletePage (ULONG ulPageID,USHORT usFlags = BKA_SINGLE);
        ULONG InsertPage (ULONG ulPageID,USHORT usStyle,USHORT usOrder);
        ULONG TurnToPage (ULONG ulPageID);
        void  SetBinding (USHORT usFlags);
        void  SetIntersection (USHORT usFlags);
        void  SetMajorTabLocation (USHORT usFlags);
        void  SetTabShape (USHORT usFlags);
        void  SetTabTextAlignment (USHORT usFlags);
        void  SetStatuslineTextAlignment (USHORT usFlags);
protected: void      SetStyle (ULONG ulStyle);
           ULONG     ClearStyle (ULONG ulStyle);
           char far* GetClassName();
};

#endif
