(* Hardware-Bildschirmschoner ----  c't '94 *)
(* !!! nur zur Ansteuerung des Abschal-Adapters !!! *)
(* Ingo T. Storm, Borland Pascal 7.0 *)
program ctSaver;
{$D SCRNSAVE c't-Hardware-Schoner}
uses WinTypes, WinProcs, oWindows, oDialogs, Strings, uSaver,
     uCtSavCfg; (* Konfigurationsdialog *)
const
  BltDelay    =   5000; (* Zeit zwischen Grafikausgaben *)
  ControlPorts: ARRAY[1..3] of Word = ($37A,$27A,$3BE);
  szStatus    =  '  Schalte Bildschirm in %0d:%02d Minuten ab.  ';

type
  TctSaverApp = object(TScrnSaverApp)
    procedure InitMainWindow; virtual;
  end;

  PctSaverWin = ^TctSaverWin;
  TctSaverWin = object(TScrnSaverWin)
    szOut , szLast : PChar;
    ControlPort : Word;
    hBmp : hBitmap;
    posX, posY : Integer;
    PwrOffDelay, nextBlt, startTime : LongInt;
    PwrOff : Boolean;
    constructor Init(aParent: PWindowsObject; aTitle: PChar);
    procedure SetupWindow; virtual;
    procedure DefWndProc(Var Msg:TMessage); virtual;
    procedure WMAnimate(var Msg: TMessage);
              virtual WM_First + WM_Animate;
    destructor Done; virtual;
    procedure SwitchOff;
    procedure SwitchOn;
  end;

procedure TctSaverApp.InitMainWindow;
begin (* schonen bei /s, sonst konfigurieren *)
  if (ParamStr(1) = '/s') or (ParamStr(1) = '-s')
  or (ParamStr(1) = '/S') or (ParamStr(1) = '-S') then begin
    MainWindow:= New(PctSaverWin, Init(nil, 'ScreenSaver'));
    Configure := false;
  end
  else begin
    MainWindow := New(PctSaverCfgDlgWin, Init(nil, 'ConfigDialog'));
    Configure := True;
  end
end;

constructor TctSaverWin.Init(aParent: PWindowsObject; aTitle: PChar);
begin
  inherited Init(aParent, aTitle);
  ControlPort:=ControlPorts
    [GetPrivateProfileInt(AppKey,'LPT',1,'CONTROL.INI')];
  PwrOffDelay:=LongInt(GetPrivateProfileInt(
    AppKey,'PwrOffDelay',5,'CONTROL.INI'))*60000+1000;
  GetMem(szOut, StrLen(szStatus)); GetMem(szLast, StrLen(szStatus));
end;

procedure TctSaverWin.SetupWindow;
begin
  Randomize;
  hBmp := loadBitmap(hInstance, 'ctlogo');
  startTime := GetTickCount;      nextBlt   := startTime;
  PwrOff    := false; posX:= -1;  posY      := -1;
  inherited SetupWindow;
end;

procedure TctSaverWin.DefWndProc(Var Msg:TMessage);
begin (* nur bei Alt, F10 oder rechter Maustaste aufwachen *)
  case msg.Message of
    WM_ACTIVATE, WM_ACTIVATEAPP: if (msg.wParam=0) then PostMessage(HWindow,WM_CLOSE,0,0);
    WM_SYSKEYDOWN, WM_RBUTTONDOWN: PostMessage(HWindow,WM_CLOSE,0,0);
  end;
    (*
      if ( msg.WParam = 0 ) then begin
        TWindow.DefWndProc(Msg);
        exit;
      end;
  end;
  *)
  TWindow.DefWndProc(Msg); (* hier NICHT inherited *)
end;

procedure TctSaverWin.WMAnimate;
var
  hWindc, hMemDC: hDC;          hDefBmp : hBitmap;
  hF, hOf : hFont;              BitMp   : TBitMap;
  now     : LongInt;            seconds : word;
  args    : array [0..1] of Word;
begin
  if nextBlt = startTime then ClearScreen;
  now := GetTickCount;
  seconds := (PwrOffDelay - now + startTime) Div 1000;
  if seconds = 0 then SwitchOff;
  if PwrOff then exit;
  Args[0]:=Seconds DIV 60;      Args[1]:=Seconds MOD 60;
  wvsprintf(szOut, szStatus, Args);
  if (0<>StrComp(szOut, szLast)) or (now > nextBlt) then begin
    StrCopy(szLast, szOut);
    hWinDC := GetWindowDC(hWindow);
    hMemDC := CreateCompatibleDC(hWinDC);
    hF := CreateFont(-20,0,0,0,0,0,0,0,1,0,0, PROOF_QUALITY,
           FF_SWISS, 'ARIAL BOLD');
    hOf:=SelectObject(hWinDC, hF);
    SetBkColor(hWinDC, 0);       SetTextColor(hWinDC, $FFFF);
    SetTextAlign(hWinDC, TA_CENTER OR TA_BASELINE);
    TextOut(hWinDC, trWinRect.Right DIV 2, trWinRect.Bottom - 30,
                    szOut, StrLen(szOut));
    DeleteObject(SelectObject(hWinDC, hOF));
    if now > nextBlt then begin
      inc(nextBlt, bltDelay);
      hDefBmp:=SelectObject(hMemDC, hBmp);
      GetObject(hbmp, sizeof(BitMp), @BitMp);
      if (posX + posY)<>-2 then BitBlt(hWinDC, posX, posY,
        Bitmp.bmWidth, Bitmp.bmHeight , hMemDC, 0, 0, BLACKNESS);
      posX := random(trWinRect.Right - BitMp.bmWidth);
      posY := random(trWinRect.Bottom - BitMp.bmHeight - 50);
      BitBlt(hWinDC, posX, posY, Bitmp.bmWidth, Bitmp.bmHeight , hMemDC,
                     0, 0, SRCcopy);
      SelectObject(hMemDC, hDefBmp);
    end;
    DeleteDC(hMemDC);      ReleaseDC(hWindow, hWinDC);
  end;
end;

destructor TctSaverWin.Done;
begin
  if PwrOff then SwitchOn;
  DeleteObject(hBmp);
  inherited Done;
end;

procedure TctSaverWin.SwitchOff;
var OldPort : Byte;
begin (* Pin14 an LPTx: auf low *)
  OldPort:=Port[ControlPort];
  Port[ControlPort]:=OldPort OR 2;
  PwrOff:=true;
end;

procedure TctSaverWin.SwitchOn;
var OldPort : Byte;
begin (* Pin14 an LPTx: auf high *)
  OldPort:=Port[ControlPort];
  Port[ControlPort]:=OldPort AND NOT 2;
end;

var App: TctSaverApp;
begin
  App.Init('Saver'); App.Run; App.Done;
end.
