{ DSUserProcs.p fr DropShell,  ct und C.Meyer 3/95. Teile von Leonard Rosenthol }

unit DSUserProcs;
interface

	uses
		Folders, Serial, AppleTalk, Processes, PPCToolbox, EPPC, Notification, AppleEvents, DSGlobals, DSUtils;

{ Interface-Definitionen }

	procedure InstallOtherEvents;

	procedure OpenApp;
	procedure QuitApp;

	function PreFlightDocs (opening: Boolean; var userDataHandle: univ Handle): Boolean;
	procedure OpenDoc (myFSSPtr: FSSpecPtr; opening: Boolean; userDataHandle: univ Handle);
	procedure PostFlightDocs (opening: Boolean; userDataHandle: univ Handle);

	procedure SelectFile;
	procedure InitUserGlobals;
	procedure DisposeUserGlobals;

implementation

{$S Main}

{ Von DSAppleEvents whren Initialisierung aufgerufen, }
{ sowohl beim Anklicken als auch bei Drag & Drop. }
{ Erlaubt die Installation weiterer AE-Handler }
	procedure InstallOtherEvents;
	begin
	end;

{ 'oapp' Event empfangen.  Wird nicht angesprungen, wenn }
{ Drag&Drop zum Programmstart fhrte }
	procedure OpenApp;
	begin
		gOApped := TRUE;
	end;

{ QUIT Event empfangen }
	procedure QuitApp;
	begin
		gDone := TRUE;		{ und Tsch! }
	end;

{ Gemeinsame Routine vor der Einzelbehandlung der mit 'pdoc' oder 'odoc' }
{ geffneten Dateien. Ggf. hier Datenbereiche initialisieren usw. }
{ userDataHandle ist fr eigene erweiterungen frei und mu selbst}
{ erstellt und abgebaut werden. }
	function PreFlightDocs (opening: Boolean; var userDataHandle: univ Handle): Boolean;
	begin
		PreFlightDocs := opening;		{ wie aufgerufen und bergeben }
	end;

{ Diese Routine wird fr jedes einzelne mit 'pdoc' oder 'odoc' bergebene }
{ Dokument aufgerufen. Hier: Datei ggf. konvertieren und an Port senden }
	procedure OpenDoc (myFSSPtr: FSSpecPtr; opening: Boolean; userDataHandle: univ Handle);
		var
			whichWindow: WindowPtr;
			whichPart: integer;
			aLongInt, Index, Base, Table: LongInt;
			aInt, refNum, Error: Integer;
			aRect: Rect;
			picH: PicHandle;
			TextBuffHandle: Handle;
			ConvPtr, TextBuffPtr: Ptr;
			TextLng, TextIndex, TextBar, OldTextBar: LongInt;
			myCurs: CursHandle;
			ch: Char;
			aStr: Str255;
			outRefNum, inRefNum: Integer;
			HskFlags: SerShk;

		procedure SmallEventHandler;
{ Kleine Event-Loop whrend der Ausgabe, damit Programm auch in den Hintergrund }
{ gestellt oder abgebrochen werden kann. Nimmt absichtlich keine High-Level-Events}
{ entgegen, sondern prft nur, ob welche anliegen. Wenn ja, wird gOAppend gesetzt}
{ und die Applikation bricht nicht automatisch ab, weil der User noch ein weiteres File}
{ "gedroppt" hat. }
		begin
			if eventAvail(highLevelEventMask, gEvent) then
				gOApped := TRUE;
			gWasEvent := WaitNextEvent(mDownMask + keyDownMask + autoKeyMask, gEvent, 10, nil);
			case gEvent.what of
				mouseDown: 
					begin
						whichPart := FindWindow(gEvent.where, whichWindow);
						case whichPart of
							inSysWindow: 
								SystemClick(gEvent, whichWindow);
							inDrag: 
								DragWindow(whichWindow, gEvent.where, screenBits.bounds);
						end;
					end;
				keyDown, autoKey: 
					begin
						ch := CHR(BitAnd(gEvent.message, charCodeMask));
						if ch = '.' then
							TextIndex := TextLng - 1; { Ende }
					end;
			end; {case}
		end;

	begin
		if gDocNo > 7 then
{ rechte Hlfte des Statusfensters lschen }
			begin
				aRect := gSplashScreen^.VisRgn^^.rgnBBox;
				aRect.left := aRect.left + 80;
				eraseRect(aRect);
				gDocNo := 0;
			end;

{ Buffer einrichten und Datei in Buffer lesen }
		myCurs := GetCursor(watchCursor);
		SetCursor(myCurs^^);  					{ bitte warten... }
		if FSpOpenDF(myFSSPtr^, fsCurPerm, refNum) = noErr then
			begin
				Error := GetEOF(refNum, TextLng);
				TextBuffHandle := NewHandle(TextLng + 16);
				HLock(TextBuffHandle);
				if TextBuffHandle = nil then
					ErrorAlert(kErrStringID, kMemErr, 45)
				else
					Error := FSRead(refNum, TextLng, TextBuffHandle^);
				if Error <> noErr then
					begin
						ErrorAlert(kErrStringID, kMemErr, 46);
						TextLng := 0;
					end;
			end;
		Error := FSClose(refNum);
{ Handshake-Flags und Parameter fr serielle Schnittstelle setzen }
		HskFlags.fCTS := 1;		{ CTS-Handshake ein }
		HskFlags.fDTR := 1;	{ DTR-Handshake ein }
		HskFlags.fxOn := 0;		{ Software-Handshake aus }
		HskFlags.xOn := char(17);
		HskFlags.xOff := char(19);
		if gPrefs.Port = kModemPortItem then
			aStr := '.AOut'
		else
			aStr := '.BOut';
{ Treiber ffnen und ggf. Fehlermeldung ausgeben }
		ErrorAlert(kErrStringID, kDrivErr, OpenDriver(aStr, outRefNum));
		Error := SerReset(outRefNum, baud57600 + stop10 + noParity + data8);
		Error := SerHShake(outRefNum, HskFlags);
{ Epson-Escape-Sequenz zusammenbasteln: Normalschrift ESC-!-1. }
{ String-Variable ist hier nur Mittel zum Zweck (Byte-Array) }
		aStr := '! ';		{ nach Bedarf zu ndern }
		aStr[0] := char(27);
		aStr[2] := char(1);
		aLongInt := 3;
		if gPrefs.PCKonv then
			Error := FSWrite(outRefNum, aLongInt, @aStr);
{ Zwar sieht die Pointer-Arithmetik in Pascal durch die Typecasts etwas }
{ umstndlich aus, das Kompilat ist aber nicht schlechter als reiner C-Code. }
{ Pointer auf gerade eingelesenen Textbuffer: }
		Base := ord(TextBuffHandle^);
{ Pointer auf Tabelle Mac/MSDOS-Konvertierung mit anschlieender }
{ Korrektur fr SignedBytes (wg. SignedByte-Pointer!): }
		Table := ord(gConAHandle^) + 128;
		if TextLng > 1 then
			begin
				aRect.bottom := 115;
				aRect.left := 18;
				aRect.right := 43;
				TextFont(geneva);
				TextSize(10);
				TextFace([]);
				moveTo(80, 22 + 14 * gDocNo);
				WriteDraw(myFSSPtr^.name, ' (', TextLng : 1, ' Zeichen)');
				TextBar := 0;
				for TextIndex := 0 to TextLng - 1 do
					begin
						OldTextBar := TextBar;
						TextBar := TextIndex * 100 div TextLng + 1;
						if TextBar > OldTextBar then
							begin
								if TextBar mod 4 = 0 then	{ das ist oft genug }
									SmallEventHandler;
								aRect.Top := aRect.Bottom - TextBar;
								FrameRect(aRect);
								InsetRect(aRect, 1, 1);
								EraseRect(aRect);
								InsetRect(aRect, -1, -1);
							end;
						aLongInt := 1;
						TextBuffPtr := Ptr(Base + TextIndex);
{ Zeichen in Tabelle mit Mac/MSDOS-Konvertierung abgreifen }
						ConvPtr := Ptr(Table + TextBuffPtr^);
						if gPrefs.PCKonv then
							begin
								Error := FSWrite(outRefNum, aLongInt, ConvPtr);
								if TextBuffPtr^ = 13 then
{ Wenn gewnscht, Linefeed fr PC-Drucker einfgen }
									begin
										aStr[0] := char(10);
										Error := FSWrite(outRefNum, aLongInt, @aStr);
									end;
							end
						else
							Error := FSWrite(outRefNum, aLongInt, TextBuffPtr);
					end;
			end;

		if TextBuffHandle <> nil then
			begin
				HUnlock(TextBuffHandle);
				DisposHandle(TextBuffHandle);				{ das war der Text-Buffer }
			end;

{ Wenn gewnscht, Formfeed senden }
		aStr[0] := char(12);
		aLongInt := 1;
		if gPrefs.PCKonv then
			Error := FSWrite(outRefNum, aLongInt, @aStr);
		Error := CloseDriver(outRefNum);
		InitCursor;
		gDocNo := gDocNo + 1;
	end;

{ Gemeinsame Routine, nachdem alle Dokumente behandelt wurden }
	procedure PostFlightDocs (opening: Boolean; userDataHandle: univ Handle);
	begin
		if (opening) and (not gOApped) then
			gDone := TRUE;	{bei echtem 'odoc' beenden}

{ laut Empfehlung in der Apple Event Registry nicht bei }
{ 'pdoc', sondern auf  'quit' vom Finder warten }
	end;

{ Datei manuell auswhlen}
	procedure SelectFile;
		var
			stdReply: StandardFileReply;
			theTypeList: SFTypeList;
	begin
		StandardGetFile(nil, -1, theTypeList, stdReply);
		if (stdReply.sfGood) then						{ nicht abgebrochen }
			SendODOCToSelf(stdReply.sfFile);		{ Event an uns selbst }
	end;

{ Eigene Datenstrukturen initialisieren. Fenster existieren bereits }
	procedure InitUserGlobals;
		var
			Error, PrefVRefNum, refNum: Integer;
			PrefDirID, count: LongInt;
			PrefSpec: FSSpec;
		var
			picH: PicHandle;
			aRect: Rect;
	begin
{ Status-Screen updaten }
		setPort(gSplashScreen);
		ShowWindow(gSplashScreen);
		aRect := gSplashScreen^.VisRgn^^.rgnBBox;
{ Bereich ist gltig, da neu gezeichnet: }
		validRect(aRect);
		picH := GetPicture(kPicID);
		DrawPicture(picH, picH^^.picframe);

{ Preferences-Folder ausfindig machen und Preferences lesen bzw. anlegen }
		Error := FindFolder(kOnSystemDisk, kPreferencesFolderType, kCreateFolder, PrefVRefNum, PrefDirID);
		if FSMakeFSSpec(PrefVRefNum, PrefDirID, kPrefName, PrefSpec) <> 0 then
			begin
{ File existiert noch nicht: neue Prefs anlegen}
				ErrorAlert(kErrStringID, kFileErr, FSpCreate(PrefSpec, kCreator, kPrefType, -1));
				Error := FSpOpenDF(PrefSpec, fsCurPerm, refNum);
				gPrefs.PCKonv := false;
				gPrefs.Port := kPrintPortItem;
				count := sizeOf(gPrefs);
				Error := FSWrite(refNum, count, @gPrefs);
			end
		else
			begin
{ File existiert: alte Prefs lesen }
				Error := FSpOpenDF(PrefSpec, fsCurPerm, refNum);
				count := sizeOf(gPrefs);
				Error := FSRead(refNum, count, @gPrefs);
			end;
		Error := FSClose(refNum);
		gConAHandle := GetResource('ConA', kConAResNum);
		Hlock(gConAHandle);
		CheckItem(GetMenu(kOptionsNum), kDOSItem, gPrefs.PCKonv);
		CheckItem(GetMenu(kOptionsNum), kPrintPortItem, false);
		CheckItem(GetMenu(kOptionsNum), kModemPortItem, false);
		SetItemMark(GetMenu(kOptionsNum), gPrefs.Port, '');	{ Raute }
	end;

{ Wird kurz vor dem Beenden aufgerufen. Sollte }
{ Datenstrukturen entfernen, die oben installiert wurden }
	procedure DisposeUserGlobals;
		var
			Error, PrefVRefNum, refNum: Integer;
			PrefDirID, count: LongInt;
			PrefSpec: FSSpec;
	begin
{ Preferences-Folder ausfindig machen und Preferences schreiben }
		Error := FindFolder(kOnSystemDisk, kPreferencesFolderType, kCreateFolder, PrefVRefNum, PrefDirID);
		if FSMakeFSSpec(PrefVRefNum, PrefDirID, kPrefName, PrefSpec) = 0 then
			begin
				Error := FSpOpenDF(PrefSpec, fsCurPerm, refNum);
				count := sizeOf(gPrefs);
				Error := FSWrite(refNum, count, @gPrefs);
				Error := FSClose(refNum);
			end;

		if gConAHandle <> nil then
			begin
				HUnlock(gConAHandle);
				ReleaseResource(gConAHandle);
			end;
	end;
end.