#ifndef SOM_Module_redprt_Source
#define SOM_Module_redprt_Source
#endif
#define RedPart_Class_Source

#define VARIABLE_MACROS
#include "redprt.xih"

#define INCL_GPI
#define INCL_WIN
#define INCL_BASE
#define INCL_ODFACET
#define INCL_ODFRAME
#define INCL_ODSHAPE
#define INCL_ODTRANSFORM
#define INCL_ODFOCUSSET
#define INCL_ODSESSION
#define INCL_ODSTORAGEUNIT
#define INCL_ODDRAFT
#define INCL_ODCANVAS
#include <os2.h>

#define FIXED2LONG(f) (((f) + 0x8000) >> 16)
const ODType kRedPartValueType = "RedPart Data" ;
const ODType kKindRedPart      = "RedPart:redprt" ;

SOM_Scope void  SOMLINK redprtCommonInitRedPart(RedPart *somSelf,
                                                 Environment *ev)
{
    RedPartData *somThis = RedPartGetData(somSelf);
    RedPartMethodDebug("RedPart","redprtCommonInitRedPart");

    somSelf->CommonInitSimplePart (ev) ;
}

SOM_Scope void  SOMLINK redprtInitPart(RedPart *somSelf,  Environment *ev,
                                       ODStorageUnit* storageUnit)
{
    RedPartData *somThis = RedPartGetData(somSelf);
    RedPartMethodDebug("RedPart","redprtInitPart");

    if (somSelf->IsInitialized (ev))
      return ;

    somSelf->InitPersistentObject (ev, storageUnit) ;

    _count = 0 ;

    somSelf->CommonInitRedPart (ev) ;

    // RedPart_parent_SimplePart_InitPart(somSelf, ev, storageUnit);
}

SOM_Scope void  SOMLINK redprtInitPartFromStorage(RedPart *somSelf,
                                                   Environment *ev,
                                                  ODStorageUnit* storageUnit)
{
    RedPartData *somThis = RedPartGetData(somSelf);
    RedPartMethodDebug("RedPart","redprtInitPartFromStorage");

    if (somSelf->IsInitialized(ev))
      return ;

    somSelf->InitPersistentObjectFromStorage (ev, storageUnit) ;

    ODStorageUnit* su = somSelf->GetStorageUnit(ev);
    su->Focus (ev, kODPropContents, kODPosUndefined, kRedPartValueType, 0, kODPosUndefined);
    su->GetValue (ev, sizeof(long), (ODValue) &_count) ;

    somSelf->CommonInitRedPart (ev) ;

    // RedPart_parent_SimplePart_InitPartFromStorage(somSelf, ev,
    //                                               storageUnit);
}

SOM_Scope void  SOMLINK redprtExternalize(RedPart *somSelf,  Environment *ev)
{
    RedPartData *somThis = RedPartGetData(somSelf);
    RedPartMethodDebug("RedPart","redprtExternalize");

    ODStorageUnit* su = somSelf->GetStorageUnit(ev);
    su->AddProperty(ev, kODPropPart);
    su->AddValue(ev, kODISOStr);
    su->SetValue(ev, strlen(kKindRedPart) + 1, (ODValue) kKindRedPart);
    su->AddProperty(ev, kODPropContents);
    su->AddValue(ev, (ODValueType) kRedPartValueType);
    su->SetValue(ev, sizeof(long),  (ODValue) &_count);

    // RedPart_parent_SimplePart_Externalize(somSelf, ev);
}

SOM_Scope ODBoolean  SOMLINK redprtHandleEvent(RedPart *somSelf,
                                                Environment *ev,
                                               ODEventData* event,
                                               ODFrame* frame,
                                               ODFacet* facet)
{
    RedPartData *somThis = RedPartGetData(somSelf);
    RedPartMethodDebug("RedPart","redprtHandleEvent");

    if (event->msg == WM_BUTTON1DOWN)
      {
      _count ++ ;

      somSelf->GetStorageUnit(ev)->GetDraft(ev)->SetChangedFromPrev(ev) ;
      frame->Invalidate (ev, kODNULL) ;
      }
    return (RedPart_parent_SimplePart_HandleEvent(somSelf, ev,
                                                  event, frame,
                                                  facet));
}

SOM_Scope void  SOMLINK redprtDraw(RedPart *somSelf,  Environment *ev,
                                   ODFacet* facet, ODShape* invalidShape)
{
    RedPartData *somThis = RedPartGetData(somSelf);
    RedPartMethodDebug("RedPart","redprtDraw");

    ODBoolean drawing      = facet->GetCanvas(ev)->IsDynamic(ev);
    ODFrame * displayFrame = facet->GetFrame(ev);

    HPS hpsDraw = facet->GetCanvas(ev)->GetPlatformCanvas(ev);
    GpiSavePS(hpsDraw);

    HRGN frameRgn = displayFrame->GetFrameShape(ev)->GetRegion(ev);
    Rect frameRect;
    GpiQueryRegionBox(hpsDraw, frameRgn, &frameRect);

    // set up clipping
    HRGN saveClip;
    ODShape * clipShape = new ODShape;
    clipShape->CopyFrom(ev, facet->GetAggregateClipShape(ev));
    clipShape->Transform(ev, facet->GetContentTransform(ev));
    HRGN clip = clipShape->GetRegion(ev);
    GpiSetClipRegion(hpsDraw, clip, &saveClip);

    // paint the background

    GpiResetPS(hpsDraw, GRES_ATTRS);

    somSelf->SetGrafPortOrigin(ev, facet);

    GpiSetColor(hpsDraw, CLR_RED) ;
    POINTL ptl = {frameRect.xRight, frameRect.yTop};
    GpiBox(hpsDraw, DRO_FILL, &ptl, 0, 0);

    //GpiSetLineType(hpsDraw, LINETYPE_DASHDOUBLEDOT);
    GpiSetColor(hpsDraw, CLR_BLACK);
    POINTL ptlText = {10, 10};
    char szNumber [100] ;
    ltoa (_count, szNumber, 10) ;
    GpiCharStringAt (hpsDraw, &ptlText, strlen(szNumber), szNumber) ;

    GpiRestorePS(hpsDraw, -1);

    GpiSetClipRegion(hpsDraw, saveClip, (PHRGN)0);
    facet->GetCanvas(ev)->ReleasePlatformCanvas(ev);
    delete clipShape;

    // RedPart_parent_SimplePart_Draw(somSelf, ev, facet, invalidShape);
}

