#define INCL_DOS
#define INCL_PM
#include <os2.h>
#include <string.h>
#include "debug.h"
#include "generic.h"
#include "dlist.h"
#include "api.h"
#include "editor.h"

Dlist<Api *> DllList;

void _System EdSetColor(Editor *e, int color)
  {
  e->setColor(color);
  }

void _System EdAddToolbarButton(Editor *e, ActionFnPtr p, char *s1, char *s2,
           int id, HMODULE h, unsigned r)
  {
  e->addToolbarButton(p, s1, s2, id, h, r);
  //dprintf("Calling with: %p, %s, %s, %i", p, s1, s2, id);
  }

PFN vtable[]={
  (PFN)EdSetColor,
  (PFN)EdAddToolbarButton
};

void loadDll(char *name)
  {
  APIRET rc;
  char loadError[100];
  PFN fn1=0, fn2=0, fn3=0;
  HMODULE mod;

  rc=DosLoadModule((PSZ)loadError, 100, (PSZ)name, &mod);
  if (rc) return;

  DosQueryProcAddr(mod, 0, (PSZ)"ctEditInit", (PFN*)&fn1);
  DosQueryProcAddr(mod, 0, (PSZ)"ctNewName", (PFN*)&fn2);
  DosQueryProcAddr(mod, 0, (PSZ)"ctContextMenu", (PFN*)&fn3);
  if (!fn1 && !fn2 && !fn3)
     {
     DosFreeModule(mod);
     return;
     }
  Api *api=new Api(mod, (ApiInitFnPtr)fn1, (ApiFnPtr)fn2, (ApiFnPtr)fn3);

  DllList.append(api);
  }

void loadAllDll()
  {
  HDIR fh;
  FILEFINDBUF3 buf;
  ULONG fc,count;
  APIRET rc;
  char path[CCHMAXPATH];
  char fullname[CCHMAXPATH];
  char basepath[CCHMAXPATH];

  fc=1;
  fh=HDIR_CREATE;

  strcpy(basepath, "l:\\source\\edit2\\");
  strcpy(path, "*.DLL");

  rc=DosFindFirst((PSZ)path,&fh,0x37,(PFILEFINDBUF)&buf,(USHORT)sizeof(buf),&fc,1);

  for(;rc==0;rc=DosFindNext(fh,&buf,sizeof(buf),&fc))
     {
     char *name=buf.achName;
     strcpy(fullname, basepath);
     strcat(fullname, name);
     loadDll(fullname);
     }
  }

void CallDllInit()
  {
  for (void *p=DllList; p; p=DllList.next(p))
     {
     ApiInitFnPtr fnptr=DllList(p)->Init;
     if (fnptr)
        (*fnptr)(vtable);
     }
  }

void CallChangeName(Editor *e)
  {
  for (void *p=DllList; p; p=DllList.next(p))
     {
     ApiFnPtr fnptr=DllList(p)->newName;
     if (fnptr)
        (*fnptr)((void *)e, "hallo");
     }
  }
