#pragma strings (readonly)
#define INCL_DOS
#include <os2.h>
#include "dlist.h"
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>

DLockInit ilock;

void Blist::push(Dlink *p)
  {
  p->next=list;
  p->prev=0;

  if (list)
     list->prev=p;
  list=p;
  ++elem;
  if (!cursor)
     {
     cursor=list;
     curpos=0;
     }
  else
     ++curpos;
  }

Dlink *Blist::_get()
  {
  if (cursor==list)
     cursor=cursor->next;
  else
     {
     --curpos;
     if (curpos<0)
        {
        curpos=0;
        cursor=list;
        }
     }
  Dlink *first=list;
  list=list->next;
  --elem;
  return first;
  }

Dlink *Blist::last()
  {
  Dlink *p, *n;
  for (p=cursor; p; p=n)
     if (!(n=p->next))
        {
        return p;
        }
  return 0;
  }

void Blist::append(Dlink *p)
  {
  if (list)
     {
     Dlink *l=last();
     cursor=l->next=p;
     p->prev=l;
     curpos=elem;
     elem++;
     }
  else
     {
     cursor=list=p;
     elem=1;
     curpos=0;
     }
  }

Dlink* Blist::insert(Dlink *p, int no)
  {
  if (!list)
     {
     push(p);
     }
  else
     {
     int i=0;
     for (Dlink *l=list; i<no && l && l->next; l=l->next, i++)
        ;
     p->next=l->next;
     if (l->next)
        l->next->prev=p;
     l->next=p;
     p->prev=l;
     elem++;
     curpos=0;
     cursor=list;
     }
  return p;
  }

void Blist::remove(int no)
  {
  _remove(_nelem(no));
  curpos=0;
  cursor=list;
  }

void Blist::_remove(Dlink *p)
  {
  if (p==list)
     list=list->next;
  else
     {
     if (p->prev)
        p->prev->next=p->next;
     if (p->next)
        p->next->prev=p->prev;
     }
  --elem;
  if (p==cursor)
     {
     cursor=list;
     curpos=0;
     }
  delete p;
  }

Dlink *Blist::_nelem(int i)
  {
  if (i>curpos)
     {
     do {
        cursor=cursor->next;
        curpos++;
     } while (i>curpos);
     return cursor;
     }
  while (i<curpos)
     {
     cursor=cursor->prev;
     curpos--;
     }
  return cursor;
  }

void Blist::forAll(void (*f)(Dlink*))
  {
  for (Dlink *p=list; p; p=p->next)
     (*f)(p);
  }

void Blist::clear()
  {
  }
