#ifndef _EDITOR_H_
#define _EDITOR_H_

#include <stdio.h>

#include "action.h"
#include "string.h"
#include "toolbar.h"
#include "statbar.h"
#include "menu.h"
#include "edit.h"
#include "ctedit.h"

void initDefaultAction(ActionList& list);
extern void save(HWND hwnd, char *name);
extern void load(HWND hwnd, char *name);
BOOL loadMLE(HWND hwnd, char *name);

class Editor
  {
    HWND       frame;
    HWND       toolbar;
    HWND       mle;
    HWND       statusbar;
    EString    name;
    ActionList actionlist;
    FATTRS     mfont;
    FATTRS     pfont;
    BOOL       font;                         /* monospaced oder proportional */
    BOOL       showToolbar;
    BOOL       indent;
    BOOL       quickmark;
    int        maxline;
    int        curline;
    int        modified;
    int        updateStatus;
    int        current_id;
    int        curcol;
  public:
    Editor();
    char *queryName() { return (char *)name; }
    char *setName(char *x) { name=x; return (char *)name; }
    Action *queryAction(unsigned id) { return actionlist[id]; }
    char *queryHelptext(unsigned id);
    HWND queryFrame() { return frame; }
    HWND queryToolbar() { return toolbar; }
    HWND queryMle()   { return mle; }
    void setFrame(HWND h) { frame=h; }
    void setToolbar(HWND h) { toolbar=h; }
    void setStatusbar(HWND h) { statusbar=h; }
    void setMle(HWND h)   { mle=h; }
    void setFonttype(BOOL b) { font=b; }
    BOOL queryFonttype() { return font; }
    void setStatusText(char *s)
        { WinSendMsg(statusbar, SB_SETTEXT, (MPARAM)s, 0); }
    void setConditionalMenu(int submenuid, int defaultid)
        { ::setConditionalMenu(frame, submenuid, defaultid); }
    void setMenuChecked(int id, BOOL set=TRUE)
        { ::setMenuChecked(frame, id, set); }
    void setMaxLine(int i)
        { updateStatus=updateStatus || (i!=maxline); maxline=i; }
    void setCurLine(int i)
        { updateStatus=updateStatus || (i!=curline); curline=i; }
    void setCurColumn(int i)
        { updateStatus=updateStatus || (i!=curcol); curcol=i; }
    void setModified(int i)
        { updateStatus=updateStatus || (i!=modified); modified=i; }
    void updateStatusline(int force=FALSE);
    void setColor(int color)
        { WinPostMsg(mle, MLM_SETBACKCOLOR, (MPARAM)color, 0); }
    FATTRS& queryMonoFont() { return mfont; }
    FATTRS& queryPropFont() { return pfont; }
    void setIndent(BOOL b) { indent=b; setMenuChecked(ID_MENUITEM_INDENT, b); }
    BOOL queryIndent() { return indent; }
    void setQuickmark(BOOL b) { quickmark=b; setMenuChecked(ID_MENUITEM_QUICKMARK, b); }
    BOOL queryQuickmark() { return quickmark; }
    int addToolbarButton(ActionFnPtr p, char *s1, char *s2,
                         int id=0, HMODULE h=0, unsigned r=0);
    void save() { ::save(queryMle(), queryName()); }
    void load(char *s) { setName(s);
                       ::loadMLE(queryMle(), s);
                       WinPostMsg(queryFrame(), UM_CHANGENAME, 0, 0);
                       }
    void loadini();
    void saveini();
  };

#endif
