#define INCL_DOS
#define INCL_PM
#include <os2.h>
#include <ctype.h>
#include "debug.h"
#include "Editor.h"
#include "ctedit.h"
#include "statbar.h"
#include "mle.h"

extern PFNWP pfn;
extern "C" MRESULT EXPENTRY mleCtEditorProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
extern "C" PFNWP APIENTRY WinSubclassWindow(HWND, PFNWP);
void save(HWND hwnd, char *name);

extern HWND lastButton;

void SubClassMle(HWND mle)
  {
  pfn=WinSubclassWindow(mle, mleCtEditorProc);
  }

extern "C" MRESULT EXPENTRY mleCtEditorProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
  {
  return extMleProc(hwnd, msg, mp1, mp2);
  }

extern "C" MRESULT EXPENTRY ctEditorProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
  {
  unsigned id;
  Action *action;
  char *newname;

  Editor *edit=(Editor *)WinQueryWindowPtr(hwnd, QWL_USER);
  HWND frame=edit->queryFrame();

  if (!edit)
     return FALSE;

  if (msg==WM_SAVEAPPLICATION)
     {
     if (WinSendMsg(edit->queryMle(), MLM_QUERYCHANGED, 0, 0))
        {
        if (WinMessageBox(HWND_DESKTOP, HWND_DESKTOP,
            (PSZ)"Achtung, die Datei wurde gendert. Wollen Sie "
                 "die Datei speichern?", "Achung",
                 0, MB_OKCANCEL) ==MBID_OK)
           {
           save(edit->queryMle(), edit->queryName());
           }
        }
     }

  switch(msg)
     {
     case WM_COMMAND:
        id=(unsigned)SHORT1FROMMP(mp1);
        action=edit->queryAction(id);
        if (action)
           action->action(hwnd);
        break;
     case WM_CONTROL:
        lastButton=0;
        break;
     case UM_SHOW:
        WinShowWindow(edit->queryFrame(), TRUE);
        WinShowWindow(hwnd, TRUE);
        break;
     case UM_CHANGENAME:
        newname=edit->queryName();
        WinSetWindowText(frame, newname);
        break;
     }
  return FALSE;
  }

extern "C" void ctSetHelptext(HWND frame, ULONG msg, MPARAM mp1, MPARAM mp2)
  {
  Editor *edit=(Editor *)WinQueryWindowPtr(frame, QWL_USER);
  HWND statusbar=WinWindowFromID(frame, FID_STATUSBAR);

  WinSendMsg(statusbar, SB_SETTEXT, (MPARAM)edit->queryHelptext(SHORT1FROMMP(mp1)), 0);
  }
