#define INCL_PM
#define INCL_DOS
#define INCL_BASE
#include <os2.h>
#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#ifndef WC_CIRCULARSLIDER
 #define WC_CIRCULARSLIDER    ((PSZ)0xffff0041L)
#endif
#ifndef PMERR_OK
 #define PMERR_OK             0
#endif
#include "errcodes.h"
#include "debug.h"



static void queryThreadInfo(PID *pid, TID *tid, HMODULE *hmod, ULONG *type)
  {
  PTIB t;
  PPIB p;

  DosGetInfoBlocks(&t, &p);
  *pid  = p->pib_ulpid;
  *tid  = t->tib_ptib2->tib2_ultid;
  *hmod = p->pib_hmte;
  *type = p->pib_ultype;
  }

static PID queryPID(void)
  {
  PID pid;
  TID tid;
  HMODULE hmod;
  ULONG type;

  queryThreadInfo(&pid, &tid, &hmod, &type);
  return pid;
  }

static char *lower(char *s)
  {
  for (;*s;s++) *s=(*s>='A'&& *s<='Z') ? *s+('a'-'A') : *s;
     return s;
  }

static HFILE doutput=-2;

void debug_initialize(void)
  {
  char *output;

  if (DosScanEnv((PSZ)"DEBUG", (PSZ*)&output)==0 && *output!=0)
     {
     ULONG action;

     lower(output);

     if (!strcmp(output, "stdout"))
        doutput=1;
     if (!strcmp(output, "stderr"))
        doutput=2;
     if (!strcmp(output, "msgbox"))
        doutput=-1;
     if (!strcmp(output, "watchcat"))
        {
        if (DosOpen("\\PIPE\\WATCHCAT",
                &doutput, &action,
                0, FILE_NORMAL, FILE_OPEN,
                OPEN_ACCESS_READWRITE|OPEN_SHARE_DENYNONE, 0))
           doutput=0;
        }
     if (!strcmp(output, "pipe"))
        {
        if (DosOpen("\\PIPE\\DEBUG",
                &doutput, &action,
                0, FILE_NORMAL, FILE_OPEN,
                OPEN_ACCESS_READWRITE|OPEN_SHARE_DENYNONE, 0))
           doutput=0;
        }
     if (!strcmp(output, "ignore"))
        doutput=0;
     }
  else
     {
     /* Finde selbst heraus, welche Ausgabeart die beste ist */
     PID pid;
     TID tid;
     HMODULE hmod;
     ULONG type, action;

     queryThreadInfo(&pid, &tid, &hmod, &type);
     switch(type)
        {
        case 0: /* Fullscreen -> stderr*/
        case 2:
                doutput=2;
                break;
        case 3: /* PM -> msgBox */
                doutput=-1;
                break;
        case 4: /* detached -> pipe */
                if (DosOpen("\\PIPE\\DEBUG",
                        &doutput, &action,
                        0, FILE_NORMAL, FILE_OPEN,
                        OPEN_ACCESS_READWRITE|OPEN_SHARE_DENYNONE, 0))
                   doutput=0;
        default: /* ???? */
                doutput=0;
        }
     }
  }

void debug_output(char *msg)
  {
  if (doutput==-2)
     {
     debug_initialize();
     printf("init: %i\r\n", doutput);
     }
  if (doutput==0)
     return;
  else if (doutput==-1)
     WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, msg, "Debug", 100, MB_OK|MB_MOVEABLE);
  else
     {
     ULONG written;
     DosWrite(doutput, msg, strlen(msg), &written);
     }
  }

void dprintf(char *format, ...)
  {
  va_list arglist;
  char buffer[1024];

  va_start(arglist, format);
  vsprintf(buffer, format, arglist);
  debug_output(buffer);
  va_end(arglist);
  }

void _debug_ensure(int x, char *expr, char *f, char *file, int line)
  {
  if (!x)
     dprintf("failed: %s in %s, (%s,%i)\n", expr, f, file, line);
  }

void _debug_valid_ptr(void *p, char *ptr, char *f, char *file, int line)
  {
  unsigned long flags, size;
  unsigned long rc;

  if (p==0)
     {
     dprintf("null-pointer : %s in %s, (%s, %i)\r\n",
                              ptr, f, file, line);
     return;
     }

  rc=DosQueryMem(p, &size, &flags);
  if (rc==487)
     {
     dprintf("inv. address : %s, %s==%p in %s (%s,%i)\r\n",
                              ptr, ptr, p, f, file, line);
     return;
     }
  if (  (flags&(0x1|0x2|0x10)) != (0x1|0x2|0x10))
     {
     char msg[80];
     sprintf(msg, "ptr invalid  : %s, %s==%p, in %s (%s, %i); \r\n",
                              ptr, ptr, p, f, file, line);
     if (flags&0x1)     strcat(msg, "read ");
     if (flags&0x2)     strcat(msg, "write ");
     if (flags&0x8)     strcat(msg, "guard ");
     if (flags&0x10)    strcat(msg, "commit ");
     if (flags&0x4000)  strcat(msg, "free ");
     if (flags&0x2000)  strcat(msg, "shared ");
     if (flags&0x10000) strcat(msg, "base ");
     debug_output(msg);
     }
  };

static TID queryTID(void)
  {
  PID pid;
  TID tid;
  HMODULE hmod;
  ULONG type;

  queryThreadInfo(&pid, &tid, &hmod, &type);
  return tid;
  }

int checkPM(HWND hwnd, char *fun, char *file, int line)
  {
  HAB hab;
  ERRORID errid;
  char msg_buffer[1024], hwnd_buffer[80], cls[32];

  hab=WinQueryAnchorBlock(HWND_DESKTOP);
  errid=WinGetLastError(hab);

  if (ERRORIDERROR(errid)!=PMERR_OK)
     {
     char *msg="n/a";

     PERRINFO perrinfo=WinGetErrorInfo(hab);
     if (perrinfo)
        {
        USHORT *offset=(USHORT *)((char *)perrinfo+perrinfo->offaoffszMsg);
        msg=(char *)perrinfo+*offset;
        }
     if (hwnd==0)
        strcpy(hwnd_buffer, "");
     else
        {
        if (!WinQueryClassName(hwnd, 20, cls))
           strcpy(cls, "???");
        cls[31]=0;
        sprintf(hwnd_buffer, "Handle:     %x (%s) ", hwnd, cls);
        strcat(hwnd_buffer, WinIsWindow(hab, hwnd) ? "valid " : "invalid ");
        if (WinIsWindow(hab, hwnd))
           strcat(hwnd_buffer, WinIsWindowVisible(hwnd) ? "visible " : "invisible ");
        strcat(hwnd_buffer, "\r\n");
        }

     sprintf(msg_buffer,
            "[%s(%s,%i)] - PID:%x TID:%i\r\n"
            "PM-Error  : %s (%x)\r\n"
            "Error sev : %s (%x)\r\n"
            "%s"
            "Message   : %s\r\n",
                fun, file, line, queryPID(), queryTID(),
                pmerror(ERRORIDERROR(errid)),
                (int)ERRORIDERROR(errid),
                pmsev(ERRORIDSEV(errid)),
                (int)pmsev(ERRORIDSEV(errid)),
                hwnd_buffer,
                msg);
     debug_output(msg_buffer);
     return FALSE;
     }
  else
     return TRUE;
  }

void _debug_winhandle(HWND hwnd, char *fun, char *file, char *line)
  {
  HAB hab;
  char hwnd_buffer[80], cls[32];

  hab=WinQueryAnchorBlock(HWND_DESKTOP);
  if (!WinQueryClassName(hwnd, 20, cls))
     strcpy(cls, "???");
  cls[31]=0;
  dprintf("[%s(%s,%i)] - PID:%x TID:%i\r\n"
           "Handle:     %x (%s) %s%s\r\n\r\n",
           fun, file, line, queryPID(), queryTID(),
           hwnd, cls,
           WinIsWindow(hab, hwnd) ? "valid " : "invalid "),
           (WinIsWindow(hab, hwnd) && WinIsWindowVisible(hwnd)
                                  ? "visible " : "invisible ");
  }

void _debug_winmsg(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2, char *fun, char *file, int line)
  {
  HAB hab;
  char hwnd_buffer[80], cls[32], msg_buffer[40];
  char buffer[1024];

  hab=WinQueryAnchorBlock(HWND_DESKTOP);
  if (!WinQueryClassName(hwnd, 20, cls))
     strcpy(cls, "???");
  cls[31]=0;

  if (msg>WM_USER)
     sprintf(msg_buffer, "WM_USER+%i", msg-WM_USER);
  else
     strcpy(msg_buffer, querywmessage(msg));

  sprintf(buffer, "[%s(%s,%i)] - PID:%x TID:%i\r\n"
           "Handle:     %x (%s) %s%s\r\n"
           "Message:    %s (%x)\r\n"
           "mp1:        %x (dec. %i)\r\n"
           "mp2:        %x (dec. %i)\r\n\r\n",
           fun, file, line, queryPID(), queryTID(),
           hwnd, cls,
           WinIsWindow(hab, hwnd) ? "valid " : "invalid ",
           (WinIsWindow(hab, hwnd) && WinIsWindowVisible(hwnd))
                                  ? "visible " : "invisible ",
           msg_buffer, msg,
           mp1, mp1, mp2, mp2);
  debug_output(buffer);
  }

int checkDOS(APIRET rc, char *fun, char *file, int line)
  {
  ULONG cl, action, locus;
  char msg_buffer[1024];

  if (DosErrClass(rc,&cl, &action, &locus))
     printf("error in error");
  else
     {
     ULONG len;
     char buffer[160];
     APIRET rcm;

     rcm=DosGetMessage(0,0, (UCHAR *)buffer, 158, rc, "OSO001.MSG", &len);
     if (rcm==0 || rcm==316)
        buffer[len]=0;
     else
        strcpy(buffer, "n/a");

     sprintf(msg_buffer,
            "[%s(%s,%i)] - PID:%x TID:%i\r\n"
            "Base-Error: %s (%i)\r\n"
            "Class:      %s\r\n"
            "Action:     %s\r\n"
            "Msg:        %s\r\n",
              fun, file, line, queryPID(), queryTID(),
              doserror(rc), rc,
              queryClass(rc),
              queryAction(rc),
              buffer);
     debug_output(msg_buffer);
     }
  return rc;
  }

#ifdef TEST
void main()
  {
  APIRET rc;
  void *p=(void *)123;

  _debug_valid_ptr(p, "p", __FUNCTION__, __FILE__, __LINE__);
  WinInitialize(0);
  WinCreateMsgQueue(0,0);
  CHECKPM(123);
  rc=DosCopy("1", "3", 0);
  /*BREAKPOINT;*/
  printf("DosBeep: %i\r\n", rc);
  CHECKDOS(rc);
  CHECKMSG((HWND)387, WM_BUTTON1DOWN, (MPARAM)8, (MPARAM)9);
  }
#endif
