#define INCL_DOS
#define INCL_PM
#include <os2.h>
#include "toolbar.h"
#include "statbar.h"
#include "debug.h"
#include "ctedit.h"

MRESULT EXPENTRY newFrameWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
extern "C" void ctSetHelptext(HWND frame, ULONG msg, MPARAM mp1, MPARAM mp2);

static PFNWP oldFrameProc;
PFNWP APIENTRY WinSubclassWindow(HWND, PFNWP);

/* Define the new frame window proc */
extern "C" HWND EnhWinCreateStdWindow(HWND    hwndParent,
                           ULONG   flStyle,
                           PULONG  flags,
                           PSZ     clientClass,
                           PSZ     title,
                           ULONG   styleClient,
                           HMODULE hmod,
                           ULONG   id,
                           PHWND   hwndClient,
                           void    *parameter
                           )
  {
  FRAMECDATA fcd;
  HWND hwndFrame;

  fcd.cb=sizeof(FRAMECDATA);
  fcd.flCreateFlags=*flags;
  fcd.hmodResources=hmod;
  fcd.idResources=id;

  registerToolbar(0);

  hwndFrame=WinCreateWindow(HWND_DESKTOP,
                            WC_FRAME,
                            title,
                            0,0,0,0,0,
                            0,
                            HWND_TOP,
                            id,
                            &fcd,
                            0);
  WinCreateWindow(hwndFrame,
                  "ctToolbar",
                  "",
                  0,10,10,10,50,
                  hwndFrame,
                  HWND_TOP,
                  FID_TOOLBAR,
                  0,
                  0);
  WinCreateWindow(hwndFrame,
                  "ctStatusbar",
                  "Statusbar",
                  0,0,0,0,0,
                  hwndFrame,
                  HWND_TOP,
                  FID_STATUSBAR,
                  0,
                  0);

  *hwndClient=WinCreateWindow(hwndFrame,
                              clientClass,
                              0,
                              MLS_HSCROLL|MLS_VSCROLL,
                              0,0,0,0,
                              hwndFrame,
                              HWND_BOTTOM,
                              FID_CLIENT,
                              0,0);
  oldFrameProc=WinSubclassWindow(hwndFrame, newFrameWndProc);

  WinSetWindowPtr(hwndFrame, QWL_USER, parameter);
  return hwndFrame;
  }

MRESULT EXPENTRY newFrameWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
  {
  HWND hwndToolbar;
  MRESULT result, mr;

  if (msg>=WM_USER || msg==WM_SAVEAPPLICATION)
     return ctEditorProc(hwnd, msg, mp1, mp2);

  switch(msg)
     {
     case WM_CALCFRAMERECT:
       result= (*oldFrameProc)(hwnd, msg, mp1, mp2);

       if (result && mp2)
          {
          PRECTL prectl;
          prectl = (PRECTL) mp1;
          prectl->yTop-=   (40+20);
          prectl->yBottom+=20;
          }
       return result;

     case WM_FORMATFRAME:
       {
       SHORT countSwp;
       int i;
       PRECTL prectl;
       PSWP  pswp, pswpClient=0, pswpToolbar=0, pswpStatusbar=0;
       SWP tmpSwp;
       BOOL toolbarVisible;
       int cy;
       SWP  swp, *sav;

       toolbarVisible=WinIsWindowVisible(WinWindowFromID(hwnd, FID_TOOLBAR));

       countSwp = (int) (*oldFrameProc)(hwnd, msg, mp1, mp2);

       /*
        * Reformat the frame to move the client
        * over and make room for the his/her sibling.
        */
       pswp=(PSWP)mp1;

       WinQueryWindowPos(WinWindowFromID(hwnd, FID_TOOLBAR), &swp);
       cy=swp.cy;

/*
       pswpClient=&pswp[countSwp-1];
       pswpToolbar=&pswp[countSwp];
       pswpStatusbar=&pswp[countSwp+1];

       *pswpToolbar = *pswpClient;
       *pswpStatusbar = *pswpClient;
*/

      sav=pswpToolbar=&pswp[countSwp-1];
      pswpStatusbar=&pswp[countSwp];
      pswpClient=&pswp[countSwp+1];

      *pswpStatusbar = *sav;
      *pswpClient = *sav;

       pswpClient->y  += 20;
       pswpClient->cy -= 20+cy;

       pswpToolbar->hwnd=WinWindowFromID(hwnd, FID_TOOLBAR);
       pswpToolbar->y  = (pswpClient->y+pswpClient->cy);
       pswpToolbar->cy = cy/*50*/;

       pswpStatusbar->hwnd=WinWindowFromID(hwnd, FID_STATUSBAR);
       pswpStatusbar->y  = pswpClient->y - 20;
       pswpStatusbar->cy = 20;
       return MRFROMSHORT(countSwp+2);
       }

     case WM_QUERYFRAMECTLCOUNT:
       return MRFROMSHORT((ULONG)((*oldFrameProc)(hwnd, msg, mp1, mp2))+2);

     case WM_COMMAND:
     case WM_CONTROL:
        return ctEditorProc(hwnd, msg, mp1, mp2);
     case WM_MENUSELECT:
        ctSetHelptext(hwnd, msg, mp1, mp2);
        return (MRESULT)TRUE;
     default:
        return (*oldFrameProc)(hwnd, msg, mp1, mp2);

     }
  return FALSE;
  }
