unit UWfWNet;

interface

uses WinTypes, SysUtils, Dialogs;

const
  (* Mailslot Fehlerkonstanten  *)
  NERR_Success		           = 0;
  NERR_BASE                         = 2100;
  NERR_AlreadyExists	           = NERR_BASE+176;

  ERR_SEM_TIMEOUT                  = 109;

  MAILSLOT_NO_TIMEOUT   =  -1;
  MAILSLOT_MAX_MSG_SIZE	= 65475;

  (* Konstanten fr WNetGetCaps *)
  WNNC_NET_TYPE             = $0002;
  WNNC_NET_MultiNet         = $8000;
  WNNC_SUBNET_WinWorkgroups = $0004;


type
  TMSHandle = THandle;

Function DosMakeMailslot ( const pszName        : PChar;
                           const cbMessageSize  : Word;
                           const cbMailslotSize : Word;
                           var   hMailslot      : TMSHandle)
                         : Word;
                         far;

function DosDeleteMailslot ( const hMailslot    : TMSHandle)
                           : Word ;
                           far;

function DosMailslotInfo ( const hMailslot      : TMSHandle;
                           var   cbMessageSize  : Word;
                           var   cbMailslotSize : Word;
                           var   cbNextSize     : Word;
                           var   usNextPriority : Word;
                           var   cMessages      : Word)
                         : Word;
                         far;

Function DosPeekMailslot ( const hMailslot      : TMSHandle;
                                 pbBuffer       : PChar;
                           var   cbReturned     : Word;
                           var   cbNextSize     : Word;
                           var   usNextPriority : Word)
                         : Word;
                         far;

function DosReadMailslot ( const hMailslot      : THandle;
                                 pbBuffer       : PChar;
                           var   cbReturned     : Word;
                           var   cbNextSize     : Word;
                           var   usNextPriority : Word;
                           const cTimeout       : LongInt)
                         : Word;
                         far;

Function DosWriteMailslot ( const pszName    : PChar;
                            const pbBuffer   : Pointer;
                            const cbBuffer   : Word;
                            const usPriority : Word;
                            const usClass    : Word;
                            const cTimeout   : LongInt)
                          : Word;
                          far;

function GetWSName:PChar;
function GetWGName:PChar;
function GetDomainName:PChar;
function GetUserName:PChar;

function WNetGetError(var nError : Integer):Word; far;
function WNetGetErrorText(const nError : Integer;
                                pszBuffer : PChar;
                          var   bufSize   : Integer):Word;
         far;

function WNetGetCaps(index : word):word; far;

implementation

function DosMakeMailslot;   external 'netapi';
function DosWriteMailslot;  external 'netapi';
function DosReadMailslot;   external 'netapi';
function DosDeleteMailslot; external 'netapi';
function DosMailslotInfo;   external 'netapi';
function DosPeekMailslot;   external 'netapi';

function NetWkstaGetInfo(const pszServer : PChar;
                         const sLevel    : Word;
                               pbBuffer  : PChar;
                         const cbBuffer  : Word;
                         var   cbTotalAvail:Word):word; far;
         external 'netapi';

function WNetGetError(var nError : Integer):Word;
         external 'USER.EXE';

function WNetGetErrorText(const nError : Integer;
                                pszBuffer : PChar;
                          var   bufSize   : Integer):Word;
         external 'USER.EXE';

function WNetGetCaps(index : word):word;
         external 'USER.EXE';

type
  WSinfo_10 = record
    ComputerName,
    UserName,
    WorkGroup : PChar;
    verMajor, verMinor : byte;
    Domain,
    reserved : PChar;
  end;

function GetWSName:PChar;
var
  p     : Pointer;
  count : Word;
  error : integer;
begin
  GetMem(p,8192);
  if NERR_SUCCESS = NetWkstaGetInfo(nil, 10, p, 8192, count)
  then result:=StrNew(WSInfo_10(p^).ComputerName)
  else result:=nil;
  FreeMem(p,8192);
end;

function GetWGName:PChar;
var
  p     : Pointer;
  count : Word;
begin
  GetMem(p,8192);
  if NERR_SUCCESS = NetWkstaGetInfo(nil, 10, p, 8192, count)
  then result:=StrNew(WSInfo_10(p^).WorkGroup)
  else result:=nil;
  FreeMem(p,8192);
end;

function GetUserName:PChar;
var
  p     : Pointer;
  count : Word;
begin
  GetMem(p,8192);
  if NERR_SUCCESS = NetWkstaGetInfo(nil, 10, p, 8192, count)
  then result:=StrNew(WSInfo_10(p^).UserName)
  else result:=nil;
  FreeMem(p,8192);
end;

function GetDomainName:PChar;
var
  p     : Pointer;
  count : Word;
begin
  GetMem(p,8192);
  if NERR_SUCCESS = NetWkstaGetInfo(nil, 10, p, 8192, count)
  then result:=StrNew(WSInfo_10(p^).Domain)
  else result:=nil;
  FreeMem(p,8192);
end;

end.
