// Eine Klasse fr eine Menge gleichartiger Manipulatoren

#include <iostream.h>

// -------- gemeinsamer Teil fr alle Manipulatoren ---------------
class OMI {
public:
  typedef int Arg;
  typedef ostream& (*Fkt)(ostream&, Arg);
  OMI(Fkt ff, Arg aa) : f(ff), a(aa) {}
  friend ostream& operator<<(ostream& os, const OMI& omi) {
    return omi.f(os, omi.a);
  }
private:
  const Fkt f;
  const Arg a;
};

// -------- Definition des space-Manipulators ---------------------
ostream& spaces(ostream& os, int n) {
  for (int i=0; i<n; i++)
    os << ' ';
  return os;
}

inline OMI space(int n) { return OMI(spaces, n); }

int main() {
  cout << "0123456\n";
  cout << '#' << space(5) << '#' << endl;
  return 0;
}
