/******************************************************************************\
*                                                                              *
*  c't OS/2 Editor v0.7                                                        *
*                                                                              *
*  Modul:     aclient.c                                                        *
*  Aufgabe:   Toolbar, Statusbar, MLE im Clientbereich anlegen                 *
*             (nur zur Demonstration; Framecontrols sind vorzuziehen)          *
*             [wird nicht mehr benutzt!!]                                      *
\******************************************************************************/
#include "common.h"
#pragma hdrstop
#include "toolbar.h"
#include "statbar.h"
#include "ctedit.h"
#include "debug.h"

MRESULT EXPENTRY clientWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);

#define ID_TOOLBAR   100
#define ID_STATUSBAR 101
#define ID_MLE       102

extern HAB hab;


/* Name     : EnhClientWinCreateStdWindow
** Task     : CLient mit Toolbar, Statusbar machen
** Input    : etwa wie WinCreateStdWindow
** Output   : Frame handle (wie WinCreateStdWindow)
*/
HWND EnhClientWinCreateStdWindow(HWND    hwndParent,
                           ULONG   flStyle,
                           PULONG  flags,
                           PSZ     clientClass,
                           PSZ     title,
                           ULONG   styleClient,
                           HMODULE hmod,
                           ULONG   id,
                           PHWND   hwndClient)
  {
  HWND hwndFrame;                               /* Frame handle               */
  static BOOL registered=FALSE;                 /* schon registriert?         */
  static char classname[]="ctEnhClient";        /* Name der Client-Klasse     */

  /* Registrieren der Client window procedure, sofern noch nicht geschehen */
  if (!registered)
      {
      WinRegisterClass(hab, classname, clientWndProc, CS_SIZEREDRAW, 0);
      registered=TRUE;                          /* ok, jetzt registriert      */
      } /* endif: !registered */

  /* Client "normal" per WinCreateStdWindow erzeugen */
  hwndFrame=WinCreateStdWindow(hwndParent, flStyle, flags, classname,
                             title, styleClient, hmod, id, hwndClient);

  /* gib' Frame handle zurck */
  return hwndFrame;
  } /* EnhClientWinCreateStdWindow */



/* Name     : clientWndProc
** Task     : Client window procedure
** Input    : HWND hwnd                 - window handle
              ULONG msg                 - message
              MPARAM mp1                - parameter 1
              MPARAM mp2                - parameter 2
** Output   : gem window procedure
*/
MRESULT EXPENTRY clientWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
  {
  /* Handle zu den drei childs. (Knnen - bei WM_CREATE od. Fehler auch 0 sein*/
  HWND hwndToolbar  =WinWindowFromID(hwnd, ID_TOOLBAR);
  HWND hwndStatusbar=WinWindowFromID(hwnd, ID_STATUSBAR);
  HWND hwndMLE      =WinWindowFromID(hwnd, ID_MLE);

  /* WM_COMMAND (Push-Buttons, Men) und WM_CONTROL(sonstige Controls) abfang.*/
  if (msg==WM_COMMAND || msg==WM_CONTROL)
     {
     return ctEditorProc(hwnd, msg, mp1, mp2);
     } /* endif: msg==WM_COMMAND || msg==WM_CONTROL */

  /* Hier nun die Message auswerten */
  switch(msg)
     {
    /* WM_CREATE wird bei der Erzeugung des Fensters geschickt */
    case WM_CREATE:
        /* Mache MLE */
        WinCreateWindow(hwnd, WC_MLE, (PSZ)"",
                        WS_VISIBLE | MLS_HSCROLL | MLS_VSCROLL,
                        10, 0, 455, 101,
                        hwnd, HWND_TOP, ID_MLE, 0L, NULL);
        /* Mache Toolbar */
        WinCreateWindow(hwnd, "ctToolbar", (PSZ)"",
                        WS_VISIBLE,
                        0, 0, 0, 0,
                        hwnd, HWND_TOP, ID_TOOLBAR, 0L, NULL);
        /* Mache Statusbar */
        WinCreateWindow(hwnd, "ctStatusbar", (PSZ)"ctStatusbar",
                        WS_VISIBLE,
                        0, 0, 0, 0,
                        hwnd, HWND_TOP, ID_STATUSBAR, 0L, NULL);
        /* Alle obigen Fenster sind childs. Man braucht sich die      */
        /* Handles daher nicht zu merken, sondern kann sie per ID_... */
        /* erfragen.                                                  */
        break;
    /* WM_SIZE wird geshickt, wenn sich die Gre eines Fensters verndert */
    case WM_SIZE:
         {
         int cx=SHORT1FROMMP(mp2);              /* Breite des Fensters        */
         int cy=SHORT2FROMMP(mp2);              /* Hhe des fensters          */

         /* Positioniere alle Childs neu. Das ist das Wichtige (Problem)      */
         /* bei diesem Ansatz: Alle Fenster mssen immer wieder neu           */
         /* positioniert werden */
         WinSetWindowPos(hwndToolbar,   HWND_TOP, 0,cy-TOOLBAR_HEIGHT,cx,TOOLBAR_HEIGHT,SWP_MOVE|SWP_SIZE|SWP_ZORDER);
         WinSetWindowPos(hwndMLE,       HWND_TOP, 0,   20,cx, cy-(TOOLBAR_HEIGHT+20), SWP_MOVE|SWP_SIZE|SWP_ZORDER);
         WinSetWindowPos(hwndStatusbar, HWND_TOP, 0,    0,cx,    20, SWP_MOVE|SWP_SIZE|SWP_ZORDER);
         } /* endswitch: msg */
       break;
     /* appl. spezifisch */
     case WM_USER:
        return (MRESULT)hwndToolbar;
     /* Sonst: WinDefWindowProc */
     default:
       return WinDefWindowProc(hwnd,msg,mp1,mp2);
     } /* clientWndProc */
  return FALSE;
  }
