(* Packen von dBase-Dateien unter Delphi 1.0 fr Windows   *)
(* Unit mit zwei Kapselungen der BDE-Funktion dbiPackTable *)
(* Ingo T. Storm // c't 12/95                              *)
Unit UPack;

(* Diese beiden Funktionen kapseln die BDE-Funktion
(* function DbiPackTable (                                            *)
(*   hDb           : hDBIDb;   Datenbank-Handle                       *)
(*   hCursor       : hDBICur;  ENTWEDER - Cursor (TTable.handle)      *)
(*   pszTableName  : PChar;    ODER 1. Table name (PChar)             *)
(*   pszDriverType : PChar;     UND 2. Driver type ('STANDARD' o. nil)*)
(*   bRegenIdxs    : Bool      Indizes regenerieren?                  *)
(*   ): DBIResult;                                                    *)

interface

uses Classes, DB, DBTables, DBITypes, DBIErrs;

(* dBase-Tabelle aus aktuellem Projekt packen *)
function  PackTableInternal( const Table: TTable): DBIResult;

(* packt eine dBase-Tabelle, die nicht zum Projekt gehrt *)
function  PackTableByName( const Owner : TComponent;
                           const AnAliasName : string;
                           const ATableName : string): DBIResult;
implementation

uses DBIProcs;

(* dBase-Tabelle aus aktuellem Projekt packen *)
function PackTableInternal( const Table: TTable): DBIResult;
var
  oldActive, oldEx : Boolean;
begin
  result    := 0;
  (* alten Zustand sichern *)
  oldEx     := Table.Exclusive;
  oldActive := Table.Active;
  try (* erst schlieen, dann exclusiv ffnen *)
    if not oldEx then begin
      if oldActive then Table.Close;
      Table.Exclusive := true
    end;
    Table.Open;
    Result := DbiPackTable( Table.DBHandle, Table.Handle,
                            nil, nil, true);
    if result <> DBIERR_NONE then DBError(result);
  finally (* Properties "Exclusive" und "Active" restaurieren *)
    Table.Close;
    Table.Exclusive := oldEx;
    Table.Active    := oldActive;
  end;
end;

function PackTableByName( const Owner : TComponent;
                          const AnAliasName : string;
                          const ATableName : string): DBIResult;
(* packt eine dBase-Tabelle, die nicht zum Projekt gehrt *)
var
  TTTemp : TTable;
begin
  result := 0;
  TTTemp              := TTable.Create(Owner);
  TTTemp.TableType    := ttdBase;
  TTTemp.DatabaseName := AnAliasName;
  TTTemp.TableName    := ATableName;
  TTTemp.Exclusive    := true;
try
  TTTemp.Open;
  result := dbiPackTable( TTTemp.DBHandle, TTTemp.Handle,
                          nil, nil, true);
  finally (* Tabelle in jedem Fall wieder schlieen *)
    if TTTemp.Active then TTTemp.Close
  end
end;

end.
