/******************************************************************************\
*                                                                              *
*  c't OS/2 Editor v0.7                                                        *
*                                                                              *
*  Modul:     ctedit.cpp                                                       *
*  Aufgabe:   einige Funktionen die spezifisch fr diesen Editor sind          *
*                                                                              *
\******************************************************************************/
#include "common.h"
#pragma hdrstop
#include <ctype.h>
#include "debug.h"
#include "Editor.h"
#include "ctedit.h"
#include "statbar.h"
#include "mle.h"

extern PFNWP pfn;
extern "C" MRESULT EXPENTRY mleCtEditorProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
void save(HWND hwnd, char *name);

extern HWND lastButton;



/* Name     : cleanUpMenu
** Aufgabe  : Das Men auf den Ursprungszustand bringen
** Parameter: HWND hwnd                 - Men window handle
              int userid                - ID, ab der Benutzerids liegen
** Bemerkung: Alle Mens werden rekursiv durchsucht
*/
void cleanUpMenu(HWND hwnd, int userid)
  {
  ensure(validwin(hwnd));
  MENUITEM menuitem;
  int i;

  // userid wird im Moment nicht benutzt :-)
  //userid=USER_OFFSET_ID;

  // Wieviel Eintrge gibt es denn in diesem Men?
  int count=(int)WinSendMsg(hwnd, MM_QUERYITEMCOUNT, 0, 0);
  if (count==0)
     return;

  // Nun alle Eintrge nach Benutzereintrgen durchsuchen
  // Achtung, die Position im Men ist nicht mit der ID identisch!
  for (i=count-1; i>=0; i--)
     {
     // Ermittle ID
     int id=(int)WinSendMsg(hwnd, MM_ITEMIDFROMPOSITION, (MPARAM)i, 0);

     // Ermittle Menelement Daten
     WinSendMsg(hwnd, MM_QUERYITEM,
                MPFROM2SHORT((SHORT)(ULONG)id, TRUE),
                MPFROMP(&menuitem));

     // Gibt's vielleicht Unermens?
     if (menuitem.hwndSubMenu)
        {
        // Jawoll!
        int items_before, items_after;

        /* hat Untermens */
        // merke, wieviele Eintrge jetzt sind
        items_before=(int)WinSendMsg(menuitem.hwndSubMenu, MM_QUERYITEMCOUNT, 0, 0);
        // Rekursiv das Men "bereinigen"
        cleanUpMenu(menuitem.hwndSubMenu, userid);
        // Wieviele sind es jetzt (evtl. sind welche gelscht worden)
        items_after=(int)WinSendMsg(menuitem.hwndSubMenu, MM_QUERYITEMCOUNT, 0, 0);
        // Falls das Untermen jetzt leer ist, mu es freigegeben werden
        if (items_after==0 && items_before!=0)
           {
           // lschen ...
           WinDestroyWindow(menuitem.hwndSubMenu);
           // ... und dem oberen Men mitteilen
           menuitem.hwndSubMenu=0;
           WinSendMsg(hwnd, MM_SETITEM,(MPFROM2SHORT(0,TRUE)), (MPARAM)&menuitem);
           } /* endif: items_after==0 && items_before!=0 */
        } /* endif: menuitem.hwndSubMenu */

     // Falls die ID eine benutzerdefinierte ID ist -> lschen
     if (id>=userid)
        {
        WinSendMsg(hwnd, MM_DELETEITEM,
                   MPFROM2SHORT((USHORT)id, FALSE), 0);
        } /* endif: id>=userid */
     } /* endfor: i>=0 */
  } /* cleanUpMenu */

/* Name     : SubClassMle
** Aufgabe  : Subclasse MLE (die Funktionalitt erweitern)
** Parameter: HWND mle                  - Handle des MLE
*/
void SubClassMle(HWND mle)
  {
  pfn=WinSubclassWindow(mle, mleCtEditorProc);
  ensure(pfn!=0);
  } /* SubClassMle */


/* Name     : mleCtEditorProc
** Aufgabe  : ... und das ist die window procedure fr das MLE
** Parameter: HWND mle                  - Handle des MLE
*/
extern "C" MRESULT EXPENTRY mleCtEditorProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
  {
  return extMleProc(hwnd, msg, mp1, mp2);
  }

/* Name     : ctEditorProc
** Aufgabe  : einige Editor spezifischen Funktionen (Mens, ...)
*/
extern "C" MRESULT EXPENTRY ctEditorProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
  {
  unsigned id;
  ActionBase *action;
  char *newname;

  // Ermittle das assoziierte Editorobjekt aus den window words
  Editor *edit=(Editor *)WinQueryWindowPtr(hwnd, QWL_USER);

  // Fehler?
  if (!edit)
     return FALSE;

  ensure(validread(edit));

  // Ermittle das Frame window
  HWND frame=edit->queryFrame();


  // WM_SAVEAPPLICATION wird gesendet, wenn Fenster geschlossen wird

  switch(msg)
     {
     case UM_USERQUIT:
     /*case WM_SAVEAPPLICATION: */
        {
        // Falls sich der Inhalt des Fensters gendert hat, Benutzer
        // fragen, ob der Text gespeichert werden soll
        if (WinSendMsg(edit->queryMle(), MLM_QUERYCHANGED, 0, 0))
           {
           // fragen!
           switch (WinMessageBox(HWND_DESKTOP, HWND_DESKTOP,
               (PSZ)"Achtung, die Datei wurde gendert. Wollen Sie "
                    "die Datei speichern?", "Speichern?",
                    0, MB_YESNOCANCEL|MB_ICONQUESTION))
              {
              case MBID_YES:
                 save(edit->queryMle(), edit->queryName());
                 break;
              case MBID_NO:
                 WinPostMsg(hwnd, UM_REALQUIT, 0, 0);
                 break;
              default:
                 break;
              } /* endswitch */
           } /* endif: WinSendMsg(edit->queryMle(), MLM_QUERYCHANGED, 0, 0) */
        else
           WinPostMsg(hwnd, UM_REALQUIT, 0, 0);
        } /* msg==WM_SAVEAPPLICATION */
        /* WM_COMMAND wird geschickt, wenn ein Menpunkt/TB ausgewhlt wird */
        case WM_COMMAND:
           // ID ermitteln
           id=(unsigned)SHORT1FROMMP(mp1);
           ensure(id>=0);
           // evtl. Aktion ermitteln
           action=edit->queryAction(id);
           // Aktion auslsen? (action==0 eigentlich Fehler)
           if (action)
              {
              ensure(validread(action));
              // Achtung: action ist polymorph )s. action.cpp)
              action->action(edit);
              }
           break;
        /* fr Toolbar Statusbar Message */
        case WM_CONTROL:
           // fr den Statustext bei den Buttons, damit dieser
           // sich ndert. lastButton ist der window handle des letzten
           // Buttons ber dem die maus steht (Toolbar)
           lastButton=0;
           break;

        /* intern, ungenutzt */
        case UM_SHOW:
           WinShowWindow(edit->queryFrame(), TRUE);
           WinShowWindow(hwnd, TRUE);
           break;

        /* Den Namen des Textes im Editor ndern */
        case UM_CHANGENAME:
           newname=edit->queryName();
           WinSetWindowText(frame, newname);
           break;

        case WM_USER+10:
           edit->load((char *)mp1);
           break;

        case UM_ADDMENU:
           {
           // Hinzufgen eines Knopfes zum Men
           MENUITEM menuitem, mi;
           HWND hwndMenu;
           ULONG style;
           int rc;

           // Men handle fr men ermitteln
           hwndMenu=WinWindowFromID(frame, FID_MENU);
           ensure(validwin(hwndMenu));

           // Menpunkt mp2 ermitteln
           WinSendMsg(hwndMenu, MM_QUERYITEM,
                      MPFROM2SHORT((SHORT)(ULONG)mp2, TRUE),
                      MPFROMP(&menuitem));

           // Action steht in mp1
           ActionBase *action=(ActionBase *)mp1;
           ensure(validread(mp1));
           mi.iPosition=MIT_END;
           mi.afStyle= (action->id)!=(unsigned)-1 ? MIS_TEXT : MIS_SEPARATOR;
           mi.afAttribute=0;
           mi.id=action->id;
           mi.hwndSubMenu=0;
           mi.hItem=0;

           // Falls das Men bisher leer ist, mu es erzeugt werden
           if (menuitem.hwndSubMenu==0)
              {
              menuitem.hwndSubMenu= WinCreateWindow(frame,
                                                    WC_MENU,
                                                    (PSZ)"SubMenu",
                                                    WS_VISIBLE,
                                                    0,0,0,0,
                                                    frame,
                                                    HWND_TOP,
                                                    id++,
                                                    0,0);
             ensure(validwin(menuitem.hwndSubMenu));

             WinSendMsg(hwndMenu, MM_SETITEM, (MPFROM2SHORT(0,TRUE)), (MPARAM)&menuitem);
             } /* endif: menuitem.hwndSubMenu==0 */

           rc=(int)WinSendMsg(menuitem.hwndSubMenu, MM_INSERTITEM, &mi, (MPARAM)(char *)action->entry);
           break;
           }
     case UM_REMOVEUSERITEMS:
        // Hier alle Benutzer-Menpunkte rausnehmen
        cleanUpMenu(WinWindowFromID(frame, FID_MENU), (int)mp1);
        break;
     }
  return FALSE;
  }


/* Name     : ctSetHelptext
** Aufgabe  : setze den Hilfetext fr ein Menitem
*/
extern "C" void ctSetHelptext(HWND frame, ULONG msg, MPARAM mp1, MPARAM mp2)
  {
  // Editorobjekt ermitteln
  Editor *edit=(Editor *)WinQueryWindowPtr(frame, QWL_USER);

  // Fehler?
  if (!edit)
     return;

  ensure(validread(edit));

  // Ermittel Statsbar
  HWND statusbar=WinWindowFromID(frame, FID_STATUSBAR);
  ensure(validwin(statusbar));

  // Send Botschaft
  WinSendMsg(statusbar, SB_SETTEXT, (MPARAM)edit->queryHelptext(SHORT1FROMMP(mp1)), 0);
  }
