#define INCL_DOS
#define INCL_WIN
#include <os2.h>
#include <stdlib.h>
#include <stdio.h>
#include <somedit.hh>
#include <string.h>
#include <signal.h>

extern "C" gofer_main(int argc, char *argv[]);
extern "C" void edit_file(char *filename, int line);

HPIPE pipe_stdin, pipe_stdout;

void print_to_stdin(char *format, ...)
  {
  va_list arglist;
  char buffer[1024];                    /* ok, beschrnkte Gre */
  ULONG written;

  va_start(arglist, format);
  strcpy(buffer, "\r\n");
  vsprintf(buffer+2, format, arglist);
  strcat(buffer, "\r\n");
  DosWrite(pipe_stdin, buffer, strlen(buffer), &written);
  DosResetBuffer(pipe_stdin);

  va_end(arglist);
  } /* print_to_stdin */

class ContextMenuEditor: public SOMEditor
  {
     char selection[1024];
  public:
     ContextMenuEditor();
     void ctContextMenu(char *name, char *selection);
     int info(SOMEditor *) { print_to_stdin(":info %s", selection); return 0; }
     int find(SOMEditor *) { print_to_stdin(":find %s", selection); return 0; }
     int eval(SOMEditor *) { print_to_stdin("%s", selection); return 0; }
  };


ContextMenuEditor::ContextMenuEditor()
  {
  } /* ContextMenuEditor::ContextMenuEditor */


void ContextMenuEditor::ctContextMenu(char *name, char *sel)
  {
  char buffer[1024];
  strncpy(selection, sel, 1024);

  sprintf(buffer, "Den Funktionstyp (Signatur) von \"%s\" anzeigen", sel);
  addContextMenu((ActionMemberFnPtr)info, 0, "Signatur", buffer, 0);
  sprintf(buffer, "Werte den Ausdruck \"%s\" aus", sel);
  addContextMenu((ActionMemberFnPtr)eval, 0, "Auswerten", buffer, 0);
  sprintf(buffer, "Suche nach der Definition von \"%s\" und zeige sie in einem Editorfenster an", sel);
  addContextMenu((ActionMemberFnPtr)find, 0, "Suche Definition", buffer, 0);
  } /* ContextMenuEditor::ctContextMenu */

class MainWindow : public ContextMenuEditor
  {
     int b_red;
     int b_sig;
     int b_err;
     int id_red;
     int id_sig;
     int id_err;
  public:
     MainWindow();
     MRESULT pmmsg(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
     void    ctInitEditorWindow();
     int     names(SOMEditor *) { print_to_stdin(":names"); return 0; }
     int     edit(SOMEditor *)  { print_to_stdin(":edit"); return 0; }
     int     gc(SOMEditor *)    { print_to_stdin(":gc"); return 0; }
     int     showRed(SOMEditor *);
     int     showSig(SOMEditor *);
     int     showErr(SOMEditor *);
     int     open() { edit_file("", -1); return 0;}
  };

MainWindow *mainWindow;


MainWindow::MainWindow()
  {
  b_red=b_sig=b_err=FALSE;
  } /* MainWindow::MainWindow */


void MainWindow::ctInitEditorWindow()
  {
  setFont(0,0,1);
  setName("PMGofer");
  addToolbarButton((ActionMemberFnPtr)names, "Funktionen",
                   "Listet alle gebundenen Namen im aktuellen Gltigkeitsbereich auf",
                   1,0,2007);
  addToolbarButton((ActionMemberFnPtr)edit, "Edit",
                   "ffnet ein neues Editorfenster",
                   1,0,2009);
  addToolbarButton((ActionMemberFnPtr)gc, "GC",
                   "Fhrt eine Speicherbereinigung (garbage collection) durch",
                   1,0,2010);

  addMenuItem((ActionMemberFnPtr)names, 300, "", "", 4);
  addMenuItem((ActionMemberFnPtr)showRed, 300, "Reduktionen anzeigen",
                   "Zeige die Anzahl der Reduktionen nach jeder Auswertung an", 1, 0,0,&id_red);
  setMenuChecked(id_red, b_red=TRUE);
  addMenuItem((ActionMemberFnPtr)showSig, 300, "Signatur anzeigen",
                   "Zeige die Signatur (Funktionstyp) nach jeder Auswertung an", 1,0,0,&id_sig);
  addMenuItem((ActionMemberFnPtr)showErr, 300, "Fehlermeldungen",
                   "Zeige ausfhrliche Fehlermeldungen", 1,0,0, &id_err);
  } /* MainWindow::ctInitEditorWindow */

int MainWindow::showRed(SOMEditor *edit)
  {
  b_red=!b_red;
  print_to_stdin(":set %cs", b_red ? '+':'-');
  setMenuChecked(id_red, b_red);
  return 0;
  } /* MainWindow::showRed */


int MainWindow::showSig(SOMEditor *edit)
  {
  b_sig=!b_sig;
  print_to_stdin(":set %ct", b_sig ? '+':'-');
  setMenuChecked(id_sig, b_sig);
  return 0;
  } /* MainWindow::showSig */


int MainWindow::showErr(SOMEditor *edit)
  {
  b_err=!b_err;
  print_to_stdin(":set %ck", b_err ? '+':'-');
  setMenuChecked(id_err, b_err);
  return 0;
  } /* MainWindow::showErr */


MRESULT MainWindow::pmmsg(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
  {
  static x=0;
  int curline;

  if (msg==WM_CHAR && !(CHARMSG(&msg)->fs&KC_KEYUP))
     {
     if ((CHARMSG(&msg)->fs&KC_CHAR)&&(CHARMSG(&msg)->chr==13))
        goto enter;     // :-)
     if ((CHARMSG(&msg)->fs&KC_VIRTUALKEY))
        {
        BOOL readonly, new_readonly;
        MRESULT ret;

        curline=queryCurrentLine();
        switch (CHARMSG(&msg)->vkey)
          {
enter:
          case VK_ENTER: char line[4096];
                         ULONG written;
                         getTextLine(line, 4096, queryNrOfLines());
                         strcat(line, "\r\n");
                         DosWrite(pipe_stdin, line+1, strlen(line)-1, &written);
                         break;
          case VK_BREAK: DosBeep(100,100);
                         DosWrite(pipe_stdin, "\x3", 1, &written);
                         break;
          case VK_PAGEUP:
          case VK_UP:     curline-=2;
          case VK_DOWN:
          case VK_PAGEDOWN:
                         curline++;
                         readonly=queryReadOnly();
                         if (curline<queryNrOfLines())
                            new_readonly=TRUE;
                         else
                            new_readonly=FALSE;
                         if (new_readonly!=readonly)
                            setReadOnly(new_readonly);
          } /* endswitch: CHARMSG(&msg)->vkey */
        } /* endif: (CHARMSG(&msg)->fs&KC_VIRTUALKEY) */
     } /* endif: msg==WM_CHAR && !(CHARMSG(&msg)->fs&KC_KEYUP) */
  return SOMEditor::pmmsg(hwnd, msg, mp1, mp2);
  } /* MainWindow::pmmsg */

class EditorWindow : public ContextMenuEditor
  {
     int line;
     char *filename;
  public:
     EditorWindow(char *s, int i);
     ~EditorWindow();
     void start();
     void ctInitEditorWindow();
     int names();
  };


EditorWindow::EditorWindow(char *s, int i)
  {
  line=i;
  filename=new char[strlen(s)+1];
  strcpy(filename, s);
  } /* EditorWindow::EditorWindow */


int EditorWindow::names()
  {
  char buffer[1024];
  char *name=tmpnam(0);
  strcpy(buffer, queryName());
  save(name);
  setName(buffer);
  print_to_stdin(":load %s",name);
  print_to_stdin("main");
  unlink(name);
  return 0;
  } /* EditorWindow::names */


EditorWindow::~EditorWindow()
  {
  delete filename;
  } /* EditorWindow::~EditorWindow */


void EditorWindow::start()
  {
  setInitFile(filename);
  process(this);
  } /* EditorWindow::start */


void EditorWindow::ctInitEditorWindow()
  {
  setCurrentLine(line);
  setFont(0,0,1);
  if (line==-1)
     open();
  SWP swp1,swp2;
  WinQueryWindowPos(queryFrame(), &swp1);
  WinQueryTaskSizePos(WinQueryAnchorBlock(queryFrame()), 0, &swp2);
  WinSetWindowPos(queryFrame(),0,swp2.x,swp2.y,swp1.cx/2,swp1.cy/2,SWP_SIZE|SWP_MOVE);
  addToolbarButton((ActionMemberFnPtr)names, "Auswerten",
                   "Lade diese Datei im Hauptfenster, werte main aus",
                   1,0,2008);
  } /* EditorWindow::ctInitEditorWindow */


void _Optlink newEditor(void *p)
  {
  EditorWindow *w=(EditorWindow *)p;
  w->start();
  delete w;
  } /* newEditor */


extern "C" void edit_file(char *filename, int line)
  {
  _beginthread(newEditor,0,16000,((void *)new EditorWindow(filename, line)));
  }


void _Optlink thread_in(void *dummy)
  {
  DosCreateNPipe("\\PIPE\\GOFERIN", &pipe_stdin, NP_NOINHERIT|NP_ACCESS_DUPLEX,
     NP_WAIT|NP_TYPE_BYTE|NP_READMODE_BYTE|NP_UNLIMITED_INSTANCES, 65500, 0, 0);
  DosConnectNPipe(pipe_stdin);
  } /* thread_in */

void _Optlink thread_out(void *dummy)
  {
  ULONG written;
  HAB hab;
  HMQ hmq;

  hab=WinInitialize(0);
  hmq=WinCreateMsgQueue(hab,0);
  WinCancelShutdown(hmq, TRUE);

  DosCreateNPipe("\\PIPE\\GOFEROUT", &pipe_stdout, NP_NOINHERIT|NP_ACCESS_DUPLEX,
     NP_WAIT|NP_TYPE_BYTE|NP_READMODE_BYTE|NP_UNLIMITED_INSTANCES, 65500, 0, 0);

  DosConnectNPipe(pipe_stdout);
  char buffer[1024];
  ULONG cbRead;
  while (0==DosRead(pipe_stdout, buffer, 1023, &cbRead))
     {
     char *p=buffer;
     buffer[cbRead]=0;
     mainWindow->setCurrentCurPos(mainWindow->queryTextLength());
     mainWindow->add(p);
     mainWindow->setCurrentCurPos(mainWindow->queryTextLength());
     } /* endwhile: 0==DosRead(pipe_stdout, buffer, 1023, &cbRead) */

  WinDestroyMsgQueue(hmq);
  WinTerminate(hab);
  } /* thread_out */


void _Optlink window(void *)
  {
  mainWindow=new MainWindow;
  mainWindow->process(mainWindow);
  delete mainWindow;
  exit(0);
  } /* window */

void main(int argc, char *argv[])
  {
  _beginthread(window, 0,16000,0);
  DosSleep(120);                // Normalerweise Semaphoren (Teil 4)
  _beginthread(thread_in, 0,16000,0);
  _beginthread(thread_out, 0,16000,0);
  DosSleep(320);                // Semaphoren! (Teil 4)
  freopen("\\PIPE\\GOFERIN", "r", stdin);
  freopen("\\PIPE\\GOFEROUT", "w", stdout);
  gofer_main(0, 0);
  } /* main */
