#ifndef _BEDIT_H
#define _BEDIT_H

#include <som.hh>
#include <somobj.hh>

#ifdef _DTS
  #define LHANDLE unsigned long
  #define HWND    unsigned long
  #define BOOL    unsigned long
  #define HMODULE unsigned long
  #define MPARAM  void *
  #define MRESULT unsigned long
  #define ULONG   unsigned long
  #define CLR_WHITE 1
  #define CLR_BLACK 1
  struct FATTRS;
#else
  #include <os2.h>
#endif

class ActionBase;
class Editor;

#ifndef ACTIONPTR_DEFINED
#ifndef DTS
 #define ACTIONPTR_DEFINED
 typedef int (* _System ActionFnPtr)(Editor *frame);
#endif
#endif

#pragma SOMNoMangling(on)
class Editor : public SOMObject
  {
#pragma SOMClassName(*, "SOMBaseEditor")
#pragma SOMClassVersion(*,1,0)
#pragma SOMIDLPass(*,"Implementation-Begin", "dllname=\"editdll.dll\";")
  public:
typedef int (Editor::*ActionMemberFnPtr)();
    Editor();
    virtual ~Editor();

// "interne" Informationen
    virtual HWND       queryFrame()=0;
    virtual HWND       queryContextMenu()=0;
    virtual HWND       queryToolbar()=0;
    virtual HWND       queryMle()=0;

// Datei (laden, speichern, exportieren, ...)
    virtual char      *queryName()=0;
    virtual char      *setName(char *x)=0;
    virtual void       load(char *s)=0;
    virtual void       save(char *s=0)=0;
    virtual BOOL       getText(char *buffer, int length, int pos=0)=0;
    virtual BOOL       getTextLine(char *buffer, int length, int line)=0;
    virtual void       loadini()=0;
    virtual void       saveini()=0;

// Editieren (cut, paste, ...)
    virtual void       add(char *text, BOOL changeCurPos=FALSE, int offset=-1)=0;
    virtual void       addLine(char *text, BOOL changeCurPos, int offset=-1)=0;
    virtual BOOL       isChanged()=0;
    virtual void       clear()=0;
    virtual void       clearAll()=0;
    virtual void       copy()=0;
    virtual void       cut()=0;
    virtual void       paste()=0;
    virtual void       insert(char *text)=0;
    virtual void       discard()=0;
    virtual void       undo()=0;
    virtual void       markall()=0;
    virtual void       disableUpdate()=0;
    virtual void       enableUpdate()=0;
    virtual void       setWordWrap(BOOL w=TRUE)=0;
    virtual BOOL       queryWordWrap()=0;
    virtual void       setReadOnly(BOOL set=TRUE)=0;
    virtual BOOL       queryReadOnly()=0;
    virtual void       setChangedFlag(BOOL c)=0;
    virtual void       resetChangedFlag()=0;
    virtual void       removeLine(int line)=0;
    virtual int        queryNrOfLines()=0;
    virtual void       setText(char *)=0;
    virtual int        queryTextLength()=0;

// Cursor
    virtual int        queryCurrentLine()=0;
    virtual int        queryCurrentCol()=0;
    virtual int        queryCurrentCurPos()=0;

    virtual void       setCurrentLine(int line)=0;
    virtual void       setCurrentCol(int col)=0;
    virtual void       setCurrentCurPos(int pos)=0;

// Features (Toolbar, ...)
    virtual void       setStatusText(char *s)=0;
    virtual BOOL       queryIndent()=0;
    virtual void       setIndent(BOOL b)=0;
    virtual BOOL       queryQuickmark()=0;
    virtual void       setQuickmark(BOOL b)=0;
    virtual BOOL       queryHideToolbar()=0;
    virtual void       hideToolbar(BOOL b)=0;
#pragma SOMNoMangling(off)
    virtual ActionFnPtr addToolbarButton(ActionFnPtr p, char *s1, char *s2,
                         int flag=0, HMODULE h=0, unsigned r=0, int *ret_id=0)=0;
    virtual ActionFnPtr addMenuItem(ActionFnPtr p, int mainmenu, char *s1, char *s2,
                         int flag=0, HMODULE h=0, unsigned r=0, int *ret_id=0)=0;
    virtual int        addContextMenu(ActionFnPtr p, int mainmenu, char *entry, char *description, int *ret_id=0)=0;

    virtual ActionFnPtr addToolbarButton(ActionMemberFnPtr p, char *s1, char *s2,
                         int flag=0, HMODULE h=0, unsigned r=0, int *ret_id=0)=0;
    virtual ActionFnPtr addMenuItem(ActionMemberFnPtr p, int mainmenu, char *s1, char *s2,
                         int flag=0, HMODULE h=0, unsigned r=0, int *ret_id=0)=0;
    virtual int        addContextMenu(ActionMemberFnPtr p, int mainmenu, char *entry, char *description, int *ret_id)=0;
#pragma SOMNoMangling(pop)

    virtual BOOL       doAction(int i)=0;
    virtual BOOL       search(char *s, int offset=-1)=0;
    virtual void       process(Editor *e)=0;
    virtual void       threadEntry()=0;

// Hilfsfunktionen
    virtual void       setConditionalMenu(int submenuid, int defaultid)=0;
    virtual void       setMenuChecked(int id, BOOL set=TRUE)=0;
// Farbe
    virtual void       setColor(int color)=0;
    virtual unsigned   queryBkColor()=0;
    virtual void       setBkColor(unsigned color=CLR_WHITE)=0;
    virtual unsigned   queryFgColor()=0;
    virtual void       setFgColor(unsigned color=CLR_BLACK)=0;

// Font
    virtual void       setFonttype(BOOL b)=0;
    virtual BOOL       queryFonttype()=0;
    virtual FATTRS&    queryMonoFont()=0;
    virtual FATTRS&    queryPropFont()=0;
#pragma SOMNoMangling(off)
    virtual void       setFont(char *name=0, int size=0, int monospaced=-1)=0;
    virtual void       setFont(FATTRS& f)=0;
#pragma SOMNoMangling(pop)

// "interne" Funktionen, sollten vorsichtig benutzt werden
    virtual ActionBase *queryAction(unsigned id)=0;
    virtual char      *queryHelptext(unsigned id)=0;
    virtual void       setFrame(HWND h)=0;
    virtual void       setToolbar(HWND h)=0;
    virtual void       setStatusbar(HWND h)=0;
    virtual void       setMle(HWND h)=0;
    virtual void       setMaxLine(int i)=0;
    virtual void       setCurLine(int i)=0;
    virtual void       setCurColumn(int i)=0;
    virtual void       setModified(int i)=0;
    virtual void       updateStatusline(int force=FALSE)=0;
    virtual void       cleanContextMenu()=0;
    virtual void       setInitFile(char *s)=0;

    virtual int        open()=0;
    virtual int        saveas()=0;
    virtual int        quit()=0;
    virtual int        print()=0;
    virtual int        dlgSearch()=0;
    virtual int        monoFont()=0;
    virtual int        setMonoFont()=0;
    virtual int        propFont()=0;
    virtual int        setPropFont()=0;
    virtual int        fontToggle()=0;
    virtual int        colorPalette()=0;
    virtual int        wordWrapOn()=0;
    virtual int        wordWrapOff()=0;
    virtual int        toolbarToggle()=0;
    virtual int        autoIndentToggle()=0;
    virtual int        quickmarkToggle()=0;
    virtual int        about()=0;
    virtual void       ctInitEditorWindow()=0;
    virtual void       ctDeInitEditorWindow()=0;
    virtual void       ctNewName(char *name)=0;
    virtual void       ctContextMenu(char *name, char *selection)=0;
    virtual MRESULT    pmmsg(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)=0;
/* Editor */
#pragma SOMReleaseOrder( \
/*   1 */       queryFrame(),\
/*   2 */       queryContextMenu(),\
/*   3 */       queryToolbar(),\
/*   4 */       queryMle(),\
/*   5 */       queryName(),\
/*   6 */       setName(char*),\
/*   7 */       load(char*),\
/*   8 */       save(char*),\
/*   9 */       getText(char*,int,int),\
/*  10 */       getTextLine(char*,int,int),\
/*  11 */       loadini(),\
/*  12 */       saveini(),\
/*  13 */       add(char*,BOOL,int),\
/*  14 */       addLine(char*,BOOL,int),\
/*  15 */       isChanged(),\
/*  16 */       clear(),\
/*  17 */       clearAll(),\
/*  18 */       copy(),\
/*  19 */       cut(),\
/*  20 */       paste(),\
/*  21 */       insert(char*),\
/*  22 */       discard(),\
/*  23 */       undo(),\
/*  24 */       markall(),\
/*  25 */       disableUpdate(),\
/*  26 */       enableUpdate(),\
/*  27 */       setWordWrap(BOOL),\
/*  28 */       queryWordWrap(),\
/*  29 */       setReadOnly(BOOL),\
/*  30 */       queryReadOnly(),\
/*  31 */       setChangedFlag(BOOL),\
/*  32 */       resetChangedFlag(),\
/*  33 */       removeLine(int),\
/*  34 */       queryNrOfLines(),\
/*  35 */       setText(char*),\
/*  36 */       queryTextLength(),\
/*  37 */       queryCurrentLine(),\
/*  38 */       queryCurrentCol(),\
/*  39 */       queryCurrentCurPos(),\
/*  40 */       setCurrentLine(int),\
/*  41 */       setCurrentCol(int),\
/*  42 */       setCurrentCurPos(int),\
/*  43 */       setStatusText(char*),\
/*  44 */       queryIndent(),\
/*  45 */       setIndent(BOOL),\
/*  46 */       queryQuickmark(),\
/*  47 */       setQuickmark(BOOL),\
/*  48 */       queryHideToolbar(),\
/*  49 */       hideToolbar(BOOL),\
/*  50 */       addToolbarButton(ActionFnPtr,char*,char*,int,HMODULE,unsigned int,int*),\
/*  51 */       addMenuItem(ActionFnPtr,int,char*,char*,int,HMODULE,unsigned int,int*),\
/*  52 */       addContextMenu(ActionFnPtr,int,char*,char*,int*),\
/*  53 */       addToolbarButton(ActionMemberFnPtr,char*,char*,int,HMODULE,unsigned int,int*),\
/*  54 */       addMenuItem(ActionMemberFnPtr,int,char*,char*,int,HMODULE,unsigned int,int*),\
/*  55 */       addContextMenu(ActionMemberFnPtr,int,char*,char*,int*),\
/*  56 */       doAction(int),\
/*  57 */       search(char*,int),\
/*  58 */       process(Editor*),\
/*  59 */       threadEntry(),\
/*  60 */       setConditionalMenu(int,int),\
/*  61 */       setMenuChecked(int,BOOL),\
/*  62 */       setColor(int),\
/*  63 */       queryBkColor(),\
/*  64 */       setBkColor(unsigned int),\
/*  65 */       queryFgColor(),\
/*  66 */       setFgColor(unsigned int),\
/*  67 */       setFonttype(BOOL),\
/*  68 */       queryFonttype(),\
/*  69 */       queryMonoFont(),\
/*  70 */       queryPropFont(),\
/*  71 */       setFont(char*,int,int),\
/*  72 */       setFont(FATTRS&),\
/*  73 */       queryAction(unsigned int),\
/*  74 */       queryHelptext(unsigned int),\
/*  75 */       setFrame(HWND),\
/*  76 */       setToolbar(HWND),\
/*  77 */       setStatusbar(HWND),\
/*  78 */       setMle(HWND),\
/*  79 */       setMaxLine(int),\
/*  80 */       setCurLine(int),\
/*  81 */       setCurColumn(int),\
/*  82 */       setModified(int),\
/*  83 */       updateStatusline(int),\
/*  84 */       cleanContextMenu(),\
/*  85 */       setInitFile(char*),\
/*  86 */       open(),\
/*  87 */       saveas(),\
/*  88 */       quit(),\
/*  89 */       print(),\
/*  90 */       dlgSearch(),\
/*  91 */       monoFont(),\
/*  92 */       setMonoFont(),\
/*  93 */       propFont(),\
/*  94 */       setPropFont(),\
/*  95 */       fontToggle(),\
/*  96 */       colorPalette(),\
/*  97 */       wordWrapOn(),\
/*  98 */       wordWrapOff(),\
/*  99 */       toolbarToggle(),\
/* 100 */       autoIndentToggle(),\
/* 101 */       quickmarkToggle(),\
/* 102 */       about(),\
/* 103 */       ctInitEditorWindow(),\
/* 104 */       ctDeInitEditorWindow(),\
/* 105 */       ctNewName(char*),\
/* 106 */       ctContextMenu(char*,char*),\
/* 107 */       pmmsg(HWND,ULONG,MPARAM,MPARAM))
    };
#endif
