Program TritonInfo;  {als Demo fr PCI-Unit, as, c't 2/96 }
uses dos,crt,PCIunit;

var bus,dev,func,revision,res:byte;

Procedure getTritonInfo;
var cc,dramt,dramc,drt:byte;
var wleadoff,rleadoff:byte;
var i:integer;
var drb:array[0..4] of byte;
var bank:array[0..4] of byte;
const DRAMmode:byte=0;   { 1: EDO, 2: FPM, 3: Misch }

begin
cc    :=read_config   (xbyte,bus,dev,func,$52,res);
dramc :=read_config   (xbyte,bus,dev,func,$57,res);
dramt :=read_config   (xbyte,bus,dev,func,$58,res);
drt   :=read_config   (xbyte,bus,dev,func,$68,res);

Write ('L2-Cache                     : ');
case CC and $C0 of
 $00: write ('nicht vorhanden,');
 $40: Write ('256 KByte,');
 $80: Write ('512 KByte,');
 $C0: Write ('???');
end;
case CC and $30 of
 $00: write (' Synchron Pipeline Burst');
 $10: Write (' Synchron Burst');
 $20: Write (' Asynchron');
 $30: Write (' Dual Bank');
end;
Writeln;
Write ('Cache-Zustand                : ');
case CC and 3 of
$00: Write ('Caches freeze');
$01: Write ('Normaler Betriebszustand');
$02: Write ('keine Tag Invalidierung bei Read');
$03: Write ('eingeschaltet, immer Cache-Miss');
end;
Writeln;
Write ('L2-Bursts                    :');
case CC and $30 of
 $00: write (' RD: 3-1-1-1 (-1-1-1-1)  WR: 3-1-1-1');
 $10: Write (' RD: 3-1-1-1             WR: 3-1-1-1');
 $20: Write (' RD: 3-2-2-2             WR: 4-3-3-3');
 $30: Write (' RD: 3-1-1-1 (-2-1-1-1)  WR: 3-1-1-1');
end;

Writeln;
Write ('DRAM insgesamt               : ');
for i:=0 to 4 do drb[i]:=read_config (xbyte, bus,dev,func,$60+i,res);
bank[0]:=drb[0];
for i:=1 to 4 do bank[i]:=drb[i]-drb[i-1];
Writeln (drb[4]*4,' MByte');
For i:=0 to 4 do
begin
 if bank[i] <> 0 then
 begin
 Write ('DRAM Bank', i,' :':20, (bank[i])*4:3,' MByte');
 if DRT and (1 shl i) > 0 Then
    begin
    Writeln ('  EDO ');
    DRAMmode:=DRAMmode or 1;
    end
  else
    begin
    Writeln ('  Fast Page Mode ');
    DRAMmode:=DRAMmode or 2;
    end;
 end;
end;

RLeadoff:=8-(DRAMT and 1);
Wleadoff:=6-(DRAMT and 1);

Write ('DRAM Read-Burst              : ');

if DRAMMode and 1 > 0 then
case DRAMT and $60  of
$00: write (Rleadoff,'-4-4-4 (EDO)  ');
$20: write (Rleadoff,'-3-3-3 (EDO)  ');
$40: write (Rleadoff,'-2-2-2 (EDO)  ');
$60: write (Rleadoff,'???    (ED0)  ');
end;

if DRAMMode and 2 > 0 then
case DRAMT and $60  of
$00: write (Rleadoff,'-4-4-4 (FPM)');
$20: write (Rleadoff,'-4-4-4 (FPM)');
$40: write (Rleadoff,'-3-3-3 (FPM)');
$60: write (Rleadoff,'??? (FPM)');
end;

Writeln;
Write ('DRAM Write-Burst             : ',Wleadoff);
case DRAMT and $18  of
$00: write ('-4-4-4');
$08: write ('-3-3-3');
$10: write ('-2-2-2');
$18: write ('???');
end;
Writeln;
Write ('DRAM RAS/CAS, /RAS Precharge : ');
case DRAMT and 4  of
  $00: write ('3 T, ');
  $04: write ('2 T, ');
  end;
case DRAMT and 2  of
  $00: write ('3 T');
  $02: write ('4 T');
  end;
Writeln;

Write ('DRAM Refresh                 : ');
Case DRAMC and 7 of
  $00: Write ('Disabled');
  $01: Write ('50 MHz');
  $02: Write ('60 MHz');
  $03: Write ('66 MHz');
  else Write ('???');
  end;

Writeln;
end;

var ok:boolean;
var ch:char;
begin
clrscr;
Writeln ('*******  Triton-Kurzinfo, c''t 2/96/Andreas Stiller *******' );
showPCIinfo (ok);
if ok then
  begin
  Find_PCI_Device (IntelID,TritonId,0,bus,dev,func,res);
  If res = 0 then
   begin
    Writeln
    ('----------------------------------------------------------------');
    revision:=read_config (xbyte,bus,dev,func,8,res);
    Writeln ('Triton TPC, Version:',Revision,' auf Bus:',bus,
             ',Device-Nr:',dev,', Funktion:',Func);
    gettritonInfo;
    end
   else writeln ('kein Triton-Chipsatz');
   Writeln ('>>>>>>>> IRQ-Routing-Options-Info ? - (J/N) <<<<<<<<');
   ch:=upcase(readkey);
   if ch='J' then showIRQ;
   end
  else Writeln ('kein PCI-BIOS identifiziert');

end.



