/*****************************************************************************/
/* program: train.c          * date: 20.11.94 * Autor: Hans Georg Frey       */
/*****************************************************************************/
/* Usage: Lernalgorithmus und alle zustzlichen Funktionen speziell zum      */
/*   Backpropagation-Algorithmus.                                            */
/*                                                                           */
/****************** MODIFIED**************************************************/
/* date:*  By:   * what:                                             * Vers. */
/*****************************************************************************/
/*                                                                           */
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
#include <stdio.h>                             /** Veraltetes Listing: *     */
#include "backp.h"                             /******************************/
#include "system.h"
#include "train.h"
#include "transfer.h"
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <time.h>

/* Modulweit bekannte Variablen */

float* fp_SollAusgabe;                /* Pointer auf die Sollausgaben des Netzes */
float* fp_PatternFehler;              /* Pointer auf die Fehler der Pattern */
long*  dl_PatternZaehler;             /* Wie oft kam das Pattern dran */
float* afp_Gewichte[MAX_SCHICHTEN-1]; /* Pointer auf Gewichtslisten */
float* afp_Differenz[MAX_SCHICHTEN-1];/* Gewichtsaenderung (delta wij) */
float* afp_Fehler[MAX_SCHICHTEN-2];   /* Pointer auf Fehler der Gewichte */
float* afp_NeuronAusgabe[MAX_SCHICHTEN]; /* Array mit Pointern auf die Aus- */
                                       /* gabewerte der Neuronen pro Schicht */

           /* Steuerroutine fuer trainieren eines Netzes (2) */
/******************************************************************************/
void bpgTrainieren( int ai_NetzSchichten[], Pattern* p_Pattern
                  , NetzParameter* sp_NetzParameter )
{
  int      i;                    /* einfacher Zaehler */
  int      i_PatternZaehler;     /* Anzahl der Pattern in dieser Periode */
  int      i_Pattern;            /* welches Pattern ist am dran */
  long     l_Perioden;           /* wieviele Zyklen wurden durchgefuehrt */
  float    f_GesFehler;          /* Summe ueber alle f_Fehler pro Zyklus */
  Pattern* p_TempPattern;        /* Adresse des momentan verwendeten Pattern */

                                 /* Wieviele Perioden wurden bisher bearbeitet */
  l_Perioden  = sp_NetzParameter->l_Perioden;

  if( l_Perioden == 0 )                /* Seed aufsetzen, wenn neues Netz */
    if( sp_NetzParameter->ul_Seed > 0 )/* 0 -> zufaelliges ausetzen */
      srand( sp_NetzParameter->ul_Seed );
                                       /* Den benoetigten Speicher bereitstellen */
  bpgSpeicherKontrollieren( *sp_NetzParameter, ai_NetzSchichten );
  for( i=0; i < sp_NetzParameter->i_AnzahlDerPattern; i++ )
  {                                    /* Zaehler initialisieren */
    dl_PatternZaehler[i] = 0;          /* Wie oft kam das Pattern dran */
    fp_PatternFehler[i]  = 1;          /* Fehler des Pattern */
  }
                                       /* wurden die Perioden pro Ausgabe angegeben */
  if( sp_NetzParameter->i_PeriodenProAusgabe == 0 )
    sp_NetzParameter->i_PeriodenProAusgabe =      /* Wenn nein -> Anzahl der */
            sp_NetzParameter->i_AnzahlDerPattern; /* Muster */

  n_clrscr();                      /* Textausgabe fuer den Fehler und so weiter */
  n_gotoxy( 10, 2 );
  printf( "Anzahl der Muster: %d", sp_NetzParameter->i_AnzahlDerPattern );
  fflush( stdout );
  n_gotoxy( 40, 2 );
  printf( "Name der Musterdatei: %s", sp_NetzParameter->c_MusterDatei );
  fflush( stdout );
  write_str( 10,  3, "Perioden Pro Ausgabe:" );
  n_gotoxy( 32, 3 );
  printf( "%3d", sp_NetzParameter->i_PeriodenProAusgabe );
  fflush( stdout );
  if( sp_NetzParameter->b_ZufallLernen )
    write_str( 10, 4, "Muster werden zufaellig vorgelegt" );
  else
    write_str( 10, 4, "Muster werden in Reihenfolge vorgelegt" );
  if( strlen( sp_NetzParameter->c_ProDatei ) > 0 )
  {                                    /* wird ein Protokollfile angelegt */
    n_gotoxy( 10, 5 );
    printf( "Protokoll File: %s", sp_NetzParameter->c_ProDatei );
    fflush( stdout );
  }
  else
    write_str( 10, 5, "                                 " );

  write_str( 25, 6, "Fehler  :" );     /* Anzahl der Lernschritte schreiben */
  write_str( 25, 7, "Schritte:" );
  write_str( 10, 23, "Fuer Abbruch bitte eine TASTE druecken" );

  i_PatternZaehler = 0;                /* Wieviele Pattern wurden vorgelegt */
  i_Pattern        = -1;               /* Um welches Pattern handelt es sich */

  do                                   /* endlich wird gelernt */
  {                                    /* naechstes Muster bestimmen */
    if( sp_NetzParameter->b_ZufallLernen ) /* Zufaelliges Muster */
      i_Pattern = rand() % sp_NetzParameter->i_AnzahlDerPattern;
    else                               /* Oder Muster in Reihnefolge */
    {
      i_Pattern++;                     /* Wenn kein Pattern mehr da ist */
      if( i_Pattern == sp_NetzParameter->i_AnzahlDerPattern )
        i_Pattern = 0;                 /* wieder von vorne beginnen */
    }
    p_TempPattern = p_Pattern;         /* Adresse des ausgewaehlten Musters */
    for( i=0; i < i_Pattern; i++ )     /* holen und den Input und Output */
      p_TempPattern = p_TempPattern->p_next;/* festhalten */
    afp_NeuronAusgabe[0] = p_TempPattern->fp_OneInput;
    fp_SollAusgabe       = p_TempPattern->fp_OneOutput;
    fp_PatternFehler[i_Pattern] = 0;   /* Fehler fuer dieses Pattern festhalten */

    bpgForward( ai_NetzSchichten );    /* Zuerst vorwaerts und dann rueckwaerts */
    bpgBackward( *sp_NetzParameter, ai_NetzSchichten, i_Pattern );

    l_Perioden++;                      /* wird nur bei neuem Netz genullt */
    i_PatternZaehler++;                /* wird bei jedem neuen do genullt */

                             /* Das Ende der Anzahl pro Periode ist erreicht */
    if( i_PatternZaehler == sp_NetzParameter->i_PeriodenProAusgabe )
    {                                  /* Kontrollausgaaben durchfuehren */
      f_GesFehler = 0;                 /* Fehler ueber alle Muster summieren */
      for( i=0; i < sp_NetzParameter->i_AnzahlDerPattern; i++ )
        f_GesFehler += fp_PatternFehler[i];
      if( sp_NetzParameter->b_Protokoll )   /* Soll auf HD protokolliert */
        ProtokollSchreiben( f_GesFehler, l_Perioden );/* werden */
      n_gotoxy( 35, 6 );
      printf( "%9.6f", f_GesFehler );
      fflush( stdout );
      n_gotoxy( 35, 7 );
      printf( "%4ld", l_Perioden );
      fflush( stdout );
      f_GesFehler = 0;
      i_PatternZaehler = 0;
    }
  } while( !n_kbhit() );               /* Bis eine Taste gedrueckt wird */

  sp_NetzParameter->l_Perioden        = l_Perioden;
  sp_NetzParameter->b_TrainiertesNetz = TRUE;

  write_str( 10, 23, "Zurueck zum Hauptmenue bitte eine TASTE druecken" );
  n_GetKey();
  return;
} /* bpgTrainieren */

/******************************************************************************/
void bpgForward( int ai_NetzSchichten[] )
{                                      /* I-Schicht kommt vor der J-Schicht */
  register float  f_GewichtSumme;      /* Summe der Gewichte fuer ein Neuron */
  register float* fp_NeuronAusgabeI;   /* Output eines Neurons der I-Schicht */
  register float* fp_Gewichte;         /* Adresse der Gewichte zur I-Schicht */
  register float* fp_NeuronAusgabeJ;   /* Output eines Neurons der J-Schicht */
  register int    i, j;                /* einfache Zaehler */
  register int    i_Schicht;           /* Neuronenzaehler der I-Schicht */
  register int    j_Schicht;           /* Neuronenzaehler der J-Schicht */


  i_Schicht = 0;                       /* I-Schicht kommt vor der J-Schicht */
  j_Schicht = 1;

  do                                   /* forwardpropagation */
  {                                    /* solange noch Schichten da sind */
    fp_Gewichte = afp_Gewichte[i_Schicht];  /* Startadressen holen */
    fp_NeuronAusgabeJ = afp_NeuronAusgabe[j_Schicht];
    j = ai_NetzSchichten[j_Schicht]-1;
    do                                 /* solange noch Neuronen in der J-Schicht */
    {                                  /* da sind */
      f_GewichtSumme = 0.0;     /* des Neurons Gewichtsumme initialisieren */
      fp_NeuronAusgabeI = afp_NeuronAusgabe[i_Schicht];
      i = ai_NetzSchichten[i_Schicht]; /* BIAS nicht vergessen */
      do                               /* solange noch Neuronen in der I-Schicht */
      {                                /* da sind */
        f_GewichtSumme += *fp_Gewichte * *fp_NeuronAusgabeI;
        fp_Gewichte++;
        fp_NeuronAusgabeI++;
      } while( i-- );                  /* Nettoinput berechnen */
                                       /* Aktivierungsfunktion durchfuehren */
      *fp_NeuronAusgabeJ++ = (1 / (1 + exp( -f_GewichtSumme )));
    } while( j-- );
    i_Schicht++;                       /* naechste Neuronenschicht */
    j_Schicht++;
  } while( ai_NetzSchichten[j_Schicht] != 0 );


} /* bpgForward */

/******************************************************************************/
void bpgBackward( NetzParameter sp_NetzParameter, int ai_NetzSchichten[]
                , int i_Pattern )
{
  register float* fp_Gewichte;      /* Summe der Gewichte fuer ein Neuron */
  register float* fp_NeuronAusgabeI;/* Output eines Neurons der I-Schicht */
  register float* fp_Differenz;     /* Adresse von wij(t-1) fuer Momentum */
  register float* fp_FehlerI;       /* Fehler fuer den naechsten Schritt */
  register float  f_Differenz2;     /* Zwischenspeicher fuer delta wij */
  register float  f_Delta;          /* Faktor zur Berechnung der allg. Deltaregel */
  register float* fp_NeuronAusgabeJ;/* Output eines Neurons der J-Schicht */
  register float* fp_SollAus;       /* Adresse der Sollausgabe des Musters */
  register float* fp_FehlerJ;       /* Adresse fuer die Summe der Fehler, wenn */
                                    /* kein SollAus vorhanden ist */
  register float* fp_Fehler;        /* Startadresse der Fehlermatrix fuer initialisieren */
  register int    i, j;             /* Zaehler fuer die beiden relevanten Schichten */
  register int    i_Fehler;         /* Index fuer afp_Fehler[] */
  register int    i_Gewichte;       /* Index fuer afp_Gewichte[] */
  register int    i_Schicht;        /* i,j sind die Bezeichner fuer die Schichten */
  register int    j_Schicht;        /* dabei kommt i vor j vor k, vom Eingang zum */
  register int    i_AusgabeSchicht; /* Welche Nummer hat die Ausgabeschicht */
  register float  f_Differenz1;     /* Zwischenspeicher */


                                       /* Startnummern der Schichten festlegen */
  i_AusgabeSchicht = sp_NetzParameter.i_AnzahlDerSchichten - 1;
  j_Schicht        = i_AusgabeSchicht;
  i_Schicht        = i_AusgabeSchicht - 1;
  i_Fehler         = i_AusgabeSchicht - 2;
  i_Gewichte       = i_AusgabeSchicht - 1;

  if( i_Fehler >= 0 )             /* Fehlerfelder fuer die vorderen Schichten */
    for( i=0; i <= i_Fehler; i++ )     /* auf Null setzen */
    {
      fp_Fehler = afp_Fehler[i];
      for( j=0; j < ai_NetzSchichten[i+1]; j++ )
        *(fp_Fehler++) = 0;
    }

  dl_PatternZaehler[i_Pattern]++;
  do                                   /* solange noch Schichten da sind */
  {                                    /* Startadressen festhalten */
    fp_Gewichte  = afp_Gewichte[i_Gewichte];
    fp_Differenz = afp_Differenz[i_Gewichte];
    fp_NeuronAusgabeJ = afp_NeuronAusgabe[j_Schicht];
    fp_SollAus = fp_SollAusgabe;
    fp_FehlerJ = afp_Fehler[i_Fehler+1];

    j = ai_NetzSchichten[j_Schicht]-1;
    do                                 /* solange Neuronen in der J-Schicht sind */
    {
      if( j_Schicht == i_AusgabeSchicht )
      {                                /* Ist dies der erste Backprop Schritt? */
        f_Differenz1 = *fp_SollAus - *fp_NeuronAusgabeJ;
        f_Delta = f_Differenz1 * ( *fp_NeuronAusgabeJ
              * ( 1 - *fp_NeuronAusgabeJ ) + sp_NetzParameter.f_FlatSpot );
        fp_PatternFehler[i_Pattern] += pow( f_Differenz1, 2);
        fp_SollAus++;
      }
      else                             /* ansonsten wird der Fehler anders */
      {                                /* berechnet */
        f_Delta = *fp_FehlerJ * ( *fp_NeuronAusgabeJ
                 * ( 1 - *fp_NeuronAusgabeJ ) + sp_NetzParameter.f_FlatSpot );
        fp_FehlerJ++;
      }
      fp_NeuronAusgabeJ++;

      fp_NeuronAusgabeI = afp_NeuronAusgabe[i_Schicht];
      fp_FehlerI = afp_Fehler[i_Fehler];
                                       /* Neuronen der I-Schicht durchgehen */
      i = ai_NetzSchichten[i_Schicht];
      do
      {

        if( i_Fehler >= 0 )            /* Fehler fuer die naechste Schicht */
        {                              /* aufaddieren, wenn benoetigt */
          *(fp_FehlerI) += f_Delta * *(fp_Gewichte);
          fp_FehlerI++;
        }                              /* delta w(ij) zusammenstellen */
        f_Differenz2 =
            sp_NetzParameter.Lernrate * f_Delta * *(fp_NeuronAusgabeI++)
          + sp_NetzParameter.Momentum * *(fp_Differenz)    /* Momentum */
          - sp_NetzParameter.f_WeightDecay * *fp_Gewichte; /*Weight Decay */
                                       /* Fehler fuer Momentum im naechsten */
        *(fp_Differenz) = f_Differenz2;/* durchlauf festhalten */
        *(fp_Gewichte) += f_Differenz2;/* Das neue Gewicht berechnen */
        fp_Gewichte++;
        fp_Differenz++;
      }  while( i-- );
    } while( j-- );
    j_Schicht--;                       /* naechste Schicht zurueck */
    i_Schicht--;
    i_Gewichte--;
    i_Fehler--;
  } while( i_Schicht >= 0 );
}
/******************************************************************************/
void bpgSpeicherKontrollieren( NetzParameter sp_NetzParameter
                             , int ai_NetzSchichten[] )
{
  register float* fp_Gewichte;         /* Adresse der Gewichte */
  register float* fp_Differenz;        /* Adresse der Gewichtdifferenz */
  register i, j;                       /* einfache Zaehler */
  int      i_AnzahlDerGewichte;        /* Groesse des benoetigten Speichers */

                                       /* Wenn noch ein trainiertes Netz da ist */
  if( sp_NetzParameter.b_TrainiertesNetz )  /* wird kein Speicher mehr angelegt */
    return;

  i=1;                               /* Speicher fuer die Gewichte holen */
  for( i=1; i < sp_NetzParameter.i_AnzahlDerSchichten; i++ )
  {                  /* Die Plus 1 ist fuer die Biaselemente reserviert */
    i_AnzahlDerGewichte = (ai_NetzSchichten[i-1]+1)*ai_NetzSchichten[i];
    if(( afp_Gewichte[i-1] = (float* )malloc( sizeof( float )
               * i_AnzahlDerGewichte )) == NULL )
    {
      write_str( 10, 23, "Fehler beim Speicheranlegen" );
      exit( 1 );
    }
    if(( afp_Differenz[i-1] = (float* )malloc( sizeof( float )
       * i_AnzahlDerGewichte )) == NULL )
    {
      write_str( 10, 23, "Fehler beim Speicheranlegen" );
      exit( 1 );
    }
                                /* Gewichte mit Zufallswerten initialisieren */
    fp_Gewichte  = afp_Gewichte[i-1];
    fp_Differenz = afp_Differenz[i-1];
    for( j=0; j < i_AnzahlDerGewichte; j++ )
    {
      *(fp_Gewichte++)  = NeuroZufall();
      *(fp_Differenz++) = 0;
    }
  }
                                       /* Wenn mehr als zwei Schichten vorhanden */
  if( sp_NetzParameter.i_AnzahlDerSchichten > 2 )/* dann wird ein Speicher fuer die Fehler */
    for( i=2; i < sp_NetzParameter.i_AnzahlDerSchichten; i++ ) /* der vorherigen Schicht benoetigt */
    {                                  /* Speicher fuer den Fehler der Gewichte */
      if(( afp_Fehler[i-2] = (float* )malloc( sizeof( float )
         * i_AnzahlDerGewichte )) == NULL )
      {
        write_str( 10, 23, "Fehler beim Speicheranlegen" );
        exit( 1 );
      }
    }

  i = 1;                               /* fuer den Ausgabewert der Inputschicht */
  do                                   /* braucht kein Speicher reserviert zu */
  {                                    /* werden, da dieser ja schon vorhanden ist */
        if(( afp_NeuronAusgabe[i] = (float* ) calloc( ai_NetzSchichten[i]+1
           , sizeof( float ))) == NULL )
        {
          write_str( 10, 23, "Fehler beim Speicheranlegen" );
          exit( 1 );
        }
                                       /* Ausgang fuer BIAS hat den Wert 1 */
        *(afp_NeuronAusgabe[i] + ai_NetzSchichten[i]) = 1.0;
    i++;
  } while( ai_NetzSchichten[i] != 0 );

  if(( fp_PatternFehler = (float* ) malloc(
              sizeof( float )*sp_NetzParameter.i_AnzahlDerPattern )) == NULL )
    {
      write_str( 10, 23, "Fehler beim Speicheranlegen" );
      exit( 1 );
    }

  if(( dl_PatternZaehler = (long* ) malloc(
              sizeof( float )*sp_NetzParameter.i_AnzahlDerPattern )) == NULL )
    {
      write_str( 10, 23, "Fehler beim Speicheranlegen" );
      exit( 1 );
    }

}  /* bpgSpeicherKontrollieren */

/******************************************************************************/
void bpgSpeicherFreigeben( NetzParameter* sp_NetzParameter )
{
  int i;
                                       /* Wenn nichts trainiert wurde braucht */
  if( !sp_NetzParameter->b_TrainiertesNetz ) /* auch nichts freigegeben zu */
    return;                            /* werden */

  for( i=0; i < sp_NetzParameter->i_AnzahlDerSchichten; i++ )
    free( afp_Gewichte[i] );

  if( sp_NetzParameter->i_AnzahlDerSchichten > 2 )
    for( i=2; i < sp_NetzParameter->i_AnzahlDerSchichten; i++ )
      free( afp_Fehler[i-2] );

  for( i=1 ; i < sp_NetzParameter->i_AnzahlDerSchichten; i++ )
    free( afp_NeuronAusgabe[i] );

  free( fp_PatternFehler );
  free( dl_PatternZaehler );

  sp_NetzParameter->b_TrainiertesNetz = FALSE;

}  /* bpgSpeicherFreigeben */

/******************************************************************************/
void bpgTesten( int ai_NetzSchichten[], Pattern* p_Pattern
              ,NetzParameter sp_NetzParameter, int i_Flag )
{
  int      i;                     /* einfache Zaehler */
  int      i_PatternZaehler;      /* Welches Pattern ist das naechste */
  int      i_AusgabeSchicht;      /* Nr. der Ausgabeschicht */
  Pattern* p_TempPattern;         /* Adresse des momentan verwendeten Pattern */
  int      i_Erkannt;             /* Wieviele Ausgaenge sind > 0.5 */
  int      i_GroessterOutput;     /* Welcher Ausgang hat den groessten Wert */
  float    f_GroessterOutput;     /* Entsprechender Wert dazu */

  n_clrscr();

  i_AusgabeSchicht = sp_NetzParameter.i_AnzahlDerSchichten - 1;
  write_str( 10, 1, "Musternummer:" );
  write_str( 5, 2, "Sollausgabe:      Istausgabe:      Differenz:" );

  i_PatternZaehler = 0;
  p_TempPattern = p_Pattern;
  do
  {
    afp_NeuronAusgabe[0] = p_TempPattern->fp_OneInput;
    fp_SollAusgabe = p_TempPattern->fp_OneOutput;

    bpgForward( ai_NetzSchichten );

    if( i_Flag == MUSTER )             /* macht nur bei Mustern Sinn, da */
    {                                  /* es sonst nur ein Pattern gibt und */
      n_gotoxy( 23, 1 );               /* die Anzzahl der Pattern unbestimmt */
      printf( "%d", i_PatternZaehler+1 );   /* ist */
      fflush( stdout );
      n_gotoxy( 30, 1 );
      printf( "Anzahl: %ld", dl_PatternZaehler[i_PatternZaehler] );
      fflush( stdout );
    }
    for( i=0; i < ai_NetzSchichten[i_AusgabeSchicht]; i++ )
    {
      n_gotoxy( 5, i+3 );
      printf( "%9.6f", *(fp_SollAusgabe + i) );
      fflush( stdout );
      n_gotoxy( 22, i+3 );
      printf( "%9.6f", *(afp_NeuronAusgabe[i_AusgabeSchicht]+i) );
      fflush( stdout );
      n_gotoxy( 38, i+3 );
      printf( "%9.6f", *(fp_SollAusgabe + i) - *(afp_NeuronAusgabe[i_AusgabeSchicht]+i) );
      fflush( stdout );

    }

    if( i_Flag == MUSTER )             /* Nur wenn Muster getestet werden, da */
    {                                  /* bei Bilder nur ein Bild vorliegt */
      write_str( 37, 23, "TASTE" );
      n_GetKey();
      write_str( 37, 23, "     " );
    }
    p_TempPattern = p_TempPattern->p_next ;
    i_PatternZaehler++;

  } while( p_TempPattern != NULL );

  f_GroessterOutput = 0.0;
  i_Erkannt = 0;
  if( i_Flag  == BILDER )              /* Wenn auf Bildern gearbeitet wird */
  {                                    /* dann werden weitere Daten ausgegeben */
    for( i=0; i<ai_NetzSchichten[i_AusgabeSchicht]; i++ )
    {
      if( *(afp_NeuronAusgabe[i_AusgabeSchicht]+i) > f_GroessterOutput )
      {
        f_GroessterOutput = *(afp_NeuronAusgabe[i_AusgabeSchicht]+i);
        i_GroessterOutput = i+1;
      }
      if( *(afp_NeuronAusgabe[i_AusgabeSchicht]+i) > 0.5 )
        i_Erkannt++;
    }
    n_gotoxy( 10, 15 );
    printf( "Den groessten Wert hat Klasse: %d", i_GroessterOutput );
    fflush( stdout );
    if( i_Erkannt == 1 )
      write_str( 10, 16, "Die Klasse wurde genau erkannt" );
    else
      write_str( 10, 16, "Die Klasse wurde nicht erkannt" );
  }
  else
    write_str( 33, 23, "Alle Muster getestet" );

  n_GetKey();
}

/******************************************************************************/
void bpgGewichteHolen( float* afp_Speicher[] )
{
  int i;

  for( i=0; i < MAX_SCHICHTEN-1; i++ )
    afp_Speicher[i] = afp_Gewichte[i];

}
