//
// Zugriff mehrerer Threads auf eine verkettete Liste (als Console 
// Applikation bersetzen und mit thread-sicherer Runtime linken) 
// 
// Das Auskommentieren der Enter- und LeaveCriticalSection-Aufrufe
// in MyThread() zeigt, da es ohne Synchronisation schiefgeht.
// 
#define RUNS	1000	// Anzahl Durchlufe je Threads
#define THREADS	8		// Gesamtzahl Threads

#include <process.h>	// fr _beginthreadex
#include <stdlib.h>		// dies&das
#include <stdio.h>		// fr printf&Co.
#include <windows.h>	// fr Synchronisation

typedef struct node		// Einfach verkettete Liste
{	node	*next;
} *pnode;

// Zeigt auf den Anfang der verketteten Liste
pnode				base= (pnode)malloc( sizeof( node));
// Wird zum Synchronisieren der Listenzugriffe bentigt
CRITICAL_SECTION	cs;

unsigned _stdcall MyThread( void *p) // Eigtl. Thread-Code
{	pnode	pnew;
	int		i= 0;
	
	for ( i= 0; i < RUNS; i++)		// Knoten in Liste einfgen
	{	pnew= (pnode)malloc( sizeof( node));
		// Folgenden Code schtzen, so da immer nur ein Thread
		// die Code-Passage abarbeiten kann.
//		EnterCriticalSection( &cs);
		// Das Einfgen in die Liste zerfllt in zwei C-
		// Statements. Der Compiler generiert daraus unter
		// Umstnden mehr als zwei CPU-Befehle. Whrend deren
		// Abarbeitung kann der Scheduler den Thread 
		// unterbrechen. Deswegen ist dieser Code durch einen
		// kritischen Abschnitt zu schtzen.
		pnew->next= base;
		base= pnew;
		// Ende des kritischen Abschnitts beim System anmelden.
//		LeaveCriticalSection( &cs);
	}
	return 0; // Rckgabewert hier unntig
}

void main( void)
{	int 		i;				// Arbeitszhler
	pnode		d, w;		 	// Arbeitszeiger
	HANDLE		th [THREADS];	// Die Handles der erzeugten Threads
								// sind fr geordneten Betrieb ntig.
	unsigned	uID;			// beim Erzeugen von Threads ntig

	// Ein kritischer Abschnitt mu initialisiert werden.
	InitializeCriticalSection( &cs);
	// Endlosschleife. Programmende via CTRL-C
	while (1)
	{	// Initialisieren des ersten Knotens (Listenende).
		base->next= (pnode)0xffffffff;
		// Threads erzeugen. Default-Security und -Stack.
		// Threads laufen direkt los.
		for ( i= 0; i < THREADS; i++) 
		  th[i]= (HANDLE)_beginthreadex( NULL,0,MyThread,NULL,0,&uID);
		// Warten, da alle Threads fertig (Handles bleiben gltig)
		WaitForMultipleObjects( THREADS, &th [0], TRUE, INFINITE);
		// Handles wegrumen (tut die C-Bibliothek nicht selbstndig)
		for ( i= 0; i < THREADS; i++) CloseHandle( th [i]);
		// Anzahl der Knoten zhlen, die in der Liste stehen.
		for ( w= base->next, i= 0; w != (pnode)0xffffffff; w= w->next) i++;
		// Laufzeitverhalten ausgeben.
		printf( "%8i Knoten verloren!\n", (RUNS* THREADS)- i);
		// Fr die Listenknoten allozierten Speicher freigeben.
		w= base->next; // "Blindknoten" erhalten.
		while ( w != (pnode)0xffffffff)
		{	d= w;			// Ohne Synchronisation beim Einfgen
			w= w-> next;	// verlorene Knoten, bleiben im Speicher
			free( d);		// zurck!
		}
	}
	// Das System rumt zwar auch auf, aber ...
	DeleteCriticalSection( &cs);
}                  
 
